/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.installer.ResourceManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class LocaleDatabase
extends TreeMap {
    private static Map<String, LocaleDatabase> cachedLocales = new HashMap<String, LocaleDatabase>();
    public static final String LOCALE_DATABASE_DIRECTORY = "/langpacks/";
    public static final String LOCALE_DATABASE_DEF_SUFFIX = ".properties";
    private static final char TEMP_QUOTING_CHARACTER = '\uffff';
    static final long serialVersionUID = 4941525634108401848L;

    public static synchronized LocaleDatabase getLocaleDatabase(String isoCode) throws Exception {
        return LocaleDatabase.getLocaleDatabase(isoCode, false);
    }

    public static synchronized LocaleDatabase getLocaleDatabase(String isoCode, boolean reload) throws Exception {
        LocaleDatabase langpack = cachedLocales.get(isoCode);
        if (reload || langpack == null) {
            StringBuffer localeDefPath = new StringBuffer();
            localeDefPath.append(LOCALE_DATABASE_DIRECTORY);
            localeDefPath.append(isoCode);
            localeDefPath.append(LOCALE_DATABASE_DEF_SUFFIX);
            String path = localeDefPath.toString();
            if (LocaleDatabase.class.getResource(path) != null) {
                langpack = new LocaleDatabase(LocaleDatabase.class.getResourceAsStream(path));
                cachedLocales.put(isoCode, langpack);
            }
        }
        return langpack;
    }

    public static synchronized LocaleDatabase getLocaleDatabase() throws Exception {
        ResourceManager resourceManager = ResourceManager.getInstance();
        String defaultLocale = resourceManager.getLocale();
        return LocaleDatabase.getLocaleDatabase(defaultLocale);
    }

    public LocaleDatabase(InputStream in) throws Exception {
        this.add(in);
    }

    public void add(InputStream in) throws Exception {
        String line;
        BufferedInputStream bin = new BufferedInputStream(in);
        bin.mark(500);
        InputStreamReader rawReader = new InputStreamReader(bin);
        BufferedReader reader = new BufferedReader(rawReader);
        while ((line = reader.readLine()) != null && line.length() == 0) {
        }
        bin.reset();
        if (line.trim().startsWith("<?xml")) {
            this.readFromOldXML(bin);
        } else {
            this.readFromProperties(bin);
        }
    }

    private void readFromProperties(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        Set<Map.Entry<Object, Object>> set = props.entrySet();
        for (Map.Entry<Object, Object> entry : set) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private void readFromOldXML(InputStream in) throws Exception {
        XMLParser parser = new XMLParser();
        IXMLElement data = parser.parse(in);
        if (!"langpack".equalsIgnoreCase(data.getName())) {
            throw new Exception("this is not an IzPack XML langpack file");
        }
        Vector<IXMLElement> children = data.getChildren();
        int size = children.size();
        for (int i2 = 0; i2 < size; ++i2) {
            IXMLElement e2 = children.get(i2);
            String text = e2.getContent();
            if (text != null && !"".equals(text)) {
                this.put(e2.getAttribute("id"), text.trim());
                continue;
            }
            this.put(e2.getAttribute("id"), e2.getAttribute("txt"));
        }
    }

    public String getString(String key) {
        String val = (String)this.get(key);
        if (val == null) {
            val = key;
        }
        return val;
    }

    public String getString(String key, String[] variables) {
        for (int i2 = 0; i2 < variables.length; ++i2) {
            if (variables[i2] == null) {
                variables[i2] = "N/A";
                continue;
            }
            if (!variables[i2].startsWith("$")) continue;
            String curArg = variables[i2];
            curArg = curArg.startsWith("${") ? curArg.substring(2, curArg.length() - 1) : curArg.substring(1);
            variables[i2] = this.getString(curArg);
        }
        String message = this.getString(key);
        message = message.replace('\'', '\uffff');
        message = MessageFormat.format(message, variables);
        return message.replace('\uffff', '\'');
    }
}

