/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import com.izforge.izpack.util.OsConstraint;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pack
implements Serializable,
Comparable<Pack> {
    static final long serialVersionUID = -5458360562175088671L;
    private boolean hidden;
    public boolean loose;
    public boolean uninstall;
    public String name;
    public String id;
    public Set<String> installGroups = new HashSet<String>();
    public String excludeGroup = "";
    public String group;
    public String description;
    public List<OsConstraint> osConstraints = null;
    private String condition;
    private List<String> dependencies = null;
    private List<String> revMapping = null;
    private List<String> reverseDependencies = null;
    private boolean required = false;
    public long nbytes;
    public boolean preselected;
    public String parent;
    public int color;
    public String packImgId;
    private List<String> validators = new ArrayList<String>();
    public static final int WHITE = 0;
    public static final int GREY = 1;
    public static final int BLACK = 2;
    private static final double KILOBYTES = 1024.0;
    private static final double MEGABYTES = 1048576.0;
    private static final double GIGABYTES = 1.073741824E9;
    private static final DecimalFormat formatter = new DecimalFormat("#,###.##");

    public Pack(String name, String id, String description, List<OsConstraint> osConstraints, List<String> dependencies, boolean required, boolean preselected, boolean loose, String excludegroup, boolean uninstall) {
        this.name = name;
        this.id = id;
        this.description = description;
        this.osConstraints = osConstraints;
        this.dependencies = dependencies;
        this.required = required;
        this.preselected = preselected;
        this.loose = loose;
        this.excludeGroup = excludegroup;
        this.uninstall = uninstall;
        this.packImgId = null;
        this.condition = null;
        this.nbytes = 0L;
        this.color = 0;
    }

    public Pack(Pack p2) {
        this.color = p2.color;
        this.condition = p2.condition;
        if (p2.dependencies != null && p2.dependencies.size() > 0) {
            this.dependencies = this.deepCopy(p2.dependencies);
        }
        this.description = p2.description;
        this.excludeGroup = p2.excludeGroup;
        this.group = p2.group;
        this.hidden = p2.hidden;
        this.id = p2.id;
        if (p2.installGroups != null && p2.installGroups.size() > 0) {
            this.installGroups = this.deepCopy(p2.installGroups);
        }
        this.loose = p2.loose;
        this.name = p2.name;
        this.nbytes = p2.nbytes;
        this.osConstraints = p2.osConstraints;
        this.packImgId = p2.packImgId;
        this.parent = p2.parent;
        this.preselected = p2.preselected;
        this.required = p2.required;
        if (p2.revMapping != null && p2.revMapping.size() > 0) {
            this.revMapping = this.deepCopy(p2.revMapping);
        }
        this.uninstall = p2.uninstall;
        if (p2.validators != null && p2.validators.size() > 0) {
            this.validators = this.deepCopy(p2.validators);
        }
    }

    private List<String> deepCopy(List<String> listAvailablePacks2) {
        ArrayList<String> copy = new ArrayList<String>(listAvailablePacks2.size());
        for (String item : listAvailablePacks2) {
            copy.add(new String(item));
        }
        return copy;
    }

    private Set<String> deepCopy(Set<String> setAvailablePacks2) {
        HashSet<String> copy = new HashSet<String>(setAvailablePacks2.size());
        for (String item : setAvailablePacks2) {
            copy.add(new String(item));
        }
        return copy;
    }

    public String toString() {
        return this.name + " (" + this.description + ")";
    }

    public String depString() {
        String name0;
        String text = "";
        if (this.dependencies == null) {
            return text;
        }
        for (int i2 = 0; i2 < this.dependencies.size() - 1; ++i2) {
            name0 = this.dependencies.get(i2);
            text = text + name0 + ",";
        }
        name0 = this.dependencies.get(this.dependencies.size() - 1);
        text = text + name0;
        return text;
    }

    public static String toByteUnitsString(long bytes) {
        if ((double)bytes < 1024.0) {
            return String.valueOf(bytes) + " bytes";
        }
        if ((double)bytes < 1048576.0) {
            double value = (double)bytes / 1024.0;
            return formatter.format(value) + " KB";
        }
        if ((double)bytes < 1.073741824E9) {
            double value = (double)bytes / 1048576.0;
            return formatter.format(value) + " MB";
        }
        double value = (double)bytes / 1.073741824E9;
        return formatter.format(value) + " GB";
    }

    public static String toMegaByteUnitsString(long bytes) {
        double value = (double)bytes / 1048576.0;
        return formatter.format(value) + " MB";
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public void addValidator(String validatorClassName) {
        this.validators.add(validatorClassName);
    }

    public List<String> getValidators() {
        return this.validators;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public int compareTo(Pack o2) {
        return (this.parent + this.name).compareToIgnoreCase(o2.parent + o2.name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pack) {
            Pack pack = (Pack)obj;
            return this.id.equals(pack.id);
        }
        return super.equals(obj);
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public List<String> getRevMapping() {
        return this.revMapping;
    }

    public void setRevMapping(List<String> mapping) {
        this.revMapping = mapping;
    }

    public void addRevMapping(String mapping) {
        if (this.getRevMapping() == null) {
            this.setRevMapping(new ArrayList<String>());
        }
        if (this.revMapping.contains(mapping)) {
            return;
        }
        this.revMapping.add(mapping);
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public void addDependency(String dependency) {
        if (this.getDependencies() == null) {
            this.setDependencies(new ArrayList<String>());
        }
        if (this.dependencies.contains(dependency)) {
            return;
        }
        this.dependencies.add(dependency);
    }

    public List<String> getReverseDependencies() {
        return this.reverseDependencies;
    }

    public void setReverseDependencies(List<String> reverseDependencies) {
        this.reverseDependencies = reverseDependencies;
    }

    public void addReverseDependency(String reverseDependency) {
        if (this.getReverseDependencies() == null) {
            this.setReverseDependencies(new ArrayList<String>());
        }
        if (this.reverseDependencies.contains(reverseDependency)) {
            return;
        }
        this.reverseDependencies.add(reverseDependency);
    }
}

