/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import com.izforge.izpack.Pack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackHandler {
    private static TreeMap<String, Pack> packs = new TreeMap();
    private static TreeMap<String, StateHolder> states = new TreeMap();

    public static Pack getPack(String packID) {
        if (packID == null) {
            return null;
        }
        if (!packs.containsKey(packID.toLowerCase())) {
            return null;
        }
        Pack pack = packs.get(packID.toLowerCase());
        return pack;
    }

    public static Pack getPackByName(String packName) {
        return PackHandler.getPack(PackHandler.getPackIdForName(packName));
    }

    public static String getPackIdForName(String packName) {
        Collection<Pack> values = packs.values();
        for (Pack pack : values) {
            if (!pack.name.equalsIgnoreCase(packName)) continue;
            return pack.id;
        }
        return null;
    }

    public static StateHolder getState(String packID) {
        if (!states.containsKey(packID.toLowerCase())) {
            return null;
        }
        return states.get(packID.toLowerCase());
    }

    public static void setAllPacks(List<Pack> listPack) {
        for (Pack pack : listPack) {
            String id = pack.id.toLowerCase();
            if (packs.keySet().contains(id)) {
                packs.put(id, pack);
                continue;
            }
            packs.put(id, pack);
            states.put(id, new StateHolder());
        }
    }

    public static List<Pack> getAllPacks() {
        return new ArrayList<Pack>(packs.values());
    }

    public static TreeMap<String, StateHolder> getAllStates() {
        return states;
    }

    public static List<Pack> getSelectedPacks() {
        ArrayList<Pack> selectedList = new ArrayList<Pack>();
        for (String packID : states.keySet()) {
            if (states.get(packID.toLowerCase()) != null) {
                if (!states.get(packID.toLowerCase()).isSelected()) continue;
                selectedList.add(packs.get(packID.toLowerCase()));
                continue;
            }
            throw new IllegalArgumentException(packID.toLowerCase());
        }
        return selectedList;
    }

    public static List<Pack> getAvailablePacks() {
        ArrayList<Pack> availableList = new ArrayList<Pack>();
        for (String packID : states.keySet()) {
            if (states.get(packID.toLowerCase()) != null) {
                if (!states.get(packID.toLowerCase()).isAvailable()) continue;
                availableList.add(packs.get(packID.toLowerCase()));
                continue;
            }
            throw new IllegalArgumentException(packID.toLowerCase());
        }
        return availableList;
    }

    public static void setAvailablePacks(List<Pack> availablePacks) {
        for (Pack pack : packs.values()) {
            if (availablePacks.contains(pack)) {
                PackHandler.setAvailablePack(pack);
                continue;
            }
            PackHandler.unsetAvailablePack(pack);
        }
    }

    public static void setAvailablePack(Pack availablePack) {
        if (states.containsKey(availablePack.id.toLowerCase())) {
            StateHolder value = states.get(availablePack.id.toLowerCase());
            value.setAvailable(true);
            states.put(availablePack.id.toLowerCase(), value);
        } else {
            StateHolder value = new StateHolder();
            value.setAvailable(true);
            states.put(availablePack.id.toLowerCase(), value);
        }
    }

    public static void unsetAvailablePack(Pack availablePack) {
        if (states.containsKey(availablePack.id.toLowerCase())) {
            StateHolder value = states.get(availablePack.id.toLowerCase());
            value.setAvailable(false);
            states.put(availablePack.id.toLowerCase(), value);
        } else {
            StateHolder value = new StateHolder();
            value.setAvailable(false);
            states.put(availablePack.id.toLowerCase(), value);
        }
    }

    public static void setSelectedPacks(List<Pack> selectedPacks) {
        for (Pack pack : packs.values()) {
            if (selectedPacks.contains(pack)) {
                PackHandler.setSelectedPack(pack);
                continue;
            }
            PackHandler.unsetSelectedPack(pack);
        }
    }

    public static void setSelectedPack(Pack selectedPack) {
        if (states.containsKey(selectedPack.id.toLowerCase())) {
            StateHolder value = states.get(selectedPack.id.toLowerCase());
            value.setSelected(true);
            states.put(selectedPack.id.toLowerCase(), value);
        } else {
            StateHolder value = new StateHolder();
            value.setSelected(true);
            states.put(selectedPack.id.toLowerCase(), value);
        }
    }

    public static void unsetSelectedPack(Pack selectedPack) {
        if (states.containsKey(selectedPack.id.toLowerCase())) {
            StateHolder value = states.get(selectedPack.id.toLowerCase());
            value.setSelected(false);
            states.put(selectedPack.id.toLowerCase(), value);
        } else {
            StateHolder value = new StateHolder();
            value.setSelected(false);
            states.put(selectedPack.id.toLowerCase(), value);
        }
    }

    public static void movePackToIndex(int i2, Pack pack) {
    }

    public static void setAllStates(TreeMap<String, StateHolder> allStates) {
        states = allStates;
    }

    public static void resetPacks() {
        packs = new TreeMap();
        states = new TreeMap();
    }

    public static class StateHolder {
        private boolean isAvaileble = false;
        private boolean isSelected = false;

        public StateHolder() {
        }

        public StateHolder(boolean isAvaileble, boolean isSelected) {
            this.isAvaileble = isAvaileble;
            this.isSelected = isSelected;
        }

        public boolean isAvailable() {
            return this.isAvaileble;
        }

        public void setAvailable(boolean isAvaileble) {
            this.isAvaileble = isAvaileble;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }
    }
}

