/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.util.OsConstraint;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PackInfo
implements Serializable {
    private static final long serialVersionUID = -3604642858885697783L;
    private Pack pack;
    public int colour;
    public static final int WHITE = 0;
    public static final int GREY = 1;
    public static final int BLACK = 2;
    private Map files = new HashMap();
    private List parsables = new ArrayList();
    private List executables = new ArrayList();
    private List updateChecks = new ArrayList();

    public PackInfo(String name, String id, String description, boolean required, boolean loose, String excludegroup, boolean uninstall) {
        boolean ispreselected = excludegroup == null;
        this.pack = new Pack(name, id, description, null, null, required, ispreselected, loose, excludegroup, uninstall);
        this.colour = 0;
    }

    public void setDependencies(List<String> dependencies) {
        this.pack.setDependencies(dependencies);
    }

    public void setExcludeGroup(String group) {
        this.pack.excludeGroup = group;
    }

    public void setOsConstraints(List<OsConstraint> osConstraints) {
        this.pack.osConstraints = osConstraints;
    }

    public List<OsConstraint> getOsConstraints(List osConstraints) {
        return this.pack.osConstraints;
    }

    public void setPreselected(boolean preselected) {
        this.pack.preselected = preselected;
    }

    public boolean isPreselected() {
        return this.pack.preselected;
    }

    public String getGroup() {
        return this.pack.group;
    }

    public void setGroup(String group) {
        this.pack.group = group;
    }

    public void addInstallGroup(String group) {
        this.pack.installGroups.add(group);
    }

    public boolean hasInstallGroup(String group) {
        return this.pack.installGroups.contains(group);
    }

    public Set<String> getInstallGroups() {
        return this.pack.installGroups;
    }

    public Pack getPack() {
        return this.pack;
    }

    public boolean isHidden() {
        return this.pack.isHidden();
    }

    public void setHidden(boolean hidden) {
        this.pack.setHidden(hidden);
    }

    public void addFile(File baseDir, File file, String targetfile, List<OsConstraint> osList, int override, Map additionals, String condition) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        PackFile packFile = new PackFile(baseDir, file, targetfile, osList, override, additionals);
        packFile.setLoosePackInfo(this.pack.loose);
        packFile.setCondition(condition);
        this.files.put(packFile, file);
    }

    public Set getPackFiles() {
        return this.files.keySet();
    }

    public File getFile(PackFile packFile) {
        return (File)this.files.get(packFile);
    }

    public void addParsable(ParsableFile parsable) {
        this.parsables.add(parsable);
    }

    public List getParsables() {
        return this.parsables;
    }

    public void addExecutable(ExecutableFile executable) {
        this.executables.add(executable);
    }

    public List getExecutables() {
        return this.executables;
    }

    public void addUpdateCheck(UpdateCheck updateCheck) {
        this.updateChecks.add(updateCheck);
    }

    public List getUpdateChecks() {
        return this.updateChecks;
    }

    public void addDependency(String dependency) {
        if (this.pack.getDependencies() == null) {
            this.pack.setDependencies(new ArrayList<String>());
        }
        this.pack.addDependency(dependency);
    }

    public List<String> getDependencies() {
        return this.pack.getDependencies();
    }

    public String getParent() {
        return this.pack.parent;
    }

    public void setParent(String p2) {
        this.pack.parent = p2;
    }

    public String toString() {
        return this.pack.name;
    }

    public void setPackImgId(String packImgId) {
        this.pack.packImgId = packImgId;
    }

    public String getCondition() {
        return this.pack.getCondition();
    }

    public void setCondition(String condition) {
        this.pack.setCondition(condition);
    }

    public void addValidator(String validatorClassName) {
        this.pack.addValidator(validatorClassName);
    }
}

