/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.event.AntAction;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.ExtendedUIProgressHandler;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntActionInstallerListener
extends SimpleInstallerListener {
    public static final String SPEC_FILE_NAME = "AntActionsSpec.xml";
    private HashMap<String, HashMap<Object, ArrayList<AntAction>>> actions = new HashMap();
    private ArrayList<AntAction> uninstActions = new ArrayList();

    public AntActionInstallerListener() {
        super(true);
    }

    public HashMap<String, HashMap<Object, ArrayList<AntAction>>> getActions() {
        return this.actions;
    }

    @Override
    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        super.beforePacks(idata, npacks, handler);
        this.getSpecHelper().readSpec(SPEC_FILE_NAME, new VariableSubstitutor(idata.getVariables()));
        if (this.getSpecHelper().getSpec() == null) {
            return;
        }
        Iterator<Pack> iter = idata.getSelectedPacks().iterator();
        Pack p2 = null;
        while (iter != null && iter.hasNext()) {
            p2 = iter.next();
            IXMLElement pack = this.getSpecHelper().getPackForName(p2.name);
            if (pack == null) continue;
            HashMap packActions = new HashMap();
            packActions.put("beforepack", new ArrayList());
            packActions.put("afterpack", new ArrayList());
            packActions.put("beforepacks", new ArrayList());
            packActions.put("afterpacks", new ArrayList());
            Vector<IXMLElement> antCallEntries = pack.getChildrenNamed("antcall");
            if (antCallEntries != null && antCallEntries.size() >= 1) {
                Iterator<IXMLElement> entriesIter = antCallEntries.iterator();
                while (entriesIter != null && entriesIter.hasNext()) {
                    AntAction act = this.readAntCall(entriesIter.next(), idata);
                    if (act == null) continue;
                    ((ArrayList)packActions.get(act.getOrder())).add(act);
                }
                if (((ArrayList)packActions.get("afterpacks")).size() > 0) {
                    this.setProgressBarCaller();
                }
            }
            this.actions.put(p2.name, packActions);
        }
        iter = idata.getAvailablePacks().iterator();
        while (iter.hasNext()) {
            String currentPack = iter.next().name;
            this.performAllActions(currentPack, "beforepacks", null);
        }
    }

    @Override
    public void beforePack(Pack pack, Integer i2, AbstractUIProgressHandler handler) throws Exception {
        this.performAllActions(pack.name, "beforepack", handler);
    }

    @Override
    public void afterPack(Pack pack, Integer i2, AbstractUIProgressHandler handler) throws Exception {
        this.performAllActions(pack.name, "afterpack", handler);
    }

    @Override
    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        if (this.informProgressBar()) {
            handler.nextStep(this.getMsg("AntAction.pack"), this.getProgressBarCallerId(), this.getActionCount(idata, "afterpacks"));
        }
        Iterator<Pack> iter = idata.getSelectedPacks().iterator();
        while (iter.hasNext()) {
            String currentPack = iter.next().name;
            this.performAllActions(currentPack, "afterpacks", handler);
        }
        if (this.uninstActions.size() > 0) {
            UninstallData.getInstance().addAdditionalData("antActions", this.uninstActions);
        }
    }

    private int getActionCount(AutomatedInstallData idata, String order) {
        int retval = 0;
        Iterator<Pack> iter = idata.getSelectedPacks().iterator();
        while (iter.hasNext()) {
            String currentPack = iter.next().name;
            ArrayList<AntAction> actList = this.getActions(currentPack, order);
            if (actList == null) continue;
            retval += actList.size();
        }
        return retval;
    }

    protected ArrayList<AntAction> getActions(String packName, String order) {
        if (this.actions == null) {
            return null;
        }
        HashMap<Object, ArrayList<AntAction>> packActions = this.actions.get(packName);
        if (packActions == null || packActions.size() == 0) {
            return null;
        }
        return packActions.get(order);
    }

    private void performAllActions(String packName, String order, AbstractUIProgressHandler handler) throws InstallerException {
        ArrayList<AntAction> actList = this.getActions(packName, order);
        if (actList == null || actList.size() == 0) {
            return;
        }
        Debug.trace("******* Executing all " + order + " actions of " + packName + " ...");
        for (AntAction act : actList) {
            if (this.informProgressBar() && handler != null && handler instanceof ExtendedUIProgressHandler && order.equals("afterpacks")) {
                ((ExtendedUIProgressHandler)((Object)handler)).progress(act.getMessageID() != null ? this.getMsg(act.getMessageID()) : "");
            }
            try {
                act.performInstallAction();
            }
            catch (Exception e2) {
                if ("CopyTomcatPolicy".equalsIgnoreCase(act.messageID)) {
                    handler.emitWarning("Warnung", this.getMsg("AntActions.CantCopyTomcatPolicy"));
                }
                throw new InstallerException(e2);
            }
            if (act.getUninstallTargets().size() <= 0) continue;
            this.uninstActions.add(act);
        }
    }

    private AntAction readAntCall(IXMLElement el2, AutomatedInstallData idata) throws InstallerException {
        String msgId;
        String buildFile = null;
        String buildResource = null;
        if (el2 == null) {
            return null;
        }
        SpecHelper spec = this.getSpecHelper();
        AntAction act = new AntAction();
        try {
            act.setOrder(spec.getRequiredAttribute(el2, "order"));
            act.setUninstallOrder(el2.getAttribute("uninstall_order", "beforedeletion"));
        }
        catch (Exception e2) {
            throw new InstallerException(e2);
        }
        act.setQuiet(spec.isAttributeYes(el2, "quiet", false));
        act.setVerbose(spec.isAttributeYes(el2, "verbose", false));
        buildFile = el2.getAttribute("buildfile");
        buildResource = this.processBuildfileResource(spec, idata, el2);
        if (null == buildFile && null == buildResource) {
            throw new InstallerException("Invalid AntActionsSpec.xml: either buildfile or buildresource must be specified");
        }
        if (null != buildFile && null != buildResource) {
            throw new InstallerException("Invalid AntActionsSpec.xml: cannot specify both buildfile and buildresource");
        }
        if (null != buildFile) {
            act.setBuildFile(buildFile);
        } else {
            act.setBuildFile(buildResource);
        }
        String str = el2.getAttribute("logfile");
        if (str != null) {
            act.setLogFile(str);
        }
        if ((msgId = el2.getAttribute("messageid")) != null && msgId.length() > 0) {
            act.setMessageID(msgId);
        }
        for (IXMLElement propEl : el2.getChildrenNamed("propertyfile")) {
            act.addPropertyFile(spec.getRequiredAttribute(propEl, "path"));
        }
        for (IXMLElement propEl : el2.getChildrenNamed("property")) {
            act.setProperty(spec.getRequiredAttribute(propEl, "name"), spec.getRequiredAttribute(propEl, "value"));
        }
        for (IXMLElement targEl : el2.getChildrenNamed("target")) {
            act.addTarget(spec.getRequiredAttribute(targEl, "name"));
        }
        for (IXMLElement utargEl : el2.getChildrenNamed("uninstall_target")) {
            act.addUninstallTarget(spec.getRequiredAttribute(utargEl, "name"));
        }
        if (null != buildResource && act.getUninstallTargets().size() > 0) {
            this.addBuildResourceToUninstallerData(buildResource);
        }
        return act;
    }

    private String processBuildfileResource(SpecHelper spec, AutomatedInstallData idata, IXMLElement el2) throws InstallerException {
        String buildResource = null;
        String attr = el2.getAttribute("buildresource");
        if (null != attr) {
            BufferedInputStream bis = new BufferedInputStream(spec.getResource(attr));
            if (null == bis) {
                throw new InstallerException("Failed to find buildfile_resource: " + attr);
            }
            FilterOutputStream bos = null;
            try {
                int c2;
                File tempFile = File.createTempFile("buildfile_resource", "xml");
                tempFile.deleteOnExit();
                bos = new BufferedOutputStream(new FileOutputStream(tempFile));
                while (-1 != (c2 = bis.read())) {
                    ((BufferedOutputStream)bos).write(c2);
                }
                bis.close();
                bos.close();
                buildResource = tempFile.getAbsolutePath();
            }
            catch (Exception x2) {
                throw new InstallerException("Failed to write buildfile_resource", x2);
            }
            finally {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception x3) {}
                }
            }
        }
        return buildResource;
    }

    private void addBuildResourceToUninstallerData(String buildResource) throws InstallerException {
        byte[] content = null;
        File buildFile = new File(buildResource);
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)buildFile.length());
        BufferedInputStream bis = null;
        try {
            int c2;
            bis = new BufferedInputStream(new FileInputStream(buildFile));
            while (-1 != (c2 = bis.read())) {
                bos.write(c2);
            }
            content = bos.toByteArray();
            UninstallData.getInstance().addAdditionalData("build_resource", content);
        }
        catch (Exception x2) {
            throw new InstallerException("Failed to add buildfile_resource to uninstaller", x2);
        }
        finally {
            try {
                bis.close();
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }
}

