/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.coi.tools.os.win.NativeLibException;
import com.coi.tools.os.win.RegDataContainer;
import com.inet.lib.util.PreferencesUtils;
import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.event.NativeInstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.GUIInstaller;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.SpecHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import com.izforge.izpack.util.os.WrappedNativeLibException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class RegistryInstallerListener
extends NativeInstallerListener
implements CleanupClient {
    private static final String SPEC_FILE_NAME = "RegistrySpec.xml";
    private static final String REG_KEY = "key";
    private static final String REG_VALUE = "value";
    private static final String REG_ROOT = "root";
    private static final String REG_BASENAME = "name";
    private static final String REG_KEYPATH = "keypath";
    private static final String REG_DWORD = "dword";
    private static final String REG_STRING = "string";
    private static final String REG_MULTI = "multi";
    private static final String REG_BIN = "bin";
    private static final String REG_DATA = "data";
    private static final String REG_OVERRIDE = "override";
    private static final String SAVE_PREVIOUS = "saveprevious";
    private RulesEngine rules;
    private List registryModificationLog;

    public RegistryInstallerListener() {
        super(true);
    }

    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        super.beforePacks(idata, npacks, handler);
        this.rules = idata.getRules();
        this.initializeRegistryHandler(idata);
    }

    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        try {
            if (!PreferencesUtils.isSystemWriteable(PreferencesUtils.getRelativePrefPath(GUIInstaller.class))) {
                return;
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            List<Object> info;
            String uninstallSuffix;
            Housekeeper.getInstance().registerForCleanup(this);
            RegistryHandler rh = RegistryDefaultHandler.getInstance();
            if (rh == null) {
                return;
            }
            IXMLElement uninstallerPack = null;
            Unpacker.setDiscardInterrupt(true);
            rh.activateLogging();
            try {
                String[] valuesNames;
                rh.setRoot(-2147483646);
                for (String key : valuesNames = rh.getSubkeys("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\".substring(0, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\".length() - 1))) {
                    if (!key.startsWith("i-net ")) continue;
                    try {
                        RegDataContainer data = rh.getValue("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + key, "UninstallString");
                        String uninstallString = data.getStringData();
                        if (!uninstallString.toLowerCase().contains(idata.getVariable("INSTALL_PATH").toLowerCase() + "\\")) continue;
                        rh.deleteKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + key);
                    }
                    catch (NativeLibException e3) {
                        rh.deleteKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + key);
                    }
                }
            }
            catch (NativeLibException e4) {
                Debug.trace(e4);
            }
            try {
                String uninstall_name = rh.getUninstallName();
                rh.setRoot(-2147483646);
                String[] valuesNames = rh.getSubkeys("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\".substring(0, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\".length() - 1));
                ArrayList<String> keys = new ArrayList<String>();
                for (String key : valuesNames) {
                    keys.add(key);
                }
                boolean finished = false;
                int i2 = 0;
                String tmp_name = uninstall_name;
                while (!finished) {
                    if (keys.contains(tmp_name)) {
                        tmp_name = uninstall_name + " (" + ++i2 + ")";
                        continue;
                    }
                    uninstall_name = tmp_name;
                    finished = true;
                }
                if (i2 != 0) {
                    idata.setVariable("UNINSTALL_NAME", uninstall_name);
                    this.initializeRegistryHandler(idata);
                }
            }
            catch (NativeLibException e5) {
                Debug.trace(e5);
            }
            if (this.getSpecHelper().getSpec() != null) {
                VariableSubstitutor substitutor = new VariableSubstitutor(idata.getVariables());
                Iterator<Pack> iter = idata.getSelectedPacks().iterator();
                uninstallerPack = this.getSpecHelper().getPackForName("UninstallStuff");
                this.performPack(uninstallerPack, substitutor);
                while (iter != null && iter.hasNext()) {
                    IXMLElement pack = this.getSpecHelper().getPackForName(iter.next().name);
                    this.performPack(pack, substitutor);
                }
            }
            if ((uninstallSuffix = idata.getVariable("UninstallKeySuffix")) != null) {
                rh.setUninstallName(rh.getUninstallName() + " " + uninstallSuffix);
            }
            if (uninstallerPack == null) {
                rh.registerUninstallKey();
            }
            if ((info = rh.getLoggingInfo()) != null) {
                UninstallData.getInstance().addAdditionalData("registryEntries", info);
            }
            this.registryModificationLog = info;
        }
        catch (Exception e6) {
            if (e6 instanceof NativeLibException) {
                throw new WrappedNativeLibException(e6);
            }
            throw e6;
        }
    }

    public void cleanUp() {
        if (AutomatedInstallData.getInstance().installSuccess || this.registryModificationLog == null || this.registryModificationLog.size() < 1) {
            return;
        }
        RegistryHandler registryHandler = RegistryDefaultHandler.getInstance();
        try {
            if (registryHandler == null) {
                return;
            }
            if (registryHandler == null) {
                return;
            }
            registryHandler.activateLogging();
            registryHandler.setLoggingInfo(this.registryModificationLog);
            registryHandler.rewind();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void performPack(IXMLElement pack, VariableSubstitutor substitutor) throws Exception {
        Vector<IXMLElement> regEntries;
        if (pack == null) {
            return;
        }
        String packcondition = pack.getAttribute("condition");
        if (packcondition != null) {
            Debug.trace("condition " + packcondition + " found for pack of registry entries.");
            if (!this.rules.isConditionTrue(packcondition)) {
                Debug.trace("not fulfilled.");
                return;
            }
        }
        if ((regEntries = pack.getChildren()) == null) {
            return;
        }
        Iterator<IXMLElement> entriesIter = regEntries.iterator();
        while (entriesIter != null && entriesIter.hasNext()) {
            String type;
            IXMLElement regEntry = entriesIter.next();
            String condition = regEntry.getAttribute("condition");
            if (condition != null) {
                Debug.trace("condition " + condition + " found for registry entry.");
                if (!this.rules.isConditionTrue(condition)) {
                    Debug.trace("not fulfilled.");
                    continue;
                }
            }
            if ((type = regEntry.getName()).equalsIgnoreCase(REG_KEY)) {
                this.performKeySetting(regEntry, substitutor);
                continue;
            }
            if (type.equalsIgnoreCase(REG_VALUE)) {
                this.performValueSetting(regEntry, substitutor);
                continue;
            }
            this.getSpecHelper().parseError(regEntry, "Non-valid type of entry; only 'key' and 'value' are allowed.");
        }
    }

    private void performValueSetting(IXMLElement regEntry, VariableSubstitutor substitutor) throws Exception {
        SpecHelper specHelper = this.getSpecHelper();
        String name = specHelper.getRequiredAttribute(regEntry, REG_BASENAME);
        name = substitutor.substitute(name, null);
        String keypath = specHelper.getRequiredAttribute(regEntry, REG_KEYPATH);
        keypath = substitutor.substitute(keypath, null);
        String root = specHelper.getRequiredAttribute(regEntry, REG_ROOT);
        int rootId = this.resolveRoot(regEntry, root, substitutor);
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        if (rh == null) {
            return;
        }
        rh.setRoot(rootId);
        String override = regEntry.getAttribute(REG_OVERRIDE, "true");
        if (!"true".equalsIgnoreCase(override) && rh.getValue(keypath, name, null) != null) {
            return;
        }
        rh.setLogPrevSetValueFlag("true".equalsIgnoreCase(regEntry.getAttribute(SAVE_PREVIOUS, "true")));
        String value = regEntry.getAttribute(REG_DWORD);
        if (value != null) {
            value = substitutor.substitute(value, null);
            rh.setValue(keypath, name, Long.parseLong(value));
            return;
        }
        value = regEntry.getAttribute(REG_STRING);
        if (value != null) {
            value = substitutor.substitute(value, null);
            rh.setValue(keypath, name, value);
            return;
        }
        Vector<IXMLElement> values = regEntry.getChildrenNamed(REG_MULTI);
        if (values != null && !values.isEmpty()) {
            Iterator<IXMLElement> multiIter = values.iterator();
            String[] multiString = new String[values.size()];
            int i2 = 0;
            while (multiIter.hasNext()) {
                IXMLElement element = multiIter.next();
                multiString[i2] = specHelper.getRequiredAttribute(element, REG_DATA);
                multiString[i2] = substitutor.substitute(multiString[i2], null);
                ++i2;
            }
            rh.setValue(keypath, name, multiString);
            return;
        }
        values = regEntry.getChildrenNamed(REG_BIN);
        if (values != null && !values.isEmpty()) {
            Iterator<IXMLElement> multiIter = values.iterator();
            StringBuffer buf = new StringBuffer();
            int i3 = 0;
            while (multiIter.hasNext()) {
                IXMLElement element = multiIter.next();
                String tmp = specHelper.getRequiredAttribute(element, REG_DATA);
                buf.append(tmp);
                if (!tmp.endsWith(",") && multiIter.hasNext()) {
                    buf.append(",");
                }
                ++i3;
            }
            byte[] bytes = this.extractBytes(regEntry, substitutor.substitute(buf.toString(), null));
            rh.setValue(keypath, name, bytes);
            return;
        }
        specHelper.parseError(regEntry, "No data found.");
    }

    private byte[] extractBytes(IXMLElement element, String byteString) throws Exception {
        StringTokenizer st = new StringTokenizer(byteString, ",");
        byte[] retval = new byte[st.countTokens()];
        int i2 = 0;
        while (st.hasMoreTokens()) {
            byte value = 0;
            String token = st.nextToken().trim();
            try {
                int tval = Integer.parseInt(token, 16);
                if (tval < 0 || tval > 255) {
                    throw new NumberFormatException("Value out of range.");
                }
                if (tval > 127) {
                    tval -= 256;
                }
                value = (byte)tval;
            }
            catch (NumberFormatException nfe) {
                this.getSpecHelper().parseError(element, "Bad entry for REG_BINARY; a byte should be written as 2 digit hexvalue followed by a ','.");
            }
            retval[i2++] = value;
        }
        return retval;
    }

    private void performKeySetting(IXMLElement regEntry, VariableSubstitutor substitutor) throws Exception {
        String keypath = this.getSpecHelper().getRequiredAttribute(regEntry, REG_KEYPATH);
        keypath = substitutor.substitute(keypath, null);
        String root = this.getSpecHelper().getRequiredAttribute(regEntry, REG_ROOT);
        int rootId = this.resolveRoot(regEntry, root, substitutor);
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        if (rh == null) {
            return;
        }
        rh.setRoot(rootId);
        if (!rh.keyExist(keypath)) {
            rh.createKey(keypath);
        }
    }

    private int resolveRoot(IXMLElement regEntry, String root, VariableSubstitutor substitutor) throws Exception {
        String root1 = substitutor.substitute(root, null);
        Integer tmp = RegistryHandler.ROOT_KEY_MAP.get(root1);
        if (tmp != null) {
            return tmp;
        }
        this.getSpecHelper().parseError(regEntry, "Unknown value (" + root1 + ")for registry root.");
        return 0;
    }

    private void initializeRegistryHandler(AutomatedInstallData idata) throws Exception {
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        if (rh == null) {
            return;
        }
        rh.verify(idata);
        this.getSpecHelper().readSpec(SPEC_FILE_NAME);
    }
}

