/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.IzPanelConstraints;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.panels.PathSelectionPanel;
import com.izforge.izpack.util.Log;
import com.izforge.izpack.util.MultiLineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class IzPanelLayout
implements LayoutManager,
LayoutManager2,
LayoutConstants {
    private ArrayList<ArrayList<IzPanelConstraints>> components = new ArrayList();
    private int currentYPos = 0;
    private int currentXPos = -1;
    private Dimension prefLayoutDim;
    private Dimension oldParentSize;
    private Insets oldParentInsets;
    private int columnFillOutRule;
    private double[] overallYStretch = new double[]{-1.0, 0.0};
    protected static int[] DEFAULT_Y_GAPS = new int[]{-1, 0, 5, 5, 10, 5, 5, 5, 5, 5, 5, 5, 5, 5, 15, 12, 9, 6, 3, 0};
    protected static int[] DEFAULT_X_GAPS = new int[]{-1, 0, 0, 0, 0, 0, 10, 10, 10, 10, 10, 10, 10, 15, 12, 9, 6, 3, 0};
    protected static int[] DEFAULT_X_ALIGNMENT = new int[]{2, 2, 2, 2};
    protected static int[] DEFAULT_Y_ALIGNMENT = new int[]{0, 0, 0, 0};
    private static IzPanelConstraints[] DEFAULT_CONSTRAINTS = new IzPanelConstraints[]{new IzPanelConstraints(-1, -1, -1, -2, 1, 1, -19, -19, 0.0, 0.0), new IzPanelConstraints(-2, -2, -1, -2, 1, 1, -19, -19, 0.0, 0.0), new IzPanelConstraints(-3, -3, -1, -2, 1, 1, -19, -19, 0.0, 0.0), new IzPanelConstraints(-1, -1, 0, -1, 127, 127, -19, -19, -1.0, 0.0), new IzPanelConstraints(-1, -1, 0, -1, 127, 127, -19, -19, -1.0, -2.0), new IzPanelConstraints(-1, -1, -1, -2, 1, 1, 0, 0, 0.0, 0.0), new IzPanelConstraints(-1, -1, 0, -1, 1, 1, 0, 0, 0.0, 0.0), new IzPanelConstraints(-3, -3, 0, -1, 127, 127, -19, -19, -1.0, 0.0)};
    private static int ANCHOR = 0;
    private static int X_STRETCH_TYPE = 1;
    private static int Y_STRETCH_TYPE = 1;
    private static double FULL_LINE_STRETCH_DEFAULT = 1.0;
    private static double FULL_COLUMN_STRETCH_DEFAULT = 1.0;
    private static int DEFAULT_TEXTFIELD_LENGTH = 12;
    private static final int[][] GAP_INTERMEDIAER_LOOKUP = new int[][]{{-1, -5, -6, -1, -6, -1, -1}, {-7, -2, -10, -7, -10, -2, -2}, {-8, -9, -3, -8, -3, -3, -3}, {-1, -5, -6, -1, -6, -1, -1}, {-8, -9, -3, -8, -3, -3, -3}, {-13, -13, -13, -13, -13, -13, -13, -13}, {-13, -13, -13, -13, -13, -13, -13, -13}, {-13, -13, -13, -13, -13, -13, -13, -13}};

    public IzPanelLayout() {
        this(0);
    }

    public IzPanelLayout(int colFillOutRule) {
        this.columnFillOutRule = colFillOutRule;
    }

    private static int getYGap(IzPanelConstraints curConst, IzPanelConstraints nextYConst) {
        Class<FillerComponent> nextClass = nextYConst != null ? nextYConst.component.getClass() : FillerComponent.class;
        int interId = GAP_INTERMEDIAER_LOOKUP[IzPanelLayout.getIntermediarId(curConst.component.getClass(), null)][IzPanelLayout.getIntermediarId(nextClass, null)];
        if (interId < 0) {
            interId = -interId;
        }
        return DEFAULT_Y_GAPS[interId];
    }

    private static int getXGap(IzPanelConstraints curConst, IzPanelConstraints nextXConst) {
        Class<FillerComponent> nextClass = nextXConst != null ? nextXConst.component.getClass() : FillerComponent.class;
        int interId = GAP_INTERMEDIAER_LOOKUP[IzPanelLayout.getIntermediarId(curConst.component.getClass(), null)][IzPanelLayout.getIntermediarId(nextClass, null)];
        if (interId < 0) {
            interId = -interId;
        }
        return DEFAULT_X_GAPS[interId];
    }

    private static int getIntermediarId(Class clazz, Component comp) {
        if (comp != null) {
            if (MultiLineLabel.class.isAssignableFrom(clazz) || LabelFactory.FullLineLabel.class.isAssignableFrom(clazz)) {
                return 3;
            }
            if (PathSelectionPanel.class.isAssignableFrom(clazz) || JCheckBox.class.isAssignableFrom(clazz) || JRadioButton.class.isAssignableFrom(clazz)) {
                return 7;
            }
            if (FillerComponent.class.isAssignableFrom(clazz) || Box.Filler.class.isAssignableFrom(clazz)) {
                Dimension size = comp.getPreferredSize();
                if (size.height >= Short.MAX_VALUE || size.height <= 0) {
                    size.height = 0;
                    comp.setSize(size);
                    return 5;
                }
                if (size.width >= Short.MAX_VALUE || size.width <= 0) {
                    size.width = 0;
                    comp.setSize(size);
                    return 6;
                }
            }
        }
        if (JScrollPane.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (JLabel.class.isAssignableFrom(clazz)) {
            return 0;
        }
        if (JTextComponent.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (FillerComponent.class.isAssignableFrom(clazz)) {
            return 5;
        }
        if (Box.Filler.class.isAssignableFrom(clazz)) {
            return 5;
        }
        return 2;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.determineSize();
    }

    private Dimension determineSize() {
        if (this.prefLayoutDim == null) {
            int width = this.minimumAllColumnsWidth();
            int height = this.minimumOverallHeight();
            this.prefLayoutDim = new Dimension(width, height);
        }
        return (Dimension)this.prefLayoutDim.clone();
    }

    private int rows() {
        int maxRows = 0;
        for (ArrayList<IzPanelConstraints> component : this.components) {
            int curRows = component.size();
            if (curRows <= maxRows) continue;
            maxRows = curRows;
        }
        return maxRows;
    }

    private int columns() {
        return this.components.size();
    }

    private int minimumOverallHeight() {
        int height = 0;
        for (int i2 = 0; i2 < this.rows(); ++i2) {
            height += this.rowHeight(i2);
        }
        return height;
    }

    private int rowHeight(int row) {
        int height = 0;
        for (int i2 = 0; i2 < this.components.size(); ++i2) {
            int curHeight = this.getCellSize((int)i2, (int)row, null).height;
            if (curHeight <= height) continue;
            height = curHeight;
        }
        return height;
    }

    private int rowHeight(int row, int minOverallHeight, int maxOverallHeight) {
        int height = 0;
        double[] yStretch = this.getOverallYStretch();
        if (yStretch[0] <= 0.0) {
            return this.rowHeight(row);
        }
        double maxStretch = 0.0;
        double[] stretchParts = new double[this.components.size()];
        for (int i2 = 0; i2 < this.components.size(); ++i2) {
            int curHeight;
            double stretch;
            IzPanelConstraints constraints = this.getConstraints(i2, row);
            stretchParts[i2] = stretch = constraints.getYStretch();
            if (stretch > maxStretch) {
                maxStretch = stretch;
            }
            if ((curHeight = this.getCellSize((int)i2, (int)row, (IzPanelConstraints)constraints).height) <= height) continue;
            height = curHeight;
        }
        if (maxOverallHeight <= minOverallHeight) {
            return height;
        }
        int pixels = (int)((double)maxOverallHeight - yStretch[1] - (double)minOverallHeight);
        int stretchPart = (int)((double)pixels * maxStretch);
        if (stretchPart > 0) {
            for (int i3 = 0; i3 < this.components.size(); ++i3) {
                if (stretchParts[i3] < 1.0E-8) continue;
                IzPanelConstraints constraints = this.getConstraints(i3, row);
                Dimension size = constraints.component.getPreferredSize();
                size.height = (double)size.height + (double)stretchPart * stretchParts[i3] < (double)height ? (int)((double)height + (double)stretchPart * stretchParts[i3]) : height + stretchPart;
                if (constraints.component instanceof JScrollPane && ((JScrollPane)constraints.component).getViewport().getView() instanceof JTextArea && ((JTextArea)((JScrollPane)constraints.component).getViewport().getView()).getLineWrap()) {
                    size.width = 1000;
                }
                constraints.component.setPreferredSize(size);
            }
            height += stretchPart;
        }
        return height;
    }

    private double[] getOverallYStretch() {
        if (this.overallYStretch[0] >= 0.0) {
            return this.overallYStretch;
        }
        this.overallYStretch[0] = 0.0;
        for (int row = 0; row < this.rows(); ++row) {
            double maxStretch = 0.0;
            double maxGap = 0.0;
            for (int i2 = 0; i2 < this.components.size(); ++i2) {
                double curYGap;
                double curStretch;
                IzPanelConstraints constraints = this.getConstraints(i2, row);
                this.resolveDefaultSettings(i2, row);
                if (constraints.getYStretch() == -2.0) {
                    constraints.setYStretch(IzPanelLayout.getFullColumnStretch());
                }
                if ((curStretch = constraints.getYStretch()) > maxStretch) {
                    maxStretch = curStretch;
                }
                if (!((curYGap = (double)constraints.getYGap()) > maxGap)) continue;
                maxGap = curYGap;
            }
            this.overallYStretch[0] = this.overallYStretch[0] + maxStretch;
            this.overallYStretch[1] = this.overallYStretch[1] + maxGap;
        }
        if (this.overallYStretch[0] > 0.0) {
            switch (IzPanelLayout.getYStretchType()) {
                case 1: {
                    break;
                }
                case 2: {
                    this.overallYStretch[0] = 1.0;
                    break;
                }
                default: {
                    this.overallYStretch[0] = 0.0;
                }
            }
        }
        return this.overallYStretch;
    }

    private Dimension getCellSize(int column, int row, IzPanelConstraints constraints) {
        Dimension retval = new Dimension();
        try {
            if (constraints == null) {
                constraints = this.getConstraints(column, row);
            }
            if (constraints != null) {
                Component component = constraints.component;
                Dimension dim = component.getPreferredSize();
                Dimension dim2 = component.getMinimumSize();
                retval.height = dim.height > dim2.height ? dim.height : dim2.height;
                int n2 = retval.width = dim.width > dim2.width ? dim.width : dim2.width;
                if (component instanceof JScrollPane) {
                    retval.height = dim2.height;
                    retval.width = dim2.width;
                }
                if (this.needsReEvaluation(component)) {
                    retval.width = 0;
                }
            }
        }
        catch (Throwable exception) {
            // empty catch block
        }
        return retval;
    }

    private int minimumColumnWidth(int column) {
        int i2;
        int maxWidth = 0;
        Dimension[] cs2 = new Dimension[this.rows()];
        for (i2 = 0; i2 < this.rows(); ++i2) {
            IzPanelConstraints constraints = this.getConstraints(column, i2);
            cs2[i2] = this.getCellSize(column, i2, constraints);
            if (constraints.getXWeight() > 1 || maxWidth >= cs2[i2].width) continue;
            maxWidth = cs2[i2].width;
        }
        if (maxWidth == 0) {
            for (i2 = 0; i2 < this.rows(); ++i2) {
                if (maxWidth >= cs2[i2].width) continue;
                maxWidth = cs2[i2].width;
            }
        }
        return maxWidth;
    }

    private int minimumAllColumnsWidth() {
        int width = 0;
        for (int i2 = 0; i2 < this.components.size(); ++i2) {
            width += this.minimumColumnWidth(i2);
        }
        return width;
    }

    private IzPanelConstraints getConstraints(int col, int row) {
        if (col >= this.columns() || row >= this.rows()) {
            return null;
        }
        Cloneable obj = this.components.get(col);
        if (obj != null && obj instanceof ArrayList) {
            try {
                obj = this.components.get(col).get(row);
            }
            catch (Throwable t2) {
                obj = null;
            }
            if (obj != null) {
                return (IzPanelConstraints)obj;
            }
            ArrayList<IzPanelConstraints> colA = this.components.get(col);
            for (int curRow = colA.size(); row >= curRow; ++curRow) {
                IzPanelConstraints currentConst = IzPanelLayout.getDefaultConstraint(5);
                currentConst.setXPos(col);
                currentConst.setYPos(curRow);
                currentConst.component = new FillerComponent();
                try {
                    this.components.get(col).add(row, currentConst);
                    continue;
                }
                catch (Throwable t3) {
                    return null;
                }
            }
            return this.getConstraints(col, row);
        }
        return null;
    }

    private int getAdaptedXPos(int xpos, int curWidth, Dimension curDim, IzPanelConstraints currentConst) {
        int adaptedXPos = xpos;
        if ((this.columnFillOutRule & 1) > 0) {
            return adaptedXPos;
        }
        switch (currentConst.getXCellAlignment()) {
            case 2: {
                break;
            }
            case 4: {
                adaptedXPos += curWidth - curDim.width;
                break;
            }
            default: {
                adaptedXPos += (curWidth - curDim.width) / 2;
            }
        }
        return adaptedXPos;
    }

    private int getAdaptedYPos(int ypos, int curHeight, Dimension curDim, IzPanelConstraints currentConst) {
        int adaptedYPos = ypos;
        if ((this.columnFillOutRule & 2) > 0) {
            return adaptedYPos;
        }
        int height = curDim.height;
        switch (currentConst.getYCellAlignment()) {
            case 1: {
                break;
            }
            case 3: {
                adaptedYPos += curHeight - height;
                break;
            }
            default: {
                adaptedYPos += (curHeight - height) / 2;
            }
        }
        if (adaptedYPos < ypos) {
            return ypos;
        }
        return adaptedYPos;
    }

    private void resolveDefaultSettings(int col, int row) {
        IzPanelConstraints currentConst = this.getConstraints(col, row);
        IzPanelConstraints nextYConst = this.getConstraints(col, row + 1);
        IzPanelConstraints nextXConst = this.getConstraints(col + 1, row);
        if (currentConst == null) {
            return;
        }
        int gap = currentConst.getYGap();
        if (gap == -19) {
            currentConst.setYGap(IzPanelLayout.getYGap(currentConst, nextYConst));
        } else if (gap < 0) {
            currentConst.setYGap(DEFAULT_Y_GAPS[-gap]);
        }
        gap = currentConst.getXGap();
        if (gap == -19) {
            currentConst.setXGap(IzPanelLayout.getXGap(currentConst, nextXConst));
        } else if (gap < 0) {
            currentConst.setXGap(DEFAULT_X_GAPS[-gap]);
        }
        if (currentConst.getXCellAlignment() < 0) {
            currentConst.setXCellAlignment(DEFAULT_X_ALIGNMENT[-currentConst.getXCellAlignment()]);
        }
        if (currentConst.getYCellAlignment() < 0) {
            currentConst.setYCellAlignment(DEFAULT_Y_ALIGNMENT[-currentConst.getYCellAlignment()]);
        }
    }

    public void layoutContainer(Container parent) {
        if (!this.needNewLayout(parent)) {
            this.fastLayoutContainer(parent);
            return;
        }
        this.prefLayoutDim = null;
        this.preferredLayoutSize(parent);
        Dimension realSizeDim = parent.getSize();
        Log.getInstance().addDebugMessage("IzPanelLayout.layoutContainer parent size: {0}", new String[]{parent.getSize().toString()}, "LayoutTrace", null);
        Insets insets = parent.getInsets();
        int rowHeight = 0;
        int onceAgain = 0;
        int[] generellOffset = new int[]{0, 0};
        int maxWidth = 0;
        int overallHeight = 0;
        Rectangle curRect = new Rectangle();
        int minOverallHeight = this.minimumOverallHeight();
        int maxOverallHeight = realSizeDim.height - insets.top - insets.bottom;
        for (int anchorNeedsReEval = 0; anchorNeedsReEval < 2; anchorNeedsReEval += this.resolveGenerellOffsets(generellOffset, realSizeDim, insets, maxWidth, overallHeight)) {
            int ypos = insets.top;
            int row = 0;
            int minWidth = 65535;
            int minHeight = 65535;
            maxWidth = 0;
            overallHeight = 0;
            while (row < this.rows()) {
                int i2;
                int outerRowHeight = 0;
                int xpos = insets.left;
                int col = 0;
                IzPanelConstraints[] colConstraints = new IzPanelConstraints[this.columns()];
                int usedWidth = 0;
                while (col < this.columns()) {
                    int curMax;
                    IzPanelConstraints currentConst;
                    if (col == 0) {
                        rowHeight = this.rowHeight(row, minOverallHeight, maxOverallHeight);
                    }
                    colConstraints[col] = currentConst = this.getConstraints(col, row);
                    Component currentComp = currentConst.component;
                    Dimension curDim = currentComp.getPreferredSize();
                    int curWidth = this.minimumColumnWidth(col);
                    ++col;
                    if (currentConst.getXWeight() > 1) {
                        for (int weight = currentConst.getXWeight(); weight > 1 && col < this.columns(); ++col, --weight) {
                            colConstraints[col] = this.getConstraints(col, row);
                            if (!(colConstraints[col].component instanceof FillerComponent)) break;
                            curWidth += this.minimumColumnWidth(col);
                        }
                    }
                    int adaptedXPos = this.getAdaptedXPos(xpos, curWidth, curDim, currentConst);
                    int adaptedYPos = this.getAdaptedYPos(ypos, rowHeight, curDim, currentConst);
                    int useWidth = curDim.width;
                    int useHeight = curDim.height;
                    if ((this.columnFillOutRule & 1) > 0) {
                        useWidth = curWidth;
                    }
                    if ((this.columnFillOutRule & 2) > 0) {
                        useHeight = rowHeight;
                    }
                    if (curWidth < useWidth) {
                        useWidth = curWidth;
                    }
                    currentComp.setBounds(adaptedXPos + generellOffset[0], adaptedYPos + generellOffset[1], useWidth, useHeight);
                    currentComp.getBounds(curRect);
                    if (curRect.height > 100) {
                        curRect.height = useHeight;
                    }
                    if (!(currentComp instanceof FillerComponent)) {
                        if (curRect.x < minWidth) {
                            minWidth = curRect.x;
                        }
                        if (curRect.y < minHeight) {
                            minHeight = curRect.y;
                        }
                    }
                    if ((curMax = (int)curRect.getMaxX()) - minWidth > maxWidth) {
                        maxWidth = curMax - minWidth;
                    }
                    curMax = (int)curRect.getMaxY();
                    currentConst.setBounds(curRect);
                    if (curMax - minHeight > overallHeight) {
                        overallHeight = curMax - minHeight;
                    }
                    xpos += curWidth + currentConst.getXGap();
                    usedWidth += curWidth;
                    if (outerRowHeight >= rowHeight + currentConst.getYGap()) continue;
                    outerRowHeight = rowHeight + currentConst.getYGap();
                }
                double rowStretch = 0.0;
                for (i2 = 0; i2 < colConstraints.length; ++i2) {
                    if (colConstraints[i2].getXStretch() == -1.0) {
                        colConstraints[i2].setXStretch(IzPanelLayout.getFullLineStretch());
                    }
                    rowStretch += colConstraints[i2].getXStretch();
                }
                if (rowStretch > 0.0) {
                    switch (IzPanelLayout.getXStretchType()) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            rowStretch = 1.0;
                            break;
                        }
                        default: {
                            rowStretch = 0.0;
                        }
                    }
                }
                if (realSizeDim.width - insets.right != xpos && rowStretch > 0.0) {
                    int pixel = realSizeDim.width - insets.right - xpos;
                    int offset = 0;
                    int oldOnceAgain = onceAgain;
                    for (i2 = 0; i2 < colConstraints.length; ++i2) {
                        int curMax;
                        int curPixel = (int)(colConstraints[i2].getXStretch() / rowStretch * (double)pixel);
                        Rectangle curBounds = colConstraints[i2].component.getBounds();
                        int curWidth = this.minimumColumnWidth(i2);
                        if (curBounds.width < curWidth) {
                            curBounds.width = curWidth;
                        }
                        int newWidth = curPixel + curBounds.width;
                        Log.getInstance().addDebugMessage("IzPanelLayout.layoutContainer resize bounds for {2}|{3} old width {0} new width {1}", new String[]{Integer.toString(curBounds.width), Integer.toString(newWidth), Integer.toString(row), Integer.toString(i2)}, "LayoutTrace", null);
                        colConstraints[i2].component.setBounds(curBounds.x + offset, curBounds.y, newWidth, curBounds.height);
                        colConstraints[i2].component.getBounds(curRect);
                        if (curRect.x > 0 && curRect.x < minWidth) {
                            minWidth = curRect.x;
                        }
                        if (curRect.y > 0 && curRect.y < minHeight) {
                            minHeight = curRect.y;
                        }
                        if ((curMax = (int)curRect.getMaxX()) - minWidth > maxWidth) {
                            maxWidth = curMax - minWidth;
                        }
                        curMax = (int)curRect.getMaxY();
                        colConstraints[i2].setBounds(curRect);
                        if (curMax - minHeight > overallHeight) {
                            overallHeight = curMax - minHeight;
                        }
                        Log.getInstance().addDebugMessage("IzPanelLayout.layoutContainer resize bounds for {2}|{3} ({0}): {1}", new String[]{colConstraints[i2].component.getClass().getName(), curRect.toString(), Integer.toString(row), Integer.toString(i2)}, "LayoutTrace", null);
                        Log.getInstance().addDebugMessage("IzPanelLayout.layoutContainer resize bounds for {2}|{3}: maxWidth = {0} maxHeight = {1}", new String[]{Integer.toString(maxWidth), Integer.toString(overallHeight), Integer.toString(row), Integer.toString(i2)}, "LayoutTrace", null);
                        offset += curPixel;
                        if (!this.needsReEvaluation(colConstraints[i2].component) || oldOnceAgain != onceAgain) continue;
                        ++onceAgain;
                    }
                }
                if (onceAgain == 1) continue;
                onceAgain = 0;
                ypos += outerRowHeight;
                ++row;
            }
        }
    }

    private void fastLayoutContainer(Container parent) {
        for (int row = 0; row < this.rows(); ++row) {
            for (int col = 0; col < this.columns(); ++col) {
                IzPanelConstraints currentConst = this.getConstraints(col, row);
                if (currentConst == null) continue;
                Log.getInstance().addDebugMessage("IzPanelLayout.fastLayoutContainer bounds: {0}", new String[]{currentConst.getBounds().toString()}, "LayoutTrace", null);
                currentConst.component.setBounds(currentConst.getBounds());
            }
        }
    }

    private boolean needNewLayout(Container parent) {
        Dimension ops = this.oldParentSize;
        Insets opi = this.oldParentInsets;
        this.oldParentSize = parent.getSize();
        this.oldParentInsets = parent.getInsets();
        if (opi == null) {
            return true;
        }
        return !ops.equals(parent.getSize()) || !opi.equals(parent.getInsets());
    }

    private int resolveGenerellOffsets(int[] generellOffset, Dimension realSizeDim, Insets insets, int maxWidth, int overallHeight) {
        int retval = 1;
        switch (IzPanelLayout.getAnchor()) {
            case 0: {
                generellOffset[0] = (realSizeDim.width - insets.left - insets.right - maxWidth) / 2;
                generellOffset[1] = (realSizeDim.height - insets.top - insets.bottom - overallHeight) / 2;
                break;
            }
            case 7: {
                generellOffset[0] = 0;
                generellOffset[1] = (realSizeDim.height - insets.top - insets.bottom - overallHeight) / 2;
                break;
            }
            case 3: {
                generellOffset[0] = realSizeDim.width - insets.left - insets.right - maxWidth;
                generellOffset[1] = (realSizeDim.height - insets.top - insets.bottom - overallHeight) / 2;
                break;
            }
            case 1: {
                generellOffset[0] = (realSizeDim.width - insets.left - insets.right - maxWidth) / 2;
                generellOffset[1] = 0;
                break;
            }
            case 5: {
                generellOffset[0] = (realSizeDim.width - insets.left - insets.right - maxWidth) / 2;
                generellOffset[1] = realSizeDim.height - insets.top - insets.bottom - overallHeight;
                break;
            }
            case 8: {
                generellOffset[0] = 0;
                generellOffset[1] = 0;
                retval = 2;
                break;
            }
            case 2: {
                generellOffset[0] = realSizeDim.width - insets.left - insets.right - maxWidth;
                generellOffset[1] = 0;
                break;
            }
            case 6: {
                generellOffset[0] = 0;
                generellOffset[1] = realSizeDim.height - insets.top - insets.bottom - overallHeight;
                break;
            }
            case 4: {
                generellOffset[0] = realSizeDim.width - insets.left - insets.right - maxWidth;
                generellOffset[1] = realSizeDim.height - insets.top - insets.bottom - overallHeight;
            }
        }
        if (generellOffset[0] < 0) {
            generellOffset[0] = 0;
        }
        if (generellOffset[1] < 0) {
            generellOffset[1] = 0;
        }
        return retval;
    }

    private boolean needsReEvaluation(Component comp) {
        return comp instanceof MultiLineLabel || comp instanceof PathSelectionPanel;
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public void invalidateLayout(Container target) {
    }

    public Dimension maximumLayoutSize(Container target) {
        return this.minimumLayoutSize(target);
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        int i2;
        int perfCol;
        IzPanelConstraints cc2;
        if (comp == null) {
            throw new NullPointerException("component has to be not null");
        }
        if (!(constraints instanceof IzPanelConstraints)) {
            cc2 = comp instanceof FillerComponent && ((FillerComponent)comp).getConstraints() != null ? (IzPanelConstraints)((FillerComponent)comp).getConstraints().clone() : (IzPanelConstraints)DEFAULT_CONSTRAINTS[IzPanelLayout.getIntermediarId(comp.getClass(), comp)].clone();
            if ("nextLine".equals(constraints)) {
                cc2.setXPos(0);
                cc2.setYPos(-1);
            }
        } else {
            cc2 = (IzPanelConstraints)((IzPanelConstraints)constraints).clone();
        }
        cc2.component = comp;
        int yPos = cc2.getYPos();
        if (yPos == -1) {
            yPos = this.currentYPos + 1;
        }
        if (yPos == -2) {
            yPos = this.currentYPos;
        }
        cc2.setYPos(yPos);
        int xPos = cc2.getXPos();
        if (xPos == -1) {
            xPos = this.currentXPos + 1;
        }
        if (xPos == -2) {
            xPos = this.currentXPos;
        }
        cc2.setXPos(xPos);
        int n2 = perfCol = cc2.getXWeight() < 127 ? cc2.getXWeight() : 1;
        if (this.components.size() < cc2.getXPos() + perfCol) {
            for (i2 = this.components.size() - 1; i2 < cc2.getXPos() + perfCol - 1; ++i2) {
                this.components.add(new ArrayList());
            }
        }
        IzPanelConstraints curConst = cc2;
        for (int j2 = 0; j2 < perfCol; ++j2) {
            ArrayList<IzPanelConstraints> xComp = this.components.get(xPos);
            if (xComp.size() < yPos) {
                for (i2 = xComp.size() - 1; i2 < yPos - 1; ++i2) {
                    IzPanelConstraints dc2 = IzPanelLayout.getDefaultConstraint(5);
                    dc2.component = new FillerComponent();
                    xComp.add(dc2);
                }
            }
            xComp.add(yPos, curConst);
            if (j2 >= perfCol - 1) continue;
            curConst = IzPanelLayout.getDefaultConstraint(5);
            curConst.component = new FillerComponent();
            ++xPos;
        }
        int xcsize = this.components.get(xPos).size() - 1;
        if (this.currentYPos < xcsize) {
            this.currentYPos = xcsize;
        }
        this.currentXPos = xPos;
    }

    public static Component createHorizontalStrut(int width) {
        return new FillerComponent(new Dimension(width, 0));
    }

    public static Component createVerticalStrut(int height) {
        return new FillerComponent(new Dimension(0, height));
    }

    public static Component createParagraphGap() {
        return IzPanelLayout.createGap(-4, 1);
    }

    public static Component createVerticalFiller(int fillerNumber) {
        return IzPanelLayout.createGap(-13 - fillerNumber, 1);
    }

    public static Component createHorizontalFiller(int fillerNumber) {
        return IzPanelLayout.createGap(-13 - fillerNumber, 0);
    }

    public static Component createGap(int gapType, int direction) {
        if (direction == 0) {
            return new FillerComponent(new Dimension(0, 0), new IzPanelConstraints(-3, -3, -1, -2, 1, 1, gapType, 0, 0.0, 0.0));
        }
        return new FillerComponent(new Dimension(0, 0), new IzPanelConstraints(-3, -3, 0, -1, 10, 10, 0, gapType, 1.0, 0.0));
    }

    public static IzPanelConstraints getDefaultConstraint(int type) {
        return (IzPanelConstraints)DEFAULT_CONSTRAINTS[type].clone();
    }

    public static int getAnchor() {
        return ANCHOR;
    }

    public static void setAnchor(int anchor) {
        ANCHOR = anchor;
    }

    public static int getXStretchType() {
        return X_STRETCH_TYPE;
    }

    public static void setXStretchType(int x_stretch) {
        X_STRETCH_TYPE = x_stretch;
    }

    public static int getYStretchType() {
        return Y_STRETCH_TYPE;
    }

    public static void setYStretchType(int y_stretch) {
        Y_STRETCH_TYPE = y_stretch;
    }

    public static double getFullLineStretch() {
        return FULL_LINE_STRETCH_DEFAULT;
    }

    public static void setFullLineStretch(double fullLineStretch) {
        FULL_LINE_STRETCH_DEFAULT = fullLineStretch;
    }

    public static double getFullColumnStretch() {
        return FULL_COLUMN_STRETCH_DEFAULT;
    }

    public static void setFullColumnStretch(double fullStretch) {
        FULL_COLUMN_STRETCH_DEFAULT = fullStretch;
    }

    public static int verifyGapId(int gapId) {
        if (gapId < 0) {
            gapId = -gapId;
        }
        if (gapId >= DEFAULT_X_GAPS.length) {
            throw new IndexOutOfBoundsException("gapId is not in the default gap container.");
        }
        return gapId;
    }

    public static int getDefaultXGap(int gapId) {
        gapId = IzPanelLayout.verifyGapId(gapId);
        return DEFAULT_X_GAPS[gapId];
    }

    public static void setDefaultXGap(int gap, int gapId) {
        gapId = IzPanelLayout.verifyGapId(gapId);
        IzPanelLayout.DEFAULT_X_GAPS[gapId] = gap;
    }

    public static int getDefaultYGap(int gapId) {
        gapId = IzPanelLayout.verifyGapId(gapId);
        return DEFAULT_Y_GAPS[gapId];
    }

    public static void setDefaultYGap(int gap, int gapId) {
        gapId = IzPanelLayout.verifyGapId(gapId);
        IzPanelLayout.DEFAULT_Y_GAPS[gapId] = gap;
    }

    public static int getDefaultTextfieldLength() {
        return DEFAULT_TEXTFIELD_LENGTH;
    }

    public static void setDefaultTextfieldLength(int val) {
        DEFAULT_TEXTFIELD_LENGTH = val;
    }

    public static class FillerComponent
    extends Component {
        private static final long serialVersionUID = 7270064864038287900L;
        private Dimension size;
        private IzPanelConstraints constraints;

        public FillerComponent() {
            this(new Dimension(0, 0));
        }

        public FillerComponent(Dimension size) {
            this(size, null);
        }

        public FillerComponent(Dimension size, IzPanelConstraints constraints) {
            this.size = size;
            this.constraints = constraints;
        }

        public Dimension getMinimumSize() {
            return (Dimension)this.size.clone();
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            return this.getMinimumSize();
        }

        public Rectangle getBounds() {
            return this.getBounds(new Rectangle());
        }

        public Rectangle getBounds(Rectangle rect) {
            Rectangle rv = rect != null ? rect : new Rectangle();
            rv.setBounds(0, 0, this.size.width, this.size.height);
            return rv;
        }

        public IzPanelConstraints getConstraints() {
            return this.constraints;
        }

        public void setConstraints(IzPanelConstraints constraints) {
            this.constraints = constraints;
        }
    }
}

