/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ConsolePanelAutomationHelper;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.DataValidatorFactory;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionFactory;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomatedInstaller
extends InstallerBase {
    private TreeMap<String, Integer> panelInstanceCount;
    private AutomatedInstallData idata = new AutomatedInstallData();
    private boolean result = false;

    public AutomatedInstaller(String inputFilename) throws Exception {
        File input = new File(inputFilename);
        this.loadInstallData(this.idata);
        this.idata.xmlData = this.getXMLData(input);
        this.idata.setVariable("Automated", "true");
        this.idata.localeISO3 = this.idata.xmlData.getAttribute("langpack", "eng");
        InputStream in = this.getClass().getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".properties");
        this.idata.langpack = new LocaleDatabase(in);
        this.idata.setVariable("ISO3_LANG", this.idata.localeISO3);
        ResourceManager.create(this.idata);
        this.addCustomLangpack(this.idata);
        this.panelInstanceCount = new TreeMap();
        this.loadConditions(this.idata);
        this.loadInstallerRequirements();
        this.loadDynamicVariables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUninstallerInstallLog(UninstallData udata) {
        ArrayList<String> uninstallerInfos = new ArrayList<String>();
        File f2 = new File(this.idata.getInstallPath() + File.separator + "Uninstaller" + File.separator + "install.log");
        if (f2.exists() && f2.canRead()) {
            FileReader fr2 = null;
            BufferedReader br2 = null;
            try {
                String s2;
                fr2 = new FileReader(f2);
                br2 = new BufferedReader(fr2);
                while ((s2 = br2.readLine()) != null) {
                    uninstallerInfos.add(s2);
                }
            }
            catch (Exception e2) {
                Debug.trace(e2);
            }
            finally {
                try {
                    fr2.close();
                }
                catch (IOException e3) {}
                try {
                    br2.close();
                }
                catch (IOException e4) {}
            }
        }
        ArrayList files = udata.getUninstalableFilesList();
        if (uninstallerInfos != null && uninstallerInfos.size() > 0) {
            files.addAll(uninstallerInfos);
            HashSet hashSet = new HashSet(files);
            files = new ArrayList(hashSet);
        }
        return files;
    }

    private void insertUninstallerInstallLog(UninstallData udata, ZipOutputStream outJar) throws Exception {
        outJar.putNextEntry(new ZipEntry("install.log"));
        BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
        logWriter.write(this.idata.getInstallPath());
        logWriter.newLine();
        Iterator<String> iter = this.getUninstallerInstallLog(udata).iterator();
        while (iter.hasNext()) {
            logWriter.write(iter.next());
            if (!iter.hasNext()) continue;
            logWriter.newLine();
        }
        logWriter.flush();
        outJar.closeEntry();
    }

    private void insertUninstallerJarlocationLog(UninstallData udata, ZipOutputStream outJar) throws Exception {
        outJar.putNextEntry(new ZipEntry("jarlocation.log"));
        BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
        logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
        logWriter.write(udata.getUninstallerJarFilename());
        logWriter.newLine();
        logWriter.write(udata.getUninstallerPath());
        logWriter.flush();
        outJar.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ExecutableFile> getExecutablesList() {
        ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
        File f2 = new File(this.idata.getInstallPath() + File.separator + "Uninstaller" + File.separator + "executables");
        if (f2.exists() && f2.canRead()) {
            FileInputStream fin = null;
            ObjectInputStream oin = null;
            try {
                fin = new FileInputStream(f2);
                oin = new ObjectInputStream(fin);
                int num = oin.readInt();
                for (int i2 = 0; i2 < num; ++i2) {
                    ExecutableFile file = (ExecutableFile)oin.readObject();
                    executables.add(file);
                }
            }
            catch (Exception e2) {
                Debug.error(e2);
            }
            finally {
                try {
                    fin.close();
                }
                catch (IOException e3) {}
                try {
                    oin.close();
                }
                catch (IOException e4) {}
            }
        }
        return executables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertUninstallerExecutables(UninstallData udata, ZipOutputStream outJar) {
        ObjectOutputStream execStream = null;
        try {
            outJar.putNextEntry(new ZipEntry("executables"));
            execStream = new ObjectOutputStream(outJar);
            ArrayList<ExecutableFile> executablesList = udata.getExecutablesList();
            ArrayList<ExecutableFile> oldExecutablesList = this.getExecutablesList();
            if (oldExecutablesList != null && oldExecutablesList.size() > 0) {
                executablesList.addAll(oldExecutablesList);
            }
            HashSet hashSet = new HashSet(executablesList);
            executablesList = new ArrayList<ExecutableFile>(hashSet);
            Iterator iter = executablesList.iterator();
            execStream.writeInt(executablesList.size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream.writeObject(file);
            }
        }
        catch (IOException e2) {
            Debug.error(e2);
        }
        finally {
            try {
                execStream.flush();
            }
            catch (IOException e3) {}
            try {
                outJar.closeEntry();
            }
            catch (IOException e4) {}
        }
    }

    private boolean writeUninstallData() {
        try {
            Debug.log("[ Writing the uninstaller data ... ]");
            ZipOutputStream outJar = this.idata.uninstallOutJar;
            if (outJar == null) {
                return true;
            }
            UninstallData udata = UninstallData.getInstance();
            this.insertUninstallerInstallLog(udata, outJar);
            this.insertUninstallerJarlocationLog(udata, outJar);
            this.insertUninstallerExecutables(udata, outJar);
            Map<String, Object> additionalData = udata.getAdditionalData();
            if (additionalData != null && !additionalData.isEmpty()) {
                Iterator<String> keys = additionalData.keySet().iterator();
                HashSet<String> exist = new HashSet<String>();
                while (keys != null && keys.hasNext()) {
                    int bytesInBuffer;
                    long bytesCopied;
                    byte[] buffer;
                    String key = keys.next();
                    Object contents = additionalData.get(key);
                    if ("__uninstallLibs__".equals(key)) {
                        Iterator nativeLibIter = ((List)contents).iterator();
                        while (nativeLibIter != null && nativeLibIter.hasNext()) {
                            String nativeLibName = (String)((List)nativeLibIter.next()).get(0);
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            outJar.putNextEntry(new ZipEntry("native/" + nativeLibName));
                            InputStream in = this.getClass().getResourceAsStream("/native/" + nativeLibName);
                            while ((bytesInBuffer = in.read(buffer)) != -1) {
                                outJar.write(buffer, 0, bytesInBuffer);
                                bytesCopied += (long)bytesInBuffer;
                            }
                            outJar.closeEntry();
                        }
                        continue;
                    }
                    if ("uninstallerListeners".equals(key) || "uninstallerJars".equals(key)) {
                        ArrayList<String> subContents = new ArrayList<String>();
                        Iterator listenerIter = ((List)contents).iterator();
                        while (listenerIter.hasNext()) {
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            CustomData customData = (CustomData)listenerIter.next();
                            if (customData.listenerName != null) {
                                subContents.add(customData.listenerName);
                            }
                            for (String contentPath : customData.contents) {
                                if (exist.contains(contentPath)) continue;
                                exist.add(contentPath);
                                try {
                                    outJar.putNextEntry(new ZipEntry(contentPath));
                                }
                                catch (ZipException ze) {
                                    Debug.trace("ZipException in writing custom data: " + ze.getMessage());
                                    continue;
                                }
                                InputStream in = this.getClass().getResourceAsStream("/" + contentPath);
                                if (in != null) {
                                    while ((bytesInBuffer = in.read(buffer)) != -1) {
                                        outJar.write(buffer, 0, bytesInBuffer);
                                        bytesCopied += (long)bytesInBuffer;
                                    }
                                } else {
                                    Debug.trace("custom data not found: " + contentPath);
                                }
                                outJar.closeEntry();
                            }
                        }
                        outJar.putNextEntry(new ZipEntry(key));
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(subContents);
                        objOut.flush();
                        outJar.closeEntry();
                        continue;
                    }
                    outJar.putNextEntry(new ZipEntry(key));
                    if (contents instanceof ByteArrayOutputStream) {
                        ((ByteArrayOutputStream)contents).writeTo(outJar);
                    } else {
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(contents);
                        objOut.flush();
                    }
                    outJar.closeEntry();
                }
            }
            ArrayList<String> unInstallScripts = udata.getUninstallScripts();
            Iterator<String> unInstallIter = unInstallScripts.iterator();
            int idx = 0;
            while (unInstallIter.hasNext()) {
                outJar.putNextEntry(new ZipEntry("rootscript" + Integer.toString(idx)));
                ObjectOutputStream rootStream = new ObjectOutputStream(outJar);
                String unInstallScript = unInstallIter.next();
                rootStream.writeUTF(unInstallScript);
                rootStream.flush();
                outJar.closeEntry();
            }
            outJar.flush();
            outJar.close();
            return true;
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInstall() throws Exception {
        block10: {
            if (!this.checkInstallerRequirements(this.idata)) {
                Debug.log("not all installerconditions are fulfilled.");
                System.exit(-1);
                return;
            }
            System.out.println("[ Starting automated installation ]");
            Debug.log("[ Starting automated installation ]");
            ConsolePanelAutomationHelper uihelper = new ConsolePanelAutomationHelper();
            try {
                this.result = true;
                VariableSubstitutor substitutor = new VariableSubstitutor(this.idata.getVariables());
                for (Panel p2 : this.idata.panelsOrder) {
                    if (p2.hasCondition() && !this.idata.getRules().isConditionTrue(p2.getCondition(), this.idata.variables)) {
                        Debug.log("Condition for panel " + p2.getPanelid() + "is not fulfilled, skipping panel!");
                        if (this.panelInstanceCount.containsKey(p2.className)) {
                            this.panelInstanceCount.put(p2.className, this.panelInstanceCount.get(p2.className) + 1);
                            continue;
                        }
                        this.panelInstanceCount.put(p2.className, 1);
                        continue;
                    }
                    if (!OsConstraint.oneMatchesCurrentSystem(p2.osConstraints)) continue;
                    PanelAutomation automationHelper = this.getPanelAutomationHelper(p2);
                    if (automationHelper == null) {
                        this.executePreValidateActions(p2, uihelper);
                        this.validatePanel(p2);
                        this.executePostValidateActions(p2, uihelper);
                        continue;
                    }
                    IXMLElement panelRoot = this.updateInstanceCount(p2);
                    this.installPanel(p2, automationHelper, panelRoot);
                    this.refreshDynamicVariables(substitutor, this.idata);
                }
                this.writeUninstallData();
                if (this.result) {
                    System.out.println("[ Automated installation done ]");
                    break block10;
                }
                System.out.println("[ Automated installation FAILED! ]");
            }
            catch (Exception e2) {
                try {
                    this.result = false;
                    System.err.println(e2.toString());
                    e2.printStackTrace();
                    System.out.println("[ Automated installation FAILED! ]");
                }
                catch (Throwable throwable) {
                    Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                    throw throwable;
                }
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    private void installPanel(Panel p2, PanelAutomation automationHelper, IXMLElement panelRoot) throws InstallerException {
        this.executePreActivateActions(p2, null);
        Debug.log("automationHelperInstance.runAutomated :" + automationHelper.getClass().getName() + " entered.");
        automationHelper.runAutomated(this.idata, panelRoot);
        Debug.log("automationHelperInstance.runAutomated :" + automationHelper.getClass().getName() + " successfully done.");
        this.executePreValidateActions(p2, null);
        this.validatePanel(p2);
        this.executePostValidateActions(p2, null);
    }

    private IXMLElement updateInstanceCount(Panel p2) {
        String panelClassName = p2.className;
        Vector<IXMLElement> panelRoots = this.idata.xmlData.getChildrenNamed(panelClassName);
        int panelRootNo = 0;
        if (this.panelInstanceCount.containsKey(panelClassName)) {
            panelRootNo = this.panelInstanceCount.get(panelClassName);
        }
        IXMLElement panelRoot = panelRoots.elementAt(panelRootNo);
        this.panelInstanceCount.put(panelClassName, panelRootNo + 1);
        return panelRoot;
    }

    private PanelAutomation getPanelAutomationHelper(Panel p2) {
        Class<?> automationHelperClass = null;
        PanelAutomation automationHelperInstance = null;
        String praefix = "com.izforge.izpack.panels.";
        if (p2.className.compareTo(".") > -1) {
            praefix = "";
        }
        String automationHelperClassName = praefix + p2.className + "AutomationHelper";
        try {
            Debug.log("AutomationHelper:" + automationHelperClassName);
            automationHelperClass = Class.forName(automationHelperClassName);
        }
        catch (ClassNotFoundException e2) {
            Debug.log("ClassNotFoundException-skip :" + automationHelperClassName);
        }
        this.executePreConstructActions(p2, null);
        if (automationHelperClass != null) {
            try {
                Debug.log("Instantiate :" + automationHelperClassName);
                automationHelperInstance = (PanelAutomation)automationHelperClass.newInstance();
            }
            catch (IllegalAccessException e3) {
                Debug.log("ERROR: no default constructor for " + automationHelperClassName + ", skipping...");
            }
            catch (InstantiationException e4) {
                Debug.log("ERROR: no default constructor for " + automationHelperClassName + ", skipping...");
            }
        }
        return automationHelperInstance;
    }

    private void validatePanel(Panel p2) throws InstallerException {
        DataValidator validator;
        DataValidator.Status validationResult;
        String dataValidator = p2.getValidator();
        if (dataValidator != null && (validationResult = (validator = DataValidatorFactory.createDataValidator(dataValidator)).validateData(this.idata)) != DataValidator.Status.OK) {
            if (validationResult == DataValidator.Status.WARNING && validator.getDefaultAnswer()) {
                System.out.println("Configuration said, it's ok to go on, if validation is not successfull");
                return;
            }
            this.result = false;
            throw new InstallerException("Validating data for panel " + p2.getPanelid() + " was not successfull");
        }
    }

    public IXMLElement getXMLData(File input) throws IOException {
        FileInputStream in = new FileInputStream(input);
        XMLParser parser = new XMLParser();
        IXMLElement rtn = parser.parse(in, input.getAbsolutePath());
        in.close();
        return rtn;
    }

    public boolean getResult() {
        return this.result;
    }

    private List<PanelAction> createPanelActionsFromStringList(Panel panel, List<String> actions) {
        ArrayList<PanelAction> actionList = null;
        if (actions != null) {
            actionList = new ArrayList<PanelAction>();
            for (String actionClassName : actions) {
                PanelAction action = PanelActionFactory.createPanelAction(actionClassName);
                action.initialize(panel.getPanelActionConfiguration(actionClassName));
                actionList.add(action);
            }
        }
        return actionList;
    }

    private void executePreConstructActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> preConstructActions = this.createPanelActionsFromStringList(panel, panel.getPreConstructionActions());
        if (preConstructActions != null) {
            for (PanelAction preConstructAction : preConstructActions) {
                preConstructAction.executeAction(this.idata, handler);
            }
        }
    }

    private void executePreActivateActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> preActivateActions = this.createPanelActionsFromStringList(panel, panel.getPreActivationActions());
        if (preActivateActions != null) {
            for (PanelAction preActivateAction : preActivateActions) {
                preActivateAction.executeAction(this.idata, handler);
            }
        }
    }

    private void executePreValidateActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> preValidateActions = this.createPanelActionsFromStringList(panel, panel.getPreValidationActions());
        if (preValidateActions != null) {
            for (PanelAction preValidateAction : preValidateActions) {
                preValidateAction.executeAction(this.idata, handler);
            }
        }
    }

    private void executePostValidateActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> postValidateActions = this.createPanelActionsFromStringList(panel, panel.getPostValidationActions());
        if (postValidateActions != null) {
            for (PanelAction postValidateAction : postValidateActions) {
                postValidateAction.executeAction(this.idata, handler);
            }
        }
    }
}

