/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.DataValidatorFactory;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.PanelConsole;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Properties;

public class ConsoleInstaller
extends InstallerBase {
    private AutomatedInstallData installdata = new AutomatedInstallData();
    private boolean result = false;
    private Properties properties;
    private PrintWriter printWriter;

    public ConsoleInstaller(String langcode) throws Exception {
        this.loadInstallData(this.installdata);
        this.installdata.localeISO3 = langcode;
        if (this.installdata.localeISO3 == null) {
            this.installdata.localeISO3 = this.getAvailableLangPacks().get(0);
        }
        InputStream in = this.getClass().getResourceAsStream("/langpacks/" + this.installdata.localeISO3 + ".xml");
        this.installdata.langpack = new LocaleDatabase(in);
        this.installdata.setVariable("ISO3_LANG", this.installdata.localeISO3);
        ResourceManager.create(this.installdata);
        this.loadConditions(this.installdata);
        this.loadInstallerRequirements();
        this.loadDynamicVariables();
        if (!this.checkInstallerRequirements(this.installdata)) {
            Debug.log("not all installerconditions are fulfilled.");
            return;
        }
        this.addCustomLangpack(this.installdata);
    }

    protected void iterateAndPerformAction(String strAction) throws Exception {
        if (!this.checkInstallerRequirements(this.installdata)) {
            Debug.log("not all installerconditions are fulfilled.");
            return;
        }
        Debug.log("[ Starting console installation ] " + strAction);
        try {
            this.result = true;
            Iterator<Panel> panelsIterator = this.installdata.panelsOrder.iterator();
            this.installdata.curPanelNumber = -1;
            VariableSubstitutor substitutor = new VariableSubstitutor(this.installdata.getVariables());
            while (panelsIterator.hasNext()) {
                Panel p2 = panelsIterator.next();
                ++this.installdata.curPanelNumber;
                String praefix = "com.izforge.izpack.panels.";
                if (p2.className.compareTo(".") > -1) {
                    praefix = "";
                }
                if (!OsConstraint.oneMatchesCurrentSystem(p2.osConstraints)) continue;
                String panelClassName = p2.className;
                String consoleHelperClassName = praefix + panelClassName + "ConsoleHelper";
                Class<?> consoleHelperClass = null;
                Debug.log("ConsoleHelper:" + consoleHelperClassName);
                try {
                    consoleHelperClass = Class.forName(consoleHelperClassName);
                }
                catch (ClassNotFoundException e2) {
                    Debug.log("ClassNotFoundException-skip :" + consoleHelperClassName);
                    continue;
                }
                PanelConsole consoleHelperInstance = null;
                if (consoleHelperClass != null) {
                    try {
                        Debug.log("Instantiate :" + consoleHelperClassName);
                        this.refreshDynamicVariables(substitutor, this.installdata);
                        consoleHelperInstance = (PanelConsole)consoleHelperClass.newInstance();
                    }
                    catch (Exception e3) {
                        Debug.log("ERROR: no default constructor for " + consoleHelperClassName + ", skipping...");
                        continue;
                    }
                }
                if (consoleHelperInstance == null) continue;
                try {
                    Debug.log("consoleHelperInstance." + strAction + ":" + consoleHelperClassName + " entered.");
                    boolean bActionResult = true;
                    boolean bIsConditionFulfilled = true;
                    String strCondition = p2.getCondition();
                    if (strCondition != null) {
                        bIsConditionFulfilled = this.installdata.getRules().isConditionTrue(strCondition);
                    }
                    if (strAction.equals("doInstall") && bIsConditionFulfilled) {
                        do {
                            bActionResult = consoleHelperInstance.runConsole(this.installdata);
                        } while (!this.validatePanel(p2));
                    } else if (strAction.equals("doGeneratePropertiesFile")) {
                        bActionResult = consoleHelperInstance.runGeneratePropertiesFile(this.installdata, this.printWriter);
                    } else if (strAction.equals("doInstallFromPropertiesFile") && bIsConditionFulfilled) {
                        bActionResult = consoleHelperInstance.runConsoleFromPropertiesFile(this.installdata, this.properties);
                    }
                    if (!bActionResult) {
                        this.result = false;
                        return;
                    }
                    Debug.log("consoleHelperInstance." + strAction + ":" + consoleHelperClassName + " successfully done.");
                }
                catch (Exception e4) {
                    Debug.log("ERROR: console installation failed for panel " + panelClassName);
                    e4.printStackTrace();
                    this.result = false;
                }
            }
            if (this.result) {
                System.out.println("[ Console installation done ]");
            } else {
                System.out.println("[ Console installation FAILED! ]");
            }
        }
        catch (Exception e5) {
            this.result = false;
            System.err.println(e5.toString());
            e5.printStackTrace();
            System.out.println("[ Console installation FAILED! ]");
        }
    }

    protected void doInstall() throws Exception {
        try {
            this.iterateAndPerformAction("doInstall");
        }
        catch (Exception e2) {
            try {
                throw e2;
            }
            catch (Throwable throwable) {
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    protected void doGeneratePropertiesFile(String strFile) throws Exception {
        try {
            this.printWriter = new PrintWriter(strFile);
            this.iterateAndPerformAction("doGeneratePropertiesFile");
            this.printWriter.flush();
            this.printWriter.close();
        }
        catch (Exception e2) {
            try {
                throw e2;
            }
            catch (Throwable throwable) {
                this.printWriter.close();
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    protected void doInstallFromPropertiesFile(String strFile) throws Exception {
        FileInputStream in = new FileInputStream(strFile);
        try {
            this.properties = new Properties();
            this.properties.load(in);
            this.iterateAndPerformAction("doInstallFromPropertiesFile");
        }
        catch (Exception e2) {
            try {
                throw e2;
            }
            catch (Throwable throwable) {
                in.close();
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
                throw throwable;
            }
        }
        in.close();
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    private boolean validatePanel(Panel p2) throws InstallerException {
        DataValidator validator;
        DataValidator.Status validationResult;
        boolean bValidity = true;
        String dataValidator = p2.getValidator();
        if (dataValidator != null && (validationResult = (validator = DataValidatorFactory.createDataValidator(dataValidator)).validateData(this.installdata)) != DataValidator.Status.OK) {
            if (validationResult == DataValidator.Status.WARNING && validator.getDefaultAnswer()) {
                System.out.println("Configuration said, it's ok to go on, if validation is not successfull");
            }
            bValidity = false;
            System.out.println("Validation failed, please verify your input");
        }
        return bValidity;
    }

    public void run(int type, String path) throws Exception {
        switch (type) {
            case 1: {
                this.doGeneratePropertiesFile(path);
                break;
            }
            case 2: {
                this.doInstallFromPropertiesFile(path);
                break;
            }
            default: {
                this.doInstall();
            }
        }
    }
}

