/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.coi.tools.os.win.NativeLibException;
import com.inet.looks.plastic.PlasticLookAndFeel;
import com.inet.looks.plastic.PlasticXPLookAndFeel;
import com.inet.looks.plastic.theme.InetCrystalClear;
import com.inet.textui.IzpackTextUI;
import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.WriterOutputStream;
import com.izforge.izpack.util.os.RegistryDefaultHandler;
import com.izforge.izpack.util.os.RegistryHandler;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUIInstaller
extends InstallerBase {
    private InstallData installdata;

    public GUIInstaller() throws Exception {
        Debug.setLOG(true);
        if (!"true".equalsIgnoreCase(System.getProperty("setup.show.error"))) {
            System.setErr(new PrintStream(new WriterOutputStream(Debug.getLogFile())));
        }
        if (!GraphicsEnvironment.isHeadless() && !"true".equalsIgnoreCase(System.getProperty("setup.show.error"))) {
            System.setOut(new PrintStream(new WriterOutputStream(Debug.getLogFile())));
        }
        try {
            this.init();
        }
        catch (Exception e2) {
            this.showFatalError(e2);
            throw e2;
        }
        catch (Error e3) {
            this.showFatalError(e3);
            throw e3;
        }
    }

    private void showFatalError(Throwable e2) {
        this.showMessageDialog("Error: " + e2.toString() + "\n" + e2.getCause());
    }

    private void init() throws Exception {
        this.installdata = new InstallData();
        this.loadInstallData(this.installdata);
        this.loadLangPack();
        this.addCustomLangpack(this.installdata);
        this.loadConditions(this.installdata);
        this.loadInstallerRequirements();
        this.loadDynamicVariables();
        this.loadLookAndFeel();
        this.loadGUIInstallData();
        ResourceManager.create(this.installdata);
        this.checkJavaVersion();
        this.checkJDKAvailable();
        this.checkCrystalreportsInRegistry();
        this.checkLockFile();
        if (!this.checkInstallerRequirements(this.installdata)) {
            Debug.log((Object)"not all installerconditions are fulfilled.", this.getClass());
            System.exit(-1);
            return;
        }
        this.checkRunningReportReader();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    GUIInstaller.this.loadGUI();
                }
                catch (Exception e2) {
                    Debug.error(e2, this.getClass());
                }
            }
        });
    }

    private void checkRunningReportReader() {
        if (!OsVersion.IS_WINDOWS) {
            return;
        }
        String system32 = System.getenv("windir") + File.separatorChar + "system32";
        String[] commands = new String[]{system32 + File.separatorChar + "tasklist.exe"};
        StringBuilder b2 = null;
        try {
            Process exec = Runtime.getRuntime().exec(commands, null, new File(system32));
            InputStream inputStream = exec.getInputStream();
            b2 = new StringBuilder();
            int i2 = -1;
            while ((i2 = inputStream.read()) != -1) {
                b2.append((char)i2);
            }
            inputStream.close();
        }
        catch (Exception e2) {
            Debug.error(e2, this.getClass());
        }
        if (b2 == null || b2.length() == 0) {
            return;
        }
        if (b2.toString().contains("ReportReaderStart.exe")) {
            Debug.trace("REPORT_READER_START_EXE FOUND", this.getClass());
            this.showConfirmDialog(this.installdata.langpack.getString("GUIInstaller.reportreaderrunning") + this.installdata.langpack.getString("GUIInstaller.reportreaderrunning1"), this.installdata.langpack.getString("GUIInstaller.reportreaderrunning"));
        }
    }

    private void showConfirmDialog(String defaultText) {
        this.showConfirmDialog(defaultText, defaultText);
    }

    private void showConfirmDialog(String defaultText, String headlessText) {
        if (GraphicsEnvironment.isHeadless()) {
            System.out.println(headlessText);
        } else {
            JFrame frame = new JFrame();
            frame.setUndecorated(true);
            frame.setVisible(true);
            frame.setLocationRelativeTo(null);
            if (JOptionPane.showConfirmDialog(frame, defaultText, "Setup", 0) == 1) {
                System.exit(0);
            }
            frame.dispose();
        }
    }

    private void showMessageDialog(String defaultText) {
        this.showMessageDialog(defaultText, defaultText);
    }

    private void showMessageDialog(String defaultText, String headlessText) {
        if (GraphicsEnvironment.isHeadless()) {
            System.out.println(headlessText);
        } else {
            JFrame frame = new JFrame();
            frame.setUndecorated(true);
            frame.setVisible(true);
            frame.setLocationRelativeTo(null);
            JOptionPane.showMessageDialog(frame, defaultText, "Setup", 0);
            frame.dispose();
        }
    }

    public void loadGUIInstallData() throws Exception {
        InputStream in = GUIInstaller.class.getResourceAsStream("/GUIPrefs");
        ObjectInputStream objIn = new ObjectInputStream(in);
        this.installdata.guiPrefs = (GUIPrefs)objIn.readObject();
        objIn.close();
    }

    protected void checkLockFile() throws Exception {
        String tempDir = System.getProperty("java.io.tmpdir");
        String appName = this.installdata.info.getAppName();
        String fileName = "iz-" + appName + ".tmp";
        Debug.trace("creating temp file: " + fileName, this.getClass());
        Debug.trace("in temp directory: " + tempDir, this.getClass());
        File file = new File(tempDir, fileName);
        if (file.exists()) {
            int selectedOption = 0;
            if (!GraphicsEnvironment.isHeadless()) {
                JFrame frame = new JFrame();
                frame.setUndecorated(true);
                frame.setVisible(true);
                frame.setLocationRelativeTo(null);
                Debug.trace("Lock File Exists, asking user for permission to proceed.", this.getClass());
                StringBuffer msg = new StringBuffer();
                msg.append(this.installdata.langpack.getString("lockFileWarning", new String[]{appName}));
                JLabel label = new JLabel(msg.toString());
                label.setFont(new Font("Sans Serif", 0, 12));
                Object[] optionValues = new Object[]{this.installdata.langpack.getString("installer.next"), this.installdata.langpack.getString("installer.quit")};
                selectedOption = JOptionPane.showOptionDialog(frame, label, this.installdata.langpack.getString("installer.warning"), 0, 2, null, optionValues, optionValues[1]);
                Debug.trace("Selected option: " + selectedOption, this.getClass());
                frame.dispose();
            } else {
                StringBuffer msg = new StringBuffer();
                msg.append(this.installdata.langpack.getString("lockFileWarningHeadless", new String[]{appName}));
                System.out.println(msg.toString());
                selectedOption = 0;
            }
            if (selectedOption == 0) {
                Debug.trace("Setting temp file to delete on exit", this.getClass());
                file.deleteOnExit();
            } else {
                Debug.trace("Leaving temp file alone and exiting", this.getClass());
                System.exit(1);
            }
        } else {
            try {
                if (file.createNewFile()) {
                    Debug.trace("Temp file created", this.getClass());
                    file.deleteOnExit();
                } else {
                    Debug.trace("Temp file could not be created", this.getClass());
                    Debug.trace("*** Multiple instances of installer will be allowed ***", this.getClass());
                }
            }
            catch (Exception e2) {
                Debug.trace("Temp file could not be created: " + e2, this.getClass());
                Debug.trace("*** Multiple instances of installer will be allowed ***", this.getClass());
            }
        }
    }

    protected void checkJavaVersion() throws Exception {
        String required;
        String version = System.getProperty("java.version");
        if (version.compareTo(required = this.installdata.info.getJavaVersion()) < 0) {
            StringBuffer msg = new StringBuffer();
            msg.append(this.installdata.langpack.getString("javaVersionWarning", new String[]{required, version}));
            this.showMessageDialog(msg.toString());
            System.exit(1);
        }
    }

    protected void checkJDKAvailable() {
        if (!this.installdata.info.isJdkRequired()) {
            return;
        }
        FileExecutor exec = new FileExecutor();
        String[] output = new String[2];
        String[] params = new String[]{"javac", "-help"};
        if (exec.executeCommand(params, output) != 0) {
            this.showConfirmDialog(this.installdata.langpack.getString("jdkWarning"));
        }
    }

    protected void checkCrystalreportsInRegistry() {
        if (!OsVersion.IS_WINDOWS) {
            this.installdata.setVariable("CRYSTAL_REPORTS_INSTALLED", Boolean.toString(false));
            return;
        }
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        if (rh == null) {
            return;
        }
        try {
            rh.setRoot(Integer.MIN_VALUE);
            if (rh.keyExist("CrystalReports")) {
                for (Pack p2 : this.installdata.getAllPacks()) {
                    if (!p2.id.equalsIgnoreCase("CCReportReaderComp")) continue;
                    p2.preselected = true;
                    this.installdata.addSelectedPack(p2);
                }
                this.installdata.setVariable("CRYSTAL_REPORTS_INSTALLED", Boolean.toString(true));
            } else {
                this.installdata.setVariable("CRYSTAL_REPORTS_INSTALLED", Boolean.toString(false));
            }
        }
        catch (NativeLibException e2) {
            Debug.error(e2, this.getClass());
        }
    }

    protected void loadLangPack() throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                try {
                    List<String> availableLangPacks = GUIInstaller.this.getAvailableLangPacks();
                    int npacks = availableLangPacks.size();
                    if (npacks == 0) {
                        throw new Exception("no language pack available");
                    }
                    String locale = GUIInstaller.this.initLangpack(availableLangPacks);
                    ((GUIInstaller)GUIInstaller.this).installdata.xmlData.setAttribute("langpack", locale);
                    ((GUIInstaller)GUIInstaller.this).installdata.localeISO3 = locale;
                    GUIInstaller.this.installdata.setVariable("ISO3_LANG", ((GUIInstaller)GUIInstaller.this).installdata.localeISO3);
                    InputStream in = this.getClass().getResourceAsStream("/res/langpacks/" + locale + ".properties");
                    ((GUIInstaller)GUIInstaller.this).installdata.langpack = new LocaleDatabase(in);
                }
                catch (Exception e2) {
                    Debug.error(e2, this.getClass());
                }
            }
        });
    }

    private String initLangpack(List<String> availableLangPacks) throws Exception {
        String locale = Locale.getDefault().getISO3Country().toLowerCase();
        if (locale == null || locale.length() == 0) {
            locale = Locale.getDefault().getISO3Language().toLowerCase();
        }
        if (!availableLangPacks.contains(locale) && !availableLangPacks.contains(locale = Locale.getDefault().getISO3Language().toLowerCase())) {
            locale = "eng";
        }
        ResourceManager.getInstance().setLocale(locale);
        InputStream in = this.getClass().getResourceAsStream("/res/langpacks/eng.properties");
        this.installdata.langpack = new LocaleDatabase(in);
        in = this.getClass().getResourceAsStream("/res/langpacks/" + locale + ".properties");
        this.installdata.langpack.add(in);
        return locale;
    }

    @Override
    public List<String> getAvailableLangPacks() throws Exception {
        InputStream in = this.getClass().getResourceAsStream("/langpacks.info");
        ObjectInputStream objIn = new ObjectInputStream(in);
        List available = (List)objIn.readObject();
        objIn.close();
        return available;
    }

    protected void loadLookAndFeel() throws Exception {
        if (!GraphicsEnvironment.isHeadless()) {
            PlasticXPLookAndFeel laf_class = new PlasticXPLookAndFeel();
            PlasticLookAndFeel.setPlasticTheme(new InetCrystalClear());
            UIManager.setLookAndFeel(laf_class);
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
        }
    }

    void loadGUI() throws Exception {
        if (GraphicsEnvironment.isHeadless()) {
            this.installdata.guiPrefs.modifier.remove("showDebugWindow");
            this.installdata.variables.setProperty("HEADLESS", "true");
            this.installdata.variables.setProperty("COMPONENT_TO_INSTALL", "Server");
        }
        UIManager.put("OptionPane.yesButtonText", this.installdata.langpack.getString("installer.yes"));
        UIManager.put("OptionPane.noButtonText", this.installdata.langpack.getString("installer.no"));
        UIManager.put("OptionPane.cancelButtonText", this.installdata.langpack.getString("installer.cancel"));
        String title = this.installdata.langpack.getString("installer.title") + " " + this.installdata.info.getAppName() + " " + this.installdata.info.getAppVersion();
        new InstallerFrame(title, this.installdata, this);
        if (GraphicsEnvironment.isHeadless()) {
            new IzpackTextUI(this.installdata);
        }
    }
}

