/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.inet.looks.plastic.PlasticLookAndFeel;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.HelpTab;
import com.izforge.izpack.installer.NavigationBar;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.installer.TopFrame;
import com.izforge.izpack.util.Debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HelpBrowser {
    private JFrame helpframe;
    private JTabbedPane helpTabs;
    private TopFrame topFrame;
    private int taboffset = 0;
    private static Icon ICON_NORMAL;
    private static Icon ICON_HOVER;
    private static Icon ICON_PRESSED;
    private LocaleDatabase langpack;
    private IconsDatabase icons;
    private ImageIcon topImage;

    public HelpBrowser() {
        try {
            ICON_NORMAL = ResourceManager.getInstance().getImageIconResource("com/inet/setup/help/images/help_close_13.gif");
            ICON_HOVER = ResourceManager.getInstance().getImageIconResource("com/inet/setup/help/images/help_close_hover_13.gif");
            ICON_PRESSED = ResourceManager.getInstance().getImageIconResource("com/inet/setup/help/images/help_close_pressed_13.gif");
        }
        catch (ResourceNotFoundException e2) {
            Debug.error(e2);
        }
        catch (IOException e3) {
            Debug.error(e3);
        }
    }

    private void initHelpFrame() {
        JPanel content = null;
        this.helpframe = new JFrame(this.langpack.getString("installer.help")){
            private static final long serialVersionUID = 1L;

            public void setVisible(boolean b2) {
                if (!b2) {
                    for (int i2 = HelpBrowser.this.helpTabs.getTabCount() - 1; i2 >= 0; --i2) {
                        HelpBrowser.this.helpTabs.remove(HelpBrowser.this.helpTabs.getComponentAt(i2));
                    }
                }
                super.setVisible(b2);
            }
        };
        ResourceManager rm = ResourceManager.getInstance();
        try {
            this.topImage = rm.getImageIconResource("com/inet/setup/images/topimage.png");
        }
        catch (ResourceNotFoundException e2) {
            Debug.error(e2);
        }
        catch (IOException e3) {
            Debug.error(e3);
        }
        this.helpframe.setContentPane(new JPanel(){
            private static final long serialVersionUID = 1L;

            public void paint(Graphics g2) {
                if (HelpBrowser.this.topImage != null) {
                    g2.setColor(Color.white);
                    g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                    Image img = HelpBrowser.this.topImage.getImage();
                    g2.drawImage(img, this.getWidth() - HelpBrowser.this.topImage.getIconWidth(), 0, this);
                    super.paintChildren(g2);
                } else {
                    super.paint(g2);
                }
            }

            public void update(Graphics g2) {
                this.paint(g2);
            }
        });
        try {
            this.helpframe.setIconImage(ResourceManager.getInstance().getImageIconResource("com/inet/setup/images/installer.cc.ico.png").getImage());
        }
        catch (ResourceNotFoundException e1) {
            Debug.error(e1);
        }
        catch (IOException e1) {
            Debug.error(e1);
        }
        this.helpframe.setDefaultCloseOperation(1);
        content = (JPanel)this.helpframe.getContentPane();
        ActionMap paneActionMap = content.getRootPane().getActionMap();
        InputMap paneInputMap = content.getRootPane().getInputMap(2);
        paneActionMap.put("escape", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e2) {
                HelpBrowser.this.helpframe.setVisible(false);
            }
        });
        paneInputMap.put(KeyStroke.getKeyStroke(27, 0), "escape");
        content.setLayout(new BorderLayout());
        content.setBackground(PlasticLookAndFeel.getTabBackGround());
        content.setOpaque(true);
        this.helpTabs = new JTabbedPane(){
            private static final long serialVersionUID = 1L;

            public void remove(Component component) {
                super.remove(component);
                super.fireStateChanged();
                if (this.getTabCount() == 0) {
                    HelpBrowser.this.helpframe.setVisible(false);
                }
            }
        };
        this.helpTabs.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                int tabForCoordinate = HelpBrowser.this.helpTabs.getUI().tabForCoordinate(HelpBrowser.this.helpTabs, e2.getX(), e2.getY());
                if (tabForCoordinate < 0) {
                    return;
                }
                Rectangle bounds = ((CloseTabIcon)HelpBrowser.this.helpTabs.getIconAt(tabForCoordinate)).getBounds();
                Rectangle firsttabBounds = HelpBrowser.this.helpTabs.getUI().getTabBounds(HelpBrowser.this.helpTabs, 0);
                bounds.x = bounds.x + firsttabBounds.x - HelpBrowser.this.taboffset;
                if (bounds.contains(e2.getX(), e2.getY())) {
                    HelpBrowser.this.helpTabs.remove(HelpBrowser.this.helpTabs.getComponentAt(tabForCoordinate));
                }
                super.mouseClicked(e2);
            }

            public void mousePressed(MouseEvent e2) {
                int tabForCoordinate = HelpBrowser.this.helpTabs.getUI().tabForCoordinate(HelpBrowser.this.helpTabs, e2.getX(), e2.getY());
                if (tabForCoordinate < 0) {
                    return;
                }
                CloseTabIcon closeTabIcon = (CloseTabIcon)HelpBrowser.this.helpTabs.getIconAt(tabForCoordinate);
                Rectangle bounds = closeTabIcon.getBounds();
                Rectangle firsttabBounds = HelpBrowser.this.helpTabs.getUI().getTabBounds(HelpBrowser.this.helpTabs, 0);
                bounds.x = bounds.x + firsttabBounds.x - HelpBrowser.this.taboffset;
                if (bounds.contains(e2.getX(), e2.getY())) {
                    closeTabIcon.setType(2);
                    HelpBrowser.this.helpTabs.repaint(bounds);
                }
            }

            public void mouseReleased(MouseEvent e2) {
                int tabForCoordinate = HelpBrowser.this.helpTabs.getUI().tabForCoordinate(HelpBrowser.this.helpTabs, e2.getX(), e2.getY());
                if (tabForCoordinate < 0) {
                    return;
                }
                CloseTabIcon closeTabIcon = (CloseTabIcon)HelpBrowser.this.helpTabs.getIconAt(tabForCoordinate);
                Rectangle bounds = closeTabIcon.getBounds();
                Rectangle firsttabBounds = HelpBrowser.this.helpTabs.getUI().getTabBounds(HelpBrowser.this.helpTabs, 0);
                bounds.x = bounds.x + firsttabBounds.x - HelpBrowser.this.taboffset;
                if (bounds.contains(e2.getX(), e2.getY())) {
                    HelpBrowser.this.helpTabs.remove(HelpBrowser.this.helpTabs.getComponentAt(tabForCoordinate));
                } else {
                    closeTabIcon.setType(0);
                }
                HelpBrowser.this.helpTabs.repaint(bounds);
            }

            public void mouseEntered(MouseEvent e2) {
                int tabForCoordinate = HelpBrowser.this.helpTabs.getUI().tabForCoordinate(HelpBrowser.this.helpTabs, e2.getX(), e2.getY());
                if (tabForCoordinate < 0) {
                    return;
                }
                CloseTabIcon closeTabIcon = (CloseTabIcon)HelpBrowser.this.helpTabs.getIconAt(tabForCoordinate);
                Rectangle bounds = closeTabIcon.getBounds();
                closeTabIcon.setType(0);
                HelpBrowser.this.helpTabs.repaint(bounds);
            }

            public void mouseExited(MouseEvent e2) {
                for (int i2 = 0; i2 < HelpBrowser.this.helpTabs.getTabCount(); ++i2) {
                    CloseTabIcon closeTabIcon = (CloseTabIcon)HelpBrowser.this.helpTabs.getIconAt(i2);
                    Rectangle bounds = closeTabIcon.getBounds();
                    closeTabIcon.setType(0);
                    HelpBrowser.this.helpTabs.repaint(bounds);
                }
            }
        });
        this.helpTabs.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e2) {
                int tabForCoordinate = HelpBrowser.this.helpTabs.getUI().tabForCoordinate(HelpBrowser.this.helpTabs, e2.getX(), e2.getY());
                if (tabForCoordinate < 0) {
                    return;
                }
                CloseTabIcon closeTabIcon = (CloseTabIcon)HelpBrowser.this.helpTabs.getIconAt(tabForCoordinate);
                Rectangle bounds = closeTabIcon.getBounds();
                Rectangle firsttabBounds = HelpBrowser.this.helpTabs.getUI().getTabBounds(HelpBrowser.this.helpTabs, 0);
                bounds.x = bounds.x + firsttabBounds.x - HelpBrowser.this.taboffset;
                if (bounds.contains(e2.getX(), e2.getY())) {
                    closeTabIcon.setType(1);
                } else {
                    closeTabIcon.setType(0);
                }
                HelpBrowser.this.helpTabs.repaint(bounds);
            }

            public void mouseDragged(MouseEvent e2) {
                int tabForCoordinate = HelpBrowser.this.helpTabs.getUI().tabForCoordinate(HelpBrowser.this.helpTabs, e2.getX(), e2.getY());
                if (tabForCoordinate < 0) {
                    return;
                }
                CloseTabIcon closeTabIcon = (CloseTabIcon)HelpBrowser.this.helpTabs.getIconAt(tabForCoordinate);
                Rectangle bounds = closeTabIcon.getBounds();
                Rectangle firsttabBounds = HelpBrowser.this.helpTabs.getUI().getTabBounds(HelpBrowser.this.helpTabs, 0);
                bounds.x = bounds.x + firsttabBounds.x - HelpBrowser.this.taboffset;
                if (bounds.contains(e2.getX(), e2.getY())) {
                    closeTabIcon.setType(2);
                } else {
                    closeTabIcon.setType(0);
                }
                HelpBrowser.this.helpTabs.repaint(bounds);
            }
        });
        this.helpTabs.setTabLayoutPolicy(1);
        this.helpTabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                if (HelpBrowser.this.topFrame != null) {
                    NavigationBar navigationBar;
                    Component selectedComponent;
                    if (HelpBrowser.this.topFrame.getComponentCount() > 0) {
                        for (Component cmp : HelpBrowser.this.topFrame.getComponents()) {
                            if (cmp == null || !(cmp instanceof NavigationBar)) continue;
                            HelpBrowser.this.topFrame.remove(cmp);
                        }
                    }
                    if ((selectedComponent = HelpBrowser.this.helpTabs.getSelectedComponent()) != null && (navigationBar = ((HelpTab)selectedComponent).getNavigationBar()) != null) {
                        HelpBrowser.this.topFrame.add((Component)navigationBar, "West");
                    }
                    HelpBrowser.this.topFrame.invalidate();
                    HelpBrowser.this.topFrame.validate();
                    HelpBrowser.this.topFrame.repaint();
                }
            }
        });
        this.helpTabs.setPreferredSize(new Dimension(800, 600));
        content.add((Component)this.helpTabs, "Center");
        this.topFrame = new TopFrame(this.langpack.getString("installer.help"));
        content.add((Component)this.topFrame, "North");
        this.helpframe.pack();
    }

    public void addHelpPage(URL helpurl, LocaleDatabase langpack, IconsDatabase icons) {
        if (langpack != null) {
            this.langpack = langpack;
        }
        if (icons != null) {
            this.icons = icons;
        }
        if (this.helpframe == null) {
            this.initHelpFrame();
        }
        for (int i2 = 0; i2 < this.helpTabs.getTabCount(); ++i2) {
            HelpTab ht;
            Component component = this.helpTabs.getComponentAt(i2);
            if (!(component instanceof HelpTab) || !(ht = (HelpTab)component).getUrl().toString().equals(helpurl.toString())) continue;
            this.helpTabs.setSelectedIndex(i2);
            return;
        }
        HelpTab helpTab = new HelpTab(this.helpTabs);
        this.helpTabs.addTab("", new CloseTabIcon(null), helpTab);
        this.helpTabs.setSelectedComponent(helpTab);
        if (this.helpTabs.getTabCount() == 1) {
            Rectangle tabBounds = this.helpTabs.getUI().getTabBounds(this.helpTabs, 0);
            this.taboffset = tabBounds.x;
        }
        helpTab.setUrl(helpurl);
    }

    public void showHelpDialog(JFrame parent) {
        if (!this.helpframe.isVisible()) {
            HelpBrowser.setRelativeLocation(parent, this.helpframe);
            this.helpframe.setVisible(true);
        }
    }

    public boolean isHelpFrameVisible() {
        if (this.helpframe == null) {
            return false;
        }
        return this.helpframe.isVisible();
    }

    public static void setRelativeLocation(Component parent, Component child) {
        Point parentlocation = null;
        Dimension parentsize = null;
        if (!parent.isShowing()) {
            Window windowAncestor = SwingUtilities.getWindowAncestor(parent);
            if (windowAncestor == null) {
                windowAncestor = SwingUtilities.windowForComponent(parent);
            }
            if (windowAncestor == null) {
                parentlocation = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            } else {
                parent = windowAncestor;
                parentlocation = windowAncestor.getLocationOnScreen();
            }
            parentsize = parent.getSize();
        } else {
            parentlocation = parent.getLocationOnScreen();
            parentsize = parent.getSize();
            if (parent instanceof JComponent) {
                JComponent jcomp = (JComponent)parent;
                Rectangle visibleRect = jcomp.getVisibleRect();
                parentlocation.x += visibleRect.x;
                parentlocation.y += visibleRect.y;
                parentsize.width = visibleRect.width;
                parentsize.height = visibleRect.height;
            }
        }
        Dimension childsize = child.getSize();
        GraphicsConfiguration graphicsConfiguration = parent.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        Rectangle graphicsBounds = graphicsConfiguration.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point centerPoint = new Point(parentlocation.x + parentsize.width / 2, parentlocation.y + parentsize.height / 2);
        Point childPoint = new Point(centerPoint.x - childsize.width / 2, centerPoint.y - childsize.height / 2);
        if (childPoint.x < graphicsBounds.x + screenInsets.left) {
            childPoint.x = graphicsBounds.x + screenInsets.left;
        }
        if (childPoint.x + childsize.width > graphicsBounds.x + screenSize.width - screenInsets.right) {
            childPoint.x = graphicsBounds.x + screenSize.width - childsize.width - screenInsets.right;
        }
        if (childPoint.y < graphicsBounds.y + screenInsets.top) {
            childPoint.y = graphicsBounds.y + screenInsets.top;
        }
        if (childPoint.y + childsize.height > graphicsBounds.y + screenSize.height - screenInsets.bottom) {
            childPoint.y = graphicsBounds.y + screenSize.height - childsize.height - screenInsets.bottom;
        }
        child.setLocation(childPoint);
    }

    private class CloseTabIcon
    implements Icon {
        private int x_pos;
        private int y_pos;
        private int width;
        private int height;
        private Icon fileIcon;
        public static final int TYPE_NORMAL = 0;
        public static final int TYPE_HOVER = 1;
        public static final int TYPE_PRESSED = 2;
        private int type = 0;

        public CloseTabIcon(Icon fileIcon) {
            if (fileIcon == null) {
                fileIcon = ICON_NORMAL;
            }
            this.fileIcon = fileIcon;
            this.width = 13;
            this.height = 13;
        }

        public void setType(int typ) {
            this.type = typ;
        }

        public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
            this.x_pos = x2;
            this.y_pos = y2;
            switch (this.type) {
                case 0: {
                    this.fileIcon = ICON_NORMAL;
                    break;
                }
                case 1: {
                    this.fileIcon = ICON_HOVER;
                    break;
                }
                case 2: {
                    this.fileIcon = ICON_PRESSED;
                }
            }
            if (this.fileIcon != null) {
                this.fileIcon.paintIcon(c2, g2, x2, y2);
            }
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return this.height;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x_pos, this.y_pos, this.width, this.height);
        }
    }
}

