/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HelpButton
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int buttonWidth = 100;
    private int buttonHeight = 100;
    private static final int HELP_BUTTON_SIZE = 24;
    private InnerHelpButton innerButton;
    private ImageIcon helpIconRollover;
    private ImageIcon helpIconDisabled;
    private ImageIcon helpIconOnClick;
    private JLabel jlIcon;

    public HelpButton(String buttonLabel, ImageIcon buttonIcon, ImageIcon helpIconRollover, ImageIcon helpIconDisabled, ImageIcon helpIconOnClick) {
        this.helpIconRollover = helpIconRollover;
        this.helpIconDisabled = helpIconDisabled;
        this.helpIconOnClick = helpIconOnClick;
        this.setJlIcon(new JLabel(helpIconDisabled));
        this.setInnerButton(new InnerHelpButton(buttonLabel, buttonIcon));
        Dimension fixedSize = new Dimension(this.buttonWidth + 12, this.buttonHeight + 12);
        this.setSize(fixedSize);
        this.setMinimumSize(fixedSize);
        this.setPreferredSize(fixedSize);
        this.init();
    }

    public HelpButton(String buttonLabel, ImageIcon buttonIcon, ImageIcon helpIconRollover, ImageIcon helpIconDisabled, ImageIcon helpIconOnClick, int width, int height) {
        this.buttonHeight = height;
        this.buttonWidth = width;
        this.helpIconRollover = helpIconRollover;
        this.helpIconDisabled = helpIconDisabled;
        this.helpIconOnClick = helpIconOnClick;
        this.setJlIcon(new JLabel(helpIconDisabled));
        this.setInnerButton(new InnerHelpButton(buttonLabel, buttonIcon));
        Dimension fixedSize = new Dimension(this.buttonWidth + 12, this.buttonHeight + 12);
        this.setSize(fixedSize);
        this.setMinimumSize(fixedSize);
        this.setPreferredSize(fixedSize);
        this.init();
    }

    private void init() {
        this.getJlIcon().addMouseMotionListener(new MouseMotionAdapter(){
            private boolean activ = false;

            public void mouseMoved(MouseEvent e2) {
                Point base;
                Point mouse = new Point(e2.getX(), e2.getY());
                if (mouse.distance(base = new Point(10, 14)) <= 10.0) {
                    if (!this.activ) {
                        HelpButton.this.getJlIcon().setIcon(HelpButton.this.helpIconRollover);
                        this.activ = true;
                    }
                    HelpButton.this.getInnerButton().actionMouseLeaveEvent();
                } else {
                    if (this.activ) {
                        HelpButton.this.getJlIcon().setIcon(HelpButton.this.helpIconDisabled);
                        this.activ = false;
                    }
                    if (e2.getX() <= 12 && e2.getY() > 12) {
                        HelpButton.this.getInnerButton().actionMouseEnterEvent();
                    } else {
                        HelpButton.this.getInnerButton().actionMouseLeaveEvent();
                    }
                }
            }
        });
        this.getJlIcon().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e2) {
                Point base;
                Point mouse = new Point(e2.getX(), e2.getY());
                if (mouse.distance(base = new Point(10, 10)) <= 10.0) {
                    if (((Component)e2.getSource()).getName().equals("DesignerHelp")) {
                        // empty if block
                    }
                    if (((Component)e2.getSource()).getName().equals("ServerHelp")) {
                        // empty if block
                    }
                    if (((Component)e2.getSource()).getName().equals("CustomHelp")) {
                        // empty if block
                    }
                } else if (e2.getX() <= 12 && e2.getY() > 12) {
                    HelpButton.this.getInnerButton().doClick();
                }
            }

            public void mousePressed(MouseEvent e2) {
                Point base;
                Point mouse = new Point(e2.getX(), e2.getY());
                if (mouse.distance(base = new Point(10, 10)) <= 10.0) {
                    HelpButton.this.getJlIcon().setIcon(HelpButton.this.helpIconOnClick);
                }
            }

            public void mouseReleased(MouseEvent e2) {
                Point base;
                Point mouse = new Point(e2.getX(), e2.getY());
                if (mouse.distance(base = new Point(10, 10)) <= 10.0) {
                    HelpButton.this.getJlIcon().setIcon(HelpButton.this.helpIconRollover);
                }
            }

            public void mouseExited(MouseEvent e2) {
                HelpButton.this.getJlIcon().setIcon(HelpButton.this.helpIconDisabled);
                super.mouseExited(e2);
            }
        });
        this.setLayout(null);
        this.add(this.getJlIcon());
        this.add(this.getInnerButton());
        this.getInnerButton().setBounds(0, 12, this.buttonWidth, this.buttonHeight);
        this.getJlIcon().setBounds(this.buttonWidth - 12, 0, 24, 24);
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public void setInnerButton(InnerHelpButton innerButton) {
        this.innerButton = innerButton;
    }

    public InnerHelpButton getInnerButton() {
        return this.innerButton;
    }

    public void setJlIcon(JLabel jlIcon) {
        this.jlIcon = jlIcon;
    }

    public JLabel getJlIcon() {
        return this.jlIcon;
    }

    public class InnerHelpButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private ImageIcon icon;
        private String label;

        public InnerHelpButton(String label, ImageIcon icon) {
            this.icon = icon;
            this.label = label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void actionMouseEnterEvent() {
            this.getModel().setRollover(true);
            this.getModel().setArmed(true);
        }

        public void actionMouseLeaveEvent() {
            this.getModel().setRollover(false);
            this.getModel().setArmed(false);
        }

        protected void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            g2.drawImage(this.icon.getImage(), HelpButton.this.buttonWidth / 2 - 24, HelpButton.this.buttonHeight / 2 - 34, this);
            g2.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
            g2.drawString(this.label, (this.getWidth() - g2.getFontMetrics().stringWidth(this.label)) / 2, HelpButton.this.buttonHeight / 2 + 29);
        }
    }
}

