/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.inet.editor.BaseEditor;
import com.inet.html.css.HTML;
import com.inet.setup.panels.util.Hyperactive;
import com.izforge.izpack.installer.NavigationBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;

public class HelpTab
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTabbedPane helpTabs;
    private NavigationBar navigationBar;
    private List<URL> history = new ArrayList<URL>();
    private int indexInHistory = -1;
    private BaseEditor editor;
    private LocalBehavior localbehavior = new LocalBehavior();
    private static final String NAV_NEXT = "next";
    private static final String NAV_PREVIOUS = "previous";
    private static final String NAV_CLOSE = "close";
    private URL url;

    public HelpTab(JTabbedPane helpTabs) {
        super(new BorderLayout());
        this.editor = new HelpEditor();
        this.editor.setTextShowMode();
        this.helpTabs = helpTabs;
        HyperlinkListener[] hyperlinkListeners = this.editor.getEditor().getHyperlinkListeners();
        if (hyperlinkListeners != null) {
            for (HyperlinkListener hl : hyperlinkListeners) {
                this.editor.getEditor().removeHyperlinkListener(hl);
            }
        }
        this.editor.getEditor().addHyperlinkListener(this.localbehavior);
        this.editor.getDocumentProperties().put("IgnoreCharsetDirective", "true");
        this.add((Component)this.editor, "Center");
        this.navigationBar = new NavigationBar(this.localbehavior);
        this.navigationBar.updateNavigationBar(false, false);
    }

    public NavigationBar getNavigationBar() {
        return this.navigationBar;
    }

    public void setUrl(URL url) {
        this.url = url;
        this.editor.setPage(url);
    }

    public URL getUrl() {
        return this.url;
    }

    private class HelpEditor
    extends BaseEditor {
        private static final long serialVersionUID = 1L;
        private URL currentUrl;

        public HelpEditor() {
            super(true, false, false, true);
        }

        protected void textLoaded() {
            Object pageTitle = this.getEditor().getDocument().getProperty("title");
            this.currentUrl = this.getBase();
            if (!(HelpTab.this.indexInHistory < HelpTab.this.history.size() - 1 || HelpTab.this.history.size() != 0 && ((URL)HelpTab.this.history.get(HelpTab.this.history.size() - 1)).toString().equals(this.currentUrl.toString()))) {
                HelpTab.this.history.add(this.currentUrl);
                HelpTab.this.indexInHistory++;
            }
            if (pageTitle == null) {
                pageTitle = this.currentUrl != null && this.currentUrl.getFile() != null && this.currentUrl.getFile().length() > 0 ? this.currentUrl.getFile() : (this.currentUrl != null ? this.currentUrl.toString() : "...");
            }
            int indexOfComponent = HelpTab.this.helpTabs.indexOfComponent(HelpTab.this);
            Object pageTitleCopy = pageTitle;
            if (indexOfComponent >= 0) {
                HelpTab.this.helpTabs.setTitleAt(indexOfComponent, pageTitleCopy.toString());
            }
            HelpTab.this.navigationBar.updateNavigationBar(HelpTab.this.indexInHistory > 0, HelpTab.this.indexInHistory < HelpTab.this.history.size() - 1);
            this.getEditor().setCursor(Cursor.getDefaultCursor());
            HelpTab.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class LocalBehavior
    extends Hyperactive
    implements ActionListener,
    HyperlinkListener {
        private LocalBehavior() {
        }

        public void actionPerformed(ActionEvent e2) {
            if (HelpTab.NAV_NEXT.equals(e2.getActionCommand())) {
                if (HelpTab.this.indexInHistory < HelpTab.this.history.size() - 1) {
                    HelpTab.this.indexInHistory++;
                    HelpTab.this.editor.setPage((URL)HelpTab.this.history.get(HelpTab.this.indexInHistory));
                }
            } else if (HelpTab.NAV_PREVIOUS.equals(e2.getActionCommand())) {
                if (HelpTab.this.indexInHistory > 0) {
                    HelpTab.this.indexInHistory--;
                    HelpTab.this.editor.setPage((URL)HelpTab.this.history.get(HelpTab.this.indexInHistory));
                }
            } else if (HelpTab.NAV_CLOSE.equals(e2.getActionCommand())) {
                HelpTab.this.editor.setText("", true);
                HelpTab.this.helpTabs.remove(HelpTab.this);
            }
        }

        public void hyperlinkUpdate(HyperlinkEvent e2) {
            URL hurl;
            if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (hurl = e2.getURL()) != null) {
                Object hrefAtt;
                String href = hurl.toString();
                Element sourceElement = e2.getSourceElement();
                if (sourceElement != null && (hrefAtt = sourceElement.getAttributes().getAttribute((Object)HTML.Attribute.HREF)) != null) {
                    href = hrefAtt.toString();
                }
                System.out.println(href);
                if (!href.startsWith("http://") && !href.startsWith("mailto:")) {
                    HelpTab.this.editor.setPage(hurl);
                    if (hurl != null && !href.startsWith("#")) {
                        HelpTab.this.navigationBar.updateNavigationBar(false, false);
                        HelpTab.this.editor.getEditor().setCursor(Cursor.getPredefinedCursor(3));
                        HelpTab.this.setCursor(Cursor.getPredefinedCursor(3));
                        for (int i2 = HelpTab.this.history.size() - 1; i2 > HelpTab.this.indexInHistory; --i2) {
                            HelpTab.this.history.remove(i2);
                        }
                    }
                    return;
                }
            }
            super.hyperlinkUpdate(e2);
        }
    }
}

