/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.installer.AutomatedInstaller;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.StringTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Installer {
    public static final int INSTALLER_GUI = 0;
    public static final int INSTALLER_AUTO = 1;
    public static final int INSTALLER_CONSOLE = 2;
    public static final int CONSOLE_INSTALL = 0;
    public static final int CONSOLE_GEN_TEMPLATE = 1;
    public static final int CONSOLE_FROM_TEMPLATE = 2;

    public static void main(String[] args) {
        Debug.log(" - Logger initialized at '" + new Date(System.currentTimeMillis()) + "'.");
        Debug.log(" - commandline args: " + StringTool.stringArrayToSpaceSeparatedString(args));
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "i-net Clear Reports Install");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
        }
        try {
            PrintStream out = new PrintStream((OutputStream)System.out, true, Installer.getConsoleEncoding());
            System.setOut(out);
        }
        catch (UnsupportedEncodingException e1) {
            // empty catch block
        }
        try {
            Iterator<String> args_it = Arrays.asList(args).iterator();
            int type = 0;
            String path = null;
            while (args_it.hasNext()) {
                String arg = args_it.next().trim();
                try {
                    if ("-options-template".equalsIgnoreCase(arg)) {
                        path = args_it.next().trim();
                        continue;
                    }
                    if ("-options".equalsIgnoreCase(arg)) {
                        path = args_it.next().trim();
                        continue;
                    }
                    type = 1;
                    path = arg;
                }
                catch (NoSuchElementException e2) {
                    System.err.println("- ERROR -");
                    System.err.println("Option \"" + arg + "\" requires an argument!");
                    System.exit(1);
                }
            }
            switch (type) {
                case 0: {
                    Class.forName("com.izforge.izpack.installer.GUIInstaller").newInstance();
                    break;
                }
                case 1: {
                    AutomatedInstaller ai2 = new AutomatedInstaller(path);
                    ai2.doInstall();
                }
            }
        }
        catch (Exception e3) {
            System.err.println("- ERROR -");
            System.err.println(e3.toString());
            e3.printStackTrace();
            System.exit(1);
        }
    }

    private static String getConsoleEncoding() {
        try {
            if (OsVersion.IS_WINDOWS) {
                String result = Installer.runCommand("cmd /c chcp");
                Pattern pattern = Pattern.compile("[^\\d]*(\\d+)[^\\d]*");
                Matcher m2 = pattern.matcher(result);
                if (m2.find()) {
                    return "cp" + m2.group(1);
                }
            } else {
                String result = Installer.runCommand("locale");
                Pattern pattern = Pattern.compile("LC_CTYPE=\"[^\".]+\\.([^\"]+)");
                Matcher m3 = pattern.matcher(result);
                if (m3.find()) {
                    return m3.group(1);
                }
            }
        }
        catch (IOException e2) {
            System.out.println("WARNING: Could not detect character encoding! Special characters may be displayed incorrectly!");
            System.out.println();
        }
        return "UTF-8";
    }

    private static String runCommand(String command) throws IOException {
        String line;
        Runtime r2 = Runtime.getRuntime();
        Process p2 = r2.exec(command);
        BufferedReader is = new BufferedReader(new InputStreamReader(p2.getInputStream()));
        StringBuilder output = new StringBuilder();
        while ((line = is.readLine()) != null) {
            output.append(line);
        }
        try {
            p2.waitFor();
        }
        catch (InterruptedException e2) {
            System.out.println(e2);
        }
        return output.toString();
    }
}

