/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.CustomData;
import com.izforge.izpack.Info;
import com.izforge.izpack.Pack;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.compiler.DynamicVariable;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.InstallerRequirement;
import com.izforge.izpack.installer.PrivilegedRunner;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerBase {
    private static final String CONDITIONS_SPECRESOURCENAME = "conditions.xml";
    private RulesEngine rules;
    private List<InstallerRequirement> installerrequirements;
    private Map<String, List<DynamicVariable>> dynamicvariables;
    protected static final String LANG_FILE_NAME = "CustomLangpack.xml";

    public List<String> getAvailableLangPacks() throws Exception {
        InputStream in = this.getClass().getResourceAsStream("/langpacks.info");
        ObjectInputStream objIn = new ObjectInputStream(in);
        List available = (List)objIn.readObject();
        objIn.close();
        return available;
    }

    public RulesEngine getRules() {
        return this.rules;
    }

    public void loadInstallData(AutomatedInstallData installdata) throws Exception {
        String hostname;
        String IPAddress;
        ObjectInputStream objIn;
        Properties variables = null;
        InputStream in = InstallerBase.class.getResourceAsStream("/vars");
        if (null != in) {
            objIn = new ObjectInputStream(in);
            variables = (Properties)objIn.readObject();
            objIn.close();
        }
        in = InstallerBase.class.getResourceAsStream("/info");
        objIn = new ObjectInputStream(in);
        Info inf = (Info)objIn.readObject();
        objIn.close();
        this.checkForPrivilegedExecution(inf);
        installdata.setVariable("APP_NAME", inf.getAppName());
        if (inf.getAppURL() != null) {
            installdata.setVariable("APP_URL", inf.getAppURL());
        }
        installdata.setVariable("APP_VER", inf.getAppVersion());
        if (inf.getUninstallerCondition() != null) {
            installdata.setVariable("UNINSTALLER_CONDITION", inf.getUninstallerCondition());
        }
        in = InstallerBase.class.getResourceAsStream("/panelsOrder");
        objIn = new ObjectInputStream(in);
        List panelsOrder = (List)objIn.readObject();
        objIn.close();
        in = InstallerBase.class.getResourceAsStream("/packs.info");
        objIn = new ObjectInputStream(in);
        int size = objIn.readInt();
        ArrayList<Pack> availablePacks = new ArrayList<Pack>();
        ArrayList<Pack> allPacks = new ArrayList<Pack>();
        for (int i2 = 0; i2 < size; ++i2) {
            Pack pk = (Pack)objIn.readObject();
            allPacks.add(pk);
            if (!OsConstraint.oneMatchesCurrentSystem(pk.osConstraints)) continue;
            availablePacks.add(pk);
        }
        objIn.close();
        String dir = OsVersion.IS_WINDOWS ? this.buildWindowsDefaultPath() : (OsVersion.IS_OSX ? "/Applications" : (new File("/usr/local/").canWrite() ? "/usr/local" : System.getProperty("user.home")));
        try {
            InetAddress addr = InetAddress.getLocalHost();
            IPAddress = addr.getHostAddress();
            hostname = addr.getHostName();
        }
        catch (Exception e2) {
            hostname = "";
            IPAddress = "";
        }
        installdata.setVariable("APPLICATIONS_DEFAULT_ROOT", dir);
        dir = dir + File.separator;
        installdata.setVariable("JAVA_HOME", System.getProperty("java.home"));
        installdata.setVariable("CLASS_PATH", System.getProperty("java.class.path"));
        installdata.setVariable("USER_HOME", System.getProperty("user.home"));
        installdata.setVariable("USER_NAME", System.getProperty("user.name"));
        installdata.setVariable("IP_ADDRESS", IPAddress);
        installdata.setVariable("HOST_NAME", hostname);
        installdata.setVariable("FILE_SEPARATOR", File.separator);
        Enumeration<Object> e3 = System.getProperties().keys();
        while (e3.hasMoreElements()) {
            String varName = (String)e3.nextElement();
            String varValue = System.getProperty(varName);
            if (varValue == null) continue;
            varName = varName.replace('.', '_');
            installdata.setVariable("SYSTEM_" + varName, varValue);
        }
        if (null != variables) {
            Enumeration<Object> enumeration = variables.keys();
            while (enumeration.hasMoreElements()) {
                String varName = (String)enumeration.nextElement();
                String varValue = variables.getProperty(varName);
                installdata.setVariable(varName, varValue);
            }
        }
        installdata.info = inf;
        installdata.panelsOrder = panelsOrder;
        installdata.setAllPacks(allPacks);
        installdata.setAvailablePacks(availablePacks);
        for (Pack pack : availablePacks) {
            if (!pack.preselected) continue;
            installdata.addSelectedPack(pack);
        }
        String installPath = dir + inf.getAppName();
        if (inf.getInstallationSubPath() != null) {
            installPath = IoHelper.translatePath(dir + inf.getInstallationSubPath(), new VariableSubstitutor(installdata.getVariables()));
        }
        installdata.setInstallPath(installPath);
        this.loadCustomData(installdata);
    }

    private void checkForPrivilegedExecution(Info info) {
        if (PrivilegedRunner.isPrivilegedMode()) {
            return;
        }
        if (info.isPrivilegedExecutionRequired()) {
            PrivilegedRunner runner;
            boolean shouldElevate = true;
            String conditionId = info.getPrivilegedExecutionConditionID();
            if (conditionId != null) {
                shouldElevate = RulesEngine.getCondition(conditionId).isTrue();
            }
            if ((runner = new PrivilegedRunner(!shouldElevate)).isPlatformSupported() && runner.isElevationNeeded()) {
                try {
                    if (runner.relaunchWithElevatedRights(false) != 0) {
                        throw new RuntimeException("Launching an installer with elevated permissions failed.");
                    }
                    System.exit(0);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    JOptionPane.showMessageDialog(null, "The installer could not launch itself with administrator permissions.\nThe installation will still continue but you may encounter problems due to insufficient permissions.");
                }
            } else if (!runner.isPlatformSupported()) {
                JOptionPane.showMessageDialog(null, "This installer should be run by an administrator.\nThe installation will still continue but you may encounter problems due to insufficient permissions.");
            }
        }
    }

    protected void addCustomLangpack(AutomatedInstallData idata) {
        try {
            idata.langpack.add(ResourceManager.getInstance().getInputStream(LANG_FILE_NAME));
        }
        catch (Throwable exception) {
            Debug.trace("No custom langpack available.");
            return;
        }
        Debug.trace("Custom langpack for " + idata.localeISO3 + " available.");
    }

    private String buildWindowsDefaultPath() {
        try {
            String prgFilesPath = IoHelper.getenv("ProgramFiles");
            if (prgFilesPath != null && prgFilesPath.length() > 0) {
                return prgFilesPath;
            }
            return this.buildWindowsDefaultPathFromProps();
        }
        catch (Exception x2) {
            x2.printStackTrace();
            return this.buildWindowsDefaultPathFromProps();
        }
    }

    private String buildWindowsDefaultPathFromProps() {
        StringBuffer dpath = new StringBuffer("");
        try {
            Properties props = new Properties();
            props.load(InstallerBase.class.getResourceAsStream("/com/izforge/izpack/installer/win32-defaultpaths.properties"));
            String drive = System.getProperty("user.home");
            if (drive.length() > 3) {
                drive = drive.substring(0, 3);
            }
            dpath.append(drive);
            if (drive.length() == 2) {
                dpath.append("\\");
            }
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            String language_country = language + "_" + country;
            if (null != props.getProperty(language_country)) {
                dpath.append(props.getProperty(language_country));
            } else if (null != props.getProperty(language)) {
                dpath.append(props.getProperty(language));
            } else {
                dpath.append(props.getProperty(Locale.ENGLISH.getLanguage()));
            }
        }
        catch (Exception err) {
            dpath = new StringBuffer("C:\\Program Files");
        }
        return dpath.toString();
    }

    private void loadCustomData(AutomatedInstallData installdata) throws Exception {
        int i2;
        String[] streamNames = AutomatedInstallData.CUSTOM_ACTION_TYPES;
        List[] out = new List[streamNames.length];
        for (i2 = 0; i2 < streamNames.length; ++i2) {
            out[i2] = new ArrayList();
        }
        InputStream in = InstallerBase.class.getResourceAsStream("/customData");
        if (in != null) {
            ObjectInputStream objIn = new ObjectInputStream(in);
            Object listeners = objIn.readObject();
            objIn.close();
            Iterator keys = ((List)listeners).iterator();
            while (keys != null && keys.hasNext()) {
                CustomData ca2 = (CustomData)keys.next();
                if (ca2.osConstraints != null && !OsConstraint.oneMatchesCurrentSystem(ca2.osConstraints)) continue;
                switch (ca2.type) {
                    case 0: {
                        Class<?> clazz = Class.forName(ca2.listenerName);
                        if (clazz == null) {
                            throw new InstallerException("Custom action " + ca2.listenerName + " not bound!");
                        }
                        out[ca2.type].add(clazz.newInstance());
                        break;
                    }
                    case 1: 
                    case 3: {
                        out[ca2.type].add(ca2);
                        break;
                    }
                    case 2: {
                        out[ca2.type].add(ca2.contents);
                    }
                }
            }
            for (i2 = 0; i2 < streamNames.length; ++i2) {
                installdata.customData.put(streamNames[i2], out[i2]);
            }
        }
    }

    protected void loadConditions(AutomatedInstallData installdata) {
        try {
            InputStream in = InstallerBase.class.getResourceAsStream("/rules");
            ObjectInputStream objIn = new ObjectInputStream(in);
            Map rules = (Map)objIn.readObject();
            if (rules != null && rules.size() != 0) {
                this.rules = new RulesEngine(rules, installdata);
            }
            objIn.close();
        }
        catch (Exception e2) {
            Debug.trace("Can not find optional rules");
        }
        if (this.rules != null) {
            installdata.setRules(this.rules);
            return;
        }
        try {
            InputStream input = null;
            input = this.getResource(CONDITIONS_SPECRESOURCENAME);
            if (input == null) {
                this.rules = new RulesEngine((IXMLElement)null, installdata);
                return;
            }
            XMLParser xmlParser = new XMLParser();
            IXMLElement conditionsxml = xmlParser.parse(input);
            this.rules = new RulesEngine(conditionsxml, installdata);
        }
        catch (Exception e3) {
            Debug.trace("Can not find optional resource conditions.xml");
            this.rules = new RulesEngine((IXMLElement)null, installdata);
        }
        installdata.setRules(this.rules);
    }

    protected void loadDynamicVariables() {
        try {
            InputStream in = InstallerFrame.class.getResourceAsStream("/dynvariables");
            ObjectInputStream objIn = new ObjectInputStream(in);
            this.dynamicvariables = (Map)objIn.readObject();
            objIn.close();
        }
        catch (Exception e2) {
            Debug.trace("Cannot find optional dynamic variables");
            System.out.println(e2);
        }
    }

    public void loadInstallerRequirements() throws Exception {
        InputStream in = InstallerBase.class.getResourceAsStream("/installerrequirements");
        ObjectInputStream objIn = new ObjectInputStream(in);
        this.installerrequirements = (List)objIn.readObject();
        objIn.close();
    }

    public boolean checkInstallerRequirements(AutomatedInstallData installdata) throws Exception {
        boolean result = true;
        for (InstallerRequirement installerrequirement : this.installerrequirements) {
            String conditionid = installerrequirement.getCondition();
            Condition condition = RulesEngine.getCondition(conditionid);
            if (condition == null) {
                Debug.log(conditionid + " not a valid condition.");
                throw new Exception(conditionid + "could not be found as a defined condition");
            }
            if (condition.isTrue()) continue;
            String message = installerrequirement.getMessage();
            if (message != null && message.length() > 0) {
                String localizedMessage = installdata.langpack.getString(message);
                this.showMissingRequirementMessage(localizedMessage);
            }
            result = false;
            break;
        }
        return result;
    }

    protected void showMissingRequirementMessage(String message) {
        Debug.log(message);
    }

    public InputStream getResource(String res) throws Exception {
        String basePath = "";
        ResourceManager rm = null;
        try {
            rm = ResourceManager.getInstance();
            basePath = rm.resourceBasePath;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        InputStream result = this.getClass().getResourceAsStream(basePath + res);
        if (result == null) {
            throw new ResourceNotFoundException("Warning: Resource not found: " + res);
        }
        return result;
    }

    protected void refreshDynamicVariables(VariableSubstitutor substitutor, AutomatedInstallData installdata) {
        Debug.log("refreshing dyamic variables.");
        if (this.dynamicvariables != null) {
            for (String dynvarname : this.dynamicvariables.keySet()) {
                Debug.log("Variable: " + dynvarname);
                for (DynamicVariable dynvar : this.dynamicvariables.get(dynvarname)) {
                    boolean refresh = false;
                    String conditionid = dynvar.getConditionid();
                    Debug.log("condition: " + conditionid);
                    if (conditionid != null && conditionid.length() > 0) {
                        if (this.rules != null && this.rules.isConditionTrue(conditionid)) {
                            Debug.log("refresh condition");
                            refresh = true;
                        }
                    } else {
                        Debug.log("refresh condition");
                        refresh = true;
                    }
                    if (!refresh) continue;
                    String newvalue = substitutor.substitute(dynvar.getValue(), null);
                    Debug.log("newvalue: " + newvalue);
                    installdata.variables.setProperty(dynvar.getName(), newvalue);
                }
            }
        }
    }
}

