/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.inet.setup.Constants;
import com.inet.textui.DelegateJFrame;
import com.izforge.izpack.CustomData;
import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Panel;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.adaptator.impl.XMLWriter;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidatorFactory;
import com.izforge.izpack.installer.Debugger;
import com.izforge.izpack.installer.GUIListener;
import com.izforge.izpack.installer.HelpBrowser;
import com.izforge.izpack.installer.IUnpacker;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionFactory;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.installer.UnpackerFactory;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.Log;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerFrame
extends DelegateJFrame {
    private static final long serialVersionUID = 3257852069162727473L;
    private static final float JAVA_SPECIFICATION_VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    private static final String ICON_RESOURCE = "Installer.image";
    private static final String ICON_RESOURCE_EXT_VARIABLE_NAME = "installerimage.ext";
    private static final String HEADING_ICON_RESOURCE = "Heading.image";
    public LocaleDatabase langpack;
    protected InstallData installdata;
    public IconsDatabase icons;
    protected JPanel panelsContainer;
    protected JPanel contentPane;
    protected JButton helpButton = null;
    protected JButton prevButton;
    protected JButton nextButton;
    protected JButton quitButton;
    protected ArrayList<Integer> visiblePanelMapping;
    protected ArrayList<GUIListener> guiListener;
    protected JLabel[] headingLabels;
    protected JPanel headingPanel;
    protected JComponent headingCounterComponent;
    private JLabel iconLabel;
    private int interruptCount = 1;
    private static final int MAX_INTERRUPT = 3;
    protected RulesEngine rules;
    private static final String CUSTOM_ICONS_RESOURCEFILE = "customicons.xml";
    private VariableSubstitutor substitutor;
    private Debugger debugger;
    private boolean imageLeft = false;
    private InstallerBase parentInstaller;
    private IUnpacker unpacker;
    private HelpBrowser helpFrame = new HelpBrowser();
    private static InstallerFrame iFrame;
    private boolean isBack = false;
    private Object usualFTP = null;
    private Object blockFTP = null;

    public InstallerFrame(String title, InstallData installdata, InstallerBase parentInstaller) throws Exception {
        super(title);
        iFrame = this;
        this.parentInstaller = parentInstaller;
        this.rules = this.parentInstaller.getRules();
        this.substitutor = new VariableSubstitutor(installdata.variables);
        this.guiListener = new ArrayList();
        this.visiblePanelMapping = new ArrayList();
        this.installdata = installdata;
        this.langpack = installdata.langpack;
        String variable = this.installdata.getVariable("LOCALE");
        if (variable == null || variable.length() < 2) {
            String languageProperty = System.getProperty("user.language", "en");
            String languageString = Constants.getIso2Toiso3().get(languageProperty);
            this.installdata.setVariable("LOCALE", languageString);
        }
        this.addWindowListener(new WindowHandler());
        this.setDefaultCloseOperation(0);
        this.loadIcons();
        this.loadCustomIcons();
        this.loadPanels();
        this.buildGUI();
        this.showFrame();
        this.switchPanel(0);
    }

    public static Component getInstance() {
        return iFrame;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    private void loadPanels() throws Exception {
        List panelsOrder = this.installdata.panelsOrder;
        int size = panelsOrder.size();
        Class[] paramsClasses = new Class[]{Class.forName("com.izforge.izpack.installer.InstallerFrame"), Class.forName("com.izforge.izpack.installer.InstallData")};
        Object[] params = new Object[]{this, this.installdata};
        int curVisPanelNumber = 0;
        int lastVis = 0;
        int count = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            List<String> postValidateActions;
            List<String> preValidateActions;
            Panel p2 = (Panel)panelsOrder.get(i2);
            if (!OsConstraint.oneMatchesCurrentSystem(p2.osConstraints)) continue;
            String className = p2.className;
            String praefix = "com.inet.setup.panels.";
            if (className.indexOf(46) > -1) {
                praefix = "";
            }
            Class<?> objectClass = Class.forName(praefix + className);
            Constructor<?> constructor = objectClass.getDeclaredConstructor(paramsClasses);
            this.installdata.currentPanel = p2;
            List<String> preConstgructionActions = p2.getPreConstructionActions();
            if (preConstgructionActions != null) {
                for (int actionIndex = 0; actionIndex < preConstgructionActions.size(); ++actionIndex) {
                    PanelAction action = PanelActionFactory.createPanelAction(preConstgructionActions.get(actionIndex));
                    action.initialize(p2.getPanelActionConfiguration(preConstgructionActions.get(actionIndex)));
                    action.executeAction(AutomatedInstallData.getInstance(), null);
                }
            }
            Object object = constructor.newInstance(params);
            IzPanel panel = (IzPanel)object;
            String dataValidator = p2.getValidator();
            if (dataValidator != null) {
                panel.setValidationService(DataValidatorFactory.createDataValidator(dataValidator));
            }
            panel.setHelps(p2.getHelpsMap());
            List<String> preActivateActions = p2.getPreActivationActions();
            if (preActivateActions != null) {
                for (int actionIndex = 0; actionIndex < preActivateActions.size(); ++actionIndex) {
                    String panelActionClass = preActivateActions.get(actionIndex);
                    PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                    action.initialize(p2.getPanelActionConfiguration(panelActionClass));
                    panel.addPreActivationAction(action);
                }
            }
            if ((preValidateActions = p2.getPreValidationActions()) != null) {
                for (int actionIndex = 0; actionIndex < preValidateActions.size(); ++actionIndex) {
                    String panelActionClass = preValidateActions.get(actionIndex);
                    PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                    action.initialize(p2.getPanelActionConfiguration(panelActionClass));
                    panel.addPreValidationAction(action);
                }
            }
            if ((postValidateActions = p2.getPostValidationActions()) != null) {
                for (int actionIndex = 0; actionIndex < postValidateActions.size(); ++actionIndex) {
                    String panelActionClass = postValidateActions.get(actionIndex);
                    PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                    action.initialize(p2.getPanelActionConfiguration(panelActionClass));
                    panel.addPostValidationAction(action);
                }
            }
            this.installdata.panels.add(panel);
            if (panel.isHidden()) {
                this.visiblePanelMapping.add(count, -1);
            } else {
                this.visiblePanelMapping.add(count, curVisPanelNumber);
                ++curVisPanelNumber;
                lastVis = count;
            }
            ++count;
            XMLElementImpl panelRoot = new XMLElementImpl(className, this.installdata.xmlData);
            String panelId = p2.getPanelid();
            if (panelId != null) {
                panelRoot.setAttribute("id", panelId);
            }
            this.installdata.xmlData.addChild(panelRoot);
        }
        this.visiblePanelMapping.add(count, lastVis);
    }

    private void loadIcons() throws Exception {
        this.icons = new IconsDatabase();
    }

    protected void loadCustomIcons() throws Exception {
        ImageIcon img;
        URL url;
        IXMLElement icon;
        int i2;
        InputStream inXML = null;
        try {
            inXML = ResourceManager.getInstance().getInputStream(CUSTOM_ICONS_RESOURCEFILE);
        }
        catch (Throwable exception) {
            Debug.error("Resource customicons.xml not defined. No custom icons available.");
            return;
        }
        Debug.trace("Custom icons available.");
        XMLParser parser = new XMLParser();
        IXMLElement data = parser.parse(inXML);
        Vector<IXMLElement> children = data.getChildrenNamed("icon");
        int size = children.size();
        for (i2 = 0; i2 < size; ++i2) {
            icon = children.get(i2);
            url = InstallerFrame.class.getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            Debug.trace("Icon with id found: " + icon.getAttribute("id"));
            this.icons.put(icon.getAttribute("id"), img);
        }
        children = data.getChildrenNamed("sysicon");
        size = children.size();
        for (i2 = 0; i2 < size; ++i2) {
            icon = children.get(i2);
            url = InstallerFrame.class.getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            UIManager.put(icon.getAttribute("id"), img);
        }
    }

    private void buildGUI() {
        this.setDefaultCloseOperation(0);
        try {
            this.setIconImage(ResourceManager.getInstance().getImageIconResource("com/inet/setup/images/installer.cc.ico.png").getImage());
        }
        catch (ResourceNotFoundException e1) {
            Debug.error(e1);
        }
        catch (IOException e1) {
            Debug.error(e1);
        }
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.panelsContainer = new JPanel();
        this.panelsContainer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.panelsContainer.setLayout(new GridLayout(1, 1));
        this.contentPane.add((Component)this.panelsContainer, "Center");
        this.installdata.curPanelNumber = 0;
        IzPanel panel_0 = (IzPanel)this.installdata.panels.get(0);
        this.panelsContainer.add(panel_0);
        NavigationHandler navHandler = new NavigationHandler();
        JPanel navPanel = new JPanel();
        navPanel.setLayout(new BoxLayout(navPanel, 0));
        navPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.helpButton = ButtonFactory.createButton(this.langpack.getString("installer.help"), this.icons.getImageIcon("help"), this.installdata.buttonsHColor);
        navPanel.add(this.helpButton);
        this.helpButton.setName("HelpButton");
        this.helpButton.addActionListener(new HelpHandler());
        navPanel.add(Box.createHorizontalGlue());
        this.prevButton = ButtonFactory.createButton(this.langpack.getString("installer.prev"), this.icons.getImageIcon("stepback"), this.installdata.buttonsHColor);
        navPanel.add(this.prevButton);
        this.prevButton.addActionListener(navHandler);
        this.prevButton.addFocusListener(navHandler);
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.nextButton = ButtonFactory.createButton(this.langpack.getString("installer.next"), this.icons.getImageIcon("stepforward"), this.installdata.buttonsHColor);
        navPanel.add(this.nextButton);
        this.nextButton.addActionListener(navHandler);
        this.nextButton.addFocusListener(navHandler);
        navPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.quitButton = ButtonFactory.createButton(this.langpack.getString("installer.cancel"), this.icons.getImageIcon("stop"), this.installdata.buttonsHColor);
        navPanel.add(this.quitButton);
        this.quitButton.addActionListener(navHandler);
        this.quitButton.addFocusListener(navHandler);
        JPanel styledNavPanel = new JPanel();
        styledNavPanel.setLayout(new GridBagLayout());
        styledNavPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        styledNavPanel.add((Component)new JSeparator(0), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        styledNavPanel.add((Component)navPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPane.add((Component)styledNavPanel, "South");
        this.debugger = new Debugger(this.installdata, this.icons, this.rules);
        JPanel debugpanel = this.debugger.getDebugPanel();
        if (Debug.isDEBUG()) {
            if (this.installdata.guiPrefs.modifier.containsKey("showDebugWindow") && Boolean.valueOf(this.installdata.guiPrefs.modifier.get("showDebugWindow")).booleanValue()) {
                JFrame debugframe = new JFrame("Debug information");
                debugframe.setContentPane(debugpanel);
                debugframe.setSize(new Dimension(400, 400));
                debugframe.setVisible(true);
            } else {
                debugpanel.setPreferredSize(new Dimension(200, 400));
                this.contentPane.add((Component)debugpanel, "East");
            }
        }
        this.setDefaultButton();
        this.callGUIListener(0, navPanel);
        this.createHeading(navPanel);
    }

    private void setDefaultButton() {
        if (this.nextButton.isEnabled()) {
            this.quitButton.setDefaultCapable(false);
            this.prevButton.setDefaultCapable(false);
            this.nextButton.setDefaultCapable(true);
            this.nextButton.requestFocus();
        } else if (this.quitButton.isEnabled()) {
            this.quitButton.setDefaultCapable(true);
            this.prevButton.setDefaultCapable(false);
            this.nextButton.setDefaultCapable(false);
            this.quitButton.requestFocus();
        } else {
            this.quitButton.setDefaultCapable(false);
            this.prevButton.setDefaultCapable(true);
            this.nextButton.setDefaultCapable(false);
            this.prevButton.requestFocus();
        }
    }

    private void callGUIListener(int what) {
        this.callGUIListener(what, null);
    }

    private void callGUIListener(int what, Object param) {
        Iterator<GUIListener> iter = this.guiListener.iterator();
        while (iter.hasNext()) {
            iter.next().guiActionPerformed(what, param);
        }
    }

    private ImageIcon loadIcon(String resPrefix, int PanelNo, boolean tryBaseIcon) throws ResourceNotFoundException, IOException {
        ResourceManager rm = ResourceManager.getInstance();
        ImageIcon icon = null;
        String iconext = this.getIconResourceNameExtension();
        if (tryBaseIcon) {
            try {
                icon = rm.getImageIconResource(resPrefix);
            }
            catch (Exception e2) {
                Debug.error(e2);
                icon = rm.getImageIconResource(resPrefix + "." + PanelNo + iconext);
            }
        } else {
            icon = rm.getImageIconResource(resPrefix + "." + PanelNo + iconext);
        }
        return icon;
    }

    private ImageIcon loadIcon(String resPrefix, String panelid, boolean tryBaseIcon) throws ResourceNotFoundException, IOException {
        ResourceManager rm = ResourceManager.getInstance();
        ImageIcon icon = null;
        String iconext = this.getIconResourceNameExtension();
        if (tryBaseIcon) {
            try {
                icon = rm.getImageIconResource(resPrefix);
            }
            catch (Exception e2) {
                Debug.error(e2);
                icon = rm.getImageIconResource(resPrefix + "." + panelid + iconext);
            }
        } else {
            icon = rm.getImageIconResource(resPrefix + "." + panelid + iconext);
        }
        return icon;
    }

    private String getIconResourceNameExtension() {
        try {
            String iconext = this.installdata.getVariable(ICON_RESOURCE_EXT_VARIABLE_NAME);
            if (iconext == null) {
                iconext = "";
            } else if (iconext.length() > 0 && iconext.charAt(0) != '.') {
                iconext = "." + iconext;
            }
            iconext = iconext.trim();
            return iconext;
        }
        catch (Exception e2) {
            Debug.error(e2);
            return "";
        }
    }

    private void loadAndShowImage(int panelNo) {
        this.loadAndShowImage(this.iconLabel, ICON_RESOURCE, panelNo);
    }

    private void loadAndShowImage(int panelNo, String panelid) {
        this.loadAndShowImage(this.iconLabel, ICON_RESOURCE, panelNo, panelid);
    }

    private void loadAndShowImage(JLabel iLabel, String resPrefix, int panelno, String panelid) {
        ImageIcon icon = null;
        try {
            icon = this.loadIcon(resPrefix, panelid, false);
        }
        catch (Exception e2) {
            Debug.error(e2);
            try {
                icon = this.loadIcon(resPrefix, panelno, false);
            }
            catch (Exception ex2) {
                Debug.error(ex2);
                try {
                    icon = this.loadIcon(resPrefix, panelid, true);
                }
                catch (Exception e1) {
                    Debug.error(e1);
                }
            }
        }
        if (icon != null) {
            iLabel.setVisible(false);
            iLabel.setIcon(icon);
            iLabel.setVisible(true);
        }
    }

    private void loadAndShowImage(JLabel iLabel, String resPrefix, int panelNo) {
        ImageIcon icon = null;
        try {
            icon = this.loadIcon(resPrefix, panelNo, false);
        }
        catch (Exception e2) {
            Debug.error(e2);
            try {
                icon = this.loadIcon(resPrefix, panelNo, true);
            }
            catch (Exception e1) {
                Debug.error(e1);
            }
        }
        if (icon != null) {
            iLabel.setVisible(false);
            iLabel.setIcon(icon);
            iLabel.setVisible(true);
        }
    }

    private void showFrame() {
        this.pack();
        this.setSize(this.installdata.guiPrefs.width, this.installdata.guiPrefs.height);
        this.setResizable(this.installdata.guiPrefs.resizable);
        this.centerFrame(this);
        this.setVisible(true);
    }

    protected void switchPanel(int last) {
        this.parentInstaller.refreshDynamicVariables(this.substitutor, this.installdata);
        try {
            if (this.installdata.curPanelNumber < last) {
                this.isBack = true;
            }
            this.panelsContainer.setVisible(false);
            IzPanel panel = (IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber);
            IzPanel l_panel = (IzPanel)this.installdata.panels.get(last);
            this.showHelpButton(panel.canShowHelp());
            if (Debug.isTRACE()) {
                this.debugger.switchPanel(panel.getMetadata(), l_panel.getMetadata());
            }
            Log.getInstance().addDebugMessage("InstallerFrame.switchPanel: try switching panel from {0} to {1} ({2} to {3})", new String[]{l_panel.getClass().getName(), panel.getClass().getName(), Integer.toString(last), Integer.toString(this.installdata.curPanelNumber)}, "PanelTrace", null);
            if (this.visiblePanelMapping.get(this.installdata.curPanelNumber) == 0) {
                this.prevButton.setVisible(false);
                this.lockPrevButton();
                this.unlockNextButton();
            } else if (this.visiblePanelMapping.get(this.installdata.panels.size()) == this.installdata.curPanelNumber) {
                this.prevButton.setVisible(false);
                this.nextButton.setVisible(false);
                this.lockNextButton();
            } else {
                if (this.hasNavigatePrevious(this.installdata.curPanelNumber, true) != -1) {
                    this.prevButton.setVisible(true);
                    this.unlockPrevButton();
                } else {
                    this.lockPrevButton();
                    this.prevButton.setVisible(false);
                }
                if (this.hasNavigateNext(this.installdata.curPanelNumber, true) != -1) {
                    this.nextButton.setVisible(true);
                    this.unlockNextButton();
                } else {
                    this.lockNextButton();
                    this.nextButton.setVisible(false);
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String buttonName = "next";
                    if (InstallerFrame.this.quitButton.isEnabled()) {
                        buttonName = "quit";
                    }
                    InstallerFrame.this.setDefaultButton();
                    Log.getInstance().addDebugMessage("InstallerFrame.switchPanel: setting {0} as default button", new String[]{buttonName}, "PanelTrace", null);
                }
            });
            this.panelsContainer.remove(l_panel);
            l_panel.panelDeactivate();
            this.panelsContainer.add(panel);
            if (panel.getInitialFocus() != null) {
                JTextComponent inText;
                final Component inFoc = panel.getInitialFocus();
                if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
                    inFoc.requestFocus();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            inFoc.requestFocusInWindow();
                        }
                    });
                }
                if (inFoc instanceof JTextComponent && (inText = (JTextComponent)inFoc).isEditable() && inText.getDocument() != null) {
                    inText.setCaretPosition(inText.getDocument().getLength());
                }
            }
            this.performHeading(panel);
            this.performHeadingCounter(panel);
            panel.executePreActivationActions();
            panel.panelActivate();
            this.panelsContainer.setVisible(true);
            this.isBack = false;
            this.callGUIListener(3);
            Log.getInstance().addDebugMessage("InstallerFrame.switchPanel: switched", null, "PanelTrace", null);
        }
        catch (Exception e2) {
            Debug.error(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getUninstallerInstallLog(UninstallData udata) {
        ArrayList<String> uninstallerInfos = new ArrayList<String>();
        File f2 = new File(this.installdata.getInstallPath() + File.separator + "Uninstaller" + File.separator + "install.log");
        if (f2.exists() && f2.canRead()) {
            FileReader fr2 = null;
            BufferedReader br2 = null;
            try {
                String s2;
                fr2 = new FileReader(f2);
                br2 = new BufferedReader(fr2);
                while ((s2 = br2.readLine()) != null) {
                    uninstallerInfos.add(s2);
                }
            }
            catch (Exception e2) {
                Debug.trace(e2);
            }
            finally {
                try {
                    fr2.close();
                }
                catch (IOException e3) {
                    Debug.error(e3);
                }
                try {
                    br2.close();
                }
                catch (IOException e4) {
                    Debug.error(e4);
                }
            }
        }
        ArrayList files = udata.getUninstalableFilesList();
        if (uninstallerInfos != null && uninstallerInfos.size() > 0) {
            files.addAll(uninstallerInfos);
            HashSet hashSet = new HashSet(files);
            files = new ArrayList(hashSet);
        }
        return files;
    }

    private void insertUninstallerInstallLog(UninstallData udata, ZipOutputStream outJar) throws Exception {
        outJar.putNextEntry(new ZipEntry("install.log"));
        BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
        logWriter.write(this.installdata.getInstallPath());
        logWriter.newLine();
        Iterator<String> iter = this.getUninstallerInstallLog(udata).iterator();
        while (iter.hasNext()) {
            logWriter.write(iter.next());
            if (!iter.hasNext()) continue;
            logWriter.newLine();
        }
        logWriter.flush();
        outJar.closeEntry();
    }

    private void insertUninstallerJarlocationLog(UninstallData udata, ZipOutputStream outJar) throws Exception {
        outJar.putNextEntry(new ZipEntry("jarlocation.log"));
        BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
        logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
        logWriter.write(udata.getUninstallerJarFilename());
        logWriter.newLine();
        logWriter.write(udata.getUninstallerPath());
        logWriter.flush();
        outJar.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ExecutableFile> getExecutablesList() {
        ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
        File f2 = new File(this.installdata.getInstallPath() + File.separator + "Uninstaller" + File.separator + "executables");
        if (f2.exists() && f2.canRead()) {
            FileInputStream fin = null;
            ObjectInputStream oin = null;
            try {
                fin = new FileInputStream(f2);
                oin = new ObjectInputStream(fin);
                int num = oin.readInt();
                for (int i2 = 0; i2 < num; ++i2) {
                    Object readObject = oin.readObject();
                    if (readObject instanceof ExecutableFile) {
                        ExecutableFile file = (ExecutableFile)readObject;
                        executables.add(file);
                        continue;
                    }
                    --i2;
                }
            }
            catch (Exception e2) {
                Debug.error(e2);
            }
            finally {
                try {
                    fin.close();
                }
                catch (IOException e3) {
                    Debug.error(e3);
                }
                try {
                    oin.close();
                }
                catch (IOException e4) {
                    Debug.error(e4);
                }
            }
        }
        return executables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertUninstallerExecutables(UninstallData udata, ZipOutputStream outJar) {
        ObjectOutputStream execStream = null;
        try {
            outJar.putNextEntry(new ZipEntry("executables"));
            execStream = new ObjectOutputStream(outJar);
            List executablesList = udata.getExecutablesList();
            ArrayList<ExecutableFile> oldExecutablesList = this.getExecutablesList();
            if (oldExecutablesList != null && oldExecutablesList.size() > 0) {
                executablesList.addAll(oldExecutablesList);
            }
            Iterator iter = executablesList.iterator();
            execStream.writeInt(executablesList.size());
            while (iter.hasNext()) {
                ExecutableFile file = (ExecutableFile)iter.next();
                execStream.writeObject(file);
            }
        }
        catch (IOException e2) {
            Debug.error(e2);
        }
        finally {
            try {
                execStream.flush();
            }
            catch (IOException e3) {
                Debug.error(e3);
            }
            try {
                outJar.closeEntry();
            }
            catch (IOException e4) {
                Debug.error(e4);
            }
        }
    }

    public void writeUninstallData() {
        String logfile = this.installdata.getVariable("InstallerFrame.logfilePath");
        BufferedWriter extLogWriter = null;
        if (logfile != null) {
            File outFile;
            if (logfile.toLowerCase().startsWith("default")) {
                logfile = this.installdata.info.getUninstallerPath() + "/install.log";
            }
            if (!(outFile = new File(logfile = IoHelper.translatePath(logfile, new VariableSubstitutor(this.installdata.getVariables())))).getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outFile);
            }
            catch (FileNotFoundException e2) {
                Debug.trace("Cannot create logfile!");
                Debug.error(e2);
            }
            if (out != null) {
                extLogWriter = new BufferedWriter(new OutputStreamWriter(out));
            }
        }
        try {
            String condition = this.installdata.getVariable("UNINSTALLER_CONDITION");
            if (condition != null && !RulesEngine.getCondition(condition).isTrue()) {
                return;
            }
            Debug.log("[ Writing the uninstaller data ... ]");
            ZipOutputStream outJar = this.installdata.uninstallOutJar;
            if (outJar == null) {
                return;
            }
            UninstallData udata = UninstallData.getInstance();
            this.insertUninstallerInstallLog(udata, outJar);
            this.insertUninstallerJarlocationLog(udata, outJar);
            this.insertUninstallerExecutables(udata, outJar);
            Map<String, Object> additionalData = udata.getAdditionalData();
            if (additionalData != null && !additionalData.isEmpty()) {
                Iterator<String> keys = additionalData.keySet().iterator();
                HashSet<String> exist = new HashSet<String>();
                while (keys != null && keys.hasNext()) {
                    int bytesInBuffer;
                    long bytesCopied;
                    byte[] buffer;
                    String key = keys.next();
                    Object contents = additionalData.get(key);
                    if ("__uninstallLibs__".equals(key)) {
                        Iterator nativeLibIter = ((List)contents).iterator();
                        while (nativeLibIter != null && nativeLibIter.hasNext()) {
                            String nativeLibName = (String)((List)nativeLibIter.next()).get(0);
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            outJar.putNextEntry(new ZipEntry("native/" + nativeLibName));
                            InputStream in = this.getClass().getResourceAsStream("/native/" + nativeLibName);
                            while ((bytesInBuffer = in.read(buffer)) != -1) {
                                outJar.write(buffer, 0, bytesInBuffer);
                                bytesCopied += (long)bytesInBuffer;
                            }
                            outJar.closeEntry();
                        }
                        continue;
                    }
                    if ("uninstallerListeners".equals(key) || "uninstallerJars".equals(key)) {
                        ArrayList<String> subContents = new ArrayList<String>();
                        Iterator listenerIter = ((List)contents).iterator();
                        while (listenerIter.hasNext()) {
                            buffer = new byte[5120];
                            bytesCopied = 0L;
                            CustomData customData = (CustomData)listenerIter.next();
                            if (customData.listenerName != null) {
                                subContents.add(customData.listenerName);
                            }
                            for (String contentPath : customData.contents) {
                                if (exist.contains(contentPath)) continue;
                                exist.add(contentPath);
                                try {
                                    outJar.putNextEntry(new ZipEntry(contentPath));
                                }
                                catch (ZipException ze) {
                                    Debug.error("ZipException in writing custom data: " + ze.getMessage());
                                    continue;
                                }
                                InputStream in = this.getClass().getResourceAsStream("/" + contentPath);
                                if (in != null) {
                                    while ((bytesInBuffer = in.read(buffer)) != -1) {
                                        outJar.write(buffer, 0, bytesInBuffer);
                                        bytesCopied += (long)bytesInBuffer;
                                    }
                                } else {
                                    Debug.error("custom data not found: " + contentPath);
                                }
                                outJar.closeEntry();
                            }
                        }
                        outJar.putNextEntry(new ZipEntry(key));
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(subContents);
                        objOut.flush();
                        outJar.closeEntry();
                        continue;
                    }
                    outJar.putNextEntry(new ZipEntry(key));
                    if (contents instanceof ByteArrayOutputStream) {
                        ((ByteArrayOutputStream)contents).writeTo(outJar);
                    } else {
                        ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                        objOut.writeObject(contents);
                        objOut.flush();
                    }
                    outJar.closeEntry();
                }
            }
            ArrayList<String> unInstallScripts = udata.getUninstallScripts();
            Iterator<String> unInstallIter = unInstallScripts.iterator();
            int idx = 0;
            while (unInstallIter.hasNext()) {
                outJar.putNextEntry(new ZipEntry("rootscript" + Integer.toString(idx)));
                ObjectOutputStream rootStream = new ObjectOutputStream(outJar);
                String unInstallScript = unInstallIter.next();
                rootStream.writeUTF(unInstallScript);
                rootStream.flush();
                outJar.closeEntry();
                ++idx;
            }
            outJar.flush();
            outJar.close();
        }
        catch (Exception e3) {
            Debug.error(e3);
        }
    }

    public InputStream getResource(String res) throws Exception {
        String basePath = "";
        ResourceManager rm = null;
        try {
            rm = ResourceManager.getInstance();
            basePath = rm.resourceBasePath;
        }
        catch (Exception e2) {
            Debug.error(e2);
        }
        InputStream result = this.getClass().getResourceAsStream(basePath + res);
        if (result == null) {
            throw new ResourceNotFoundException("Warning: Resource not found: " + res);
        }
        return result;
    }

    public void centerFrame(InstallerFrame frame) {
        if (!GraphicsEnvironment.isHeadless()) {
            Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            Dimension frameSize = frame.getSize();
            frame.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
        }
    }

    public Dimension getPanelsContainerSize() {
        return this.panelsContainer.getSize();
    }

    public void buildConstraints(GridBagConstraints gbc, int gx2, int gy2, int gw2, int gh2, double wx, double wy) {
        gbc.gridx = gx2;
        gbc.gridy = gy2;
        gbc.gridwidth = gw2;
        gbc.gridheight = gh2;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public void deleteTmp(String delete_dir) {
        try {
            ArrayList<String> dirs = new ArrayList<String>();
            File f2 = new File(delete_dir);
            File[] list = f2.listFiles();
            if (list.length == 0) {
                f2.delete();
            } else {
                for (int i2 = 0; i2 < list.length; ++i2) {
                    if (list[i2].isFile()) {
                        list[i2].delete();
                        continue;
                    }
                    dirs.add(list[i2].getAbsolutePath());
                }
                for (int j2 = 0; j2 < dirs.size(); ++j2) {
                    this.deleteTmp((String)dirs.get(j2));
                    new File((String)dirs.get(j2)).delete();
                }
                f2.delete();
            }
        }
        catch (Exception e2) {
            if (GraphicsEnvironment.isHeadless()) {
                System.err.println(e2.getMessage());
            } else {
                JOptionPane.showMessageDialog(null, e2.getMessage(), "Setup", 0);
            }
            Debug.error(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        if (!(!this.installdata.canClose || this.nextButton.isVisible() && this.nextButton.isEnabled() || this.prevButton.isVisible() && this.prevButton.isEnabled())) {
            try {
                this.writeUninstallData();
            }
            catch (Throwable t2) {
                Debug.error(t2);
            }
            finally {
                Housekeeper.getInstance().shutDown(0, this.installdata.getInstallPath());
            }
        } else {
            try {
                if (Unpacker.isDiscardInterrupt() && this.interruptCount < 3) {
                    ++this.interruptCount;
                    return;
                }
                this.wipeAborted();
            }
            catch (Throwable t3) {
                Debug.error(t3);
            }
            Housekeeper.getInstance().shutDown(0);
        }
    }

    protected void wipeAborted() {
        if (!Unpacker.interruptAll(40000L)) {
            return;
        }
        UninstallData u2 = UninstallData.getInstance();
        for (String p2 : u2.getInstalledFilesList()) {
            File f2 = new File(p2);
            f2.delete();
        }
    }

    public void install(AbstractUIProgressHandler listener) {
        this.unpacker = UnpackerFactory.getUnpacker(this.installdata.info.getUnpackerClassName(), this.installdata, listener);
        this.unpacker.setRules(this.rules);
        Thread unpackerthread = new Thread((Runnable)this.unpacker, "IzPack - Unpacker thread");
        unpackerthread.start();
    }

    public void writeXMLTree(IXMLElement root, OutputStream out) throws Exception {
        XMLWriter writer = new XMLWriter(out);
        for (int i2 = 0; i2 < this.installdata.panels.size(); ++i2) {
            IzPanel panel = (IzPanel)this.installdata.panels.get(i2);
            panel.makeXMLData(this.installdata.xmlData.getChildAtIndex(i2));
        }
        writer.write(root);
    }

    public void setQuitButtonText(String text) {
        String text1 = text;
        if (text1 == null) {
            text1 = this.langpack.getString("installer.cancel");
        }
        this.quitButton.setText(text1);
    }

    public void setQuitButtonIcon(String iconName) {
        String useButtonIcons = this.installdata.guiPrefs.modifier.get("useButtonIcons");
        if (useButtonIcons == null || "yes".equalsIgnoreCase(useButtonIcons)) {
            this.quitButton.setIcon(this.icons.getImageIcon(iconName));
        }
    }

    public void blockGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().setVisible(true);
        this.getGlassPane().setEnabled(true);
        if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
            return;
        }
        if (this.usualFTP == null) {
            this.usualFTP = this.getFocusTraversalPolicy();
        }
        if (this.blockFTP == null) {
            this.blockFTP = new BlockFocusTraversalPolicy();
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.blockFTP);
        this.getGlassPane().requestFocus();
        this.callGUIListener(1);
    }

    public void releaseGUI() {
        this.getGlassPane().setEnabled(false);
        this.getGlassPane().setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if ((double)JAVA_SPECIFICATION_VERSION < 1.35) {
            return;
        }
        this.setFocusTraversalPolicy((FocusTraversalPolicy)this.usualFTP);
        this.callGUIListener(2);
    }

    public void lockPrevButton() {
        this.prevButton.setEnabled(false);
        this.setDefaultButton();
    }

    public void lockNextButton() {
        this.nextButton.setEnabled(false);
        this.setDefaultButton();
    }

    public void setNextButtonText(String text) {
        this.nextButton.setText(text);
    }

    public void unlockPrevButton() {
        this.prevButton.setEnabled(true);
        this.setDefaultButton();
    }

    public void unlockNextButton() {
        this.nextButton.setEnabled(true);
        this.setDefaultButton();
    }

    public void hideNextButton() {
        this.nextButton.setVisible(false);
    }

    public void showNextButton() {
        this.nextButton.setVisible(true);
    }

    public void skipPanel() {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            if (this.isBack) {
                this.navigatePrevious(this.installdata.curPanelNumber);
            } else {
                this.navigateNext(this.installdata.curPanelNumber, false);
            }
        }
    }

    public boolean canShow(int panelnumber) {
        IzPanel panel = (IzPanel)this.installdata.panels.get(panelnumber);
        Panel panelmetadata = panel.getMetadata();
        String panelid = panelmetadata.getPanelid();
        Debug.trace("Current Panel: " + panelid);
        if (panelmetadata.hasCondition()) {
            Debug.log("Checking panelcondition");
            return this.rules.isConditionTrue(panelmetadata.getCondition());
        }
        if (!this.rules.canShowPanel(panelid, this.installdata.variables)) {
            Debug.log("Skip panel with panelid=" + panelid);
            return false;
        }
        return true;
    }

    public void navigateNext() {
        if (!this.nextButton.isEnabled()) {
            return;
        }
        boolean result = this.navigateNext(this.installdata.curPanelNumber, true);
        if (result) {
            this.setDefaultButton();
        }
    }

    public boolean navigateNext(int startPanel, boolean doValidation) {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            boolean isValid;
            IzPanel panel = (IzPanel)this.installdata.panels.get(startPanel);
            panel.executePreValidationActions();
            boolean bl2 = isValid = doValidation ? panel.panelValidated() : true;
            if (!this.nextButton.isEnabled()) {
                return false;
            }
            if (!isValid) {
                return false;
            }
            panel.executePostValidationActions();
            int nextPanel = this.hasNavigateNext(startPanel, false);
            if (-1 != nextPanel) {
                this.installdata.curPanelNumber = nextPanel;
                this.switchPanel(startPanel);
            }
        }
        return doValidation;
    }

    public int hasNavigateNext(int startPanel, boolean visibleOnly) {
        int res = -1;
        for (int panel = startPanel + 1; res == -1 && panel < this.installdata.panels.size(); ++panel) {
            if (visibleOnly && this.visiblePanelMapping.get(panel) == -1 || !this.canShow(panel)) continue;
            res = panel;
        }
        return res;
    }

    public int hasNavigatePrevious(int endingPanel, boolean visibleOnly) {
        int res = -1;
        for (int panel = endingPanel - 1; res == -1 && panel >= 0; --panel) {
            if (visibleOnly && this.visiblePanelMapping.get(panel) == -1 || !this.canShow(panel)) continue;
            res = panel;
        }
        return res;
    }

    public void navigatePrevious() {
        if (!this.prevButton.isEnabled()) {
            return;
        }
        this.navigatePrevious(this.installdata.curPanelNumber);
    }

    public void navigatePrevious(int endingPanel) {
        int prevPanel = this.hasNavigatePrevious(endingPanel, false);
        if (-1 != prevPanel) {
            this.installdata.curPanelNumber = prevPanel;
            this.switchPanel(endingPanel);
        }
    }

    public void showHelp() {
        if (this.loadHelp(this.installdata.curPanelNumber, ((IzPanel)this.installdata.panels.get((int)this.installdata.curPanelNumber)).myClassname)) {
            this.helpFrame.showHelpDialog(this.getJFrame());
        }
    }

    public boolean isHelpVisible() {
        return this.helpFrame.isHelpFrameVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadHelp(int panelNo, String panelName) {
        try {
            ResourceManager rm = ResourceManager.getInstance();
            URL helpURL = null;
            ++panelNo;
            try {
                String resource = panelName + "_" + panelNo + "_help_" + this.installdata.localeISO3 + ".html";
                helpURL = rm.getURL(resource);
                if (helpURL != null) {
                    this.helpFrame.addHelpPage(helpURL, this.langpack, this.icons);
                }
            }
            catch (ResourceNotFoundException e2) {
                try {
                    Debug.error(e2);
                    helpURL = rm.getURL(panelName + "_" + panelNo + "_help_" + "eng" + ".html");
                    if (helpURL != null) {
                        this.helpFrame.addHelpPage(helpURL, this.langpack, this.icons);
                    }
                }
                catch (Throwable throwable) {
                    if (helpURL != null) {
                        this.helpFrame.addHelpPage(helpURL, this.langpack, this.icons);
                    }
                    throw throwable;
                }
            }
            return true;
        }
        catch (Exception e3) {
            Debug.error(e3);
            return false;
        }
    }

    void askBeforeClearAndExit() {
        if (this.installdata.curPanelNumber < this.installdata.panels.size() - 1) {
            if (((IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber)).askQuestion(this.langpack.getString("installer.quit.title"), this.langpack.getString("installer.quit.message"), 37, 49) == 47) {
                this.clearAndExit();
            }
        } else {
            this.clearAndExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAndExit() {
        ((IzPanel)this.installdata.panels.get(this.installdata.curPanelNumber)).panelDeactivate();
        try {
            String tmp = this.installdata.getInstallPath() + File.separator + "setup_tmp" + File.separator;
            if (new File(tmp).exists()) {
                this.deleteTmp(tmp);
            }
        }
        catch (Exception exc) {
            Debug.error(exc);
        }
        finally {
            this.exit();
        }
    }

    public List<GUIListener> getGuiListener() {
        return this.guiListener;
    }

    public void addGuiListener(GUIListener listener) {
        this.guiListener.add(listener);
    }

    private void createHeadingLabels(int headingLines, Color back) {
        float fontSize;
        this.headingLabels = new JLabel[headingLines + 1];
        this.headingLabels[0] = new JLabel("");
        this.headingLabels[0].setFont(this.headingLabels[0].getFont().deriveFont(1));
        Color foreground = null;
        if (this.installdata.guiPrefs.modifier.containsKey("headingForegroundColor")) {
            foreground = Color.decode(this.installdata.guiPrefs.modifier.get("headingForegroundColor"));
            this.headingLabels[0].setForeground(foreground);
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingFontSize") && (double)(fontSize = Float.parseFloat(this.installdata.guiPrefs.modifier.get("headingFontSize"))) > 0.0 && (double)fontSize <= 5.0) {
            float currentSize = this.headingLabels[0].getFont().getSize2D();
            this.headingLabels[0].setFont(this.headingLabels[0].getFont().deriveFont(currentSize * fontSize));
        }
        if (this.imageLeft) {
            this.headingLabels[0].setAlignmentX(1.0f);
        }
        for (int i2 = 1; i2 < headingLines; ++i2) {
            this.headingLabels[i2] = new JLabel();
            if (this.imageLeft) {
                this.headingLabels[i2].setAlignmentX(1.0f);
                continue;
            }
            this.headingLabels[i2].setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 8));
        }
    }

    private void createHeadingCounter(Color back, JPanel navPanel, JPanel leftHeadingPanel) {
        String counterPos = "inHeading";
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounterPos")) {
            counterPos = this.installdata.guiPrefs.modifier.get("headingPanelCounterPos");
        }
        if (leftHeadingPanel == null && "inHeading".equalsIgnoreCase(counterPos)) {
            return;
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingPanelCounter")) {
            this.headingCounterComponent = null;
            if ("progressbar".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                JProgressBar headingProgressBar = new JProgressBar();
                headingProgressBar.setStringPainted(true);
                headingProgressBar.setString("");
                headingProgressBar.setValue(0);
                this.headingCounterComponent = headingProgressBar;
                if (this.imageLeft) {
                    this.headingCounterComponent.setAlignmentX(1.0f);
                }
            } else if ("text".equalsIgnoreCase(this.installdata.guiPrefs.modifier.get("headingPanelCounter"))) {
                JLabel headingCountPanels = new JLabel(" ");
                this.headingCounterComponent = headingCountPanels;
                if (this.imageLeft) {
                    this.headingCounterComponent.setAlignmentX(1.0f);
                } else {
                    this.headingCounterComponent.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
                }
                Color foreground = null;
                if (this.installdata.guiPrefs.modifier.containsKey("headingForegroundColor")) {
                    foreground = Color.decode(this.installdata.guiPrefs.modifier.get("headingForegroundColor"));
                    headingCountPanels.setForeground(foreground);
                }
            }
            if ("inHeading".equals(counterPos)) {
                leftHeadingPanel.add(this.headingCounterComponent);
            } else if ("inNavigationPanel".equals(counterPos)) {
                int i2;
                Component[] comps = navPanel.getComponents();
                for (i2 = 0; i2 < comps.length && !comps[i2].equals(this.prevButton); ++i2) {
                }
                if (i2 <= comps.length) {
                    navPanel.add(Box.createHorizontalGlue(), i2);
                    navPanel.add((Component)this.headingCounterComponent, i2);
                }
            }
        }
    }

    private JPanel createHeadingIcon(Color back) {
        ImageIcon icon = null;
        try {
            icon = this.loadIcon(HEADING_ICON_RESOURCE, 0, true);
        }
        catch (Exception e2) {
            Debug.error(e2);
        }
        JPanel imgPanel = new JPanel();
        imgPanel.setLayout(new BoxLayout(imgPanel, 1));
        int borderSize = 8;
        if (this.installdata.guiPrefs.modifier.containsKey("headingImageBorderSize")) {
            borderSize = Integer.parseInt(this.installdata.guiPrefs.modifier.get("headingImageBorderSize"));
        }
        imgPanel.setBorder(BorderFactory.createEmptyBorder(borderSize, borderSize, borderSize, borderSize));
        if (back != null) {
            imgPanel.setBackground(back);
        }
        JLabel iconLab = new JLabel(icon);
        if (this.imageLeft) {
            imgPanel.add((Component)iconLab, "West");
        } else {
            imgPanel.add((Component)iconLab, "East");
        }
        this.headingLabels[this.headingLabels.length - 1] = iconLab;
        return imgPanel;
    }

    private void createHeading(JPanel navPanel) {
        this.headingPanel = null;
        int headingLines = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            headingLines = Integer.parseInt(this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        Color back = null;
        int i2 = 0;
        if (this.installdata.guiPrefs.modifier.containsKey("headingBackgroundColor")) {
            back = Color.decode(this.installdata.guiPrefs.modifier.get("headingBackgroundColor"));
        }
        if (!this.isHeading(null)) {
            this.createHeadingCounter(back, navPanel, null);
            return;
        }
        if (this.installdata.guiPrefs.modifier.containsKey("headingImageOnLeft") && (this.installdata.guiPrefs.modifier.get("headingImageOnLeft").equalsIgnoreCase("yes") || this.installdata.guiPrefs.modifier.get("headingImageOnLeft").equalsIgnoreCase("true"))) {
            this.imageLeft = true;
        }
        this.createHeadingLabels(headingLines, back);
        JPanel leftHeadingPanel = new JPanel();
        if (back != null) {
            leftHeadingPanel.setBackground(back);
        }
        leftHeadingPanel.setLayout(new BoxLayout(leftHeadingPanel, 1));
        if (this.imageLeft) {
            leftHeadingPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        }
        for (i2 = 0; i2 < headingLines; ++i2) {
            leftHeadingPanel.add(this.headingLabels[i2]);
        }
        this.createHeadingCounter(back, navPanel, leftHeadingPanel);
        JPanel imgPanel = this.createHeadingIcon(back);
        JPanel northPanel = new JPanel();
        if (back != null) {
            northPanel.setBackground(back);
        }
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        northPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        if (this.imageLeft) {
            northPanel.add(imgPanel);
            northPanel.add(Box.createHorizontalGlue());
            northPanel.add(leftHeadingPanel);
        } else {
            northPanel.add(leftHeadingPanel);
            northPanel.add(Box.createHorizontalGlue());
            northPanel.add(imgPanel);
        }
        this.headingPanel = new JPanel(new BorderLayout());
        this.headingPanel.add(northPanel);
        this.headingPanel.add((Component)new JSeparator(), "South");
        this.contentPane.add((Component)this.headingPanel, "North");
    }

    public boolean isHeading(IzPanel caller) {
        if (!this.installdata.guiPrefs.modifier.containsKey("useHeadingPanel") || !this.installdata.guiPrefs.modifier.get("useHeadingPanel").equalsIgnoreCase("yes")) {
            return false;
        }
        if (caller == null) {
            return true;
        }
        return caller.getI18nStringForClass("headline", null) != null;
    }

    private void performHeading(IzPanel panel) {
        int i2;
        int headingLines = 1;
        if (this.installdata.guiPrefs.modifier.containsKey("headingLineCount")) {
            headingLines = Integer.parseInt(this.installdata.guiPrefs.modifier.get("headingLineCount"));
        }
        if (this.headingLabels == null) {
            return;
        }
        String headline = panel.getI18nStringForClass("headline");
        if (headline == null) {
            this.headingPanel.setVisible(false);
            return;
        }
        for (i2 = 0; i2 <= headingLines; ++i2) {
            if (this.headingLabels[i2] == null) continue;
            this.headingLabels[i2].setVisible(false);
        }
        for (i2 = 0; i2 < headingLines - 1; ++i2) {
            String info = panel.getI18nStringForClass("headinfo" + Integer.toString(i2));
            if (info == null) {
                info = " ";
            }
            if (info.endsWith(":")) {
                info = info.substring(0, info.length() - 1) + ".";
            }
            this.headingLabels[i2 + 1].setText(info);
            this.headingLabels[i2 + 1].setVisible(true);
        }
        this.headingLabels[0].setText(headline);
        this.headingLabels[0].setVisible(true);
        int curPanelNo = this.visiblePanelMapping.get(this.installdata.curPanelNumber);
        if (this.headingLabels[headingLines] != null) {
            this.loadAndShowImage(this.headingLabels[headingLines], HEADING_ICON_RESOURCE, curPanelNo);
            this.headingLabels[headingLines].setVisible(true);
        }
        this.headingPanel.setVisible(true);
    }

    private void performHeadingCounter(IzPanel panel) {
        if (this.headingCounterComponent != null) {
            int curPanelNo = this.visiblePanelMapping.get(this.installdata.curPanelNumber);
            int visPanelsCount = this.visiblePanelMapping.get(this.visiblePanelMapping.get(this.installdata.panels.size()));
            StringBuffer buf = new StringBuffer();
            buf.append(this.langpack.getString("installer.step")).append(" ").append(curPanelNo + 1).append(" ").append(this.langpack.getString("installer.of")).append(" ").append(visPanelsCount + 1);
            if (this.headingCounterComponent instanceof JProgressBar) {
                JProgressBar headingProgressBar = (JProgressBar)this.headingCounterComponent;
                headingProgressBar.setMaximum(visPanelsCount + 1);
                headingProgressBar.setValue(curPanelNo + 1);
                headingProgressBar.setString(buf.toString());
            } else {
                ((JLabel)this.headingCounterComponent).setText(buf.toString());
            }
        }
    }

    public RulesEngine getRules() {
        return this.rules;
    }

    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    private void showHelpButton(boolean show) {
        if (this.helpButton == null) {
            return;
        }
        this.helpButton.setVisible(show);
    }

    public IUnpacker getUnpacker() {
        return this.unpacker;
    }

    private class BlockFocusTraversalPolicy
    extends DefaultFocusTraversalPolicy {
        private static final long serialVersionUID = 3258413928261169209L;

        private BlockFocusTraversalPolicy() {
        }

        protected boolean accept(Component aComp) {
            return aComp == InstallerFrame.this.getGlassPane();
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent e2) {
            InstallerFrame.this.askBeforeClearAndExit();
        }
    }

    class HelpHandler
    implements ActionListener {
        HelpHandler() {
        }

        public void actionPerformed(ActionEvent e2) {
            InstallerFrame.this.showHelp();
        }
    }

    class NavigationHandler
    implements ActionListener,
    FocusListener {
        NavigationHandler() {
        }

        public void actionPerformed(ActionEvent e2) {
            Object source = e2.getSource();
            if (source == InstallerFrame.this.prevButton) {
                InstallerFrame.this.navigatePrevious();
            } else if (source == InstallerFrame.this.nextButton) {
                InstallerFrame.this.navigateNext();
            } else if (source == InstallerFrame.this.quitButton) {
                InstallerFrame.this.askBeforeClearAndExit();
            }
        }

        public void focusGained(FocusEvent e2) {
            Object source = e2.getSource();
            if (source instanceof JButton) {
                InstallerFrame.this.getRootPane().setDefaultButton((JButton)source);
            }
        }

        public void focusLost(FocusEvent e2) {
            InstallerFrame.this.getRootPane().setDefaultButton(InstallerFrame.this.nextButton);
        }
    }
}

