/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Panel;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.LayoutHelper;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.panels.HelpWindow;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.MultiLineLabel;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.Utils;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class IzPanel
extends JPanel
implements AbstractUIHandler,
LayoutConstants {
    private static final long serialVersionUID = 3256442495255786038L;
    protected LayoutHelper layoutHelper;
    protected Component initialFocus = null;
    protected InstallData idata;
    protected InstallerFrame parent;
    protected String myFullClassname;
    protected String myClassname;
    protected String myPrefix;
    protected String headline;
    protected JLabel headLineLabel;
    protected boolean hidden;
    public static final String HEADLINE = "headline";
    private DataValidator validationService = null;
    private List<PanelAction> preActivateActions = null;
    private List<PanelAction> preValidateActions = null;
    private List<PanelAction> postValidateActions = null;
    public static final int X_ORIGIN = 0;
    public static final int Y_ORIGIN = 0;
    public static final String D = ".";
    public static final String d = ".";
    public static final int COLS_1 = 1;
    public static final int ROWS_1 = 1;
    public Panel metadata;
    private HashMap<String, String> helps = null;
    private HelpWindow helpWindow = null;

    public IzPanel(InstallerFrame parent, InstallData idata) {
        this(parent, idata, (LayoutManager2)null);
    }

    public IzPanel(InstallerFrame parent, InstallData idata, LayoutManager2 lm) {
        this.init(parent, idata);
        if (lm != null) {
            this.getLayoutHelper().startLayout(lm);
        }
    }

    public IzPanel(InstallerFrame parent, InstallData idata, String iconName) {
        this(parent, idata, iconName, -1);
    }

    public IzPanel(InstallerFrame parent, InstallData idata, String iconName, int instance) {
        this(parent, idata);
        this.buildHeadline(iconName, instance);
    }

    protected boolean buildHeadline(String imageIconName, int instanceNumber) {
        String headline;
        boolean result = false;
        if (this.parent.isHeading(this)) {
            return false;
        }
        String headlineSearchBaseKey = this.myClassname + "." + HEADLINE;
        if (instanceNumber > -1) {
            String instanceSearchKey = headlineSearchBaseKey + "." + Integer.toString(instanceNumber);
            String instanceHeadline = this.getString(instanceSearchKey);
            if (Debug.isLOG()) {
                System.out.println("found headline: " + instanceHeadline + "." + " for instance # " + instanceNumber);
            }
            headline = !instanceSearchKey.equals(instanceHeadline) ? instanceHeadline : this.getString(headlineSearchBaseKey);
        } else {
            headline = this.getString(headlineSearchBaseKey);
        }
        if (headline != null) {
            this.headLineLabel = imageIconName != null && !"".equals(imageIconName) ? new JLabel(headline, this.getImageIcon(imageIconName), 10) : new JLabel(headline);
            Font font = this.headLineLabel.getFont();
            float size = font.getSize();
            int style = 0;
            font = font.deriveFont(style, size * 1.5f);
            this.headLineLabel.setFont(font);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.headLineLabel.setName(HEADLINE);
            ((GridBagLayout)this.getLayout()).addLayoutComponent(this.headLineLabel, gbc);
            this.add(this.headLineLabel);
        }
        return result;
    }

    public String getString(String key) {
        return this.parent.langpack.getString(key);
    }

    public ImageIcon getImageIcon(String iconName) {
        return this.parent.icons.getImageIcon(iconName);
    }

    protected void initLayoutHelper() {
        this.layoutHelper = new LayoutHelper(this);
    }

    protected void getClassName() {
        this.myFullClassname = this.getClass().getName();
        this.myClassname = this.myFullClassname.substring(this.myFullClassname.lastIndexOf(".") + 1);
        this.myPrefix = this.myClassname + ".";
    }

    protected void init(InstallerFrame parent, InstallData idata) {
        this.getClassName();
        this.idata = idata;
        this.parent = parent;
        this.metadata = idata.currentPanel;
        idata.currentPanel = null;
        this.initLayoutHelper();
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "exit");
        actionMap.put("exit", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e2) {
                IzPanel.this.parent.askBeforeClearAndExit();
            }
        });
    }

    protected boolean isValidated() {
        return true;
    }

    public boolean panelValidated() {
        return this.isValidated() && this.validatePanel();
    }

    public void panelActivate() {
    }

    public void panelDeactivate() {
    }

    public void makeXMLData(IXMLElement panelRoot) {
    }

    public int askQuestion(String title, String question, int choices) {
        return this.askQuestion(title, question, choices, -1);
    }

    public int askQuestion(String title, String question, int choices, int defaultChoice) {
        question = Utils.breakText(question);
        if (GraphicsEnvironment.isHeadless()) {
            System.out.println(question);
            return defaultChoice;
        }
        int jo_choices = 0;
        if (choices == 37) {
            jo_choices = 0;
        } else if (choices == 38) {
            jo_choices = 1;
        }
        int user_choice = JOptionPane.showOptionDialog(this, question, title, jo_choices, 3, null, this.getYesNoCancelOptions(choices), this.getDefaultOption(defaultChoice));
        boolean isMacOrder = OsVersion.IS_MAC || UIManager.getBoolean("OptionPane.isYesLast");
        switch (user_choice) {
            case 2: {
                return isMacOrder ? 47 : 45;
            }
            case 0: {
                if (choices == 1) {
                    return isMacOrder ? 45 : 47;
                }
                return isMacOrder ? 49 : 47;
            }
            case 1: {
                if (choices == 1) {
                    return 49;
                }
                return isMacOrder ? 47 : 49;
            }
            case -1: {
                return 49;
            }
        }
        return defaultChoice;
    }

    private String getDefaultOption(int defaultChoice) {
        switch (defaultChoice) {
            case 49: {
                return UIManager.getString((Object)"OptionPane.noButtonText", this.idata.locale);
            }
            case 45: {
                return UIManager.getString((Object)"OptionPane.cancelButtonText", this.idata.locale);
            }
        }
        return UIManager.getString((Object)"OptionPane.yesButtonText", this.idata.locale);
    }

    private String[] getYesNoCancelOptions(int choices) {
        String yesButton = UIManager.getString((Object)"OptionPane.yesButtonText", this.idata.locale);
        String noButton = UIManager.getString((Object)"OptionPane.noButtonText", this.idata.locale);
        String cancelButton = UIManager.getString((Object)"OptionPane.cancelButtonText", this.idata.locale);
        if (OsVersion.IS_MAC || UIManager.getBoolean("OptionPane.isYesLast")) {
            if (choices == 1) {
                return new String[]{cancelButton, noButton, yesButton};
            }
            return new String[]{noButton, yesButton};
        }
        if (choices == 1) {
            return new String[]{yesButton, noButton, cancelButton};
        }
        return new String[]{yesButton, noButton};
    }

    private void emitMessage(String title, String message, int type) {
        message = Utils.breakText(message);
        if (!GraphicsEnvironment.isHeadless()) {
            JOptionPane.showMessageDialog(this, message, title, type);
        } else if (type == 0) {
            System.err.println(message);
        } else {
            System.out.println(message);
        }
    }

    private void emitMessage(String message, int messageType) {
        String title = "";
        switch (messageType) {
            case 0: {
                title = this.idata.langpack.getString("installer.error");
                break;
            }
            case 1: {
                title = this.idata.langpack.getString("installer.Message");
                break;
            }
            case 2: {
                title = this.idata.langpack.getString("installer.warning");
                break;
            }
            default: {
                title = this.idata.langpack.getString("installer.Message");
            }
        }
        this.emitMessage(title, message, messageType);
    }

    public void emitNotification(String title, String message) {
        if (title != null) {
            this.emitMessage(title, message, 1);
        } else {
            this.emitMessage(message, 1);
        }
    }

    public void emitWarning(String title, String message) {
        if (title != null) {
            this.emitMessage(title, message, 2);
        } else {
            this.emitMessage(message, 2);
        }
    }

    public void emitError(String title, String message) {
        if (title != null) {
            this.emitMessage(title, message, 0);
        } else {
            this.emitMessage(message, 0);
        }
    }

    public void emitErrorAndBlockNext(String title, String message) {
        this.emitError(title, message);
        if (!GraphicsEnvironment.isHeadless()) {
            this.parent.lockNextButton();
        }
    }

    public Component getInitialFocus() {
        return this.initialFocus;
    }

    public void setInitialFocus(Component component) {
        this.initialFocus = component;
    }

    public String getI18nStringForClass(String subkey) {
        String retval = null;
        Class<?> clazz = this.getClass();
        while (retval == null && !clazz.getName().endsWith(".IzPanel")) {
            retval = this.getI18nStringForClass(clazz.getName(), subkey, null);
            clazz = clazz.getSuperclass();
        }
        return retval;
    }

    public String getI18nStringForClass(String subkey, String alternateClass) {
        return this.getI18nStringForClass(this.getClass().getName(), subkey, alternateClass);
    }

    private String getI18nStringForClass(String curClassName, String subkey, String alternateClass) {
        int nameStart = curClassName.lastIndexOf(46) + 1;
        curClassName = curClassName.substring(nameStart, curClassName.length());
        StringBuffer buf = new StringBuffer();
        buf.append(curClassName).append(".").append(subkey);
        String fullkey = buf.toString();
        String panelid = null;
        if (this.getMetadata() != null) {
            panelid = this.getMetadata().getPanelid();
        }
        String retval = null;
        if (panelid != null) {
            buf.append(".");
            buf.append(panelid);
            retval = this.parent.langpack.getString(buf.toString());
        }
        if (retval == null || retval.startsWith(fullkey)) {
            retval = this.parent.langpack.getString(fullkey);
        }
        if (retval == null || retval.startsWith(fullkey)) {
            if (alternateClass == null) {
                return null;
            }
            buf.delete(0, buf.length());
            buf.append(alternateClass).append(".").append(subkey);
            retval = this.parent.langpack.getString(buf.toString());
        }
        if (retval != null && retval.indexOf(36) > -1) {
            VariableSubstitutor substitutor = new VariableSubstitutor(this.idata.getVariables());
            retval = substitutor.substitute(retval, null);
        }
        return retval;
    }

    public InstallerFrame getInstallerFrame() {
        return this.parent;
    }

    public JLabel createLabel(String subkey, String alternateClass, String iconId, int pos) {
        ImageIcon ii = iconId != null ? this.parent.icons.getImageIcon(iconId) : null;
        String msg = this.getI18nStringForClass(subkey, alternateClass);
        JLabel label = LabelFactory.create(msg, ii, pos);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public JLabel createLabel(String subkey, String alternateClass, String iconId, int pos, boolean isFullLine) {
        ImageIcon ii = iconId != null ? this.parent.icons.getImageIcon(iconId) : null;
        String msg = this.getI18nStringForClass(subkey, alternateClass);
        JLabel label = LabelFactory.create(msg, ii, pos, isFullLine);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public JLabel createLabel(String textId, String iconId, int pos) {
        return this.createLabel(textId, iconId, pos, false);
    }

    public JLabel createLabel(String textId, String iconId, int pos, boolean isFullLine) {
        ImageIcon ii = iconId != null ? this.parent.icons.getImageIcon(iconId) : null;
        JLabel label = LabelFactory.create(this.parent.langpack.getString(textId), ii, pos, isFullLine);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public MultiLineLabel createMultiLineLabelLang(String textId) {
        return this.createMultiLineLabel(this.parent.langpack.getString(textId));
    }

    public MultiLineLabel createMultiLineLabel(String text) {
        return this.createMultiLineLabel(text, null, 2);
    }

    public MultiLineLabel createMultiLineLabel(String text, String iconId, int pos) {
        MultiLineLabel mll = null;
        mll = new MultiLineLabel(text, 0, 0);
        if (mll != null) {
            mll.setFont(this.getControlTextFont());
        }
        return mll;
    }

    public Font getControlTextFont() {
        Font fontObj = IzPanel.getLAF() != null ? MetalLookAndFeel.getControlTextFont() : this.getFont();
        float val = LabelFactory.getLabelFontSize();
        if (val != 1.0f) {
            fontObj = fontObj.deriveFont(fontObj.getSize2D() * val);
        }
        return fontObj;
    }

    protected static MetalLookAndFeel getLAF() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof MetalLookAndFeel) {
            return (MetalLookAndFeel)laf;
        }
        return null;
    }

    @Deprecated
    public GridBagConstraints getDefaultGridBagConstraints() {
        return (GridBagConstraints)this.layoutHelper.getDefaultConstraints();
    }

    @Deprecated
    public void setDefaultGridBagConstraints(GridBagConstraints constraints) {
        this.layoutHelper.setDefaultConstraints(constraints);
    }

    @Deprecated
    public void resetGridCounter() {
        this.layoutHelper.resetGridCounter();
    }

    @Deprecated
    public GridBagConstraints getNewGridBagConstraints(int gridx, int gridy) {
        return (GridBagConstraints)this.layoutHelper.getNewConstraints(gridx, gridy);
    }

    @Deprecated
    public GridBagConstraints getNewGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight) {
        return (GridBagConstraints)this.layoutHelper.getNewConstraints(gridx, gridy, gridwidth, gridheight);
    }

    @Deprecated
    public GridBagConstraints getNextXGridBagConstraints() {
        return (GridBagConstraints)this.layoutHelper.getNextXConstraints();
    }

    @Deprecated
    public GridBagConstraints getNextYGridBagConstraints() {
        return (GridBagConstraints)this.layoutHelper.getNextYConstraints();
    }

    @Deprecated
    public GridBagConstraints getNextYGridBagConstraints(int gridwidth, int gridheight) {
        return (GridBagConstraints)this.layoutHelper.getNextYConstraints(gridwidth, gridheight);
    }

    @Deprecated
    public void startGridBagLayout() {
        this.layoutHelper.startLayout(new GridBagLayout());
    }

    @Deprecated
    public void completeGridBagLayout() {
        this.layoutHelper.completeLayout();
    }

    public String getSummaryBody() {
        return null;
    }

    public String getSummaryCaption() {
        String caption = this.parent.isHeading(this) && this.idata.guiPrefs.modifier.containsKey("useHeadingForSummary") && this.idata.guiPrefs.modifier.get("useHeadingForSummary").equalsIgnoreCase("yes") ? this.getI18nStringForClass(HEADLINE, this.getClass().getName()) : this.getI18nStringForClass("summaryCaption", this.getClass().getName());
        return caption;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public LayoutHelper getLayoutHelper() {
        return this.layoutHelper;
    }

    public Panel getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Panel p2) {
        this.metadata = p2;
    }

    public DataValidator getValidationService() {
        return this.validationService;
    }

    public void setValidationService(DataValidator validationService) {
        this.validationService = validationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validatePanel() {
        boolean returnValue = false;
        if (this.validationService == null) return true;
        Container guiComponent = this.getTopLevelAncestor();
        Cursor originalCursor = guiComponent.getCursor();
        Cursor newCursor = Cursor.getPredefinedCursor(3);
        try {
            guiComponent.setCursor(newCursor);
            DataValidator.Status returnStatus = this.validationService.validateData(this.idata);
            if (returnStatus == DataValidator.Status.OK) {
                returnValue = true;
                return returnValue;
            } else {
                Debug.trace("Validation did not pass!");
                VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                if (this.validationService.getWarningMessageId() != null && returnStatus == DataValidator.Status.WARNING) {
                    String warningMessage = this.parent.langpack.getString(this.validationService.getWarningMessageId());
                    if (this.askQuestion(this.getString("data.validation.warning.title"), vs.substitute(warningMessage, null), 37) != 47) return returnValue;
                    returnValue = true;
                    Debug.trace("... but user decided to go on!");
                    return returnValue;
                } else {
                    String errorMessage = this.parent.langpack.getString(this.validationService.getErrorMessageId());
                    this.emitError(this.getString("data.validation.error.title"), vs.substitute(errorMessage, null));
                }
            }
            return returnValue;
        }
        finally {
            guiComponent.setCursor(originalCursor);
        }
    }

    protected String parseText(String string_to_parse) {
        try {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            string_to_parse = vs.substitute(string_to_parse, null);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return string_to_parse;
    }

    public void setHelps(HashMap helps) {
        this.helps = helps;
    }

    public String getHelpUrl(String isoCode) {
        String url = null;
        if (this.helps != null) {
            url = this.helps.get(isoCode);
        }
        return url;
    }

    public boolean canShowHelp() {
        return this.getHelpUrl(this.idata.localeISO3) != null;
    }

    public void showHelp() {
        String helpName = this.getHelpUrl(this.idata.localeISO3);
        if (helpName != null) {
            URL helpUrl = this.getClass().getResource("/res/" + helpName);
            this.getHelpWindow().showHelp(this.getString("installer.help"), helpUrl);
        }
    }

    private HelpWindow getHelpWindow() {
        if (this.helpWindow != null) {
            return this.helpWindow;
        }
        this.helpWindow = new HelpWindow(this.parent, this.getString("installer.prev"));
        return this.helpWindow;
    }

    public void addPreActivationAction(PanelAction preActivateAction) {
        if (this.preActivateActions == null) {
            this.preActivateActions = new ArrayList<PanelAction>();
        }
        this.preActivateActions.add(preActivateAction);
    }

    public void addPreValidationAction(PanelAction preValidateAction) {
        if (this.preValidateActions == null) {
            this.preValidateActions = new ArrayList<PanelAction>();
        }
        this.preValidateActions.add(preValidateAction);
    }

    public void addPostValidationAction(PanelAction postValidateAction) {
        if (this.postValidateActions == null) {
            this.postValidateActions = new ArrayList<PanelAction>();
        }
        this.postValidateActions.add(postValidateAction);
    }

    protected final void executePreActivationActions() {
        if (this.preActivateActions != null) {
            for (int actionIndex = 0; actionIndex < this.preActivateActions.size(); ++actionIndex) {
                this.preActivateActions.get(actionIndex).executeAction(this.idata, this);
            }
        }
    }

    protected final void executePreValidationActions() {
        if (this.preValidateActions != null) {
            for (int actionIndex = 0; actionIndex < this.preValidateActions.size(); ++actionIndex) {
                this.preValidateActions.get(actionIndex).executeAction(this.idata, this);
            }
        }
    }

    protected final void executePostValidationActions() {
        if (this.postValidateActions != null) {
            for (int actionIndex = 0; actionIndex < this.postValidateActions.size(); ++actionIndex) {
                this.postValidateActions.get(actionIndex).executeAction(this.idata, this);
            }
        }
    }

    public static class Filler
    extends JComponent {
        private static final long serialVersionUID = 3258416144414095153L;
    }
}

