/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.DownloadPanel;
import com.izforge.izpack.installer.WebAccessor;
import java.io.IOException;
import java.io.InputStream;

public class LoggedInputStream
extends InputStream {
    private long bytesRead = 0L;
    private InputStream is;
    private DownloadPanel downloader;
    private boolean cancelled = false;
    private long lastTime = -1L;
    private long lastBytes = -1L;

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public LoggedInputStream(InputStream is, WebAccessor webAccessor) {
        if (is == null) {
            throw new RuntimeException("Unable to connect");
        }
        this.is = is;
        String sizeStr = webAccessor.getContentLength() > 0 ? "(" + Pack.toByteUnitsString(webAccessor.getContentLength()) + ")" : "";
        this.downloader = new DownloadPanel(this);
        this.downloader.setTitle("Downloading");
        this.downloader.setFileLabel(webAccessor.getUrl() + " " + sizeStr);
        this.downloader.setLocationRelativeTo(null);
        this.downloader.setVisible(true);
        if (webAccessor.getContentLength() > 0) {
            this.downloader.setProgressMax(webAccessor.getContentLength());
            this.downloader.setProgressCurrent(0);
        }
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void close() throws IOException {
        this.downloader.setVisible(false);
        this.downloader.dispose();
        this.is.close();
    }

    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    public long skip(long n2) throws IOException {
        return this.is.skip(n2);
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int bytes = this.is.read(b2, off, len);
        if (bytes > 0) {
            this.bytesRead += (long)bytes;
        }
        this.update();
        return bytes;
    }

    public int read(byte[] b2) throws IOException {
        int bytes = this.is.read(b2);
        if (bytes > 0) {
            this.bytesRead += (long)bytes;
        }
        this.update();
        return bytes;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public int read() throws IOException {
        int bytes = this.is.read();
        if (bytes > 0) {
            ++this.bytesRead;
        }
        this.update();
        return bytes;
    }

    private void update() {
        if (this.lastTime > 0L) {
            long currTime = System.currentTimeMillis();
            long diff = currTime - this.lastTime;
            if (diff > 800L) {
                double bps = (double)(this.bytesRead - this.lastBytes) / ((double)diff / 1000.0);
                this.downloader.setStatusLabel(Pack.toByteUnitsString(Math.round(bps)) + "/s");
                this.lastTime = currTime;
                this.lastBytes = this.bytesRead;
            }
        } else {
            this.lastTime = System.currentTimeMillis();
            this.lastBytes = this.bytesRead;
        }
        this.downloader.setProgressCurrent((int)this.bytesRead);
        if (this.cancelled) {
            throw new RuntimeException("Cancelled");
        }
    }
}

