/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.installer.Installer;
import com.izforge.izpack.installer.ProgressDialog;
import com.izforge.izpack.uninstaller.SelfModifier;
import com.izforge.izpack.util.Debug;
import java.awt.HeadlessException;
import java.io.File;
import java.lang.reflect.Method;

public class MultiVolumeInstaller {
    protected static String mediadirectory;

    public static void main(String[] args) {
        ProgressDialog progressDialog = null;
        try {
            progressDialog = new ProgressDialog();
            progressDialog.startProgress();
        }
        catch (HeadlessException ex2) {
            Debug.log("Progress will not be shown. No display found.");
        }
        MultiVolumeInstaller.setMediadirectory(new File(".").getParent());
        if (args.length > 0 && "-direct".equals(args[0])) {
            String[] newargs;
            if (args.length > 1) {
                newargs = new String[args.length - 1];
                System.arraycopy(args, 1, newargs, 0, args.length - 1);
            } else {
                newargs = new String[]{};
            }
            MultiVolumeInstaller.install(newargs);
        } else {
            try {
                long maxmem = Runtime.getRuntime().maxMemory() / 0x100000L;
                Debug.trace("Currently using maximum memory of " + maxmem + "m");
                long maxpermgensize = maxmem / 4L;
                Class<MultiVolumeInstaller> clazz = MultiVolumeInstaller.class;
                Method target = clazz.getMethod("install", String[].class);
                String[] newargs = new String[args.length + 2];
                System.arraycopy(args, 0, newargs, 2, args.length);
                newargs[0] = "-mediadir";
                newargs[1] = SelfModifier.findJarFile(clazz).getParent();
                System.out.println("Setting mediadir: " + newargs[1]);
                MultiVolumeInstaller.setMediadirectory(newargs[1]);
                new SelfModifier(target, maxmem, maxpermgensize).invoke(newargs);
            }
            catch (Exception e2) {
                Debug.trace(e2);
            }
        }
        if (progressDialog != null) {
            progressDialog.stopProgress();
        }
    }

    public static String getMediadirectory() {
        return mediadirectory;
    }

    public static void setMediadirectory(String mediadirectory) {
        MultiVolumeInstaller.mediadirectory = mediadirectory;
    }

    public static void install(String[] args) {
        if (args.length >= 2 && "-mediadir".equals(args[0])) {
            MultiVolumeInstaller.setMediadirectory(args[1]);
            if (args.length > 2) {
                String[] newargs = new String[args.length - 2];
                System.arraycopy(args, 2, newargs, 0, args.length - 2);
                args = newargs;
            } else {
                args = new String[]{};
            }
        }
        Installer.main(args);
    }
}

