/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class NavigationBar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    private JButton previous;
    private JButton next;
    private ActionListener acl;
    private JButton close;

    public NavigationBar(ActionListener acl) {
        this.acl = acl;
        this.init();
    }

    private void init() {
        this.setOpaque(false);
        this.setBorderPainted(false);
        this.setRollover(true);
        ResourceManager rm = ResourceManager.getInstance();
        try {
            this.previous = new JButton(rm.getImageIconResource("com/inet/setup/help/images/backward.gif"));
            this.previous.setActionCommand("previous");
            this.previous.addActionListener(this.acl);
            this.previous.setBorderPainted(false);
            this.previous.setRolloverEnabled(true);
            this.previous.setToolTipText("Backward (Alt + <-)");
            this.add(this.previous);
            this.next = new JButton(rm.getImageIconResource("com/inet/setup/help/images/forward.gif"));
            this.next.setActionCommand("next");
            this.next.addActionListener(this.acl);
            this.next.setBorderPainted(false);
            this.next.setRolloverEnabled(true);
            this.next.setToolTipText("Forward (Alt + ->)");
            this.add(this.next);
            this.close = new JButton(rm.getImageIconResource("com/inet/setup/help/images/close.png"));
            this.close.setActionCommand("close");
            this.close.addActionListener(this.acl);
            this.close.setBorderPainted(false);
            this.close.setRolloverEnabled(true);
        }
        catch (IOException ioe) {
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
        this.addKeys();
    }

    private void addKeys() {
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(37, 512), "previous");
        inputMap.put(KeyStroke.getKeyStroke(39, 512), "next");
        inputMap.put(KeyStroke.getKeyStroke(115, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "close");
        actionMap.put("previous", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e2) {
                if (NavigationBar.this.previous.isEnabled()) {
                    NavigationBar.this.previous.doClick();
                }
            }
        });
        actionMap.put("next", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e2) {
                if (NavigationBar.this.next.isEnabled()) {
                    NavigationBar.this.next.doClick();
                }
            }
        });
        actionMap.put("close", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e2) {
                if (NavigationBar.this.close.isEnabled()) {
                    NavigationBar.this.close.doClick();
                }
            }
        });
    }

    public void updateNavigationBar(boolean hasPreviousEntries, boolean hasNextEntries) {
        if (this.previous != null) {
            this.previous.setEnabled(hasPreviousEntries);
        }
        if (this.next != null) {
            this.next.setEnabled(hasNextEntries);
        }
    }
}

