/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.ButtonConfig;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessPanelWorker
implements Runnable {
    private static final String SPEC_RESOURCE_NAME = "shared/ProcessPanel.Spec.xml";
    private VariableSubstitutor vs;
    private AbstractUIProcessHandler handler;
    private ArrayList<ProcessingJob> jobs = new ArrayList();
    private boolean result = true;
    private String useLogFile = null;
    private AutomatedInstallData idata;
    private Map<Boolean, List<ButtonConfig>> buttonConfigs = new Hashtable<Boolean, List<ButtonConfig>>();

    public ProcessPanelWorker(AutomatedInstallData idata, AbstractUIProcessHandler handler) throws IOException {
        this.handler = handler;
        this.idata = idata;
        this.vs = new VariableSubstitutor(idata.getVariables());
    }

    public AutomatedInstallData getIdata() {
        return this.idata;
    }

    public boolean readSpec() throws IOException {
        String conditionid;
        IXMLElement spec;
        InputStream input;
        try {
            input = ResourceManager.getInstance().getInputStream(SPEC_RESOURCE_NAME);
        }
        catch (Exception e2) {
            Debug.error(e2);
            return false;
        }
        XMLParser parser = new XMLParser();
        try {
            spec = parser.parse(input);
        }
        catch (Exception e3) {
            Debug.error(this.idata.langpack.getString("ProcessPanelWorker.error.parsing.xml"));
            Debug.error(e3);
            return false;
        }
        if (!spec.hasChildren()) {
            return false;
        }
        IXMLElement lfd = spec.getFirstChildNamed("uselog");
        if (lfd != null) {
            this.useLogFile = lfd.getContent();
        }
        for (IXMLElement job_el : spec.getChildrenNamed("job")) {
            String arg_val;
            ArrayList<String> args;
            String ef_name;
            List<OsConstraint> constraints;
            String string = job_el.hasAttribute("condition") ? job_el.getAttribute("condition") : (conditionid = job_el.hasAttribute("conditionid") ? job_el.getAttribute("conditionid") : null);
            if (conditionid != null && conditionid.length() > 0) {
                Debug.trace(this.idata.langpack.getString("ProcessPanelWorker.condition.for.job") + " : " + job_el.getAttribute("name", ""));
                Condition cond = RulesEngine.getCondition(conditionid);
                if (cond != null && !cond.isTrue()) {
                    Debug.trace(this.idata.langpack.getString("ProcessPanelWorker.condition.not.fulfilled") + " : " + job_el.getAttribute("name", ""));
                    continue;
                }
            }
            Debug.trace(this.idata.langpack.getString("ProcessPanelWorker.condition.fulfilled") + " : " + job_el.getAttribute("name", ""));
            Vector<IXMLElement> forPacks = job_el.getChildrenNamed("executeForPack");
            if (!this.jobRequiredFor(forPacks) || !OsConstraint.oneMatchesCurrentSystem(constraints = OsConstraint.getOsList(job_el))) continue;
            ArrayList<Processable> ef_list = new ArrayList<Processable>();
            String jobName = job_el.getAttribute("name", "");
            for (IXMLElement ef2 : job_el.getChildrenNamed("executefile")) {
                ef_name = ef2.getAttribute("name");
                if (ef_name == null || ef_name.length() == 0) {
                    Debug.error(this.idata.langpack.getString("ProcessPanelWorker.missing.name"));
                    return false;
                }
                args = new ArrayList<String>();
                for (IXMLElement arg_el : ef2.getChildrenNamed("arg")) {
                    arg_val = arg_el.getContent();
                    args.add(arg_val);
                }
                ArrayList<String> envvars = new ArrayList<String>();
                for (IXMLElement env_el : ef2.getChildrenNamed("env")) {
                    String env_val = env_el.getContent();
                    envvars.add(env_val);
                }
                ef_list.add(new ExecutableFile(ef_name, args, envvars, jobName));
            }
            for (IXMLElement ef2 : job_el.getChildrenNamed("executeclass")) {
                ef_name = ef2.getAttribute("name");
                if (ef_name == null || ef_name.length() == 0) {
                    Debug.error(this.idata.langpack.getString("ProcessPanelWorker.missing.name"));
                    return false;
                }
                args = new ArrayList();
                for (IXMLElement arg_el : ef2.getChildrenNamed("arg")) {
                    arg_val = arg_el.getContent();
                    args.add(arg_val);
                }
                ef_list.add(new ExecutableClass(ef_name, args));
            }
            this.jobs.add(new ProcessingJob(jobName, ef_list));
        }
        this.buttonConfigs.put(Boolean.FALSE, new ArrayList());
        this.buttonConfigs.put(Boolean.TRUE, new ArrayList());
        for (IXMLElement ef3 : spec.getChildrenNamed("onFail")) {
            conditionid = ef3.hasAttribute("condition") ? ef3.getAttribute("condition") : (ef3.hasAttribute("conditionid") ? ef3.getAttribute("conditionid") : null);
            boolean unlockPrev = ef3.hasAttribute("previous") ? Boolean.parseBoolean(ef3.getAttribute("previous")) : false;
            boolean unlockNext = ef3.hasAttribute("next") ? Boolean.parseBoolean(ef3.getAttribute("next")) : false;
            this.buttonConfigs.get(Boolean.FALSE).add(new ButtonConfig(conditionid, unlockPrev, unlockNext));
        }
        for (IXMLElement ef3 : spec.getChildrenNamed("onSuccess")) {
            conditionid = ef3.hasAttribute("condition") ? ef3.getAttribute("condition") : (ef3.hasAttribute("conditionid") ? ef3.getAttribute("conditionid") : null);
            boolean unlockPrev = ef3.hasAttribute("previous") ? Boolean.parseBoolean(ef3.getAttribute("previous")) : false;
            this.buttonConfigs.get(Boolean.TRUE).add(new ButtonConfig(conditionid, unlockPrev, true));
        }
        return true;
    }

    @Override
    public void run() {
        this.handler.startProcessing(this.jobs.size());
        for (ProcessingJob pj : this.jobs) {
            this.handler.startProcess(pj.name);
            this.result = pj.run(this.handler, this.vs);
            this.handler.finishProcess();
            if (this.result) continue;
            break;
        }
        boolean unlockNext = true;
        boolean unlockPrev = false;
        for (ButtonConfig bc2 : this.buttonConfigs.get(this.result)) {
            String conditionid = bc2.getConditionid();
            if (conditionid != null && conditionid.length() > 0) {
                Debug.trace(this.idata.langpack.getString("ProcessPanelWorker.condition.for.job"));
                Condition cond = RulesEngine.getCondition(conditionid);
                if (cond != null && !cond.isTrue()) {
                    Debug.trace(this.idata.langpack.getString("ProcessPanelWorker.condition.not.fulfilled"));
                    continue;
                }
            }
            unlockNext = bc2.isUnlockNext();
            unlockPrev = bc2.isUnlockPrev();
            break;
        }
        this.handler.finishProcessing(unlockPrev, unlockNext);
    }

    public void startThread() {
        Thread processingThread = new Thread((Runnable)this, this.idata.langpack.getString("ProcessPanelWorker.processing.thread"));
        processingThread.start();
    }

    public boolean getResult() {
        return this.result;
    }

    public ArrayList<ProcessingJob> getJobs() {
        return this.jobs;
    }

    private boolean jobRequiredFor(Vector<IXMLElement> packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i2 = 0; i2 < this.idata.getSelectedPacks().size(); ++i2) {
            String selected = this.idata.getSelectedPacks().get((int)i2).name;
            for (int k2 = 0; k2 < packs.size(); ++k2) {
                String required = packs.elementAt(k2).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecutableClass
    implements Processable {
        private final String myClassName;
        private final List<String> myArguments;
        private AbstractUIProcessHandler myHandler;

        public ExecutableClass(String className, List<String> args) {
            this.myClassName = className;
            this.myArguments = args;
        }

        @Override
        public boolean run(AbstractUIProcessHandler aHandler, VariableSubstitutor varSubstitutor) {
            boolean result = false;
            this.myHandler = aHandler;
            String[] params = new String[this.myArguments.size()];
            int i2 = 0;
            for (String myArgument : this.myArguments) {
                params[i2++] = varSubstitutor.substitute(myArgument, "plain");
            }
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                Class<?> procClass = loader.loadClass(this.myClassName);
                Object o2 = procClass.newInstance();
                Method m2 = procClass.getMethod("run", AbstractUIProcessHandler.class, String[].class);
                if (m2.getReturnType().getName().equals("boolean")) {
                    result = (Boolean)m2.invoke(o2, this.myHandler, params);
                } else {
                    m2.invoke(o2, this.myHandler, params);
                    result = true;
                }
            }
            catch (SecurityException e2) {
                this.myHandler.emitError(ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.post.processing.error"), ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.security.error") + ": " + this.myClassName);
            }
            catch (ClassNotFoundException e3) {
                this.myHandler.emitError(ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.post.processing.error"), ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.find.error") + ": " + this.myClassName);
            }
            catch (NoSuchMethodException e4) {
                this.myHandler.emitError(ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.post.processing.error"), ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.run.error") + ": " + this.myClassName);
            }
            catch (IllegalAccessException e5) {
                this.myHandler.emitError(ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.post.processing.error"), ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.accessing.error") + ": " + this.myClassName);
            }
            catch (InvocationTargetException e6) {
                Debug.error(e6);
                this.myHandler.emitError(ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.post.processing.error"), ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.invocation.error") + ": " + this.myClassName + ", " + e6.getCause().getMessage());
            }
            catch (Exception e7) {
                this.myHandler.emitError(ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.post.processing.error"), ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.running.error") + ": " + this.myClassName + ", " + e7.getMessage());
            }
            catch (Error e8) {
                this.myHandler.emitError(ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.post.processing.error"), ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.running.error") + ": " + this.myClassName + ", " + e8.getMessage());
            }
            catch (Throwable e9) {
                this.myHandler.emitError(ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.post.processing.error"), ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableClass.running.error") + ": " + this.myClassName + ", " + e9.getMessage());
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecutableFile
    implements Processable {
        private String filename;
        private List<String> arguments;
        private List<String> envvariables;
        private AbstractUIProcessHandler handler;
        private String jobName;

        public ExecutableFile(String fn2, List<String> args, List<String> envvars, String jobName) {
            this.filename = fn2;
            this.arguments = args;
            this.envvariables = envvars;
            this.jobName = jobName;
        }

        @Override
        public boolean run(AbstractUIProcessHandler handler, VariableSubstitutor vs) {
            this.handler = handler;
            ArrayList<String> params = new ArrayList<String>(this.arguments.size() + 1);
            params.add(vs.substitute(this.filename, "plain"));
            for (String argument : this.arguments) {
                params.add(vs.substitute(argument, "plain"));
            }
            ProcessBuilder pb = new ProcessBuilder(params);
            Map<String, String> environment = pb.environment();
            for (String envvar : this.envvariables) {
                String ev2 = vs.substitute(envvar, "plain");
                int i2 = ev2.indexOf("=");
                if (i2 <= 0) continue;
                environment.put(ev2.substring(0, i2), ev2.substring(i2 + 1));
            }
            try {
                Process p2 = pb.start();
                OutputMonitor stdoutMon = new OutputMonitor(this.handler, p2.getInputStream(), false);
                OutputMonitor stderrMon = new OutputMonitor(this.handler, p2.getErrorStream(), true);
                Thread stdoutThread = new Thread(stdoutMon);
                Thread stderrThread = new Thread(stderrMon);
                stdoutThread.setDaemon(true);
                stderrThread.setDaemon(true);
                stdoutThread.start();
                stderrThread.start();
                try {
                    int exitStatus = p2.waitFor();
                    this.stopMonitor(stdoutMon, stdoutThread);
                    this.stopMonitor(stderrMon, stderrThread);
                    if (exitStatus != 0) {
                        this.setNotSuccessfull(this.jobName, new Exception(stderrMon.getText()));
                        this.handler.emitError(ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableFile.process.execution.failed"), ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableFile.continue.anyway") + "\n\n" + this.jobName + "\n\n" + stderrMon.getText());
                        return false;
                    }
                }
                catch (InterruptedException ie) {
                    p2.destroy();
                    this.setNotSuccessfull(this.jobName, ie);
                    this.handler.emitError(ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableFile.process.interrupted"), ie.toString());
                    return false;
                }
            }
            catch (IOException ioe) {
                this.setNotSuccessfull(this.jobName, ioe);
                this.handler.emitError(ProcessPanelWorker.this.getIdata().langpack.getString("ProcessPanelWorker.ExecutableFile.io.error"), ioe.toString());
                return false;
            }
            return true;
        }

        private void setNotSuccessfull(String job, Exception e2) {
            ((ProcessPanelWorker)ProcessPanelWorker.this).idata.installSuccess = false;
            ProcessPanelWorker.this.idata.addNotSuccessfullInstalled(job, null);
        }

        private void stopMonitor(OutputMonitor m2, Thread t2) {
            m2.doStop();
            long softTimeout = 500L;
            try {
                t2.join(softTimeout);
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
            if (!t2.isAlive()) {
                return;
            }
            t2.interrupt();
            long hardTimeout = 500L;
            try {
                t2.join(hardTimeout);
            }
            catch (InterruptedException e3) {
                // empty catch block
            }
        }

        public class OutputMonitor
        implements Runnable {
            private boolean stderr = false;
            private AbstractUIProcessHandler handler;
            private BufferedReader reader;
            private Boolean stop = false;
            private StringBuilder output = new StringBuilder();

            public OutputMonitor(AbstractUIProcessHandler handler, InputStream is, boolean stderr) {
                this.stderr = stderr;
                this.reader = new BufferedReader(new InputStreamReader(is));
                this.handler = handler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    String line;
                    while ((line = this.reader.readLine()) != null) {
                        this.handler.logOutput(line, this.stderr);
                        this.output.append(line).append("\n");
                        Debug.log(line);
                        Boolean bl2 = this.stop;
                        synchronized (bl2) {
                            if (this.stop.booleanValue()) {
                                return;
                            }
                        }
                    }
                    return;
                }
                catch (IOException ioe) {
                    this.handler.logOutput(ioe.toString(), true);
                    Debug.error(ioe);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doStop() {
                Boolean bl2 = this.stop;
                synchronized (bl2) {
                    this.stop = true;
                }
            }

            public String getText() {
                return this.output.toString();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessingJob
    implements Processable {
        private String name;
        private List<Processable> processables;

        public ProcessingJob(String name, List<Processable> processables) {
            this.name = name;
            this.processables = processables;
        }

        @Override
        public boolean run(AbstractUIProcessHandler handler, VariableSubstitutor vs) {
            for (Processable pr : this.processables) {
                if (pr.run(handler, vs)) continue;
                return false;
            }
            return true;
        }
    }

    static interface Processable {
        public boolean run(AbstractUIProcessHandler var1, VariableSubstitutor var2);
    }
}

