/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.JOptionPaneWithCheckbox;
import com.izforge.izpack.installer.ScriptParser;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.UnpackerBase;
import com.izforge.izpack.installer.WebAccessor;
import com.izforge.izpack.installer.WebRepositoryAccessor;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraint;
import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JCheckBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unpacker
extends UnpackerBase {
    private static final String tempSubPath = "/IzpackWebTemp";
    private Pack200.Unpacker unpacker;
    private JCheckBox rememberbox = null;
    private boolean remembervalue = false;

    public Unpacker(AutomatedInstallData idata, AbstractUIProgressHandler handler) {
        super(idata, handler);
        this.rememberbox = new JCheckBox(idata.langpack.getString("InstallPanel.overwrite.checkbox"));
        this.rememberbox.setSelected(false);
    }

    @Override
    public void run() {
        this.addToInstances();
        FileOutputStream out = null;
        ArrayList<ParsableFile> parsables = new ArrayList<ParsableFile>();
        ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
        ArrayList<UpdateCheck> updatechecks = new ArrayList<UpdateCheck>();
        List<Pack> listOfPacks = this.idata.getSelectedPacks();
        int numberOfPacks = listOfPacks.size();
        this.handler.startAction("Unpacking", numberOfPacks);
        this.udata = UninstallData.getInstance();
        List[] customActions = this.getCustomActions();
        try {
            this.informListeners(customActions, 7, this.idata, numberOfPacks, this.handler);
        }
        catch (Exception e2) {
            this.setInstallationFalse("Setup - Inform Listener", e2);
        }
        listOfPacks = this.idata.getSelectedPacks();
        numberOfPacks = listOfPacks.size();
        for (int i2 = 0; i2 < numberOfPacks; ++i2) {
            Pack currentPack = listOfPacks.get(i2);
            try {
                String name;
                if (this.checkFullfilledConditions(currentPack)) continue;
                this.informListeners(customActions, 5, listOfPacks.get(i2), numberOfPacks, this.handler);
                ObjectInputStream objIn = new ObjectInputStream(this.getPackAsStream(currentPack.id, currentPack.uninstall));
                int numberOfFiles = objIn.readInt();
                String stepname = currentPack.name;
                if (currentPack.isHidden()) {
                    stepname = "";
                } else if (this.langpack != null && currentPack.id != null && !"".equals(currentPack.id) && (name = this.langpack.getString(currentPack.id)) != null && !"".equals(name)) {
                    stepname = name;
                }
                this.handler.nextStep(stepname, i2 + 1, numberOfFiles);
                for (int j2 = 0; j2 < numberOfFiles; ++j2) {
                    PackFile pf = null;
                    try {
                        pf = (PackFile)objIn.readObject();
                    }
                    catch (Throwable t2) {
                        continue;
                    }
                    if (pf.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pf.getCondition())) {
                        if (pf.isBackReference()) continue;
                        objIn.skip(pf.length());
                        continue;
                    }
                    if (OsConstraint.oneMatchesCurrentSystem(pf.osConstraints())) {
                        File pathFile;
                        String path = IoHelper.translatePath(pf.getTargetPath(), this.vs);
                        File dest = pathFile = new File(path);
                        if (!pf.isDirectory()) {
                            dest = pathFile.getParentFile();
                        }
                        if (!dest.exists()) {
                            List fileListeners = customActions[customActions.length - 1];
                            if (fileListeners != null && fileListeners.size() > 0) {
                                this.mkDirsWithEnhancement(dest, pf, customActions);
                            } else if (!dest.mkdirs()) {
                                if (GraphicsEnvironment.isHeadless()) {
                                    Debug.error(new String(this.idata.langpack.getString("Unpacker.error.create.dir") + "\n" + dest.getPath()));
                                } else {
                                    this.handler.emitError(this.idata.langpack.getString("Unpacker.error.create.dir.header"), this.idata.langpack.getString("Unpacker.error.create.dir") + "\n" + dest.getPath());
                                }
                                this.handler.stopAction();
                                this.result = false;
                                return;
                            }
                        }
                        if (pf.isDirectory()) continue;
                        this.informListeners(customActions, 1, pathFile, pf, null);
                        this.udata.addFile(path, currentPack.uninstall);
                        this.handler.progress(j2, path);
                        if (pathFile.exists() && pf.override() != 1) {
                            boolean overwritefile = false;
                            if (!(overwritefile = this.checkOverride(pf, pathFile, overwritefile))) {
                                if (pf.isBackReference() || listOfPacks.get((int)i2).loose) continue;
                                if (pf.isPack200Jar()) {
                                    objIn.skip(4L);
                                    continue;
                                }
                                objIn.skip(pf.length());
                                continue;
                            }
                        }
                        InputStream pis = objIn;
                        if (pf.isBackReference()) {
                            InputStream is = this.getPackAsStream(pf.previousPackId, currentPack.uninstall);
                            pis = new ObjectInputStream(is);
                            is.skip(pf.offsetInPreviousPack - 4L);
                        } else if (listOfPacks.get((int)i2).loose) {
                            File resolvedFile = new File(this.getAbsolutInstallSource(), pf.getRelativeSourcePath());
                            if (!resolvedFile.exists()) {
                                File userDir = new File(System.getProperty("user.dir"));
                                resolvedFile = new File(userDir, pf.getRelativeSourcePath());
                            }
                            if (resolvedFile.exists()) {
                                pis = new FileInputStream(resolvedFile);
                                pf = new PackFile(resolvedFile.getParentFile(), resolvedFile, pf.getTargetPath(), pf.osConstraints(), pf.override(), pf.getAdditionals());
                            } else {
                                Debug.log(this.idata.langpack.getString("Unpacker.no.loosely.bundle") + ": " + pf.getRelativeSourcePath());
                                if (GraphicsEnvironment.isHeadless() || this.handler.askQuestion(this.idata.langpack.getString("Unpacker.file.not.found"), this.idata.langpack.getString("Unpacker.no.loosely.bundle") + ": " + pf.getRelativeSourcePath(), 37) == 47) continue;
                                throw new InstallerException(this.idata.langpack.getString("Unpacker.installation.canelled"));
                            }
                        }
                        out = this.copyFile(out, objIn, pf, pathFile, pis);
                        if (pis != objIn) {
                            ((InputStream)pis).close();
                        }
                        if (pf.lastModified() >= 0L) {
                            pathFile.setLastModified(pf.lastModified());
                        }
                        this.informListeners(customActions, 2, pathFile, pf, null);
                        continue;
                    }
                    if (pf.isBackReference()) continue;
                    objIn.skip(pf.length());
                }
                this.loadParsableFiles(parsables, objIn);
                this.loadExecutableFiles(executables, objIn);
                this.handleAdditionalUninstallData(this.udata, customActions);
                int numUpdateChecks = objIn.readInt();
                for (int k2 = 0; k2 < numUpdateChecks; ++k2) {
                    UpdateCheck uc = (UpdateCheck)objIn.readObject();
                    updatechecks.add(uc);
                }
                objIn.close();
                if (this.performInterrupted()) {
                    return;
                }
                this.informListeners(customActions, 6, listOfPacks.get(i2), i2, this.handler);
                continue;
            }
            catch (FileNotFoundException fnfe) {
                this.setInstallationFalse(currentPack, fnfe);
                continue;
            }
            catch (InstallerException ie) {
                this.setInstallationFalse(currentPack, ie);
                continue;
            }
            catch (IOException ioe) {
                this.setInstallationFalse(currentPack, ioe);
                continue;
            }
            catch (Exception e3) {
                this.setInstallationFalse(currentPack, e3);
            }
        }
        ScriptParser parser = new ScriptParser(parsables, this.vs);
        try {
            parser.parseFiles();
        }
        catch (Exception e4) {
            this.setInstallationFalse("Setup - FileParser", e4);
        }
        if (this.performInterrupted()) {
            return;
        }
        FileExecutor executor = new FileExecutor(executables);
        if (executor.executeFiles(0, this.handler) != 0) {
            if (GraphicsEnvironment.isHeadless()) {
                Debug.error(new String(this.idata.langpack.getString("Unpacker.file.execution.failed") + "! \n" + this.idata.langpack.getString("Unpacker.installation.not.completed")));
            } else {
                this.handler.emitError(this.idata.langpack.getString("Unpacker.file.execution.failed"), this.idata.langpack.getString("Unpacker.installation.not.completed"));
            }
            this.result = false;
        }
        if (this.performInterrupted()) {
            return;
        }
        this.readFromUninstaller(this.idata.getInstallPath());
        try {
            this.putUninstaller();
        }
        catch (Exception e5) {
            this.setInstallationFalse("Setup - Put Uninstaller", e5);
        }
        this.performUpdateChecks(updatechecks);
        if (this.performInterrupted()) {
            return;
        }
        try {
            this.informListeners(customActions, 8, this.idata, this.handler, null);
        }
        catch (Exception e6) {
            this.setInstallationFalse("Setup - Inform Listener", e6);
        }
        if (this.performInterrupted()) {
            return;
        }
        try {
            this.writeInstallationInformation();
        }
        catch (IOException ioe) {
            this.setInstallationFalse("Setup - Write Installation Information", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            this.setInstallationFalse("Setup - Write Installation Information", cnfe);
        }
        this.handler.stopAction();
        this.removeFromInstances();
    }

    private void setInstallationFalse(Object notSuccessfullInstalled, Exception e2) {
        this.result = false;
        this.idata.installSuccess = false;
        if (notSuccessfullInstalled != null) {
            this.idata.addNotSuccessfullInstalled(notSuccessfullInstalled, e2);
            if (notSuccessfullInstalled instanceof Pack) {
                Pack notSuccessfullInstalledPack = (Pack)notSuccessfullInstalled;
                Debug.log("[UNPACKER ERROR] " + notSuccessfullInstalledPack.name);
            } else {
                Debug.log("[UNPACKER ERROR] " + notSuccessfullInstalled.toString());
            }
        }
        Debug.error(e2);
    }

    private boolean checkFullfilledConditions(Pack currentPack) {
        return currentPack.hasCondition() && this.rules != null && !this.rules.isConditionTrue(currentPack.getCondition());
    }

    private boolean checkOverride(PackFile pf, File pathFile, boolean overwritefile) {
        if (pf.override() != 0) {
            if (pf.override() == 1) {
                overwritefile = true;
            } else if (pf.override() == 4) {
                overwritefile = pathFile.lastModified() < pf.lastModified();
            } else {
                int def_choice = -1;
                if (GraphicsEnvironment.isHeadless()) {
                    overwritefile = true;
                } else {
                    if (pf.override() == 2) {
                        def_choice = 49;
                    }
                    if (pf.override() == 3) {
                        def_choice = 47;
                    }
                    if (!this.rememberbox.isSelected()) {
                        int answer = JOptionPaneWithCheckbox.showOptionDialog(InstallerFrame.getInstance(), this.rememberbox, this.idata.langpack.getString("InstallPanel.overwrite.title") + " - " + pathFile.getName(), this.idata.langpack.getString("InstallPanel.overwrite.question", new String[]{pathFile.getAbsolutePath()}), 37, def_choice, this.idata);
                        this.remembervalue = overwritefile = answer == 0;
                    } else {
                        return this.remembervalue;
                    }
                }
            }
        }
        return overwritefile;
    }

    private void loadExecutableFiles(ArrayList<ExecutableFile> executables, ObjectInputStream objIn) {
        int numExecutables = 0;
        try {
            numExecutables = objIn.readInt();
        }
        catch (Exception e2) {
            Debug.error(e2);
            return;
        }
        for (int k2 = 0; k2 < numExecutables; ++k2) {
            ExecutableFile ef2 = null;
            try {
                ef2 = (ExecutableFile)objIn.readObject();
                if (ef2.hasCondition() && this.rules != null && !this.rules.isConditionTrue(ef2.getCondition())) continue;
                ef2.path = IoHelper.translatePath(ef2.path, this.vs);
                if (null != ef2.argList && !ef2.argList.isEmpty()) {
                    String arg = null;
                    for (int j2 = 0; j2 < ef2.argList.size(); ++j2) {
                        arg = ef2.argList.get(j2);
                        arg = IoHelper.translatePath(arg, this.vs);
                        ef2.argList.set(j2, arg);
                    }
                }
                executables.add(ef2);
                if (ef2.executionStage != 2) continue;
                this.udata.addExecutable(ef2);
                continue;
            }
            catch (Exception e3) {
                Debug.error(e3);
                this.idata.addNotSuccessfullInstalled("Setup - Executable " + ef2.path + " " + ef2.argList, e3);
            }
        }
    }

    private void loadParsableFiles(ArrayList<ParsableFile> parsables, ObjectInputStream objIn) {
        int numParsables = 0;
        try {
            numParsables = objIn.readInt();
        }
        catch (Exception e2) {
            Debug.error(e2);
            return;
        }
        for (int k2 = 0; k2 < numParsables; ++k2) {
            ParsableFile pf = null;
            try {
                pf = (ParsableFile)objIn.readObject();
                if (pf.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pf.getCondition())) continue;
                pf.path = IoHelper.translatePath(pf.path, this.vs);
                parsables.add(pf);
                continue;
            }
            catch (Exception e3) {
                Debug.error(e3);
                this.idata.addNotSuccessfullInstalled("Setup - Parsable " + pf.path, e3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileOutputStream copyFile(FileOutputStream out, ObjectInputStream objIn, PackFile pf, File pathFile, InputStream pis) throws IOException, FileNotFoundException {
        if (pf.isPack200Jar()) {
            int key = objIn.readInt();
            InputStream pack200Input = Unpacker.class.getResourceAsStream("/packs/pack200-" + key);
            Pack200.Unpacker unpacker = this.getPack200Unpacker();
            JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(pathFile));
            unpacker.unpack(pack200Input, jarOut);
            jarOut.close();
        } else {
            try {
                if (pathFile.exists() && pathFile.canRead() && pathFile.canWrite() || !pathFile.exists()) {
                    out = new FileOutputStream(pathFile);
                    FileLock fl2 = out.getChannel().tryLock();
                    if (fl2 != null) {
                        int bytesInBuffer;
                        byte[] buffer = new byte[32768];
                        for (long bytesCopied = 0L; bytesCopied < pf.length(); bytesCopied += (long)bytesInBuffer) {
                            if (this.performInterrupted()) {
                                out.close();
                                if (pis != objIn) {
                                    pis.close();
                                }
                                FileOutputStream fileOutputStream = null;
                                return fileOutputStream;
                            }
                            int maxBytes = (int)Math.min(pf.length() - bytesCopied, (long)buffer.length);
                            bytesInBuffer = pis.read(buffer, 0, maxBytes);
                            if (bytesInBuffer == -1) {
                                throw new IOException(this.idata.langpack.getString("Unpacker.unexpected.end.of.stream"));
                            }
                            out.write(buffer, 0, bytesInBuffer);
                        }
                        fl2.release();
                    }
                } else {
                    Debug.log(this.idata.langpack.getString("Unpacker.can.not.write") + ": " + pathFile);
                }
            }
            catch (Exception e2) {
                Debug.error(e2.getMessage());
                this.idata.addNotSuccessfullInstalled("Setup - Copy " + pathFile.getName(), e2);
            }
            finally {
                out.close();
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromUninstaller(String installPath) {
        String[] extractionList = new String[]{"install.log", "infos.log", "executables"};
        Hashtable<String, byte[]> nameToData = new Hashtable<String, byte[]>();
        ArrayList uninstallerInfos = new ArrayList();
        File uninstaller = new File(installPath + File.separator + "Uninstaller" + File.separator + "uninstaller.jar");
        if (uninstaller.exists() && uninstaller.canRead()) {
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            ZipInputStream zis = null;
            try {
                fis = new FileInputStream(uninstaller);
                bis = new BufferedInputStream(fis);
            }
            catch (FileNotFoundException e1) {
                // empty catch block
            }
            try {
                ZipEntry entry;
                zis = new ZipInputStream(bis);
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    byte[] buffer = Unpacker.toByteArray(zis, false);
                    nameToData.put(entry.getName(), buffer);
                }
            }
            catch (Exception e2) {
            }
            finally {
                if (zis != null) {
                    try {
                        zis.close();
                    }
                    catch (IOException e3) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e4) {}
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e5) {}
                }
            }
            for (String extractionFileName : extractionList) {
                byte[] data = (byte[])nameToData.get(extractionFileName);
                if (data == null) continue;
                try {
                    File extractionFile = new File(installPath + File.separator + "Uninstaller" + File.separator + extractionFileName);
                    if (extractionFile.canRead() && extractionFile.canWrite()) continue;
                    extractionFile.deleteOnExit();
                    FileOutputStream fos = new FileOutputStream(extractionFile);
                    fos.write(data);
                    fos.close();
                }
                catch (IOException e1) {
                    Debug.error(e1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toByteArray(InputStream is, boolean close) throws IOException {
        if (is == null) {
            return null;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream(is.available());
            byte[] b2 = new byte[16384];
            int count = -1;
            while ((count = is.read(b2)) >= 0) {
                os.write(b2, 0, count);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            if (close) {
                is.close();
            }
        }
    }

    private Pack200.Unpacker getPack200Unpacker() {
        if (this.unpacker == null) {
            this.unpacker = Pack200.newUnpacker();
        }
        return this.unpacker;
    }

    private InputStream getPackAsStream(String packid, boolean uninstall) throws Exception {
        InputStream in = null;
        String webDirURL = this.idata.info.getWebDirURL();
        packid = "-" + packid;
        if (webDirURL == null) {
            in = Unpacker.class.getResourceAsStream("/packs/pack" + packid);
        } else {
            String tempfile;
            String baseName = this.idata.info.getInstallerBase();
            String packURL = webDirURL + "/" + baseName + ".pack" + packid + ".jar";
            String tf = IoHelper.translatePath(this.idata.info.getUninstallerPath() + tempSubPath, this.vs);
            try {
                tempfile = WebRepositoryAccessor.getCachedUrl(packURL, tf);
                this.udata.addFile(tempfile, uninstall);
            }
            catch (Exception e2) {
                if ("Cancelled".equals(e2.getMessage())) {
                    throw new InstallerException(this.idata.langpack.getString("Unpacker.installation.canelled"), e2);
                }
                throw new InstallerException(this.idata.langpack.getString("Unpacker.installation.failed"), e2);
            }
            URL url = new URL("jar:" + tempfile + "!/packs/pack" + packid);
            in = new WebAccessor(null).openInputStream(url);
            if (in == null) {
                throw new InstallerException(url.toString() + " " + this.idata.langpack.getString("Unpacker.not.available"), new FileNotFoundException(url.toString()));
            }
        }
        if (in != null && this.idata.info.getPackDecoderClassName() != null) {
            Class<?> decoder = Class.forName(this.idata.info.getPackDecoderClassName());
            Class[] paramsClasses = new Class[]{Class.forName("java.io.InputStream")};
            Constructor<?> constructor = decoder.getDeclaredConstructor(paramsClasses);
            BufferedInputStream buffer = new BufferedInputStream(in);
            Object[] params = new Object[]{buffer};
            Object instance = null;
            instance = constructor.newInstance(params);
            if (!InputStream.class.isInstance(instance)) {
                throw new InstallerException("'" + this.idata.info.getPackDecoderClassName() + "' " + this.idata.langpack.getString("Unpacker.must.be.derived.from") + InputStream.class.toString());
            }
            in = instance;
        }
        return in;
    }
}

