/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.inet.setup.Constants;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.event.InstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.IUnpacker;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.RESyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnpackerBase
implements IUnpacker {
    protected AutomatedInstallData idata;
    protected AbstractUIProgressHandler handler;
    protected UninstallData udata;
    protected VariableSubstitutor vs;
    protected File absolute_installpath;
    private File absolutInstallSource;
    protected LocaleDatabase langpack = null;
    protected boolean result = true;
    protected static HashMap<Object, String> instances = new HashMap();
    protected static boolean interruptDesired = false;
    protected static boolean discardInterrupt = false;
    public static final String ALIVE = "alive";
    public static final String INTERRUPT = "doInterrupt";
    public static final String INTERRUPTED = "interruppted";
    protected RulesEngine rules;

    public UnpackerBase(AutomatedInstallData idata, AbstractUIProgressHandler handler) {
        this.idata = idata;
        this.handler = handler;
        this.langpack = idata.langpack;
        this.vs = new VariableSubstitutor(idata.getVariables());
    }

    @Override
    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getRunningInstances() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            return (HashMap)instances.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToInstances() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            instances.put(this, ALIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromInstances() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            instances.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInterruptAll() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            for (Object key : instances.keySet()) {
                if (!instances.get(key).equals(ALIVE)) continue;
                instances.put(key, INTERRUPT);
            }
            UnpackerBase.setInterruptDesired(true);
        }
    }

    public static boolean interruptAll(long waitTime) {
        long t0 = System.currentTimeMillis();
        if (UnpackerBase.isDiscardInterrupt()) {
            return false;
        }
        UnpackerBase.setInterruptAll();
        while (!UnpackerBase.isInterruptReady()) {
            if (System.currentTimeMillis() - t0 > waitTime) {
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInterruptReady() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            for (Object key : instances.keySet()) {
                if (instances.get(key).equals(INTERRUPTED)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performInterrupted() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            String doIt = instances.get(this);
            if (doIt != null && (doIt.equals(INTERRUPT) || doIt.equals(INTERRUPTED))) {
                instances.put(this, INTERRUPTED);
                this.result = false;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldInterrupt() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            String doIt = instances.get(this);
            return doIt != null && (doIt.equals(INTERRUPT) || doIt.equals(INTERRUPTED));
            {
            }
        }
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    private boolean fileMatchesOnePattern(String filename, ArrayList<RE> patterns) {
        for (RE pattern : patterns) {
            if (!pattern.match(filename)) continue;
            return true;
        }
        return false;
    }

    private List<RE> preparePatterns(ArrayList<String> list, RECompiler recompiler) {
        ArrayList<RE> result = new ArrayList<RE>();
        for (String element : list) {
            if (element == null || element.length() <= 0) continue;
            File f2 = new File(element = this.vs.substitute(element, "plain"));
            if (!f2.isAbsolute()) {
                element = new File(this.absolute_installpath, element).toString();
            }
            StringBuffer element_re = new StringBuffer();
            int lookahead = -1;
            int pos = 0;
            block8: while (pos < element.length()) {
                char c2;
                if (lookahead != -1) {
                    c2 = (char)lookahead;
                    lookahead = -1;
                } else {
                    c2 = element.charAt(pos++);
                }
                switch (c2) {
                    case '/': {
                        element_re.append(File.separator);
                        continue block8;
                    }
                    case '.': 
                    case '\\': {
                        element_re.append("\\");
                        element_re.append(c2);
                        continue block8;
                    }
                    case '*': {
                        if (pos == element.length()) {
                            element_re.append("[^").append(File.separator).append("]*");
                            continue block8;
                        }
                        if ((lookahead = (int)element.charAt(pos++)) == 42) {
                            element_re.append(".*");
                            lookahead = -1;
                            continue block8;
                        }
                        element_re.append("[^").append(File.separator).append("]*");
                        continue block8;
                    }
                }
                element_re.append(c2);
            }
            element_re.append('$');
            try {
                result.add(new RE(recompiler.compile(element_re.toString())));
            }
            catch (RESyntaxException e2) {
                this.handler.emitNotification(null, "internal error: pattern \"" + element + "\" produced invalid RE \"" + f2.getPath() + "\"");
            }
        }
        return result;
    }

    protected void informListeners(List[] customActions, int action, Object firstParam, Object secondParam, Object thirdParam) throws Exception {
        List listener = null;
        switch (action) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                listener = customActions[customActions.length - 1];
                break;
            }
            default: {
                listener = customActions[0];
            }
        }
        if (listener == null) {
            return;
        }
        Iterator iter = listener.iterator();
        while (iter.hasNext()) {
            if (this.shouldInterrupt()) {
                return;
            }
            InstallerListener il = (InstallerListener)iter.next();
            switch (action) {
                case 1: {
                    il.beforeFile((File)firstParam, (PackFile)secondParam);
                    break;
                }
                case 2: {
                    il.afterFile((File)firstParam, (PackFile)secondParam);
                    break;
                }
                case 3: {
                    il.beforeDir((File)firstParam, (PackFile)secondParam);
                    break;
                }
                case 4: {
                    il.afterDir((File)firstParam, (PackFile)secondParam);
                    break;
                }
                case 5: {
                    il.beforePack((Pack)firstParam, (Integer)secondParam, (AbstractUIProgressHandler)thirdParam);
                    break;
                }
                case 6: {
                    il.afterPack((Pack)firstParam, (Integer)secondParam, (AbstractUIProgressHandler)thirdParam);
                    break;
                }
                case 7: {
                    il.beforePacks((AutomatedInstallData)firstParam, (Integer)secondParam, (AbstractUIProgressHandler)thirdParam);
                    break;
                }
                case 8: {
                    il.afterPacks((AutomatedInstallData)firstParam, (AbstractUIProgressHandler)secondParam);
                }
            }
        }
    }

    protected List[] getCustomActions() {
        int i2;
        String[] listenerNames = AutomatedInstallData.CUSTOM_ACTION_TYPES;
        List[] retval = new List[listenerNames.length + 1];
        for (i2 = 0; i2 < listenerNames.length; ++i2) {
            retval[i2] = this.idata.customData.get(listenerNames[i2]);
            if (retval[i2] != null) continue;
            retval[i2] = new ArrayList();
        }
        if (retval[0].size() > 0) {
            i2 = retval.length - 1;
            retval[i2] = new ArrayList();
            for (InstallerListener li : retval[0]) {
                if (!li.isFileListener()) continue;
                retval[i2].add(li);
            }
        }
        return retval;
    }

    protected boolean mkDirsWithEnhancement(File dest, PackFile pf, List[] customActions) throws Exception {
        String path = "unknown";
        if (dest != null) {
            path = dest.getAbsolutePath();
        }
        if (dest != null && !dest.exists() && dest.getParentFile() != null) {
            if (dest.getParentFile().exists()) {
                this.informListeners(customActions, 3, dest, pf, null);
            }
            if (!dest.mkdir()) {
                this.mkDirsWithEnhancement(dest.getParentFile(), pf, customActions);
                if (!dest.mkdir()) {
                    dest = null;
                }
            }
            this.informListeners(customActions, 4, dest, pf, null);
        }
        if (dest == null) {
            this.handler.emitError("Error creating directories", "Could not create directory\n" + path);
            this.handler.stopAction();
            return false;
        }
        return true;
    }

    public static synchronized boolean isDiscardInterrupt() {
        return discardInterrupt;
    }

    public static synchronized void setDiscardInterrupt(boolean di2) {
        discardInterrupt = di2;
        UnpackerBase.setInterruptDesired(false);
    }

    public static boolean isInterruptDesired() {
        return interruptDesired;
    }

    private static void setInterruptDesired(boolean interruptDesired) {
        UnpackerBase.interruptDesired = interruptDesired;
    }

    protected void putUninstaller() throws Exception {
        InputStream in2;
        ZipOutputStream outJar;
        String uninstallerCondition = this.idata.info.getUninstallerCondition();
        if (uninstallerCondition != null && uninstallerCondition.length() > 0 && !this.rules.isConditionTrue(uninstallerCondition)) {
            Debug.log("Uninstaller has a condition (" + uninstallerCondition + ") which is not fulfilled.");
            Debug.log("Skipping creation of uninstaller.");
            return;
        }
        InputStream[] in = new InputStream[2];
        in[0] = UnpackerBase.class.getResourceAsStream("/res/IzPack.uninstaller");
        if (in[0] == null) {
            return;
        }
        in[1] = UnpackerBase.class.getResourceAsStream("/res/IzPack.uninstaller-ext");
        String dest = IoHelper.translatePath(this.idata.info.getUninstallerPath(), this.vs);
        String jar = dest + File.separator + this.idata.info.getUninstallerName();
        File pathMaker = new File(dest);
        pathMaker.mkdirs();
        this.udata.setUninstallerJarFilename(jar);
        this.udata.setUninstallerPath(dest);
        FileOutputStream out = new FileOutputStream(jar);
        BufferedOutputStream bos = new BufferedOutputStream(out);
        this.idata.uninstallOutJar = outJar = new ZipOutputStream(bos);
        outJar.setLevel(9);
        this.udata.addFile(jar, true);
        HashSet<String> doubles = new HashSet<String>();
        for (InputStream anIn : in) {
            if (anIn == null) continue;
            ZipInputStream inRes = new ZipInputStream(anIn);
            ZipEntry zentry = inRes.getNextEntry();
            while (zentry != null) {
                if (!doubles.contains(zentry.getName())) {
                    doubles.add(zentry.getName());
                    outJar.putNextEntry(new ZipEntry(zentry.getName()));
                    int unc = inRes.read();
                    while (unc != -1) {
                        outJar.write(unc);
                        unc = inRes.read();
                    }
                    inRes.closeEntry();
                    outJar.closeEntry();
                }
                zentry = inRes.getNextEntry();
            }
            inRes.close();
        }
        if (this.idata.info.isPrivilegedExecutionRequiredUninstaller()) {
            outJar.putNextEntry(new ZipEntry("exec-admin"));
            outJar.closeEntry();
        }
        if ((in2 = Unpacker.class.getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".properties")) == null) {
            in2 = Unpacker.class.getResourceAsStream("/res/langpacks/" + this.idata.localeISO3 + ".properties");
        }
        outJar.putNextEntry(new ZipEntry("langpack.properties"));
        int read = in2.read();
        while (read != -1) {
            outJar.write(read);
            read = in2.read();
        }
        outJar.closeEntry();
        ArrayList<String> uninstallerInfosPacks = new ArrayList<String>();
        File f2 = new File(this.idata.getInstallPath() + File.separator + "Uninstaller" + File.separator + "infos.log");
        if (f2.exists() && f2.canRead()) {
            String s2;
            FileReader fr2 = new FileReader(f2);
            BufferedReader br2 = new BufferedReader(fr2);
            while ((s2 = br2.readLine()) != null) {
                if (!s2.startsWith("*")) continue;
                uninstallerInfosPacks.add(s2);
            }
            br2.close();
            fr2.close();
        }
        outJar.putNextEntry(new ZipEntry("infos.log"));
        outJar.write(this.idata.info.getAppVersion().getBytes());
        outJar.write(10);
        String group = "";
        LocaleDatabase lang = this.idata.langpack;
        Collections.sort(this.idata.getSelectedPacks());
        block5: for (String packToShow : Constants.PACKAGES_TO_SHOW) {
            for (Pack pack : this.idata.getSelectedPacks()) {
                if (!pack.id.equalsIgnoreCase(packToShow)) continue;
                String packName = "*" + this.getI18NPackName(pack);
                if (uninstallerInfosPacks.contains(packName)) {
                    uninstallerInfosPacks.remove(packName);
                }
                outJar.write(packName.getBytes());
                outJar.write(10);
                continue block5;
            }
        }
        for (String string : uninstallerInfosPacks) {
            outJar.write(string.getBytes());
            outJar.write(10);
        }
        outJar.closeEntry();
        Debug.addToUninstaller();
    }

    private String getI18NPackName(Pack pack) {
        String packName = pack.name;
        String key = pack.id;
        if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
            packName = this.langpack.getString(key);
        }
        if ("".equals(packName) || key == null || key.equals(packName)) {
            packName = pack.name;
        }
        return packName;
    }

    private boolean isLeaf(String parentname) {
        for (Pack p2 : this.idata.getSelectedPacks()) {
            if (!parentname.equalsIgnoreCase(p2.parent)) continue;
            return p2.parent != null && p2.parent.length() > 0;
        }
        return false;
    }

    protected void handleAdditionalUninstallData(UninstallData udata, List[] customData) {
        udata.addAdditionalData("__uninstallLibs__", customData[2]);
        udata.addAdditionalData("uninstallerListeners", customData[1]);
        udata.addAdditionalData("uninstallerJars", customData[3]);
    }

    @Override
    public abstract void run();

    protected void performUpdateChecks(ArrayList<UpdateCheck> updatechecks) {
        File f2;
        ArrayList<RE> include_patterns = new ArrayList<RE>();
        ArrayList<RE> exclude_patterns = new ArrayList<RE>();
        RECompiler recompiler = new RECompiler();
        this.absolute_installpath = new File(this.idata.getInstallPath()).getAbsoluteFile();
        for (UpdateCheck uc : updatechecks) {
            if (uc.includesList != null) {
                include_patterns.addAll(this.preparePatterns(uc.includesList, recompiler));
            }
            if (uc.excludesList == null) continue;
            exclude_patterns.addAll(this.preparePatterns(uc.excludesList, recompiler));
        }
        if (include_patterns.size() == 0) {
            return;
        }
        TreeSet<String> installed_files = new TreeSet<String>();
        for (String fname : this.udata.getInstalledFilesList()) {
            f2 = new File(fname);
            if (!f2.isAbsolute()) {
                f2 = new File(this.absolute_installpath, fname);
            }
            installed_files.add(f2.getAbsolutePath());
        }
        Stack<File> scanstack = new Stack<File>();
        ArrayList<File> files_to_delete = new ArrayList<File>();
        try {
            scanstack.add(this.absolute_installpath);
            while (!scanstack.empty()) {
                f2 = (File)scanstack.pop();
                File[] files = f2.listFiles();
                if (files == null) {
                    throw new IOException(f2.getPath() + "is not a directory!");
                }
                for (File newf : files) {
                    String newfname = newf.getPath();
                    if (installed_files.contains(newfname)) continue;
                    if (this.fileMatchesOnePattern(newfname, include_patterns) && !this.fileMatchesOnePattern(newfname, exclude_patterns)) {
                        files_to_delete.add(newf);
                    }
                    if (!newf.isDirectory() || this.fileMatchesOnePattern(newfname, exclude_patterns)) continue;
                    scanstack.push(newf);
                }
            }
        }
        catch (IOException e2) {
            this.handler.emitError("error while performing update checks", e2.toString());
        }
        for (File f3 : files_to_delete) {
            if (f3.isDirectory()) continue;
            f3.delete();
        }
    }

    public void writeInstallationInformation() throws IOException, ClassNotFoundException {
        if (!this.idata.info.isWriteInstallationInformation()) {
            Debug.trace("skip writing installation information");
            return;
        }
        Debug.trace("writing installation information");
        String installdir = this.idata.getInstallPath();
        ArrayList<Pack> installedpacks = new ArrayList<Pack>(this.idata.getSelectedPacks());
        File installationinfo = new File(installdir + File.separator + ".installationinformation");
        if (!installationinfo.exists()) {
            Debug.trace("creating info file" + installationinfo.getAbsolutePath());
            installationinfo.createNewFile();
        } else {
            Debug.trace("installation information found");
            FileInputStream fin = new FileInputStream(installationinfo);
            ObjectInputStream oin = new ObjectInputStream(fin);
            List packs = (List)oin.readObject();
            for (Object pack1 : packs) {
                Pack pack = (Pack)pack1;
                installedpacks.add(pack);
            }
            oin.close();
            fin.close();
        }
        FileOutputStream fout = new FileOutputStream(installationinfo);
        ObjectOutputStream oout = new ObjectOutputStream(fout);
        oout.writeObject(installedpacks);
        oout.writeObject(this.idata.variables);
        Debug.trace("done.");
        oout.close();
        fout.close();
    }

    protected File getAbsolutInstallSource() throws Exception {
        if (this.absolutInstallSource == null) {
            URI uri = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            if (!"file".equals(uri.getScheme())) {
                throw new Exception("Unexpected scheme in JAR file URI: " + uri);
            }
            this.absolutInstallSource = new File(uri.getSchemeSpecificPart()).getAbsoluteFile();
            if (this.absolutInstallSource.getName().endsWith(".jar")) {
                this.absolutInstallSource = this.absolutInstallSource.getParentFile();
            }
        }
        return this.absolutInstallSource;
    }
}

