/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import java.util.ArrayList;
import java.util.List;

public class VariableHistory {
    private String name;
    private List<String[]> values;
    private boolean newvariable;
    private boolean changed;

    public VariableHistory(String variable) {
        this.name = variable;
        this.values = new ArrayList<String[]>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addValue(String value, String comment) {
        String[] valuecomment = new String[]{value, comment};
        this.values.add(valuecomment);
        if (this.values.size() == 1) {
            this.newvariable = true;
            this.changed = true;
        } else {
            this.changed = true;
        }
    }

    public String[] getValueComment(int index) {
        return this.values.get(index);
    }

    public int getValuesCount() {
        return this.values.size();
    }

    public String getLastValue() {
        if (this.values.size() > 0) {
            String[] valuecomment = this.values.get(this.values.size() - 1);
            return valuecomment[0];
        }
        return "";
    }

    public boolean isNewvariable() {
        return this.newvariable;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void clearState() {
        this.newvariable = false;
        this.changed = false;
    }

    public String getValueHistoryDetails() {
        StringBuffer details = new StringBuffer();
        details.append("<html><body>");
        details.append("<h3>Details of <b>");
        details.append(this.name);
        details.append("</b></h3>");
        for (int i2 = this.values.size() - 1; i2 >= 0; --i2) {
            String[] valuecomment = this.values.get(i2);
            details.append(i2 + 1);
            details.append(". ");
            details.append(valuecomment[0]);
            details.append(" (");
            details.append(valuecomment[1]);
            details.append(")<br>");
        }
        details.append("</body></html>");
        return details.toString();
    }

    public String toString() {
        return this.getLastValue();
    }
}

