/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.Pack;
import com.izforge.izpack.ParsableFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.compiler.CompilerException;
import com.izforge.izpack.compiler.PackInfo;
import com.izforge.izpack.installer.WebAccessor;
import com.izforge.izpack.util.OsConstraint;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebRepositoryAccessor {
    private String installXmlUrl;
    private String baseUrl;
    private String installXmlString;
    private String packsInfo;
    private ArrayList<PackInfo> packs;
    private static boolean YES = true;
    private static boolean NO = false;
    private static final String installFilename = "install.xml";
    private static final String packsinfoFilename = "packsinfo.xml";
    private static final int BUFFER_SIZE = 1000000;

    public WebRepositoryAccessor(String urlbase) {
        this.installXmlUrl = urlbase + "/" + installFilename;
        this.baseUrl = urlbase;
    }

    public ArrayList<PackInfo> getOnlinePacks() {
        this.readConfig();
        this.packs = this.parsePacks();
        this.readPacksInfo();
        this.parsePacksInfo();
        return this.packs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stringFromURL(String url) {
        int max = 1000000;
        byte[] raw = new byte[max];
        InputStream in = null;
        try {
            int r2;
            WebAccessor w2 = new WebAccessor(null);
            in = w2.openInputStream(new URL(url));
            if (in == null) {
                throw new RuntimeException("Unable to open network stream");
            }
            int off = r2 = in.read(raw);
            while (r2 > 0) {
                r2 = in.read(raw, off, max - off);
                off += r2;
            }
            String string = new String(raw);
            return string;
        }
        catch (Exception e2) {
            System.out.println(e2 + " while trying to download " + url);
            String string = null;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e3) {}
        }
    }

    private void readConfig() {
        this.installXmlString = this.stringFromURL(this.installXmlUrl);
    }

    private void readPacksInfo() {
        String url = this.baseUrl + "/" + packsinfoFilename;
        this.packsInfo = this.stringFromURL(url);
    }

    private ArrayList<PackInfo> parsePacks() {
        try {
            XMLParser parser = new XMLParser();
            IXMLElement xml = parser.parse(this.installXmlString);
            return this.loadPacksList(xml);
        }
        catch (Exception e2) {
            System.out.println("WARN: Unable to parse install.xml");
            return null;
        }
    }

    private void parsePacksInfo() {
        try {
            IXMLElement xml;
            XMLParser parser = new XMLParser();
            IXMLElement root = xml = parser.parse(this.packsInfo);
            for (int q2 = 0; q2 < root.getChildrenCount(); ++q2) {
                IXMLElement ch2 = root.getChildAtIndex(q2);
                PackInfo pi = this.packs.get(q2);
                Pack p2 = pi.getPack();
                p2.nbytes = Long.parseLong(ch2.getAttribute("nbytes"));
            }
        }
        catch (Exception e2) {
            System.out.println("WARN: Unable to parse packsinfo.xml");
        }
    }

    public static String getCachedUrl(String url, String tempFolder) throws Exception {
        int max = 1000000;
        byte[] raw = new byte[max];
        try {
            WebAccessor w2 = new WebAccessor(null);
            InputStream in = w2.openInputStream(new URL(url));
            int r2 = in.read(raw);
            File tempDir = new File(tempFolder);
            tempDir.mkdirs();
            File temp = File.createTempFile("izpacktempfile", "jar", new File(tempFolder));
            FileOutputStream fos = new FileOutputStream(temp);
            String path = "file:///" + temp.getAbsolutePath();
            while (r2 > 0) {
                fos.write(raw, 0, r2);
                r2 = in.read(raw);
            }
            in.close();
            fos.close();
            return path;
        }
        catch (SecurityException e2) {
            System.out.println(e2 + " while trying to write temp file: " + tempFolder);
            throw e2;
        }
        catch (Exception e3) {
            System.out.println(e3 + " while trying to download " + url);
            throw e3;
        }
    }

    protected ArrayList<PackInfo> loadPacksList(IXMLElement data) throws CompilerException {
        ArrayList<PackInfo> result = new ArrayList<PackInfo>();
        IXMLElement root = this.requireChildNamed(data, "packs");
        Vector<IXMLElement> packElements = root.getChildrenNamed("pack");
        if (packElements.isEmpty()) {
            this.parseError(root, "<packs> requires a <pack>");
        }
        for (IXMLElement el2 : packElements) {
            String name = this.requireAttribute(el2, "name");
            String id = el2.getAttribute("id");
            boolean loose = "true".equalsIgnoreCase(el2.getAttribute("loose", "false"));
            String description = this.requireChildNamed(el2, "description").getContent();
            boolean required = this.requireYesNoAttribute(el2, "required");
            String group = el2.getAttribute("group");
            String installGroups = el2.getAttribute("installGroups");
            String excludeGroup = el2.getAttribute("excludeGroup");
            boolean uninstall = "yes".equalsIgnoreCase(el2.getAttribute("uninstall", "yes"));
            String parent = el2.getAttribute("parent");
            if (required && excludeGroup != null) {
                this.parseError(el2, "Pack, which has excludeGroup can not be required.", new Exception("Pack, which has excludeGroup can not be required."));
            }
            PackInfo pack = new PackInfo(name, id, description, required, loose, excludeGroup, uninstall);
            pack.setOsConstraints(OsConstraint.getOsList(el2));
            pack.setParent(parent);
            if (excludeGroup == null) {
                pack.setPreselected(this.validateYesNoAttribute(el2, "preselected", YES));
            } else {
                pack.setPreselected(this.validateYesNoAttribute(el2, "preselected", NO));
            }
            if (group != null) {
                pack.setGroup(group);
            }
            if (installGroups != null) {
                StringTokenizer st = new StringTokenizer(installGroups, ",");
                while (st.hasMoreTokens()) {
                    String igroup = st.nextToken();
                    pack.addInstallGroup(igroup);
                }
            }
            for (IXMLElement p2 : el2.getChildrenNamed("parsable")) {
                String target = this.requireAttribute(p2, "targetfile");
                String type = p2.getAttribute("type", "plain");
                String encoding = p2.getAttribute("encoding", null);
                List<OsConstraint> osList = OsConstraint.getOsList(p2);
                pack.addParsable(new ParsableFile(target, type, encoding, osList));
            }
            for (IXMLElement e2 : el2.getChildrenNamed("executable")) {
                ExecutableFile executable = new ExecutableFile();
                executable.path = this.requireAttribute(e2, "targetfile");
                String val = e2.getAttribute("stage", "never");
                if ("postinstall".equalsIgnoreCase(val)) {
                    executable.executionStage = 0;
                } else if ("uninstall".equalsIgnoreCase(val)) {
                    executable.executionStage = 2;
                }
                val = e2.getAttribute("type", "bin");
                if ("jar".equalsIgnoreCase(val)) {
                    executable.type = 1;
                    executable.mainClass = e2.getAttribute("class");
                }
                if ("abort".equalsIgnoreCase(val = e2.getAttribute("failure", "ask"))) {
                    executable.onFailure = 0;
                } else if ("warn".equalsIgnoreCase(val)) {
                    executable.onFailure = 1;
                }
                val = e2.getAttribute("keep");
                executable.keepFile = "true".equalsIgnoreCase(val);
                IXMLElement args = e2.getFirstChildNamed("args");
                if (null != args) {
                    for (IXMLElement arg : args.getChildrenNamed("arg")) {
                        executable.argList.add(this.requireAttribute(arg, "value"));
                    }
                }
                executable.osList = OsConstraint.getOsList(e2);
                pack.addExecutable(executable);
            }
            for (IXMLElement f2 : el2.getChildrenNamed("updatecheck")) {
                String casesensitive = f2.getAttribute("casesensitive");
                ArrayList<String> includesList = new ArrayList<String>();
                ArrayList<String> excludesList = new ArrayList<String>();
                for (IXMLElement inc_el : f2.getChildrenNamed("include")) {
                    includesList.add(this.requireAttribute(inc_el, "name"));
                }
                for (IXMLElement excl_el : f2.getChildrenNamed("exclude")) {
                    excludesList.add(this.requireAttribute(excl_el, "name"));
                }
                pack.addUpdateCheck(new UpdateCheck(includesList, excludesList, casesensitive));
            }
            for (IXMLElement dep : el2.getChildrenNamed("depends")) {
                String depName = this.requireAttribute(dep, "packname");
                pack.addDependency(depName);
            }
            result.add(pack);
        }
        return result;
    }

    protected void parseError(String message) throws CompilerException {
        throw new CompilerException("install.xml:" + message);
    }

    protected void parseError(IXMLElement parent, String message) throws CompilerException {
        throw new CompilerException("install.xml:" + parent.getLineNr() + ": " + message);
    }

    protected void parseError(IXMLElement parent, String message, Throwable cause) throws CompilerException {
        throw new CompilerException("install.xml:" + parent.getLineNr() + ": " + message, cause);
    }

    protected void parseWarn(IXMLElement parent, String message) {
        System.out.println("install.xml:" + parent.getLineNr() + ": " + message);
    }

    protected IXMLElement requireChildNamed(IXMLElement parent, String name) throws CompilerException {
        IXMLElement child = parent.getFirstChildNamed(name);
        if (child == null) {
            this.parseError(parent, "<" + parent.getName() + "> requires child <" + name + ">");
        }
        return child;
    }

    protected URL requireURLContent(IXMLElement element) throws CompilerException {
        URL url = null;
        try {
            url = new URL(this.requireContent(element));
        }
        catch (MalformedURLException x2) {
            this.parseError(element, "<" + element.getName() + "> requires valid URL", x2);
        }
        return url;
    }

    protected String requireContent(IXMLElement element) throws CompilerException {
        String content = element.getContent();
        if (content == null || content.length() == 0) {
            this.parseError(element, "<" + element.getName() + "> requires content");
        }
        return content;
    }

    protected String requireAttribute(IXMLElement element, String attribute) throws CompilerException {
        String value = element.getAttribute(attribute);
        if (value == null) {
            this.parseError(element, "<" + element.getName() + "> requires attribute '" + attribute + "'");
        }
        return value;
    }

    protected int requireIntAttribute(IXMLElement element, String attribute) throws CompilerException {
        String value = element.getAttribute(attribute);
        if (value == null || value.length() == 0) {
            this.parseError(element, "<" + element.getName() + "> requires attribute '" + attribute + "'");
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException x2) {
            this.parseError(element, "'" + attribute + "' must be an integer");
            return 0;
        }
    }

    protected boolean requireYesNoAttribute(IXMLElement element, String attribute) throws CompilerException {
        String value = this.requireAttribute(element, attribute);
        if ("yes".equalsIgnoreCase(value)) {
            return true;
        }
        if ("no".equalsIgnoreCase(value)) {
            return false;
        }
        this.parseError(element, "<" + element.getName() + "> invalid attribute '" + attribute + "': Expected (yes|no)");
        return false;
    }

    protected boolean validateYesNoAttribute(IXMLElement element, String attribute, boolean defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String value = element.getAttribute(attribute, defaultValue ? "yes" : "no");
        if ("yes".equalsIgnoreCase(value)) {
            return true;
        }
        if ("no".equalsIgnoreCase(value)) {
            return false;
        }
        this.parseWarn(element, "<" + element.getName() + "> invalid attribute '" + attribute + "': Expected (yes|no) if present");
        return defaultValue;
    }
}

