/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.io;

import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Random;
import java.util.zip.GZIPOutputStream;

public class FileSpanningOutputStream
extends OutputStream {
    public static final long KB = 1000L;
    public static final long MB = 1000000L;
    public static final long DEFAULT_VOLUME_SIZE = 650000000L;
    public static final long DEFAULT_ADDITIONAL_FIRST_VOLUME_FREE_SPACE_SIZE = 0L;
    protected static final String DEFAULT_VOLUME_NAME = "rdpack";
    protected static final long FILE_NOT_AVAILABLE = -1L;
    protected long maxvolumesize = 650000000L;
    protected long firstvolumefreespacesize = 0L;
    public static final String VOLUMES_INFO = "/volumes.info";
    public static final int MAGIC_NUMER_LENGTH = 10;
    protected File currentfile;
    protected String volumename;
    protected int currentvolumeindex;
    private FileOutputStream fileoutputstream;
    private GZIPOutputStream zippedoutputstream;
    private byte[] magicnumber;
    protected long filepointer;
    protected long totalbytesofpreviousvolumes;

    public FileSpanningOutputStream(String volumename, long maxvolumesize) throws IOException {
        this(new File(volumename), maxvolumesize);
    }

    public FileSpanningOutputStream(File volume, long maxvolumesize) throws IOException {
        this(volume, maxvolumesize, 0);
    }

    protected FileSpanningOutputStream(File volume, long maxvolumesize, int currentvolume) throws IOException {
        this.generateMagicNumber();
        this.createVolumeOutputStream(volume, maxvolumesize, currentvolume);
    }

    private void generateMagicNumber() {
        if (this.magicnumber == null) {
            this.magicnumber = new byte[10];
            Date currenttime = new Date();
            long currenttimeseconds = currenttime.getTime();
            Random random = new Random(currenttimeseconds);
            random.nextBytes(this.magicnumber);
            Debug.trace("created new magic number for FileOutputstream: " + new String(this.magicnumber));
            for (int i2 = 0; i2 < this.magicnumber.length; ++i2) {
                Debug.trace(i2 + " - " + this.magicnumber[i2]);
            }
        }
    }

    private void createVolumeOutputStream(File volume, long maxvolumesize, int currentvolume) throws IOException {
        this.fileoutputstream = new FileOutputStream(volume);
        this.zippedoutputstream = new GZIPOutputStream((OutputStream)this.fileoutputstream, 256);
        this.currentfile = volume;
        this.currentvolumeindex = currentvolume;
        this.maxvolumesize = maxvolumesize;
        String volumesuffix = "." + currentvolume;
        String volabsolutePath = volume.getAbsolutePath();
        this.volumename = volabsolutePath.endsWith(volumesuffix) ? volabsolutePath.substring(0, volabsolutePath.indexOf(volumesuffix)) : volabsolutePath;
        long oldfilepointer = this.filepointer;
        this.write(this.magicnumber);
        this.filepointer = oldfilepointer;
    }

    public FileSpanningOutputStream(File volume) throws IOException {
        this(volume.getAbsolutePath(), 650000000L);
    }

    public FileSpanningOutputStream(String volumename) throws IOException {
        this(volumename, 650000000L);
    }

    public FileSpanningOutputStream() throws IOException {
        this(DEFAULT_VOLUME_NAME, 650000000L);
    }

    protected long getCurrentVolumeSize() {
        if (this.currentfile == null) {
            return -1L;
        }
        try {
            this.flush();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.currentfile = new File(this.currentfile.getAbsolutePath());
        if (this.currentvolumeindex == 0) {
            return this.currentfile.length() + this.firstvolumefreespacesize + Math.round(0.001 * (double)this.currentfile.length());
        }
        return this.currentfile.length() + Math.round(0.001 * (double)this.currentfile.length());
    }

    protected void createStreamToNextVolume() throws IOException {
        this.close();
        this.totalbytesofpreviousvolumes = this.currentfile.length();
        ++this.currentvolumeindex;
        String nextvolumename = this.volumename + "." + this.currentvolumeindex;
        this.createVolumeOutputStream(new File(nextvolumename), this.maxvolumesize, this.currentvolumeindex);
    }

    public void close() throws IOException {
        this.flush();
        this.zippedoutputstream.close();
        this.fileoutputstream.close();
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        if ((long)len > this.maxvolumesize) {
            throw new IOException("file can't be written. buffer length exceeded maxvolumesize ( > " + this.maxvolumesize + ")");
        }
        long currentsize = this.getCurrentVolumeSize();
        long available = this.maxvolumesize - currentsize;
        if (available < (long)len) {
            Debug.trace("Not enough space left on volume. available: " + available);
            Debug.trace("current size is: " + currentsize);
            this.createStreamToNextVolume();
        }
        this.zippedoutputstream.write(b2, off, len);
        this.filepointer += (long)len;
    }

    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    public void write(int b2) throws IOException {
        long availablebytes = this.maxvolumesize - this.getCurrentVolumeSize();
        if (availablebytes >= 1L) {
            this.zippedoutputstream.write(b2);
            ++this.filepointer;
        } else {
            this.createStreamToNextVolume();
            this.zippedoutputstream.write(b2);
            ++this.filepointer;
        }
    }

    public void flush() throws IOException {
        this.zippedoutputstream.flush();
        this.fileoutputstream.flush();
    }

    public int getVolumeCount() {
        return this.currentvolumeindex + 1;
    }

    public long getFirstvolumefreespacesize() {
        return this.firstvolumefreespacesize;
    }

    public void setFirstvolumefreespacesize(long firstvolumefreespacesize) {
        this.firstvolumefreespacesize = firstvolumefreespacesize;
    }

    public long getCompressedFilepointer() throws IOException {
        this.flush();
        return this.totalbytesofpreviousvolumes + this.currentfile.length();
    }

    public long getFilepointer() {
        return this.filepointer;
    }
}

