/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.util.Debug;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpWindow
extends JDialog
implements HyperlinkListener,
ActionListener {
    public static final String HELP_TAG = "help";
    public static final String ISO3_ATTRIBUTE = "iso3";
    public static final String SRC_ATTRIBUTE = "src";
    private static final long serialVersionUID = -357544689286217809L;
    private JPanel contentPane = null;
    private JEditorPane htmlHelp = null;
    private JButton closeButton = null;
    private JScrollPane scrollPane = null;
    private String closeButtonText = "Close";

    public HelpWindow(InstallerFrame owner, String closeButtonText) {
        super(owner.getParent(), true);
        this.closeButtonText = closeButtonText;
        this.initialize();
    }

    private void initialize() {
        this.setSize(600, 400);
        this.setDefaultCloseOperation(1);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.contentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.contentPane.add((Component)this.getScrollPane(), null);
            this.contentPane.add((Component)this.getCloseButton(), null);
        }
        return this.contentPane;
    }

    private JEditorPane getHtmlHelp() {
        if (this.htmlHelp == null) {
            try {
                this.htmlHelp = new JEditorPane();
                this.htmlHelp.setContentType("text/html");
                this.htmlHelp.setEditable(false);
                this.htmlHelp.addHyperlinkListener(this);
            }
            catch (Throwable e2) {
                Debug.log(e2.getLocalizedMessage());
            }
        }
        return this.htmlHelp;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            try {
                this.scrollPane = new JScrollPane(this.getHtmlHelp());
            }
            catch (Throwable e2) {
                Debug.log(e2.getLocalizedMessage());
            }
        }
        return this.scrollPane;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            try {
                this.closeButton = new JButton(this.closeButtonText);
                this.closeButton.setAlignmentX(0.5f);
                this.closeButton.addActionListener(this);
            }
            catch (Throwable e2) {
                Debug.log(e2.getLocalizedMessage());
            }
        }
        return this.closeButton;
    }

    public void hyperlinkUpdate(HyperlinkEvent e2) {
        try {
            if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.getHtmlHelp().setPage(e2.getURL());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showHelp(String title, URL helpDocument) {
        this.setTitle(title);
        try {
            this.getHtmlHelp().setPage(helpDocument);
        }
        catch (IOException e2) {
            Debug.log(e2.getLocalizedMessage());
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }
}

