/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPasswordField;

public class PasswordGroup
implements ProcessingClient {
    private Vector<JPasswordField> fields = new Vector();
    private List<ValidatorContainer> validatorContainers = null;
    private Processor processor = null;
    private String modifiedPassword = null;
    private int currentValidator = 0;
    private InstallData idata;

    public PasswordGroup(InstallData idata, List<ValidatorContainer> validatorContainers, String processor) {
        try {
            this.idata = idata;
            this.validatorContainers = validatorContainers;
        }
        catch (Throwable exception) {
            Debug.trace("Failed in PasswordGroup constructor: " + exception);
            this.validatorContainers = null;
        }
        try {
            this.processor = (Processor)Class.forName(processor).newInstance();
        }
        catch (Throwable exception) {
            Debug.trace("Failed in PasswordGroup constructor making processor: " + exception);
            this.processor = null;
        }
    }

    public InstallData getIdata() {
        return this.idata;
    }

    @Override
    public int getNumFields() {
        return this.fields.size();
    }

    @Override
    public String getFieldContents(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.fields.size()) {
            throw new IndexOutOfBoundsException();
        }
        String contents = new String(this.fields.elementAt(index).getPassword());
        return contents;
    }

    public void addField(JPasswordField field) {
        if (field != null) {
            this.fields.add(field);
        }
    }

    public boolean validateContents(int i2) {
        boolean returnValue = true;
        try {
            this.currentValidator = i2;
            ValidatorContainer container = this.getValidatorContainer(i2);
            Validator validator = container.getValidator();
            if (validator != null) {
                returnValue = validator.validate(this);
            }
        }
        catch (Exception e2) {
            Debug.trace("validateContents(" + i2 + ") failed: " + e2);
        }
        return returnValue;
    }

    public String getValidatorMessage(int i2) {
        String returnValue = null;
        try {
            ValidatorContainer container = this.getValidatorContainer(i2);
            if (container != null) {
                returnValue = container.getMessage();
            }
        }
        catch (Exception e2) {
            Debug.trace("getValidatorMessage(" + i2 + ") failed: " + e2);
        }
        return returnValue;
    }

    public int validatorSize() {
        int size = 0;
        if (this.validatorContainers != null) {
            size = this.validatorContainers.size();
        }
        return size;
    }

    public ValidatorContainer getValidatorContainer() {
        return this.getValidatorContainer(this.currentValidator);
    }

    public ValidatorContainer getValidatorContainer(int i2) {
        ValidatorContainer container = null;
        try {
            container = this.validatorContainers.get(i2);
        }
        catch (Exception e2) {
            container = null;
        }
        return container;
    }

    @Override
    public boolean hasParams() {
        return this.hasParams(this.currentValidator);
    }

    public boolean hasParams(int i2) {
        boolean returnValue = false;
        try {
            ValidatorContainer container = this.getValidatorContainer(i2);
            if (container != null) {
                returnValue = container.hasParams();
            }
        }
        catch (Exception e2) {
            Debug.trace("hasParams(" + i2 + ") failed: " + e2);
        }
        return returnValue;
    }

    @Override
    public Map<String, String> getValidatorParams() {
        return this.getValidatorParams(this.currentValidator);
    }

    public Map<String, String> getValidatorParams(int i2) {
        Map<String, String> returnValue = null;
        try {
            ValidatorContainer container = this.getValidatorContainer(i2);
            if (container != null) {
                returnValue = container.getValidatorParams();
            }
        }
        catch (Exception e2) {
            Debug.trace("getValidatorParams(" + i2 + ") failed: " + e2);
        }
        return returnValue;
    }

    @Override
    public String getText() {
        return this.getValidatorMessage(this.currentValidator);
    }

    public void setModifiedPassword(String value) {
        this.modifiedPassword = value;
    }

    public String getPassword() {
        String returnValue = "";
        if (this.modifiedPassword != null) {
            returnValue = this.modifiedPassword;
            if (this.processor != null) {
                Debug.trace("Validator changed password, PROCESSOR WILL NOT RUN!");
            }
        } else if (this.processor != null) {
            returnValue = this.processor.process(this);
        } else if (this.fields.size() > 0) {
            returnValue = new String(this.fields.elementAt(0).getPassword());
        }
        return returnValue;
    }
}

