/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;

public class NotCondition
extends Condition {
    private static final long serialVersionUID = 3194843222487006309L;
    protected Condition operand;

    public NotCondition() {
    }

    public NotCondition(Condition operand) {
        this.operand = operand;
        if (operand != null) {
            this.operand.setInstalldata(this.installdata);
        }
    }

    public void readFromXML(IXMLElement xmlcondition) {
        try {
            if (xmlcondition.getChildrenCount() != 1) {
                Debug.log("not-condition needs one condition as operand");
                return;
            }
            this.operand = RulesEngine.analyzeCondition(xmlcondition.getChildAtIndex(0));
        }
        catch (Exception e2) {
            Debug.log("missing element in not-condition");
        }
    }

    public boolean isTrue() {
        if (this.operand == null) {
            Debug.trace("Operand of condition " + this.id + " not initialized correctly.");
            return false;
        }
        this.operand.setInstalldata(this.installdata);
        return !this.operand.isTrue();
    }

    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.id);
        details.append(" depends on:<ul><li>NOT ");
        details.append(this.operand.getDependenciesDetails());
        details.append("</li></ul>");
        return details.toString();
    }

    public void makeXMLData(IXMLElement conditionRoot) {
        IXMLElement op = RulesEngine.createConditionElement(this.operand, conditionRoot);
        this.operand.makeXMLData(op);
        conditionRoot.addChild(op);
    }
}

