/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.util.Debug;

public class UserCondition
extends Condition {
    private static final long serialVersionUID = -2076347348048202718L;
    private String requiredUsername;

    public boolean isTrue() {
        boolean result = false;
        if (this.requiredUsername == null) {
            Debug.log("Expected user name not set in user condition. Condition will return false.");
        } else {
            String actualUsername = System.getProperty("user.name");
            if (actualUsername != null || actualUsername.length() >= 0) {
                result = this.requiredUsername.equals(actualUsername);
            } else {
                Debug.log("No user.name found in system properties. Condition will return false.");
            }
        }
        return result;
    }

    public void readFromXML(IXMLElement xmlcondition) {
        IXMLElement userElement = xmlcondition.getFirstChildNamed("requiredusername");
        if (userElement == null) {
            Debug.log("Condition or type \"user\" requires child element: user");
        } else {
            this.requiredUsername = userElement.getContent();
        }
    }

    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl requiredUserEl = new XMLElementImpl("requiredusername", conditionRoot);
        requiredUserEl.setContent(this.requiredUsername);
        conditionRoot.addChild(requiredUserEl);
    }
}

