/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller;

import com.izforge.izpack.util.OsVersion;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelfModifier {
    public static final String BASE_KEY = "self.mod.base";
    public static final String JAR_KEY = "self.mod.jar";
    public static final String CLASS_KEY = "self.mod.class";
    public static final String METHOD_KEY = "self.mod.method";
    public static final String PHASE_KEY = "self.mod.phase";
    public static final String MEMORY_KEY = "self.memory";
    private String prefix = "izpack";
    private Method method = null;
    private File logFile = null;
    private File sandbox = null;
    private File jarFile = null;
    private int phase = 0;
    private SimpleDateFormat isoPoint = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private Date date = new Date();
    private long maxmemory = 128L;
    private long maxpermgensize = 64L;
    private boolean useMemorySettings = false;
    PrintStream log = null;
    private static final float JAVA_SPECIFICATION_VERSION = Float.parseFloat(System.getProperty("java.specification.version"));
    private static final String JAVA_HOME = System.getProperty("java.home");

    public static void test(String[] args) {
        try {
            File sandbox = new File(System.getProperty(BASE_KEY) + ".d");
            File randFile = new File(sandbox, "RandomAccess.tmp");
            RandomAccessFile rand = new RandomAccessFile(randFile, "rw");
            rand.writeChars("Just a test: The jvm has to close 'cuz I won't!\n");
            System.err.print("Deleting sandbox: ");
            SelfModifier.deleteTree(sandbox);
            System.err.println(sandbox.exists() ? "FAILED" : "SUCCEEDED");
        }
        catch (Exception x2) {
            System.err.println(x2.getMessage());
            x2.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "i-net Clear Reports Uninstall");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
        }
        try {
            SelfModifier selfModifier = new SelfModifier();
            if (selfModifier.phase == 2) {
                selfModifier.invoke2(args);
            } else if (selfModifier.phase == 3) {
                selfModifier.invoke3(args);
            }
        }
        catch (IOException ioe) {
            System.err.println("Error invoking a secondary phase");
            System.err.println("Note that this program is only intended as a secondary process");
            ioe.printStackTrace();
        }
    }

    private SelfModifier() throws IOException {
        this.phase = Integer.parseInt(System.getProperty(PHASE_KEY));
        String cName = System.getProperty(CLASS_KEY);
        String tName = System.getProperty(METHOD_KEY);
        this.jarFile = new File(System.getProperty(JAR_KEY));
        this.logFile = new File(System.getProperty(BASE_KEY) + ".log");
        this.sandbox = new File(System.getProperty(BASE_KEY) + ".d");
        try {
            Class<?> clazz = Class.forName(cName);
            Method method = clazz.getMethod(tName, String[].class);
            this.initMethod(method);
        }
        catch (ClassNotFoundException x1) {
            this.log("No class found for " + cName);
        }
        catch (NoSuchMethodException x2) {
            this.log("No method " + tName + " found in " + cName);
        }
    }

    public SelfModifier(Method method) throws IOException {
        this.phase = 1;
        this.initJavaExec();
        this.initMethod(method);
    }

    public SelfModifier(Method method, long maxmemory, long maxpermgensize) throws IOException {
        this(method);
        this.maxmemory = maxmemory;
        this.maxpermgensize = maxpermgensize;
        this.useMemorySettings = true;
    }

    private void initMethod(Method method) {
        int mod = method.getModifiers();
        if ((mod & 1) == 0 || (mod & 8) == 0) {
            throw new IllegalArgumentException("Method not public and static");
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 1 || !params[0].isArray() || !"java.lang.String".equals(params[0].getComponentType().getName())) {
            throw new IllegalArgumentException("Method must accept String array");
        }
        Class<?> clazz = method.getDeclaringClass();
        mod = clazz.getModifiers();
        if ((mod & 1) == 0 || (mod & 0x200) != 0) {
            throw new IllegalArgumentException("Method must be in a public class");
        }
        this.method = method;
    }

    private void initJavaExec() throws IOException {
        try {
            ArrayList<String> javaCmd = new ArrayList<String>();
            javaCmd.add(SelfModifier.javaCommand());
            Process p2 = Runtime.getRuntime().exec(javaCmd.toArray(new String[1]), null, null);
            new StreamProxy(p2.getErrorStream(), "err").start();
            new StreamProxy(p2.getInputStream(), "out").start();
            p2.getOutputStream().close();
            p2.waitFor();
        }
        catch (InterruptedException ie) {
            throw new IOException("Unable to create a java subprocess");
        }
    }

    public void invoke(String[] args) throws IOException {
        while (true) {
            this.logFile = File.createTempFile(this.prefix, ".log");
            System.out.println("creating Logfile: '" + this.logFile.getAbsolutePath() + "'");
            String f2 = this.logFile.toString();
            this.sandbox = new File(f2.substring(0, f2.length() - 4) + ".d");
            if (!this.sandbox.exists()) break;
            this.logFile.delete();
        }
        if (!this.sandbox.mkdir()) {
            throw new RuntimeException("Failed to create temp dir: " + this.sandbox);
        }
        this.sandbox = this.sandbox.getCanonicalFile();
        this.logFile = this.logFile.getCanonicalFile();
        this.jarFile = SelfModifier.findJarFile(this.method.getDeclaringClass()).getCanonicalFile();
        if (this.jarFile == null) {
            throw new IllegalStateException("SelfModifier must be in a jar file");
        }
        this.log("JarFile: " + this.jarFile);
        this.extractJarFile();
        if (args == null) {
            args = new String[]{};
        }
        Process p2 = this.spawn(args, 2);
        new StreamProxy(p2.getErrorStream(), "err", this.log).start();
        new StreamProxy(p2.getInputStream(), "out", this.log).start();
        System.exit(0);
    }

    private Process spawn(String[] args, int nextPhase) throws IOException {
        String base = this.logFile.getAbsolutePath();
        base = base.substring(0, base.length() - 4);
        String javaCommand = SelfModifier.javaCommand();
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaCommand);
        command.add("-Xmx" + this.maxmemory + "m");
        command.add("-XX:MaxPermSize=" + this.maxpermgensize + "m");
        command.add("-classpath");
        command.add(this.sandbox.getAbsolutePath());
        command.add("-Dself.mod.base=" + base);
        command.add("-Dself.mod.jar='" + this.jarFile.getPath() + "'");
        command.add("-Dself.mod.class=" + this.method.getDeclaringClass().getName());
        command.add("-Dself.mod.method=" + this.method.getName());
        command.add("-Dself.mod.phase=" + nextPhase);
        command.add("-Dself.memory=" + this.maxmemory);
        if (OsVersion.IS_MAC) {
            command.add("-Xdock:icon=" + this.sandbox.getAbsolutePath() + File.separatorChar + "img" + File.separatorChar + "cc-uninstaller.icns");
            command.add("-Xdock:name=i-net Clear Reports Uninstaller");
        }
        command.add(this.getClass().getName());
        for (String arg : args) {
            command.add(arg);
        }
        StringBuffer sb = new StringBuffer("Spawning phase ");
        sb.append(nextPhase).append(": ");
        for (String anEntireCmd : command) {
            sb.append("\n\t").append(anEntireCmd);
        }
        this.log(sb.toString());
        return Runtime.getRuntime().exec(command.toArray(new String[command.size()]), null, null);
    }

    public static File findJarFile(Class<?> clazz) {
        String resource = clazz.getName().replace('.', '/') + ".class";
        URL url = ClassLoader.getSystemResource(resource);
        if (!"jar".equals(url.getProtocol())) {
            return null;
        }
        String path = url.getFile();
        path = path.substring(0, path.lastIndexOf(33));
        File file = (double)JAVA_SPECIFICATION_VERSION < 1.4 ? new File(SelfModifier.fromURI(path)) : new File(URI.create(path));
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractJarFile() throws IOException {
        byte[] buf = new byte[5120];
        int extracted = 0;
        InputStream in = null;
        OutputStream out = null;
        String MANIFEST = "META-INF/MANIFEST.MF";
        JarFile jar = new JarFile(this.jarFile, true);
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                int n2;
                String pathname;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || MANIFEST.equals((pathname = entry.getName()).toUpperCase())) continue;
                in = jar.getInputStream(entry);
                File outFile = new File(this.sandbox, pathname);
                File parent = outFile.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                out = new BufferedOutputStream(new FileOutputStream(outFile));
                while ((n2 = in.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, n2);
                }
                out.close();
                ++extracted;
            }
            jar.close();
            this.log("Extracted " + extracted + " file" + (extracted > 1 ? "s" : "") + " into " + this.sandbox.getPath());
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException ioe) {}
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private void invoke2(String[] args) {
        int retVal = -1;
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception x2) {
                // empty catch block
            }
            Process p2 = this.spawn(args, 3);
            new StreamProxy(p2.getErrorStream(), "err", this.log).start();
            new StreamProxy(p2.getInputStream(), "out", this.log).start();
            p2.getOutputStream().close();
            try {
                retVal = p2.waitFor();
            }
            catch (InterruptedException e2) {
                this.log(e2);
            }
            this.log("deleteing sandbox");
            SelfModifier.deleteTree(this.sandbox);
        }
        catch (Exception e3) {
            this.log(e3);
        }
        this.log("Phase 3 return value = " + retVal);
    }

    public static boolean deleteTree(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File file1 : files = file.listFiles()) {
                SelfModifier.deleteTree(file1);
            }
        }
        return file.delete();
    }

    private void invoke3(String[] args) {
        try {
            this.errlog("Invoking method: " + this.method.getDeclaringClass().getName() + "." + this.method.getName() + "(String[] args)");
            this.method.invoke(null, new Object[]{args});
        }
        catch (Throwable t2) {
            this.errlog(t2.getMessage());
            t2.printStackTrace();
            this.errlog("exiting");
            System.err.flush();
            System.exit(31);
        }
        this.errlog("Method returned, waiting for other threads");
        System.err.flush();
    }

    private void errlog(String msg) {
        this.date.setTime(System.currentTimeMillis());
        System.err.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + msg);
    }

    private PrintStream checkLog() {
        try {
            if (this.log == null) {
                this.log = new PrintStream(new FileOutputStream(this.logFile.toString(), true));
            }
        }
        catch (IOException x2) {
            System.err.println("Phase " + this.phase + " log err: " + x2.getMessage());
            x2.printStackTrace();
        }
        this.date.setTime(System.currentTimeMillis());
        return this.log;
    }

    private void log(Throwable t2) {
        if (this.checkLog() != null) {
            this.log.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + t2.getMessage());
            t2.printStackTrace(this.log);
        }
    }

    private void log(String msg) {
        if (this.checkLog() != null) {
            this.log.println(this.isoPoint.format(this.date) + " Phase " + this.phase + ": " + msg);
        }
    }

    public static String fromURI(String uri) {
        if (!uri.startsWith("file:")) {
            throw new IllegalArgumentException("Can only handle file: URIs");
        }
        uri = uri.startsWith("file://") ? uri.substring(7) : uri.substring(5);
        uri = uri.replace('/', File.separatorChar);
        if (File.pathSeparatorChar == ';' && uri.startsWith("\\") && uri.length() > 2 && Character.isLetter(uri.charAt(1)) && uri.lastIndexOf(58) > -1) {
            uri = uri.substring(1);
        }
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(uri);
        char c2 = iter.first();
        while (c2 != '\uffff') {
            if (c2 == '%') {
                char c1 = iter.next();
                if (c1 != '\uffff') {
                    int i1 = Character.digit(c1, 16);
                    char c22 = iter.next();
                    if (c22 != '\uffff') {
                        int i2 = Character.digit(c22, 16);
                        sb.append((char)((i1 << 4) + i2));
                    }
                }
            } else {
                sb.append(c2);
            }
            c2 = iter.next();
        }
        String path = sb.toString();
        return path;
    }

    private static String addExtension(String command) {
        return command + (OsVersion.IS_WINDOWS || OsVersion.IS_OS2 ? ".exe" : "");
    }

    private static String javaCommand() {
        String dir;
        File jExecutable;
        String executable = SelfModifier.addExtension("java");
        String javaHome = JAVA_HOME;
        if (javaHome.endsWith(File.separator)) {
            javaHome = javaHome.substring(0, javaHome.length() - 1 - File.separator.length());
        }
        if (javaHome.endsWith(File.separator + "bin")) {
            javaHome = javaHome.substring(0, javaHome.length() - 1 - (File.separator + "bin").length());
        }
        if (!(jExecutable = new File(dir = new File(javaHome + File.separator + "bin").getAbsolutePath(), executable)).exists()) {
            return executable;
        }
        String path = jExecutable.getAbsolutePath();
        if (path.contains(" ")) {
            return "\"" + jExecutable.getAbsolutePath() + "\"";
        }
        return jExecutable.getAbsolutePath();
    }

    public static class StreamProxy
    extends Thread {
        InputStream in;
        String name;
        OutputStream out;

        public StreamProxy(InputStream in, String name) {
            this(in, name, null);
        }

        public StreamProxy(InputStream in, String name, OutputStream out) {
            this.in = in;
            this.name = name;
            this.out = out;
        }

        public void run() {
            try {
                String line;
                PrintWriter pw = null;
                if (this.out != null) {
                    pw = new PrintWriter(this.out);
                }
                BufferedReader br2 = new BufferedReader(new InputStreamReader(this.in));
                while ((line = br2.readLine()) != null) {
                    if (pw == null) continue;
                    pw.println(line);
                }
                if (pw != null) {
                    pw.flush();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

