/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.ConsoleTextArea;
import com.izforge.izpack.util.ConsoleWrite;
import java.io.OutputStream;
import javax.swing.SwingUtilities;

class ConsoleWriter
extends OutputStream {
    private ConsoleTextArea textArea;
    private StringBuffer buffer;

    public ConsoleWriter(ConsoleTextArea textArea) {
        this.textArea = textArea;
        this.buffer = new StringBuffer();
    }

    public synchronized void write(int ch2) {
        this.buffer.append((char)ch2);
        if (ch2 == 10) {
            this.flushBuffer();
        }
    }

    public synchronized void write(char[] data, int off, int len) {
        for (int i2 = off; i2 < len; ++i2) {
            this.buffer.append(data[i2]);
            if (data[i2] != '\n') continue;
            this.flushBuffer();
        }
    }

    public synchronized void flush() {
        if (this.buffer.length() > 0) {
            this.flushBuffer();
        }
    }

    public void close() {
        this.flush();
    }

    private void flushBuffer() {
        String str = this.buffer.toString();
        this.buffer.setLength(0);
        SwingUtilities.invokeLater(new ConsoleWrite(this.textArea, str));
    }
}

