/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.Installer;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.util.OsVersion;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Debug {
    public static final String DLOG = "LOG";
    public static final String DSTACKTRACE = "STACKTRACE";
    public static final String DTRACE = "TRACE";
    public static final String DDEBUG = "DEBUG";
    public static final String IZPACK_LOGFILE = "izpack.logfile";
    public static final int LOG_WITHOUT_DATE = 0;
    public static final int LOG_WITH_DATE = 1;
    public static final int LOG_WITH_TIME_STAMP = 2;
    public static final int LOG_WITH_TIME_AND_DATE = 3;
    private static final boolean TRACE = true;
    private static final boolean STACKTRACE = true;
    private static final boolean LOG = true;
    private static boolean DEBUG = false;
    private static String LOGFILE_PREFIX = "ClearReportsSetup_";
    private static String LOGFILE_EXTENSION = ".txt";
    private static String LOGFILENAME = LOGFILE_PREFIX + System.currentTimeMillis() + LOGFILE_EXTENSION;
    private static File out = null;

    public static void trace(Object s2) {
        Debug.log(s2, 3);
    }

    public static void trace(Object s2, Class<?> c2) {
        Debug.log(s2, 3, c2);
    }

    public static void error(Object s2) {
        Debug.log(s2, 3);
    }

    public static void error(Object s2, Class<?> c2) {
        Debug.log(s2, 3, c2);
    }

    public static void log(Object o2) {
        Debug.log(o2, 3);
    }

    public static void log(Object o2, int withWhatFormat) {
        Debug.log(o2, withWhatFormat, null);
    }

    public static void log(Object o2, Class<?> c2) {
        Debug.log(o2, 3, c2);
    }

    public static void log(Object o2, int withWhatFormat, Class<?> c2) {
        PrintWriter logfile = Debug.getLogFile();
        if (logfile == null) {
            logfile = Debug.createLogFile();
        }
        if (logfile != null) {
            if (o2 == null) {
                o2 = "null";
            }
            Date date = null;
            StringBuffer entry = new StringBuffer();
            if (Debug.logWithDate(withWhatFormat)) {
                if (date == null) {
                    date = new Date();
                }
                entry.append(DateFormat.getDateInstance(3).format(date));
                entry.append(';');
                entry.append(' ');
            }
            if (Debug.logWithTime(withWhatFormat)) {
                if (date == null) {
                    date = new Date();
                }
                entry.append(DateFormat.getTimeInstance(2).format(date));
                entry.append(';');
                entry.append(' ');
            }
            if (c2 != null) {
                String name = c2.getName();
                name = name.substring(name.lastIndexOf(".") + 1);
                entry.append("[" + name.toUpperCase() + "]");
                entry.append(' ');
            }
            entry.append(o2);
            logfile.println(entry.toString());
            if (o2 instanceof Throwable) {
                ((Throwable)o2).printStackTrace(logfile);
            }
            logfile.flush();
        } else {
            System.err.println("Cannot write into logfile: (" + logfile + ") <- '" + o2 + "'");
        }
    }

    private static boolean logWithDate(int withWhatFormat) {
        return (withWhatFormat & 1) == 1;
    }

    private static boolean logWithTime(int withWhatFormat) {
        return (withWhatFormat & 1) == 1;
    }

    public static File getJarFile() {
        try {
            File file = new File(Debug.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            return file;
        }
        catch (Exception ex2) {
            return null;
        }
    }

    private static PrintWriter createLogFile() {
        PrintWriter logfile;
        File jarFileDir = Debug.getJarFile().getParentFile();
        while (!jarFileDir.isDirectory()) {
            jarFileDir = jarFileDir.getParentFile();
        }
        if (!(jarFileDir.canRead() && jarFileDir.canWrite() && !OsVersion.IS_MAC || (jarFileDir = new File(System.getProperty("user.home"))).canRead() && jarFileDir.canWrite())) {
            jarFileDir = new File(System.getProperty("java.io.tmpdir"));
        }
        String logFileDir = jarFileDir.getAbsolutePath();
        try {
            jarFileDir.mkdirs();
        }
        catch (RuntimeException e1) {
            e1.printStackTrace();
        }
        String logfilename = LOGFILENAME;
        out = new File(logFileDir, logfilename);
        if (jarFileDir.canWrite()) {
            try {
                BufferedWriter fw2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out, true), "UTF-8"));
                logfile = Debug.setLogFile(new PrintWriter(fw2));
            }
            catch (Exception e2) {
                logfile = null;
                e2.printStackTrace();
            }
        } else {
            logfile = null;
            System.err.println("Fatal: cannot write File: '" + logfilename + "' into: " + jarFileDir);
        }
        System.out.println("creating Logfile: '" + logfilename + "' in: '" + logFileDir + "'");
        return logfile;
    }

    public static File getLogFilePosition() {
        return out;
    }

    public static boolean tracing() {
        return true;
    }

    public static boolean stackTracing() {
        return true;
    }

    public static boolean isLOG() {
        return true;
    }

    public static void setLOG(boolean aFlag) {
    }

    public static boolean isSTACKTRACE() {
        return true;
    }

    public static void setSTACKTRACE(boolean aFlag) {
    }

    public static boolean isTRACE() {
        return true;
    }

    public static void setTRACE(boolean aFlag) {
    }

    public static boolean isDEBUG() {
        return DEBUG;
    }

    public static void setDEBUG(boolean aFlag) {
        DEBUG = aFlag;
    }

    public static PrintWriter getLogFile() {
        PrintWriter logfile = (PrintWriter)System.getProperties().get(IZPACK_LOGFILE);
        return logfile;
    }

    public static synchronized PrintWriter setLogFile(PrintWriter aLogFile) {
        System.getProperties().put(IZPACK_LOGFILE, aLogFile);
        PrintWriter logfile = (PrintWriter)System.getProperties().get(IZPACK_LOGFILE);
        if (logfile == null) {
            System.err.println("Set::logfile == null");
        }
        return logfile;
    }

    public static void addToUninstaller() {
        if (out != null) {
            UninstallData.getInstance().addFile(out.getAbsolutePath(), true);
        }
    }

    static {
        boolean dbg = false;
        try {
            dbg = Boolean.getBoolean(DDEBUG);
        }
        catch (Exception ex2) {
            // empty catch block
        }
        DEBUG = dbg;
        boolean noLog = "true".equalsIgnoreCase(System.getProperty("setup.no.log"));
        if (!noLog) {
            PrintWriter logfile = Debug.createLogFile();
            Debug.log(Installer.class.getName() + " LogFile created at ");
            Debug.log((Object)"System.Properties:", 2);
            Properties sysProps = System.getProperties();
            Enumeration<Object> spe = sysProps.keys();
            while (spe.hasMoreElements()) {
                String aKey = (String)spe.nextElement();
                Debug.log((Object)(aKey + "  =  " + sysProps.getProperty(aKey)), 0);
            }
            Debug.log((Object)"\n==========================================\n", 0);
            Debug.log((Object)("\n " + Installer.class.getName() + " installs on: \n"), 0);
            Debug.log((Object)OsVersion.getOsDetails(), 0);
            Debug.log((Object)"\n==========================================\n", 0);
        }
        if (DEBUG) {
            System.out.println("DEBUG enabled.");
        }
    }
}

