/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.MonitorInputStream;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileExecutor {
    private static final String JAR_FILE_SUFFIX = ".jar";
    private boolean runHeadless = false;
    private Collection<ExecutableFile> files;

    private boolean stopThread(Thread t2, MonitorInputStream m2) {
        m2.doStop();
        long softTimeout = 1000L;
        try {
            t2.join(softTimeout);
        }
        catch (InterruptedException e2) {
            // empty catch block
        }
        if (!t2.isAlive()) {
            return true;
        }
        t2.interrupt();
        long hardTimeout = 1000L;
        try {
            t2.join(hardTimeout);
        }
        catch (InterruptedException e3) {
            // empty catch block
        }
        return !t2.isAlive();
    }

    public FileExecutor(Collection<ExecutableFile> files) {
        this.files = files;
    }

    public FileExecutor() {
        this.files = null;
    }

    public static String getExecOutput(String[] aCommandLine) {
        return FileExecutor.getExecOutput(aCommandLine, false);
    }

    public static String getExecOutput(String[] aCommandLine, boolean forceToGetStdOut) {
        FileExecutor fe2 = new FileExecutor();
        String[] execOut = new String[2];
        int execResult = fe2.executeCommand(aCommandLine, execOut);
        if (execResult == 0) {
            return execOut[0];
        }
        if (forceToGetStdOut) {
            return execOut[0];
        }
        return execOut[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(String[] params, String[] output) {
        Process process = null;
        MonitorInputStream outMonitor = null;
        MonitorInputStream errMonitor = null;
        Thread t1 = null;
        Thread t2 = null;
        int exitStatus = -1;
        try {
            process = Runtime.getRuntime().exec(params);
            boolean console = false;
            if (console) {
                Console c2 = new Console(process);
                output[0] = c2.getOutputData();
                output[1] = c2.getErrorData();
                exitStatus = process.exitValue();
            } else {
                StringWriter outWriter = new StringWriter();
                StringWriter errWriter = new StringWriter();
                InputStreamReader or = new InputStreamReader(process.getInputStream());
                InputStreamReader er2 = new InputStreamReader(process.getErrorStream());
                outMonitor = new MonitorInputStream(or, outWriter);
                errMonitor = new MonitorInputStream(er2, errWriter);
                t1 = new Thread(outMonitor);
                t2 = new Thread(errMonitor);
                t1.setDaemon(true);
                t2.setDaemon(true);
                t1.start();
                t2.start();
                exitStatus = process.waitFor();
                t1.join();
                t2.join();
                output[0] = outWriter.toString();
                output[1] = errWriter.toString();
            }
        }
        catch (InterruptedException e2) {
            if (Debug.tracing()) {
                e2.printStackTrace(System.err);
            }
            this.stopThread(t1, outMonitor);
            this.stopThread(t2, errMonitor);
            output[0] = "";
            output[1] = e2.getMessage() + "\n";
        }
        catch (IOException e3) {
            if (Debug.tracing()) {
                e3.printStackTrace(System.err);
            }
            output[0] = "";
            output[1] = e3.getMessage() + "\n";
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return exitStatus;
    }

    public int executeFiles(int currentStage, AbstractUIHandler handler) {
        int exitStatus = 0;
        String[] output = new String[2];
        String permissions = "a+x";
        Iterator<ExecutableFile> efileIterator = this.files.iterator();
        while (exitStatus == 0 && efileIterator.hasNext()) {
            ExecutableFile efile = efileIterator.next();
            boolean deleteAfterwards = !efile.keepFile;
            File file = new File(efile.path);
            Debug.trace("handling executable file " + efile);
            if (!OsConstraint.oneMatchesCurrentSystem(efile.osList)) continue;
            if (0 == efile.type && currentStage != 2 && OsVersion.IS_UNIX) {
                Debug.trace("making file executable (setting executable flag)");
                String[] params = new String[]{"/bin/chmod", permissions, file.toString()};
                exitStatus = this.executeCommand(params, output);
                if (exitStatus != 0) {
                    handler.emitWarning("file execution error", "Error executing \n" + params[0] + " " + params[1] + " " + params[2]);
                    continue;
                }
            }
            if (exitStatus == 0 && (currentStage == 0 && efile.executionStage == 0 || currentStage == 2 && efile.executionStage == 2)) {
                ArrayList<String> paramList = new ArrayList<String>();
                if (0 == efile.type) {
                    paramList.add(file.toString());
                } else if (1 == efile.type && null == efile.mainClass) {
                    paramList.add(System.getProperty("java.home") + "/bin/java");
                    if (this.runHeadless) {
                        paramList.add("-Djava.awt.headless=true");
                    }
                    paramList.add("-jar");
                    paramList.add(file.toString());
                } else if (1 == efile.type && null != efile.mainClass) {
                    paramList.add(System.getProperty("java.home") + "/bin/java");
                    if (this.runHeadless) {
                        paramList.add("-Djava.awt.headless=true");
                    }
                    paramList.add("-cp");
                    try {
                        paramList.add(this.buildClassPath(file.toString()));
                    }
                    catch (Exception e2) {
                        exitStatus = -1;
                        Debug.error(e2);
                    }
                    paramList.add(efile.mainClass);
                }
                if (null != efile.argList && !efile.argList.isEmpty()) {
                    paramList.addAll(efile.argList);
                }
                String[] params = new String[paramList.size()];
                for (int i2 = 0; i2 < paramList.size(); ++i2) {
                    params[i2] = (String)paramList.get(i2);
                }
                exitStatus = this.executeCommand(params, output);
                if (exitStatus != 0) {
                    deleteAfterwards = false;
                    String message = output[0] + "\n" + output[1];
                    if (message.length() == 1) {
                        message = "Failed to execute " + file.toString() + ".";
                    }
                    if (efile.onFailure == 0) {
                        handler.emitError("file execution error", message);
                    } else if (efile.onFailure == 1) {
                        handler.emitWarning("file execution error", message);
                        exitStatus = 0;
                    } else if (efile.onFailure == 3) {
                        exitStatus = 0;
                    } else if (handler.askQuestion("Execution Failed", message + "\nContinue Installation?", 37) == 47) {
                        exitStatus = 0;
                    }
                }
            }
            if (efile.executionStage != 0 || !deleteAfterwards || !file.canWrite()) continue;
            file.delete();
        }
        return exitStatus;
    }

    private String buildClassPath(String targetFile) throws Exception {
        String[] rawJars;
        StringBuffer classPath = new StringBuffer();
        ArrayList<String> jars = new ArrayList<String>();
        for (String rawJar : rawJars = targetFile.split("" + File.pathSeparatorChar)) {
            String[] subDirJars;
            File file = new File(rawJar);
            jars.add(rawJar);
            if (!file.isDirectory() || (subDirJars = FileUtil.getFileNames(rawJar, new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(FileExecutor.JAR_FILE_SUFFIX);
                }
            })) == null) continue;
            for (String subDirJar : subDirJars) {
                jars.add(rawJar + File.separator + subDirJar);
            }
        }
        Iterator iter = jars.iterator();
        if (iter.hasNext()) {
            classPath.append((String)iter.next());
        }
        while (iter.hasNext()) {
            classPath.append(File.pathSeparatorChar).append((String)iter.next());
        }
        return classPath.toString();
    }

    public void setHeadless(boolean headless) {
        this.runHeadless = headless;
    }
}

