/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.inet.setup.panels.util.JsonCreator;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.CRC32;

public class StatisticHandler
implements CleanupClient {
    private List<String> activatedPanels = new ArrayList<String>();
    private final InstallData idata;

    public StatisticHandler(InstallData idata) {
        this.idata = idata;
    }

    public void cleanUp() {
        Properties variables = this.idata.getVariables();
        Properties props = new Properties();
        this.insertValue(props, "opt_Statistic", "CR Setup");
        this.insertValue(props, "CCVersion", variables.get("APP_VER"));
        this.insertValue(props, "opt_Setuptyp", Boolean.toString(true).equalsIgnoreCase((String)variables.get("HEADLESS")) ? "Headless" : variables.get("COMPONENT_TO_INSTALL"));
        String valueRemote = (String)variables.get("SERVLET_REMOTE_INSTALL");
        if (Boolean.toString(true).equalsIgnoreCase(valueRemote)) {
            this.insertValue(props, "opt_Paket", Boolean.toString(true));
        }
        String clicksequence = null;
        for (String panel : this.activatedPanels) {
            if (clicksequence == null) {
                clicksequence = panel;
                continue;
            }
            clicksequence = clicksequence + "," + panel;
        }
        this.insertValue(props, "ClickSequence", clicksequence);
        String beans = null;
        String drivers = null;
        String samplesCode = null;
        String tutorials = null;
        String samplesReports = null;
        String reportReader = null;
        String manual = null;
        String guides = null;
        boolean isPHPselected = false;
        for (Pack pack : this.idata.getSelectedPacks()) {
            String parent;
            if ("CCApache".equals(pack.id)) {
                isPHPselected = true;
            }
            if (pack.isHidden()) continue;
            if ("CCDesigner".equals(pack.id) || "CCServer".equals(pack.id) || "CCServletRoot".equals(pack.id)) {
                String packid = pack.id;
                if ("CCServer".equals(pack.id)) {
                    packid = pack.id;
                } else if ("CCServletRoot".equals(pack.id)) {
                    packid = "CCServlet";
                }
                this.appendValue(props, "comp_MainComponent", packid);
            }
            if ("CCServer".equals(pack.id) || "CCServletRoot".equals(pack.id)) {
                this.appendValue(props, "comp_ServerVersion", pack.id);
            }
            if ((parent = pack.parent) != null && parent.trim().length() > 0 && ("Servlets".equals(parent) || "Report Server".equals(parent) || "CCServer".equals(parent) || "CCServletRoot".equals(parent))) {
                this.appendValue(props, "comp_ServerVersion", pack.id);
            }
            if ("Beans".equals(parent)) {
                beans = beans == null ? pack.id : beans + "," + pack.id;
            }
            if ("Drivers".equals(parent)) {
                drivers = drivers == null ? pack.id : drivers + "," + pack.id;
            }
            if ("Doc_Manual".equals(pack.id)) {
                manual = Boolean.toString(true);
            }
            if ("Doc_Guides".equals(pack.id)) {
                guides = Boolean.toString(true);
            }
            if ("Doc_SampleReports".equals(pack.id)) {
                samplesReports = Boolean.toString(true);
            }
            if ("Doc_Samples".equals(pack.id)) {
                samplesCode = Boolean.toString(true);
            }
            if ("Doc_Tutorials".equals(pack.id)) {
                tutorials = Boolean.toString(true);
            }
            if (!"CCReportReaderComp".equals(pack.id)) continue;
            reportReader = Boolean.toString(true);
        }
        this.insertValue(props, "comp_Beans", beans);
        this.insertValue(props, "comp_Drivers", drivers);
        this.insertValue(props, "comp_SamplesCode", samplesCode);
        this.insertValue(props, "comp_SamplesReports", samplesReports);
        this.insertValue(props, "comp_Tutorials", tutorials);
        this.insertValue(props, "comp_Manual", manual);
        this.insertValue(props, "comp_Guides", guides);
        this.insertValue(props, "comp_ReportReader", reportReader);
        String variable = (String)variables.get("ADD_TO_CONFIG");
        HashMap<Object, Object> map = null;
        if (variable != null && variable.trim().length() > 0) {
            try {
                map = JsonCreator.createMapFromJson(variable);
            }
            catch (IllegalArgumentException iae) {
                map = new HashMap();
            }
            catch (NullPointerException npe) {
                map = new HashMap();
            }
        } else {
            map = new HashMap();
        }
        if (this.activatedPanels.contains("CCLicenseKeyPanel")) {
            String value = (String)variables.get("LICENSETYPE");
            if ("activate".equals(value)) {
                this.insertValue(props, "opt_License", "existing");
            } else if ("plus".equals(value)) {
                this.insertValue(props, "opt_License", "plusRequested");
            } else if ("default".equals(value)) {
                this.insertValue(props, "opt_License", "trialRequested");
            } else {
                this.insertValue(props, "opt_License", "notSet");
            }
        }
        if (this.activatedPanels.contains("CCConfigPanel")) {
            if (map.containsKey("remoteInterface.enabled")) {
                this.insertValue(props, "opt_remoteActivated", map.get("remoteInterface.enabled"));
            }
            if (map.containsKey("permission.logintype")) {
                this.insertValue(props, "opt_loginType", map.get("permission.logintype"));
            }
            if (map.containsKey("adhoc.enabled")) {
                this.insertValue(props, "opt_adhocActivation", map.get("adhoc.enabled"));
            }
        }
        if (this.activatedPanels.contains("CCPropertiesPanel") || this.activatedPanels.contains("CCRemotePropertiesPanel")) {
            this.appendValue(props, "opt_ConfigSelect", ((String)variables.get("SELECTED")).toLowerCase());
            this.appendValue(props, "opt_ConfigScope", ((String)variables.get("SCOPE_NAME")).toUpperCase());
            this.appendValue(props, "opt_hasConfigs", variables.get("hasConfigs"));
            if (this.activatedPanels.contains("CCRemotePropertiesPanel")) {
                this.appendValue(props, "opt_isPackageInstall", Boolean.toString(true));
            } else {
                this.appendValue(props, "opt_isPackageInstall", Boolean.toString(false));
            }
        }
        if (this.activatedPanels.contains("ApacheTomcatPanel")) {
            this.appendValue(props, "comp_ServletVersion", variables.get("TOMCAT_SERVLET_VERSION"));
        }
        if (this.activatedPanels.contains("GlassFishPanel")) {
            this.appendValue(props, "comp_ServletVersion", variables.get("GLASSFISH_SERVLET_VERSION"));
        }
        if (this.activatedPanels.contains("GenericPanel")) {
            this.appendValue(props, "comp_ServletVersion", variables.get("GENERIC_SERVLET_VERSION"));
        }
        if (this.activatedPanels.contains("JettyPanel")) {
            this.appendValue(props, "comp_ServletVersion", variables.get("JETTY_SERVLET_VERSION"));
        }
        if (isPHPselected) {
            // empty if block
        }
        if (this.activatedPanels.contains("WeblogicTargetPanel")) {
            this.appendValue(props, "comp_ServletVersion", variables.get("WEBLOGIC_SERVLET_VERSION"));
        }
        if (this.activatedPanels.contains("WebsphereTargetPanel")) {
            this.appendValue(props, "comp_ServletVersion", variables.get("WEBSPHERE_SERVLET_VERSION"));
        }
        if (this.activatedPanels.contains("JBossPanel")) {
            this.appendValue(props, "comp_ServletVersion", variables.get("JBOSS_SERVLET_VERSION"));
        }
        if (this.activatedPanels.contains("ShortcutPanel")) {
            this.insertValue(props, "opt_programGroup", variables.get("shortCut.programmGroup"));
            this.insertValue(props, "opt_desktopShortcut", variables.get("shortCut.desktopLink"));
        }
        if (!Boolean.toString(true).equalsIgnoreCase((String)variables.get("HEADLESS")) && !OsVersion.IS_MAC) {
            boolean regJRA;
            String registerExtensions = "none";
            String sregRPT = variables.get("REGISTER_RPT") != null ? variables.get("REGISTER_RPT").toString() : "0";
            String sregJRA = variables.get("REGISTER_JRA") != null ? variables.get("REGISTER_JRA").toString() : "0";
            boolean regRPT = !sregRPT.equalsIgnoreCase("0");
            boolean bl2 = regJRA = !sregJRA.equalsIgnoreCase("0");
            if (regRPT && regJRA) {
                registerExtensions = "all";
            } else if (regRPT) {
                registerExtensions = "rpt";
            } else if (regJRA) {
                registerExtensions = "jra";
            }
            this.insertValue(props, "opt_registerExt", registerExtensions);
        }
        this.insertValue(props, "opt_osName", variables.get("SYSTEM_os_name"));
        this.insertValue(props, "opt_osArch", variables.get("SYSTEM_os_arch"));
        this.insertValue(props, "opt_javaVersion", variables.get("SYSTEM_java_version"));
        this.insertValue(props, "opt_javaVendor", variables.get("SYSTEM_java_vendor"));
        this.insertValue(props, "opt_javaVMName", variables.get("SYSTEM_java_vm_name"));
        this.insertValue(props, "opt_cpuCount", String.valueOf(Runtime.getRuntime().availableProcessors()));
        boolean writeStats = "true".equalsIgnoreCase(System.getProperty("setup.write.statistic"));
        if (writeStats) {
            this.writeDataToDisk(props);
        }
        this.sendData(props);
    }

    private void writeDataToDisk(Properties props) {
        Enumeration<Object> keys = props.keys();
        StringBuilder builder = new StringBuilder();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            builder.append(key + "  --  " + props.getProperty(key) + "\n");
        }
        File f2 = new File(this.idata.getInstallPath(), "statistic.txt");
        try {
            FileWriter w2 = new FileWriter(f2);
            w2.write(builder.toString());
            w2.flush();
            w2.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void sendData(Properties props) {
        CRC32 crc = new CRC32();
        long sumOfAscii = 0L;
        StringBuffer bf2 = new StringBuffer();
        if (props != null && !props.isEmpty()) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String value;
                String key;
                String codedPair;
                if (entry.getKey() == null || entry.getValue() == null || (codedPair = this.getCodedPair(key = entry.getKey().toString(), value = entry.getValue().toString())).length() <= 0) continue;
                crc.update(key.getBytes());
                crc.update(value.getBytes());
                for (char ch2 : key.toCharArray()) {
                    sumOfAscii += (long)ch2;
                }
                for (char ch2 : value.toCharArray()) {
                    sumOfAscii += (long)ch2;
                }
                if (bf2.length() > 0) {
                    bf2.append("&");
                }
                bf2.append(codedPair);
            }
        }
        if (bf2.length() > 0) {
            long checksum = crc.getValue();
            checksum += sumOfAscii;
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                md5.reset();
                md5.update(String.valueOf(checksum).getBytes());
                byte[] digest = md5.digest();
                StringBuffer hexString = new StringBuffer();
                for (int i2 = 0; i2 < digest.length; ++i2) {
                    int val = 0xFF & digest[i2];
                    hexString.append((val < 16 ? "0" : "") + Integer.toHexString(val));
                }
                bf2.append("&").append(this.getCodedPair("checksum", hexString.toString()));
                URL url = new URL("http://www.inetsoftware.de/external-services/install/clear-reports.php");
                URLConnection connection = url.openConnection();
                connection.setDoOutput(true);
                OutputStream outStream = connection.getOutputStream();
                outStream.write(bf2.toString().getBytes("UTF8"));
                outStream.close();
                InputStream istream = connection.getInputStream();
                while (istream.read() != -1) {
                }
                istream.close();
            }
            catch (MalformedURLException e2) {
            }
            catch (IOException e3) {
            }
            catch (NoSuchAlgorithmException e4) {
                // empty catch block
            }
        }
    }

    private String getCodedPair(String key, String value) {
        StringBuffer bf2 = new StringBuffer();
        try {
            bf2.append(URLEncoder.encode(key, "UTF8"));
            bf2.append("=");
            bf2.append(URLEncoder.encode(value, "UTF8"));
        }
        catch (UnsupportedEncodingException e2) {
            // empty catch block
        }
        return bf2.toString();
    }

    private void insertValue(Properties props, String key, Object value) {
        if (value != null) {
            props.put(key, value);
        }
    }

    private void appendValue(Properties props, String key, Object value) {
        if (value != null) {
            Object oldval = props.get(key);
            if (oldval != null) {
                String[] split = oldval.toString().split(",");
                if (split != null) {
                    for (String sp : split) {
                        if (!value.equals(sp.trim())) continue;
                        return;
                    }
                }
                value = oldval.toString() + "," + value;
            }
            props.put(key, value);
        }
    }

    public void notifyPanelActivation(IzPanel izPanel) {
        this.activatedPanels.add(izPanel.getClass().getSimpleName());
    }

    public void notifyHelpActivation(IzPanel currentPanel) {
        this.activatedPanels.add("Help:" + currentPanel.getClass().getSimpleName());
    }
}

