/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.util.Debug;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class SummaryProcessor {
    private static String htmlHeader = "<html><head/><body>";
    private static String htmlFooter = "</body>";
    private static String PARAGRAPH_START = "<p>";
    private static String PARAGRAPH_END = "</p>";
    private static String H1_START = "<h1 class=\"sectionedit1\">";
    private static String H1_END = "</h1>\n";
    private static String H2_START = "<h2 class=\"sectionedit2\">";
    private static String H2_END = "</h2>\n";
    private static final String DIV_START = "<div id=\"inet_page\">";
    private static final String DIV_ENDING = "<div id=\"inet_footer\">";

    public String getSummary(AutomatedInstallData idata, InstallerFrame parent) {
        StringBuffer sb = new StringBuffer(2048);
        try {
            String resource = ResourceManager.getInstance().getTextResource("eng.license.html");
            URL resourceUrl = ResourceManager.getInstance().getURL("eng.license.html");
            String base = "\n<base href=\"" + resourceUrl.toString() + "\" />";
            htmlHeader = this.returnBeginning(resource, base);
            htmlFooter = this.returnEnd(resource);
        }
        catch (ResourceNotFoundException e2) {
            Debug.error(e2);
        }
        catch (FileNotFoundException e3) {
            Debug.error(e3);
        }
        catch (IOException e4) {
            Debug.error(e4);
        }
        sb.append(htmlHeader);
        sb.append(this.createInstallSummaryHeadline(idata, parent));
        Vector<String> packNames = new Vector<String>();
        ListIterator<Pack> packsSelected = idata.getSelectedPacks().listIterator();
        while (packsSelected.hasNext()) {
            Pack pack = (Pack)packsSelected.next();
            packNames.add(pack.id);
        }
        List<IzPanel> panels = idata.panels;
        if (panels != null && panels.size() > 0) {
            for (IzPanel panel : panels) {
                boolean conditionTrue = true;
                if (panel.metadata.getCondition() != null) {
                    conditionTrue = idata.getRules().isConditionTrue(panel.metadata.getCondition());
                }
                if (panel.getName() == null || !conditionTrue) continue;
                String caption = panel.getSummaryCaption();
                String msg = panel.getSummaryBody();
                if (caption == null || msg == null) continue;
                sb.append(H2_START).append(caption).append(H2_END);
                sb.append(PARAGRAPH_START).append(msg).append(PARAGRAPH_END);
            }
        }
        sb.append(htmlFooter);
        return sb.toString();
    }

    private String createInstallSummaryHeadline(AutomatedInstallData idata, InstallerFrame parent) {
        String component = idata.getVariable("COMPONENT_TO_INSTALL");
        if (component == null || component.trim().length() == 0) {
            return H1_START + H1_END;
        }
        if (parent == null) {
            return H1_START + component + H1_END;
        }
        String string = parent.langpack.getString("SummaryProcessor." + component.toLowerCase());
        if (string != null) {
            return H1_START + string + H1_END;
        }
        return H1_START + component + H1_END;
    }

    private String returnEnd(String b2) {
        int indexOfDiv = b2.indexOf(DIV_ENDING);
        if (indexOfDiv > -1) {
            String substring = b2.substring(indexOfDiv);
            return "</div>" + substring;
        }
        return b2;
    }

    private String returnBeginning(String b2, String base) {
        int indexOfDiv = b2.indexOf(DIV_START);
        if (indexOfDiv > -1) {
            String stringHead;
            String substring = b2.substring(0, indexOfDiv + DIV_START.length());
            int indexOfHead = substring.indexOf(stringHead = "<head>");
            if (indexOfHead > -1) {
                StringBuilder sb = new StringBuilder();
                sb.append(substring.substring(0, indexOfHead + stringHead.length()));
                sb.append(base);
                sb.append(substring.substring(indexOfHead + stringHead.length()));
                sb.append("<div class=\"dokuwiki\">");
                substring = sb.toString();
            }
            return substring;
        }
        return b2;
    }

    public static SummaryProcessor getInstance() {
        return new SummaryProcessor();
    }
}

