/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.IoHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class VariableSubstitutor
implements Serializable {
    private static final long serialVersionUID = 3907213762447685687L;
    protected transient Properties variables;
    protected boolean bracesRequired = false;
    protected static final int TYPE_PLAIN = 0;
    protected static final int TYPE_JAVA_PROPERTIES = 1;
    protected static final int TYPE_XML = 2;
    protected static final int TYPE_SHELL = 3;
    protected static final int TYPE_AT = 4;
    protected static final int TYPE_JAVA = 5;
    protected static final int TYPE_ANT = 6;
    public static final String PLAIN = "plain";
    protected static final Map<String, Integer> typeNameToConstantMap = new HashMap<String, Integer>();

    public VariableSubstitutor(Properties variables) {
        this.variables = variables;
    }

    public boolean areBracesRequired() {
        return this.bracesRequired;
    }

    public void setBracesRequired(boolean braces) {
        this.bracesRequired = braces;
    }

    public String substitute(String str, String type) throws IllegalArgumentException {
        if (str == null) {
            return null;
        }
        StringReader reader = new StringReader(str);
        StringWriter writer = new StringWriter();
        try {
            this.substitute(reader, writer, type);
        }
        catch (IOException e2) {
            throw new Error("Unexpected I/O exception when reading/writing memory buffer; nested exception is: " + e2);
        }
        return writer.getBuffer().toString();
    }

    public int substitute(InputStream in, OutputStream out, String type, String encoding) throws IllegalArgumentException, UnsupportedEncodingException, IOException {
        if (encoding == null) {
            int t2 = this.getTypeConstant(type);
            switch (t2) {
                case 1: {
                    encoding = "ISO-8859-1";
                    break;
                }
                case 2: {
                    encoding = "UTF-8";
                }
            }
        }
        InputStreamReader reader = encoding != null ? new InputStreamReader(in, encoding) : new InputStreamReader(in);
        OutputStreamWriter writer = encoding != null ? new OutputStreamWriter(out, encoding) : new OutputStreamWriter(out);
        int subs = this.substitute(reader, writer, type);
        writer.flush();
        return subs;
    }

    public String substitute(InputStream in, String type) throws IllegalArgumentException, UnsupportedEncodingException, IOException {
        String encoding = PLAIN;
        int t2 = this.getTypeConstant(type);
        switch (t2) {
            case 1: {
                encoding = "ISO-8859-1";
                break;
            }
            case 2: {
                encoding = "UTF-8";
            }
        }
        InputStreamReader reader = encoding != null ? new InputStreamReader(in, encoding) : new InputStreamReader(in);
        StringWriter writer = new StringWriter();
        this.substitute(reader, writer, type);
        writer.flush();
        return writer.getBuffer().toString();
    }

    public int substitute(Reader reader, Writer writer, String type) throws IllegalArgumentException, IOException {
        int t2 = this.getTypeConstant(type);
        int variable_start = 36;
        int variable_end = 0;
        if (t2 == 3) {
            variable_start = 37;
        } else if (t2 == 4) {
            variable_start = 64;
        } else if (t2 == 6) {
            variable_start = 64;
            variable_end = 64;
        }
        int subs = 0;
        int c2 = reader.read();
        while (true) {
            if (c2 != -1 && c2 != variable_start) {
                writer.write(c2);
                c2 = reader.read();
                continue;
            }
            if (c2 == -1) {
                return subs;
            }
            boolean braces = false;
            c2 = reader.read();
            if (c2 == 123) {
                braces = true;
                c2 = reader.read();
            } else {
                if (this.bracesRequired) {
                    writer.write(variable_start);
                    continue;
                }
                if (c2 == -1) {
                    writer.write(variable_start);
                    return subs;
                }
            }
            StringBuffer nameBuffer = new StringBuffer();
            while (c2 != -1 && braces && c2 != 125 || c2 >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90 || braces && (c2 == 91 || c2 == 93) || (c2 >= 48 && c2 <= 57 || c2 == 95 || c2 == 45) && nameBuffer.length() > 0) {
                nameBuffer.append((char)c2);
                c2 = reader.read();
            }
            String name = nameBuffer.toString();
            String varvalue = null;
            if (!(braces && c2 != 125 || braces && variable_end != 0 && variable_end != c2 || name.length() <= 0)) {
                if (braces && name.startsWith("ENV[") && name.lastIndexOf(93) == name.length() - 1) {
                    varvalue = IoHelper.getenv(name.substring(4, name.length() - 1));
                    if (varvalue == null) {
                        varvalue = "";
                    }
                } else {
                    varvalue = this.variables.getProperty(name);
                }
                ++subs;
            }
            if (varvalue != null) {
                writer.write(this.escapeSpecialChars(varvalue, t2));
                if (!braces && variable_end == 0) continue;
                c2 = reader.read();
                continue;
            }
            writer.write(variable_start);
            if (braces) {
                writer.write(123);
            }
            writer.write(name);
        }
    }

    protected int getTypeConstant(String type) {
        if (type == null) {
            return 0;
        }
        Integer integer = typeNameToConstantMap.get(type);
        if (integer == null) {
            throw new IllegalArgumentException("Unknown file type " + type);
        }
        return integer;
    }

    protected String escapeSpecialChars(String str, int type) {
        switch (type) {
            case 0: 
            case 4: 
            case 6: {
                return str;
            }
            case 3: {
                return str.replace("\r", "");
            }
            case 1: 
            case 5: {
                StringBuffer buffer = new StringBuffer(str);
                int len = str.length();
                for (int i2 = 0; i2 < len; ++i2) {
                    char c2 = buffer.charAt(i2);
                    if (type == 1) {
                        if (c2 == '\t' || c2 == '\n' || c2 == '\r') {
                            char tag = c2 == '\t' ? (char)'t' : (c2 == '\n' ? (char)'n' : 'r');
                            buffer.replace(i2, i2 + 1, "\\" + tag);
                            ++len;
                            ++i2;
                        }
                        if (c2 != '\\' && c2 != '\"' && c2 != '\'' && c2 != ' ') continue;
                        buffer.insert(i2, '\\');
                        ++len;
                        ++i2;
                        continue;
                    }
                    if (c2 != '\\') continue;
                    buffer.replace(i2, i2 + 1, "\\\\");
                    ++len;
                    ++i2;
                }
                return buffer.toString();
            }
            case 2: {
                StringBuffer buffer = new StringBuffer(str);
                int len = str.length();
                for (int i2 = 0; i2 < len; ++i2) {
                    String r2 = null;
                    char c3 = buffer.charAt(i2);
                    switch (c3) {
                        case '<': {
                            r2 = "&lt;";
                            break;
                        }
                        case '>': {
                            r2 = "&gt;";
                            break;
                        }
                        case '&': {
                            r2 = "&amp;";
                            break;
                        }
                        case '\'': {
                            r2 = "&apos;";
                            break;
                        }
                        case '\"': {
                            r2 = "&quot;";
                        }
                    }
                    if (r2 == null) continue;
                    buffer.replace(i2, i2 + 1, r2);
                    len = buffer.length();
                    i2 += r2.length() - 1;
                }
                return buffer.toString();
            }
        }
        throw new Error("Unknown file type constant " + type);
    }

    static {
        typeNameToConstantMap.put(PLAIN, 0);
        typeNameToConstantMap.put("javaprop", 1);
        typeNameToConstantMap.put("java", 5);
        typeNameToConstantMap.put("xml", 2);
        typeNameToConstantMap.put("shell", 3);
        typeNameToConstantMap.put("at", 4);
        typeNameToConstantMap.put("ant", 6);
    }
}

