/*
 * Decompiled with CFR 0.152.
 */
package info.clearthought.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class SingleFiledLayout
implements LayoutManager,
Serializable {
    public static final int COLUMN = 0;
    public static final int ROW = 1;
    public static final int LEFT = 0;
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int FULL = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    public static int DEFAULT_GAP = 5;
    protected int orientation;
    protected int justification;
    protected int gap;

    public SingleFiledLayout() {
        this(0, 0, DEFAULT_GAP);
    }

    public SingleFiledLayout(int n2) {
        this(n2, 0, DEFAULT_GAP);
    }

    public SingleFiledLayout(int n2, int n3, int n4) {
        if (n2 != 1) {
            n2 = 0;
        }
        if (n3 != 1 && n3 != 2 && n3 != 4) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        this.orientation = n2;
        this.justification = n3;
        this.gap = n4;
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        int n2 = insets.left;
        int n3 = insets.top;
        Component[] componentArray = container.getComponents();
        if (this.orientation == 0) {
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                Dimension dimension2 = componentArray[i2].getPreferredSize();
                switch (this.justification) {
                    case 0: {
                        n2 = insets.left;
                        break;
                    }
                    case 1: {
                        n2 = (dimension.width - dimension2.width >> 1) + insets.left - insets.right;
                        break;
                    }
                    case 2: {
                        n2 = insets.left;
                        dimension2.width = dimension.width - insets.left - insets.right;
                        break;
                    }
                    case 4: {
                        n2 = dimension.width - dimension2.width - insets.right;
                    }
                }
                componentArray[i2].setBounds(n2, n3, dimension2.width, dimension2.height);
                n3 += dimension2.height + this.gap;
            }
        } else {
            for (int i3 = 0; i3 < componentArray.length; ++i3) {
                Dimension dimension3 = componentArray[i3].getPreferredSize();
                switch (this.justification) {
                    case 0: {
                        n3 = insets.top;
                        break;
                    }
                    case 1: {
                        n3 = (dimension.height - dimension3.height >> 1) + insets.top - insets.bottom;
                        break;
                    }
                    case 2: {
                        n3 = insets.top;
                        dimension3.height = dimension.height - insets.top - insets.bottom;
                        break;
                    }
                    case 3: {
                        n3 = dimension.height - dimension3.height - insets.bottom;
                    }
                }
                componentArray[i3].setBounds(n2, n3, dimension3.width, dimension3.height);
                n2 += dimension3.width + this.gap;
            }
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        Component[] componentArray = container.getComponents();
        if (this.orientation == 0) {
            for (n2 = 0; n2 < componentArray.length; ++n2) {
                Dimension dimension = componentArray[n2].getPreferredSize();
                if (n3 < dimension.width) {
                    n3 = dimension.width;
                }
                n4 += dimension.height + this.gap;
            }
            n4 -= this.gap;
        } else {
            for (n2 = 0; n2 < componentArray.length; ++n2) {
                Dimension dimension = componentArray[n2].getPreferredSize();
                n3 += dimension.width + this.gap;
                if (n4 >= dimension.height) continue;
                n4 = dimension.height;
            }
            n3 -= this.gap;
        }
        Insets insets = container.getInsets();
        return new Dimension(n3 += insets.left + insets.right, n4 += insets.top + insets.bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        Component[] componentArray = container.getComponents();
        if (this.orientation == 0) {
            for (n2 = 0; n2 < componentArray.length; ++n2) {
                Dimension dimension = componentArray[n2].getMinimumSize();
                if (n3 < dimension.width) {
                    n3 = dimension.width;
                }
                n4 += dimension.height + this.gap;
            }
            n4 -= this.gap;
        } else {
            for (n2 = 0; n2 < componentArray.length; ++n2) {
                Dimension dimension = componentArray[n2].getMinimumSize();
                n3 += dimension.width + this.gap;
                if (n4 >= dimension.height) continue;
                n4 = dimension.height;
            }
            n3 = -this.gap;
        }
        Insets insets = container.getInsets();
        return new Dimension(n3 += insets.left + insets.right, n4 += insets.top + insets.bottom);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }
}

