/*
 * Decompiled with CFR 0.152.
 */
package info.clearthought.layout;

import info.clearthought.layout.TableLayoutConstants;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class TableLayout
implements LayoutManager2,
Serializable,
TableLayoutConstants {
    protected static final double[][] defaultSize = new double[][]{new double[0], new double[0]};
    protected static final int C = 0;
    protected static final int R = 1;
    protected static boolean checkForComponentOrientationSupport = true;
    protected static Method methodGetComponentOrientation;
    protected double[][] crSpec = new double[][]{null, null};
    protected int[][] crSize = new int[][]{null, null};
    protected int[][] crOffset = new int[][]{null, null};
    protected LinkedList list;
    protected boolean dirty;
    protected int oldWidth;
    protected int oldHeight;
    protected int hGap;
    protected int vGap;

    public TableLayout() {
        this.init(defaultSize[0], defaultSize[1]);
    }

    public TableLayout(double[][] dArray) {
        if (dArray == null || dArray.length != 2) {
            throw new IllegalArgumentException("Parameter size should be an array, a[2], where a[0] is the is an array of column widths and a[1] is an array or row heights.");
        }
        this.init(dArray[0], dArray[1]);
    }

    public TableLayout(double[] dArray, double[] dArray2) {
        this.init(dArray, dArray2);
    }

    protected void init(double[] dArray, double[] dArray2) {
        int n2;
        if (dArray == null) {
            throw new IllegalArgumentException("Parameter col cannot be null");
        }
        if (dArray2 == null) {
            throw new IllegalArgumentException("Parameter row cannot be null");
        }
        this.crSpec[0] = new double[dArray.length];
        this.crSpec[1] = new double[dArray2.length];
        System.arraycopy(dArray, 0, this.crSpec[0], 0, this.crSpec[0].length);
        System.arraycopy(dArray2, 0, this.crSpec[1], 0, this.crSpec[1].length);
        for (n2 = 0; n2 < this.crSpec[0].length; ++n2) {
            if (!(this.crSpec[0][n2] < 0.0) || this.crSpec[0][n2] == -1.0 || this.crSpec[0][n2] == -2.0 || this.crSpec[0][n2] == -3.0) continue;
            this.crSpec[0][n2] = 0.0;
        }
        for (n2 = 0; n2 < this.crSpec[1].length; ++n2) {
            if (!(this.crSpec[1][n2] < 0.0) || this.crSpec[1][n2] == -1.0 || this.crSpec[1][n2] == -2.0 || this.crSpec[1][n2] == -3.0) continue;
            this.crSpec[1][n2] = 0.0;
        }
        this.list = new LinkedList();
        this.dirty = true;
    }

    public TableLayoutConstraints getConstraints(Component component) {
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.component != component) continue;
            return new TableLayoutConstraints(entry.cr1[0], entry.cr1[1], entry.cr2[0], entry.cr2[1], entry.alignment[0], entry.alignment[1]);
        }
        return null;
    }

    public void setConstraints(Component component, TableLayoutConstraints tableLayoutConstraints) {
        if (component == null) {
            throw new IllegalArgumentException("Parameter component cannot be null.");
        }
        if (tableLayoutConstraints == null) {
            throw new IllegalArgumentException("Parameter constraint cannot be null.");
        }
        ListIterator<Entry> listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.component != component) continue;
            listIterator.set(new Entry(component, tableLayoutConstraints));
        }
    }

    public void setColumn(double[] dArray) {
        this.setCr(0, dArray);
    }

    public void setRow(double[] dArray) {
        this.setCr(1, dArray);
    }

    protected void setCr(int n2, double[] dArray) {
        this.crSpec[n2] = new double[dArray.length];
        System.arraycopy(dArray, 0, this.crSpec[n2], 0, this.crSpec[n2].length);
        for (int i2 = 0; i2 < this.crSpec[n2].length; ++i2) {
            if (!(this.crSpec[n2][i2] < 0.0) || this.crSpec[n2][i2] == -1.0 || this.crSpec[n2][i2] == -2.0 || this.crSpec[n2][i2] == -3.0) continue;
            this.crSpec[n2][i2] = 0.0;
        }
        this.dirty = true;
    }

    public void setColumn(int n2, double d2) {
        this.setCr(0, n2, d2);
    }

    public void setRow(int n2, double d2) {
        this.setCr(1, n2, d2);
    }

    protected void setCr(int n2, int n3, double d2) {
        if (d2 < 0.0 && d2 != -1.0 && d2 != -2.0 && d2 != -3.0) {
            d2 = 0.0;
        }
        this.crSpec[n2][n3] = d2;
        this.dirty = true;
    }

    public double[] getColumn() {
        double[] dArray = new double[this.crSpec[0].length];
        System.arraycopy(this.crSpec[0], 0, dArray, 0, dArray.length);
        return dArray;
    }

    public double[] getRow() {
        double[] dArray = new double[this.crSpec[1].length];
        System.arraycopy(this.crSpec[1], 0, dArray, 0, dArray.length);
        return dArray;
    }

    public double getColumn(int n2) {
        return this.crSpec[0][n2];
    }

    public double getRow(int n2) {
        return this.crSpec[1][n2];
    }

    public int getNumColumn() {
        return this.crSpec[0].length;
    }

    public int getNumRow() {
        return this.crSpec[1].length;
    }

    public int getHGap() {
        return this.hGap;
    }

    public int getVGap() {
        return this.vGap;
    }

    public void setHGap(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Parameter hGap must be non-negative.");
        }
        this.hGap = n2;
    }

    public void setVGap(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Parameter vGap must be non-negative.");
        }
        this.vGap = n2;
    }

    public void insertColumn(int n2, double d2) {
        this.insertCr(0, n2, d2);
    }

    public void insertRow(int n2, double d2) {
        this.insertCr(1, n2, d2);
    }

    public void insertCr(int n2, int n3, double d2) {
        if (n3 < 0 || n3 > this.crSpec[n2].length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n3 + ".  Valid range is [0, " + this.crSpec[n2].length + "].");
        }
        if (d2 < 0.0 && d2 != -1.0 && d2 != -2.0 && d2 != -3.0) {
            d2 = 0.0;
        }
        double[] dArray = new double[this.crSpec[n2].length + 1];
        System.arraycopy(this.crSpec[n2], 0, dArray, 0, n3);
        System.arraycopy(this.crSpec[n2], n3, dArray, n3 + 1, this.crSpec[n2].length - n3);
        dArray[n3] = d2;
        this.crSpec[n2] = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.cr1[n2] >= n3) {
                int n4 = n2;
                entry.cr1[n4] = entry.cr1[n4] + 1;
            }
            if (entry.cr2[n2] < n3) continue;
            int n5 = n2;
            entry.cr2[n5] = entry.cr2[n5] + 1;
        }
        this.dirty = true;
    }

    public void deleteColumn(int n2) {
        this.deleteCr(0, n2);
    }

    public void deleteRow(int n2) {
        this.deleteCr(1, n2);
    }

    protected void deleteCr(int n2, int n3) {
        if (n3 < 0 || n3 >= this.crSpec[n2].length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n3 + ".  Valid range is [0, " + (this.crSpec[n2].length - 1) + "].");
        }
        double[] dArray = new double[this.crSpec[n2].length - 1];
        System.arraycopy(this.crSpec[n2], 0, dArray, 0, n3);
        System.arraycopy(this.crSpec[n2], n3 + 1, dArray, n3, this.crSpec[n2].length - n3 - 1);
        this.crSpec[n2] = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.cr1[n2] > n3) {
                int n4 = n2;
                entry.cr1[n4] = entry.cr1[n4] - 1;
            }
            if (entry.cr2[n2] <= n3) continue;
            int n5 = n2;
            entry.cr2[n5] = entry.cr2[n5] - 1;
        }
        this.dirty = true;
    }

    public String toString() {
        int n2;
        String string = "TableLayout {{";
        if (this.crSpec[0].length > 0) {
            for (n2 = 0; n2 < this.crSpec[0].length - 1; ++n2) {
                string = string + this.crSpec[0][n2] + ", ";
            }
            string = string + this.crSpec[0][this.crSpec[0].length - 1] + "}, {";
        } else {
            string = string + "}, {";
        }
        if (this.crSpec[1].length > 0) {
            for (n2 = 0; n2 < this.crSpec[1].length - 1; ++n2) {
                string = string + this.crSpec[1][n2] + ", ";
            }
            string = string + this.crSpec[1][this.crSpec[1].length - 1] + "}}";
        } else {
            string = string + "}}";
        }
        return string;
    }

    public List getInvalidEntry() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            ListIterator listIterator = this.list.listIterator(0);
            while (listIterator.hasNext()) {
                Entry entry = (Entry)listIterator.next();
                if (entry.cr1[1] >= 0 && entry.cr1[0] >= 0 && entry.cr2[1] < this.crSpec[1].length && entry.cr2[0] < this.crSpec[0].length) continue;
                linkedList.add(entry.copy());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Unexpected CloneNotSupportedException");
        }
        return linkedList;
    }

    public List getOverlappingEntry() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            int n2 = this.list.size();
            if (n2 == 0) {
                return linkedList;
            }
            Entry[] entryArray = this.list.toArray(new Entry[n2]);
            for (int i2 = 1; i2 < n2; ++i2) {
                for (int i3 = i2 - 1; i3 >= 0; --i3) {
                    if ((entryArray[i3].cr1[0] < entryArray[i2].cr1[0] || entryArray[i3].cr1[0] > entryArray[i2].cr2[0] || entryArray[i3].cr1[1] < entryArray[i2].cr1[1] || entryArray[i3].cr1[1] > entryArray[i2].cr2[1]) && (entryArray[i3].cr2[0] < entryArray[i2].cr1[0] || entryArray[i3].cr2[0] > entryArray[i2].cr2[0] || entryArray[i3].cr2[1] < entryArray[i2].cr1[1] || entryArray[i3].cr2[1] > entryArray[i2].cr2[1])) continue;
                    linkedList.add(entryArray[i3].copy());
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Unexpected CloneNotSupportedException");
        }
        return linkedList;
    }

    protected void calculateSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n2 = dimension.width - insets.left - insets.right;
        int n3 = dimension.height - insets.top - insets.bottom;
        if (this.crSpec[0].length > 0) {
            n2 -= this.hGap * (this.crSpec[0].length - 1);
        }
        if (this.crSpec[1].length > 0) {
            n3 -= this.vGap * (this.crSpec[1].length - 1);
        }
        this.crSize[0] = new int[this.crSpec[0].length];
        this.crSize[1] = new int[this.crSpec[1].length];
        n2 = this.assignAbsoluteSize(0, n2);
        n3 = this.assignAbsoluteSize(1, n3);
        n2 = this.assignPrefMinSize(0, n2, -3.0);
        n2 = this.assignPrefMinSize(0, n2, -2.0);
        n3 = this.assignPrefMinSize(1, n3, -3.0);
        n3 = this.assignPrefMinSize(1, n3, -2.0);
        n2 = this.assignRelativeSize(0, n2);
        n3 = this.assignRelativeSize(1, n3);
        this.assignFillSize(0, n2);
        this.assignFillSize(1, n3);
        this.calculateOffset(0, insets);
        this.calculateOffset(1, insets);
        this.dirty = false;
        this.oldWidth = dimension.width;
        this.oldHeight = dimension.height;
    }

    protected int assignAbsoluteSize(int n2, int n3) {
        int n4 = this.crSpec[n2].length;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!(this.crSpec[n2][i2] >= 1.0) && this.crSpec[n2][i2] != 0.0) continue;
            this.crSize[n2][i2] = (int)(this.crSpec[n2][i2] + 0.5);
            n3 -= this.crSize[n2][i2];
        }
        return n3;
    }

    protected int assignRelativeSize(int n2, int n3) {
        int n4 = n3 < 0 ? 0 : n3;
        int n5 = this.crSpec[n2].length;
        for (int i2 = 0; i2 < n5; ++i2) {
            if (!(this.crSpec[n2][i2] > 0.0) || !(this.crSpec[n2][i2] < 1.0)) continue;
            this.crSize[n2][i2] = (int)(this.crSpec[n2][i2] * (double)n4 + 0.5);
            n3 -= this.crSize[n2][i2];
        }
        return n3;
    }

    protected void assignFillSize(int n2, int n3) {
        int n4;
        int n5;
        if (n3 <= 0) {
            return;
        }
        int n6 = 0;
        int n7 = this.crSpec[n2].length;
        for (n5 = 0; n5 < n7; ++n5) {
            if (this.crSpec[n2][n5] != -1.0) continue;
            ++n6;
        }
        n5 = n3;
        for (n4 = 0; n4 < n7; ++n4) {
            if (this.crSpec[n2][n4] != -1.0) continue;
            this.crSize[n2][n4] = n3 / n6;
            n5 -= this.crSize[n2][n4];
        }
        for (n4 = n7 - 1; n4 >= 0 && n5 > 0; --n4) {
            if (this.crSpec[n2][n4] != -1.0) continue;
            int[] nArray = this.crSize[n2];
            int n8 = n4;
            nArray[n8] = nArray[n8] + 1;
            --n5;
        }
    }

    protected void calculateOffset(int n2, Insets insets) {
        int n3 = this.crSpec[n2].length;
        this.crOffset[n2] = new int[n3 + 1];
        this.crOffset[n2][0] = n2 == 0 ? insets.left : insets.top;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.crOffset[n2][i2 + 1] = this.crOffset[n2][i2] + this.crSize[n2][i2];
        }
    }

    protected int assignPrefMinSize(int n2, int n3, double d2) {
        int n4 = this.crSpec[n2].length;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (this.crSpec[n2][i2] != d2) continue;
            int n5 = 0;
            ListIterator listIterator = this.list.listIterator(0);
            block1: while (listIterator.hasNext()) {
                int n6;
                Dimension dimension;
                Entry entry = (Entry)listIterator.next();
                if (entry.cr1[n2] < 0 || entry.cr2[n2] >= n4 || entry.cr1[n2] > i2 || entry.cr2[n2] < i2) continue;
                Dimension dimension2 = dimension = d2 == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize();
                int n7 = dimension == null ? 0 : (n2 == 0 ? dimension.width : dimension.height);
                int n8 = 0;
                if (d2 == -2.0) {
                    for (n6 = entry.cr1[n2]; n6 <= entry.cr2[n2]; ++n6) {
                        if (this.crSpec[n2][n6] >= 0.0 || this.crSpec[n2][n6] == -3.0) {
                            n7 -= this.crSize[n2][n6];
                            continue;
                        }
                        if (this.crSpec[n2][n6] == -2.0) {
                            ++n8;
                            continue;
                        }
                        if (this.crSpec[n2][n6] == -1.0) continue block1;
                    }
                } else {
                    for (n6 = entry.cr1[n2]; n6 <= entry.cr2[n2]; ++n6) {
                        if (this.crSpec[n2][n6] >= 0.0) {
                            n7 -= this.crSize[n2][n6];
                            continue;
                        }
                        if (this.crSpec[n2][n6] == -2.0 || this.crSpec[n2][n6] == -3.0) {
                            ++n8;
                            continue;
                        }
                        if (this.crSpec[n2][n6] == -1.0) continue block1;
                    }
                }
                if (n5 >= (n7 = (int)Math.ceil((double)n7 / (double)n8))) continue;
                n5 = n7;
            }
            this.crSize[n2][i2] = n5;
            n3 -= n5;
        }
        return n3;
    }

    public void layoutContainer(Container container) {
        ComponentOrientation componentOrientation;
        Dimension dimension = container.getSize();
        if (this.dirty || dimension.width != this.oldWidth || dimension.height != this.oldHeight) {
            this.calculateSize(container);
        }
        boolean bl2 = (componentOrientation = this.getComponentOrientation(container)) != null && !componentOrientation.isLeftToRight();
        Insets insets = container.getInsets();
        Component[] componentArray = container.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            try {
                Object object;
                ListIterator listIterator = this.list.listIterator(0);
                Entry entry = null;
                while (listIterator.hasNext()) {
                    entry = (Entry)listIterator.next();
                    if (entry.component == componentArray[i2]) break;
                    entry = null;
                }
                if (entry == null) {
                    componentArray[i2].setBounds(0, 0, 0, 0);
                    continue;
                }
                int n2 = 0;
                int n3 = 0;
                if (entry.alignment[0] != 2 || entry.alignment[1] != 2) {
                    object = componentArray[i2].getPreferredSize();
                    n2 = ((Dimension)object).width;
                    n3 = ((Dimension)object).height;
                }
                object = this.calculateSizeAndOffset(entry, n2, true);
                Object object2 = object[0];
                Object object3 = object[1];
                object = this.calculateSizeAndOffset(entry, n3, false);
                Object object4 = object[0];
                Object object5 = object[1];
                if (bl2) {
                    object2 = dimension.width - object2 - object3 + insets.left - insets.right;
                }
                componentArray[i2].setBounds((int)object2, (int)object4, (int)object3, (int)object5);
                continue;
            }
            catch (Exception exception) {
                componentArray[i2].setBounds(0, 0, 0, 0);
            }
        }
    }

    protected ComponentOrientation getComponentOrientation(Container container) {
        ComponentOrientation componentOrientation = null;
        try {
            if (checkForComponentOrientationSupport) {
                methodGetComponentOrientation = Class.forName("java.awt.Container").getMethod("getComponentOrientation", new Class[0]);
                checkForComponentOrientationSupport = false;
            }
            if (methodGetComponentOrientation != null) {
                componentOrientation = (ComponentOrientation)methodGetComponentOrientation.invoke((Object)container, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return componentOrientation;
    }

    protected int[] calculateSizeAndOffset(Entry entry, int n2, boolean bl2) {
        int n3;
        int n4;
        int[] nArray = bl2 ? this.crOffset[0] : this.crOffset[1];
        int n5 = bl2 ? entry.alignment[0] : entry.alignment[1];
        int n6 = bl2 ? nArray[entry.cr2[0] + 1] - nArray[entry.cr1[0]] : nArray[entry.cr2[1] + 1] - nArray[entry.cr1[1]];
        int n7 = n5 == 2 || n6 < n2 ? n6 : n2;
        if (bl2 && n5 == 4) {
            n5 = 0;
        }
        if (bl2 && n5 == 5) {
            n5 = 3;
        }
        switch (n5) {
            case 0: {
                n4 = nArray[bl2 ? entry.cr1[0] : entry.cr1[1]];
                break;
            }
            case 3: {
                n4 = nArray[(bl2 ? entry.cr2[0] : entry.cr2[1]) + 1] - n7;
                break;
            }
            case 1: {
                n4 = nArray[bl2 ? entry.cr1[0] : entry.cr1[1]] + (n6 - n7 >> 1);
                break;
            }
            case 2: {
                n4 = nArray[bl2 ? entry.cr1[0] : entry.cr1[1]];
                break;
            }
            default: {
                n4 = 0;
            }
        }
        if (bl2) {
            n4 += this.hGap * entry.cr1[0];
            n3 = this.hGap * (entry.cr2[0] - entry.cr1[0]);
            switch (n5) {
                case 3: {
                    n4 += n3;
                    break;
                }
                case 1: {
                    n4 += n3 >> 1;
                    break;
                }
                case 2: {
                    n7 += n3;
                }
            }
        } else {
            n4 += this.vGap * entry.cr1[1];
            n3 = this.vGap * (entry.cr2[1] - entry.cr1[1]);
            switch (n5) {
                case 3: {
                    n4 += n3;
                    break;
                }
                case 1: {
                    n4 += n3 >> 1;
                    break;
                }
                case 2: {
                    n7 += n3;
                }
            }
        }
        int[] nArray2 = new int[]{n4, n7};
        return nArray2;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calculateLayoutSize(container, -2.0);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calculateLayoutSize(container, -3.0);
    }

    protected Dimension calculateLayoutSize(Container container, double d2) {
        int n2;
        Entry[] entryArray = this.list.toArray(new Entry[this.list.size()]);
        int n3 = entryArray.length;
        Dimension[] dimensionArray = new Dimension[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dimensionArray[n2] = d2 == -2.0 ? entryArray[n2].component.getPreferredSize() : entryArray[n2].component.getMinimumSize();
        }
        n2 = this.calculateLayoutSize(container, 0, d2, entryArray, dimensionArray);
        int n4 = this.calculateLayoutSize(container, 1, d2, entryArray, dimensionArray);
        Insets insets = container.getInsets();
        return new Dimension(n2 += insets.left + insets.right, n4 += insets.top + insets.bottom);
    }

    protected int calculateLayoutSize(Container container, int n2, double d2, Entry[] entryArray, Dimension[] dimensionArray) {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = this.crSpec[n2].length;
        double d3 = 1.0;
        int n7 = 0;
        for (n4 = 0; n4 < n6; ++n4) {
            if (this.crSpec[n2][n4] > 0.0 && this.crSpec[n2][n4] < 1.0) {
                d3 -= this.crSpec[n2][n4];
                continue;
            }
            if (this.crSpec[n2][n4] != -1.0) continue;
            ++n7;
        }
        if (n7 > 1) {
            d3 /= (double)n7;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        this.crSize[n2] = new int[n6];
        this.assignAbsoluteSize(n2, 0);
        this.assignPrefMinSize(n2, 0, -3.0);
        this.assignPrefMinSize(n2, 0, -2.0);
        int[] nArray = new int[n6];
        for (n4 = 0; n4 < n6; ++n4) {
            if (this.crSpec[n2][n4] != -2.0 && this.crSpec[n2][n4] != -3.0) continue;
            nArray[n4] = this.crSize[n2][n4];
        }
        int n8 = this.crSpec[0].length;
        int n9 = this.crSpec[1].length;
        int n10 = entryArray.length;
        for (n3 = 0; n3 < n10; ++n3) {
            Entry entry = entryArray[n3];
            if (entry.cr1[0] < 0 || entry.cr1[0] >= n8 || entry.cr2[0] >= n8 || entry.cr1[1] < 0 || entry.cr1[1] >= n9 || entry.cr2[1] >= n9) continue;
            Dimension dimension = dimensionArray[n3];
            int n11 = n2 == 0 ? dimension.width : dimension.height;
            for (n4 = entry.cr1[n2]; n4 <= entry.cr2[n2]; ++n4) {
                if (this.crSpec[n2][n4] >= 1.0) {
                    n11 = (int)((double)n11 - this.crSpec[n2][n4]);
                    continue;
                }
                if (this.crSpec[n2][n4] != -2.0 && this.crSpec[n2][n4] != -3.0) continue;
                n11 -= nArray[n4];
            }
            double d4 = 0.0;
            for (n4 = entry.cr1[n2]; n4 <= entry.cr2[n2]; ++n4) {
                if (this.crSpec[n2][n4] > 0.0 && this.crSpec[n2][n4] < 1.0) {
                    d4 += this.crSpec[n2][n4];
                    continue;
                }
                if (this.crSpec[n2][n4] != -1.0 || d3 == 0.0) continue;
                d4 += d3;
            }
            int n12 = d4 == 0.0 ? 0 : (int)((double)n11 / d4 + 0.5);
            if (n5 >= n12) continue;
            n5 = n12;
        }
        n3 = n5;
        for (n4 = 0; n4 < n6; ++n4) {
            if (this.crSpec[n2][n4] >= 1.0) {
                n3 += (int)(this.crSpec[n2][n4] + 0.5);
                continue;
            }
            if (this.crSpec[n2][n4] != -2.0 && this.crSpec[n2][n4] != -3.0) continue;
            n3 += nArray[n4];
        }
        if (n6 > 0) {
            n3 += (n2 == 0 ? this.hGap : this.vGap) * (n6 - 1);
        }
        return n3;
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String) {
            object = new TableLayoutConstraints((String)object);
            this.list.add(new Entry(component, (TableLayoutConstraints)object));
            this.dirty = true;
        } else if (object instanceof TableLayoutConstraints) {
            this.list.add(new Entry(component, (TableLayoutConstraints)object));
            this.dirty = true;
        } else {
            if (object == null) {
                throw new IllegalArgumentException("No constraint for the component");
            }
            throw new IllegalArgumentException("Cannot accept a constraint of class " + object.getClass());
        }
    }

    public void removeLayoutComponent(Component component) {
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.component != component) continue;
            listIterator.remove();
        }
        this.dirty = true;
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
        this.dirty = true;
    }

    public static class Entry
    implements Cloneable {
        public Component component;
        public int[] cr1;
        public int[] cr2;
        public int[] alignment;

        public Entry(Component component, TableLayoutConstraints tableLayoutConstraints) {
            int[] nArray = new int[]{tableLayoutConstraints.col1, tableLayoutConstraints.row1};
            int[] nArray2 = new int[]{tableLayoutConstraints.col2, tableLayoutConstraints.row2};
            int[] nArray3 = new int[]{tableLayoutConstraints.hAlign, tableLayoutConstraints.vAlign};
            this.cr1 = nArray;
            this.cr2 = nArray2;
            this.alignment = nArray3;
            this.component = component;
        }

        public Object copy() throws CloneNotSupportedException {
            return this.clone();
        }

        public String toString() {
            TableLayoutConstraints tableLayoutConstraints = new TableLayoutConstraints(this.cr1[0], this.cr1[1], this.cr2[0], this.cr2[1], this.alignment[0], this.alignment[1]);
            return "(" + tableLayoutConstraints + ") " + this.component;
        }
    }
}

