/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");

    public static Hashtable<String, String[]> parseQueryString(String s2) {
        String[] valArray = null;
        if (s2 == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s2, "&");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            String key = HttpUtils.parseName(pair.substring(0, pos), sb);
            String val = HttpUtils.parseName(pair.substring(pos + 1, pair.length()), sb);
            if (ht.containsKey(key)) {
                String[] oldVals = ht.get(key);
                valArray = new String[oldVals.length + 1];
                for (int i2 = 0; i2 < oldVals.length; ++i2) {
                    valArray[i2] = oldVals[i2];
                }
                valArray[oldVals.length] = val;
            } else {
                valArray = new String[]{val};
            }
            ht.put(key, valArray);
        }
        return ht;
    }

    public static Hashtable<String, String[]> parsePostData(int len, ServletInputStream in) {
        if (len <= 0) {
            return new Hashtable<String, String[]>();
        }
        if (in == null) {
            throw new IllegalArgumentException();
        }
        byte[] postedBytes = new byte[len];
        try {
            int inputLen;
            int offset = 0;
            do {
                if ((inputLen = in.read(postedBytes, offset, len - offset)) > 0) continue;
                String msg = lStrings.getString("err.io.short_read");
                throw new IllegalArgumentException(msg);
            } while (len - (offset += inputLen) > 0);
        }
        catch (IOException e2) {
            throw new IllegalArgumentException(e2.getMessage());
        }
        try {
            String postedBody = new String(postedBytes, 0, len, "8859_1");
            return HttpUtils.parseQueryString(postedBody);
        }
        catch (UnsupportedEncodingException e3) {
            throw new IllegalArgumentException(e3.getMessage());
        }
    }

    private static String parseName(String s2, StringBuffer sb) {
        sb.setLength(0);
        block7: for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            switch (c2) {
                case '+': {
                    sb.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s2.substring(i2 + 1, i2 + 3), 16));
                        i2 += 2;
                        continue block7;
                    }
                    catch (NumberFormatException e2) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException e3) {
                        String rest = s2.substring(i2);
                        sb.append(rest);
                        if (rest.length() != 2) continue block7;
                        ++i2;
                        continue block7;
                    }
                }
                default: {
                    sb.append(c2);
                }
            }
        }
        return sb.toString();
    }

    public static StringBuffer getRequestURL(HttpServletRequest req) {
        StringBuffer url = new StringBuffer();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        String urlPath = req.getRequestURI();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(req.getServerPort());
        }
        url.append(urlPath);
        return url;
    }
}

