/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antserver.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.antcontrib.antserver.Command;
import net.sf.antcontrib.antserver.Response;
import net.sf.antcontrib.antserver.client.Client;
import net.sf.antcontrib.antserver.commands.RunAntCommand;
import net.sf.antcontrib.antserver.commands.RunTargetCommand;
import net.sf.antcontrib.antserver.commands.SendFileCommand;
import net.sf.antcontrib.antserver.commands.ShutdownCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClientTask
extends Task {
    private String machine = "localhost";
    private int port = 17000;
    private Vector commands = new Vector();
    private boolean persistant = false;
    private boolean failOnError = true;

    public void setMachine(String machine) {
        this.machine = machine;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPersistant(boolean persistant) {
        this.persistant = persistant;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void addConfiguredShutdown(ShutdownCommand cmd) {
        this.commands.add(cmd);
    }

    public void addConfiguredRunTarget(RunTargetCommand cmd) {
        this.commands.add(cmd);
    }

    public void addConfiguredRunAnt(RunAntCommand cmd) {
        this.commands.add(cmd);
    }

    public void addConfiguredSendFile(SendFileCommand cmd) {
        this.commands.add(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Enumeration e2 = this.commands.elements();
        Command c2 = null;
        while (e2.hasMoreElements()) {
            c2 = (Command)e2.nextElement();
            c2.validate(this.getProject());
        }
        Client client = new Client(this.getProject(), this.machine, this.port);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db2 = dbf.newDocumentBuilder();
            try {
                int failCount = 0;
                client.connect();
                e2 = this.commands.elements();
                c2 = null;
                Response r2 = null;
                Document d2 = null;
                boolean keepGoing = true;
                while (e2.hasMoreElements() && keepGoing) {
                    c2 = (Command)e2.nextElement();
                    r2 = client.sendCommand(c2);
                    if (!r2.isSucceeded()) {
                        ++failCount;
                        this.log("Command caused a build failure:" + c2, 0);
                        this.log(r2.getErrorMessage(), 0);
                        this.log(r2.getErrorStackTrace(), 4);
                        if (!this.persistant) {
                            keepGoing = false;
                        }
                    }
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(r2.getResultsXml().getBytes());
                        d2 = db2.parse(bais);
                        NodeList nl = d2.getElementsByTagName("target");
                        int len = nl.getLength();
                        Element element = null;
                        for (int i2 = 0; i2 < len; ++i2) {
                            element = (Element)nl.item(i2);
                            this.getProject().log("[" + element.getAttribute("name") + "]", 2);
                        }
                    }
                    catch (SAXException se) {
                        // empty catch block
                    }
                    if (!(c2 instanceof ShutdownCommand)) continue;
                    keepGoing = false;
                    client.shutdown();
                }
                if (failCount > 0 && this.failOnError) {
                    throw new BuildException("One or more commands failed.");
                }
            }
            finally {
                if (client != null) {
                    client.disconnect();
                }
            }
        }
        catch (ParserConfigurationException ex2) {
            throw new BuildException(ex2);
        }
        catch (IOException ex3) {
            throw new BuildException(ex3);
        }
    }
}

