/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antserver.server;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConnectionBuildListener
implements BuildListener {
    private Document results;
    private Stack elementStack;
    private ThreadGroup group = Thread.currentThread().getThreadGroup();

    public ConnectionBuildListener() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.results = builder.newDocument();
        this.elementStack = new Stack();
        Element rootElement = this.results.createElement("results");
        this.elementStack.push(rootElement);
        this.results.appendChild(rootElement);
    }

    public Document getDocument() {
        return this.results;
    }

    public void buildStarted(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
        if (Thread.currentThread().getThreadGroup() != this.group) {
            return;
        }
        Element parent = (Element)this.elementStack.peek();
        Element myElement = this.results.createElement("target");
        myElement.setAttribute("name", event.getTarget().getName());
        parent.appendChild(myElement);
        this.elementStack.push(myElement);
    }

    public void targetFinished(BuildEvent event) {
        Throwable t2;
        if (Thread.currentThread().getThreadGroup() != this.group) {
            return;
        }
        Element myElement = (Element)this.elementStack.peek();
        String message = event.getMessage();
        if (message != null) {
            myElement.setAttribute("message", message);
        }
        if ((t2 = event.getException()) != null) {
            myElement.setAttribute("status", "failure");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            t2.printStackTrace(ps);
            ps.flush();
            String errorMessage = t2.getMessage();
            String stackTrace = baos.toString();
            Element error = this.results.createElement("error");
            Element errorMsgElement = this.results.createElement("message");
            errorMsgElement.appendChild(this.results.createTextNode(errorMessage));
            Element stackElement = this.results.createElement("stack");
            stackElement.appendChild(this.results.createCDATASection(stackTrace));
            error.appendChild(errorMsgElement);
            error.appendChild(stackElement);
            myElement.appendChild(error);
        } else {
            myElement.setAttribute("status", "success");
        }
        this.elementStack.pop();
    }

    public void taskStarted(BuildEvent event) {
        if (Thread.currentThread().getThreadGroup() != this.group) {
            return;
        }
        Element parent = (Element)this.elementStack.peek();
        Element myElement = this.results.createElement("task");
        myElement.setAttribute("name", event.getTask().getTaskName());
        parent.appendChild(myElement);
        this.elementStack.push(myElement);
    }

    public void taskFinished(BuildEvent event) {
        if (Thread.currentThread().getThreadGroup() != this.group) {
            return;
        }
        Element myElement = (Element)this.elementStack.peek();
        Throwable t2 = event.getException();
        if (t2 != null) {
            myElement.setAttribute("status", "failure");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            t2.printStackTrace(ps);
            ps.flush();
            String errorMessage = t2.getMessage();
            String stackTrace = baos.toString();
            Element error = this.results.createElement("error");
            Element errorMsgElement = this.results.createElement("message");
            errorMsgElement.appendChild(this.results.createTextNode(errorMessage));
            Element stackElement = this.results.createElement("stack");
            stackElement.appendChild(this.results.createCDATASection(stackTrace));
            error.appendChild(errorMsgElement);
            error.appendChild(stackElement);
            myElement.appendChild(error);
        } else {
            myElement.setAttribute("status", "success");
        }
        this.elementStack.pop();
    }

    public void messageLogged(BuildEvent event) {
    }
}

