/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antserver.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import net.sf.antcontrib.antserver.Command;
import net.sf.antcontrib.antserver.Response;
import net.sf.antcontrib.antserver.Util;
import net.sf.antcontrib.antserver.commands.DisconnectCommand;
import net.sf.antcontrib.antserver.commands.ShutdownCommand;
import net.sf.antcontrib.antserver.server.ConnectionBuildListener;
import net.sf.antcontrib.antserver.server.ServerTask;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;

public class ConnectionHandler
implements Runnable {
    private static long nextGroupId = 0L;
    private ServerTask task;
    private Socket socket;
    private Thread thread;
    private Throwable thrown;

    public ConnectionHandler(ServerTask task, Socket socket) {
        this.socket = socket;
        this.task = task;
    }

    public void start() {
        long gid = nextGroupId;
        nextGroupId = nextGroupId == Long.MAX_VALUE ? 0L : ++nextGroupId;
        ThreadGroup group = new ThreadGroup("server-tg-" + gid);
        this.thread = new Thread(group, this);
        this.thread.start();
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        InputStream is = null;
        OutputStream os = null;
        try {
            ConnectionBuildListener cbl = null;
            is = this.socket.getInputStream();
            os = this.socket.getOutputStream();
            ObjectInputStream ois = new ObjectInputStream(is);
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(new Response());
            boolean disconnect = false;
            Command inputCommand = null;
            Response response = null;
            while (!disconnect) {
                this.task.getProject().log("Reading command object.", 4);
                inputCommand = (Command)ois.readObject();
                this.task.getProject().log("Executing command object: " + inputCommand, 4);
                response = new Response();
                try {
                    cbl = new ConnectionBuildListener();
                    this.task.getProject().addBuildListener(cbl);
                    inputCommand.execute(this.task.getProject(), inputCommand.getContentLength(), is);
                    response.setSucceeded(true);
                }
                catch (Throwable t2) {
                    response.setSucceeded(false);
                    response.setThrowable(t2);
                }
                finally {
                    if (cbl != null) {
                        this.task.getProject().removeBuildListener(cbl);
                    }
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLSerializer serial = new XMLSerializer();
                OutputFormat fmt = new OutputFormat();
                fmt.setOmitDocumentType(true);
                fmt.setOmitXMLDeclaration(false);
                serial.setOutputFormat(fmt);
                serial.setOutputByteStream((OutputStream)baos);
                serial.serialize(cbl.getDocument());
                response.setResultsXml(baos.toString());
                this.task.getProject().log("Executed command object: " + inputCommand, 4);
                this.task.getProject().log("Sending response: " + response, 4);
                response.setContentLength(inputCommand.getContentLength());
                oos.writeObject(response);
                if (inputCommand.getResponseContentLength() != 0L) {
                    Util.transferBytes(inputCommand.getReponseContentStream(), inputCommand.getResponseContentLength(), os, true);
                }
                if (inputCommand instanceof DisconnectCommand) {
                    disconnect = true;
                    this.task.getProject().log("Got disconnect command", 4);
                    continue;
                }
                if (!(inputCommand instanceof ShutdownCommand)) continue;
                disconnect = true;
                this.task.getProject().log("Got shutdown command", 4);
                this.task.shutdown();
            }
        }
        catch (ClassNotFoundException e2) {
            this.thrown = e2;
        }
        catch (IOException e3) {
            this.thrown = e3;
        }
        catch (Throwable t3) {
            this.thrown = t3;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e4) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e5) {}
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e6) {}
            }
        }
    }
}

