/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.design;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import net.sf.antcontrib.design.Depends;
import net.sf.antcontrib.design.Log;
import net.sf.antcontrib.design.Package;
import net.sf.antcontrib.design.VerifyDesign;
import net.sf.antcontrib.design.VerifyDesignDelegate;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;

public class Design {
    private Map nameToPackage = new HashMap();
    private Map packageNameToPackage = new HashMap();
    private boolean isCircularDesign;
    private Log log;
    private Location location;
    private String currentClass = null;
    private String currentPackageName = null;
    private Package currentAliasPackage = null;
    private HashSet primitives = new HashSet();

    public Design(boolean isCircularDesign, Log log, Location loc) {
        Package p2 = new Package();
        p2.setIncludeSubpackages(true);
        p2.setName("java");
        p2.setUsed(true);
        p2.setNeedDeclarations(false);
        p2.setPackage("java");
        this.addConfiguredPackage(p2);
        this.isCircularDesign = isCircularDesign;
        this.log = log;
        this.location = loc;
        this.primitives.add("boolean");
        this.primitives.add("byte");
        this.primitives.add("short");
        this.primitives.add("int");
        this.primitives.add("long");
        this.primitives.add("char");
        this.primitives.add("double");
        this.primitives.add("float");
    }

    public Package getPackage(String nameAttribute) {
        return (Package)this.nameToPackage.get(nameAttribute);
    }

    private Package retreivePack(String thePackage) {
        if (thePackage == null) {
            throw new IllegalArgumentException("Cannot retrieve null packages");
        }
        String currentPackage = thePackage;
        Package result = (Package)this.packageNameToPackage.get(currentPackage);
        while (!"default package".equals(currentPackage)) {
            this.log.log("p=" + currentPackage + "result=" + result, 4);
            if (result != null) {
                if (currentPackage.equals(thePackage)) {
                    return result;
                }
                if (result.isIncludeSubpackages()) {
                    return result;
                }
                return null;
            }
            currentPackage = VerifyDesignDelegate.getPackageName(currentPackage);
            result = (Package)this.packageNameToPackage.get(currentPackage);
        }
        if (result != null && result.isIncludeSubpackages()) {
            return result;
        }
        return null;
    }

    public void addConfiguredPackage(Package p2) {
        String pack = p2.getPackage();
        Depends[] depends = p2.getDepends();
        if (depends != null && !this.isCircularDesign) {
            for (int i2 = 0; i2 < depends.length; ++i2) {
                Package dependsPackage = (Package)this.nameToPackage.get(depends[i2].getName());
                if (dependsPackage != null) continue;
                throw new RuntimeException("package name=" + p2.getName() + " did not\n" + "have " + depends[i2] + " listed before it.  circularDesign is off\n" + "so package=" + p2.getName() + " must be moved up in the xml file");
            }
        }
        this.nameToPackage.put(p2.getName(), p2);
        this.packageNameToPackage.put(p2.getPackage(), p2);
    }

    public void verifyDependencyOk(String className) {
        this.log.log("         className=" + className, 4);
        if (className.startsWith("L")) {
            className = className.substring(1, className.length());
        }
        String classPackage = VerifyDesignDelegate.getPackageName(className);
        this.log.log("         classPackage=" + classPackage, 4);
        Package p2 = this.retreivePack(classPackage);
        if (p2 == null) {
            throw new BuildException(Design.getNoDefinitionError(className), this.location);
        }
        p2.setUsed(true);
        if (p2 != null && !p2.isNeedDeclarations()) {
            return;
        }
        String pack = this.currentAliasPackage.getPackage();
        this.log.log("         AllowedDepends=" + pack, 4);
        this.log.log("         CurrentDepends=" + className, 4);
        if (this.isClassInPackage(className, this.currentAliasPackage)) {
            return;
        }
        Depends[] depends = this.currentAliasPackage.getDepends();
        for (int i2 = 0; i2 < depends.length; ++i2) {
            Depends d2 = depends[i2];
            String name = d2.getName();
            Package temp = this.getPackage(name);
            this.log.log("         AllowedDepends=" + temp.getPackage(), 4);
            this.log.log("         CurrentDepends=" + className, 4);
            if (!this.isClassInPackage(className, temp)) continue;
            temp.setUsed(true);
            this.currentAliasPackage.addUsedDependency(d2);
            return;
        }
        this.log.log("***************************************", 4);
        this.log.log("***************************************", 4);
        throw new BuildException(Design.getErrorMessage(this.currentClass, className), this.location);
    }

    public boolean isClassInPackage(String className, Package p2) {
        String classPackage = VerifyDesignDelegate.getPackageName(className);
        return p2.isIncludeSubpackages() ? className.startsWith(p2.getPackage()) : classPackage.equals(p2.getPackage());
    }

    public boolean needEvalCurrentClass(String className) {
        this.currentClass = className;
        String packageName = VerifyDesignDelegate.getPackageName(className);
        if (!packageName.equals(this.currentPackageName) || this.currentAliasPackage == null) {
            this.currentPackageName = packageName;
            this.log.log("\nEvaluating package=" + this.currentPackageName, 2);
            this.currentAliasPackage = this.retreivePack(packageName);
            if (this.currentAliasPackage == null) {
                this.log.log("   class=" + className, 3);
                throw new BuildException(Design.getNoDefinitionError(className), this.location);
            }
            this.currentAliasPackage.setUsed(true);
        }
        this.log.log("   class=" + className, 3);
        if (!className.startsWith(this.currentPackageName)) {
            throw new RuntimeException("Internal Error");
        }
        return this.currentAliasPackage.getNeedDepends();
    }

    public String getCurrentClass() {
        return this.currentClass;
    }

    void checkClass(String dependsOn) {
        this.log.log("         dependsOn1=" + dependsOn, 4);
        if (dependsOn.endsWith("[]")) {
            int index = dependsOn.indexOf("[");
            dependsOn = dependsOn.substring(0, index);
            this.log.log("         dependsOn2=" + dependsOn, 4);
        }
        if (this.primitives.contains(dependsOn)) {
            return;
        }
        String tempTry = "java.lang." + dependsOn;
        try {
            Class<?> c2 = VerifyDesign.class.getClassLoader().loadClass(tempTry);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.verifyDependencyOk(dependsOn);
            return;
        }
    }

    public static String getErrorMessage(String className, String dependsOnClass) {
        String s2 = "\nYou are violating your own design....\nClass = " + className + " depends on\nClass = " + dependsOnClass + "\nThe dependency to allow this is not defined in your design" + "\nPackage=" + VerifyDesignDelegate.getPackageName(className) + " is not defined to depend on" + "\nPackage=" + VerifyDesignDelegate.getPackageName(dependsOnClass) + "\nChange the code or the design";
        return s2;
    }

    public static String getNoDefinitionError(String className) {
        String s2 = "\nPackage=" + VerifyDesignDelegate.getPackageName(className) + " is not defined in the design.\n" + "All packages with classes must be declared in the design file\n" + "Class found in the offending package=" + className;
        return s2;
    }

    public static String getWrapperMsg(File originalFile, String message) {
        String s2 = "\nThe file '" + originalFile.getAbsolutePath() + "' failed due to: " + message;
        return s2;
    }

    public void fillInUnusedPackages(Vector designErrors) {
        Collection values = this.nameToPackage.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            Package pack = (Package)iterator.next();
            if (!pack.isUsed()) {
                String msg = "Package name=" + pack.getName() + " is unused.  Full package=" + pack.getPackage();
                this.log.log(msg, 0);
                designErrors.add(new BuildException(msg));
                continue;
            }
            this.fillInUnusedDepends(designErrors, pack);
        }
    }

    private void fillInUnusedDepends(Vector designErrors, Package pack) {
        Iterator iterator = pack.getUnusedDepends().iterator();
        while (iterator.hasNext()) {
            Depends depends = (Depends)iterator.next();
            String msg = "Package name=" + pack.getName() + " has a dependency declared that is not true anymore.  Please erase the dependency <depends>" + depends.getName() + "</depends> from package=" + pack.getName();
            this.log.log(msg, 0);
            designErrors.add(new BuildException(msg));
        }
    }
}

