/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.design;

import net.sf.antcontrib.design.Design;
import net.sf.antcontrib.design.Log;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.EmptyVisitor;
import org.apache.bcel.generic.INSTANCEOF;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.PUTSTATIC;
import org.apache.bcel.generic.Type;

public class InstructionVisitor
extends EmptyVisitor {
    private ConstantPoolGen poolGen;
    private Log log;
    private Design design;

    public InstructionVisitor(ConstantPoolGen poolGen, Log log, Design d2) {
        this.poolGen = poolGen;
        this.log = log;
        this.design = d2;
    }

    public void visitCHECKCAST(CHECKCAST c2) {
        Type t2 = c2.getType(this.poolGen);
        this.log.log("         instr(checkcast)=" + t2, 4);
        String type = t2.toString();
        this.design.checkClass(type);
    }

    public void visitLoadInstruction(LoadInstruction l2) {
        Type t2 = l2.getType(this.poolGen);
        this.log.log("         instr(loadinstr)=" + t2, 4);
        String type = t2.toString();
        this.design.checkClass(type);
    }

    public void visitNEW(NEW n2) {
        Type t2 = n2.getType(this.poolGen);
        this.log.log("         instr(new)=" + t2, 4);
        String type = t2.toString();
        this.design.checkClass(type);
    }

    public void visitANEWARRAY(ANEWARRAY n2) {
        Type t2 = n2.getType(this.poolGen);
        this.log.log("         instr(anewarray)=" + t2, 4);
        String type = t2.toString();
        this.design.checkClass(type);
    }

    public void visitINSTANCEOF(INSTANCEOF i2) {
        Type t2 = i2.getType(this.poolGen);
        this.log.log("         instr(instanceof)=" + t2, 4);
        String type = t2.toString();
        this.design.checkClass(type);
    }

    public void visitINVOKESTATIC(INVOKESTATIC s2) {
        String t2 = s2.getClassName(this.poolGen);
        this.log.log("         instr(invokestatic)=" + t2, 4);
        this.design.checkClass(t2);
    }

    public void visitPUTSTATIC(PUTSTATIC s2) {
        String one = s2.getClassName(this.poolGen);
        String two = s2.getFieldName(this.poolGen);
        String three = s2.getName(this.poolGen);
        String four = s2.getSignature(this.poolGen);
        String five = s2.getClassType(this.poolGen) + "";
        String six = s2.getFieldType(this.poolGen) + "";
        this.log.log("         instr(putstatic)a=" + one, 4);
        this.log.log("         instr(putstatic)b=" + two, 4);
        this.log.log("         instr(putstatic)c=" + three, 4);
        this.log.log("         instr(putstatic)d=" + four, 4);
        this.log.log("         instr(putstatic)e=" + five, 4);
        this.log.log("         instr(putstatic)f=" + six, 4);
        String className = s2.getFieldName(this.poolGen);
        if ("staticField".equals(className)) {
            return;
        }
        if (!className.startsWith("class$") && !className.startsWith("array$")) {
            return;
        }
        this.log.log("         instr(putstatic)1=" + className, 4);
        className = className.substring(6, className.length());
        this.log.log("         instr(putstatic)2=" + className, 4);
        className = className.replace('$', '.');
        this.log.log("         instr(putstatic)3=" + className, 4);
        this.design.checkClass(className);
    }
}

