/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.design;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.sf.antcontrib.design.Design;
import net.sf.antcontrib.design.DesignFileHandler;
import net.sf.antcontrib.design.Log;
import net.sf.antcontrib.design.VisitorImpl;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.JAXPUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class VerifyDesignDelegate
implements Log {
    private File designFile;
    private Vector paths = new Vector();
    private boolean isCircularDesign = false;
    private boolean deleteFiles = false;
    private boolean fillInBuildException = false;
    private boolean needDeclarationsDefault = true;
    private boolean needDependsDefault = true;
    private Task task;
    private Design design;
    private HashSet primitives = new HashSet();
    private Vector designErrors = new Vector();
    private boolean verifiedAtLeastOne = false;
    private String className = "";

    public VerifyDesignDelegate(Task task) {
        this.task = task;
        this.primitives.add("B");
        this.primitives.add("C");
        this.primitives.add("D");
        this.primitives.add("F");
        this.primitives.add("I");
        this.primitives.add("J");
        this.primitives.add("S");
        this.primitives.add("Z");
    }

    public void addConfiguredPath(Path path) {
        this.paths.add(path);
    }

    public void setJar(File f2) {
        Path p2 = (Path)this.task.getProject().createDataType("path");
        p2.createPathElement().setLocation(f2.getAbsoluteFile());
        this.addConfiguredPath(p2);
    }

    public void setDesign(File f2) {
        this.designFile = f2;
    }

    public void setCircularDesign(boolean isCircularDesign) {
        this.isCircularDesign = isCircularDesign;
    }

    public void setDeleteFiles(boolean deleteFiles) {
        this.deleteFiles = deleteFiles;
    }

    public void setFillInBuildException(boolean b2) {
        this.fillInBuildException = b2;
    }

    public void setNeedDeclarationsDefault(boolean b2) {
        this.needDeclarationsDefault = b2;
    }

    public void setNeedDependsDefault(boolean b2) {
        this.needDependsDefault = b2;
    }

    public void execute() {
        if (!this.designFile.exists() || this.designFile.isDirectory()) {
            throw new BuildException("design attribute in verifydesign element specified an invalid file=" + this.designFile);
        }
        this.verifyJarFilesExist();
        try {
            XMLReader reader = JAXPUtils.getXMLReader();
            DesignFileHandler ch2 = new DesignFileHandler(this, this.designFile, this.isCircularDesign, this.task.getLocation());
            ch2.setNeedDeclarationsDefault(this.needDeclarationsDefault);
            ch2.setNeedDependsDefault(this.needDependsDefault);
            reader.setContentHandler(ch2);
            this.log("about to start parsing file='" + this.designFile + "'", 2);
            FileInputStream fileInput = new FileInputStream(this.designFile);
            InputSource src = new InputSource(fileInput);
            reader.parse(src);
            this.design = ch2.getDesign();
            Enumeration pathsEnum = this.paths.elements();
            Path p2 = null;
            while (pathsEnum.hasMoreElements()) {
                p2 = (Path)pathsEnum.nextElement();
                this.verifyPathAdheresToDesign(this.design, p2);
            }
            if (this.designErrors.isEmpty()) {
                this.design.fillInUnusedPackages(this.designErrors);
            }
            if (!this.designErrors.isEmpty()) {
                this.log(this.designErrors.size() + "Errors.", 1);
                if (!this.fillInBuildException) {
                    throw new BuildException("Design check failed due to previous errors");
                }
                this.throwAllErrors();
            }
        }
        catch (SAXException e2) {
            this.maybeDeleteFiles();
            if (e2.getException() != null && e2.getException() instanceof RuntimeException) {
                throw (RuntimeException)e2.getException();
            }
            if (e2 instanceof SAXParseException) {
                SAXParseException pe = (SAXParseException)e2;
                throw new BuildException("\nProblem parsing design file='" + this.designFile + "'.  \nline=" + pe.getLineNumber() + " column=" + pe.getColumnNumber() + " Reason:\n" + e2.getMessage() + "\n", e2);
            }
            throw new BuildException("\nProblem parsing design file='" + this.designFile + "'. Reason:\n" + e2, e2);
        }
        catch (IOException e3) {
            this.maybeDeleteFiles();
            throw new RuntimeException("See attached exception", e3);
        }
        catch (RuntimeException e4) {
            this.maybeDeleteFiles();
            throw e4;
        }
        if (!this.verifiedAtLeastOne) {
            throw new BuildException("Did not find any class or jar files to verify");
        }
    }

    private void throwAllErrors() {
        String result = "Design check failed due to following errors";
        Enumeration exceptions = this.designErrors.elements();
        while (exceptions.hasMoreElements()) {
            BuildException be2 = (BuildException)exceptions.nextElement();
            String message = be2.getMessage();
            result = result + "\n" + message;
        }
        throw new BuildException(result);
    }

    private void verifyJarFilesExist() {
        Enumeration pathsEnum = this.paths.elements();
        Path p2 = null;
        while (pathsEnum.hasMoreElements()) {
            p2 = (Path)pathsEnum.nextElement();
            String[] files = p2.list();
            for (int i2 = 0; i2 < files.length; ++i2) {
                File file = new File(files[i2]);
                if (file.exists()) continue;
                throw new BuildException(VisitorImpl.getNoFileMsg(file));
            }
        }
    }

    private void maybeDeleteFiles() {
        if (this.deleteFiles) {
            this.log("Deleting all class and jar files so you do not get tempted to\nuse a jar that doesn't abide by the design(This option can\nbe turned off if you really want)", 2);
            Enumeration pathsEnum = this.paths.elements();
            Path p2 = null;
            while (pathsEnum.hasMoreElements()) {
                p2 = (Path)pathsEnum.nextElement();
                this.deleteFilesInPath(p2);
            }
        }
    }

    private void deleteFilesInPath(Path p2) {
        String[] files = p2.list();
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = new File(files[i2]);
            boolean deleted = file.delete();
            if (deleted) continue;
            file.deleteOnExit();
        }
    }

    private void verifyPathAdheresToDesign(Design d2, Path p2) throws ClassFormatException, IOException {
        String[] files = p2.list();
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = new File(files[i2]);
            if (file.isDirectory()) {
                FileSet set = new FileSet();
                set.setDir(file);
                set.setProject(this.task.getProject());
                PatternSet.NameEntry entry1 = set.createInclude();
                PatternSet.NameEntry entry2 = set.createInclude();
                PatternSet.NameEntry entry3 = set.createInclude();
                entry1.setName("**/*.class");
                entry2.setName("**/*.jar");
                entry3.setName("**/*.war");
                DirectoryScanner scanner = set.getDirectoryScanner(this.task.getProject());
                scanner.setBasedir(file);
                String[] scannerFiles = scanner.getIncludedFiles();
                for (int j2 = 0; j2 < scannerFiles.length; ++j2) {
                    this.verifyPartOfPath(scannerFiles[j2], new File(file, scannerFiles[j2]), d2);
                }
                continue;
            }
            this.verifyPartOfPath(files[i2], file, d2);
        }
    }

    private void verifyPartOfPath(String fileName, File file, Design d2) throws IOException {
        if (fileName.endsWith(".jar") || fileName.endsWith(".war")) {
            JarFile jarFile = new JarFile(file);
            this.verifyJarAdheresToDesign(d2, jarFile, file);
        } else if (fileName.endsWith(".class")) {
            this.verifyClassAdheresToDesign(d2, file);
        } else {
            throw new BuildException("Only directories, jars, wars, and class files can be supplied to verify design, not file=" + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyClassAdheresToDesign(Design d2, File classFile) throws ClassFormatException, IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(classFile);
            this.verifyClassAdheresToDesign(d2, fis, classFile.getAbsolutePath(), classFile);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e2) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyJarAdheresToDesign(Design d2, JarFile jarFile, File original) throws ClassFormatException, IOException {
        try {
            Enumeration<JarEntry> en2 = jarFile.entries();
            while (en2.hasMoreElements()) {
                ZipEntry entry = en2.nextElement();
                InputStream in = null;
                if (!entry.getName().endsWith(".class")) continue;
                in = jarFile.getInputStream(entry);
                try {
                    in = jarFile.getInputStream(entry);
                    this.verifyClassAdheresToDesign(d2, in, entry.getName(), original);
                }
                finally {
                    try {
                        if (in == null) continue;
                        in.close();
                    }
                    catch (IOException e2) {}
                }
            }
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException e3) {}
        }
    }

    private void verifyClassAdheresToDesign(Design d2, InputStream in, String name, File originalClassOrJarFile) throws ClassFormatException, IOException {
        try {
            this.verifiedAtLeastOne = true;
            ClassParser parser = new ClassParser(in, name);
            JavaClass javaClass = parser.parse();
            this.className = javaClass.getClassName();
            if (!d2.needEvalCurrentClass(this.className)) {
                return;
            }
            ConstantPool pool = javaClass.getConstantPool();
            this.processConstantPool(pool);
            VisitorImpl visitor = new VisitorImpl(pool, this, d2, this.task.getLocation());
            DescendingVisitor desc = new DescendingVisitor(javaClass, (Visitor)visitor);
            desc.visit();
        }
        catch (BuildException e2) {
            this.log(Design.getWrapperMsg(originalClassOrJarFile, e2.getMessage()), 0);
            this.designErrors.addElement(e2);
        }
    }

    private void processConstantPool(ConstantPool pool) {
        Constant[] constants = pool.getConstantPool();
        if (constants == null) {
            this.log("      constants=null", 3);
            return;
        }
        this.log("      constants len=" + constants.length, 3);
        for (int i2 = 0; i2 < constants.length; ++i2) {
            this.processConstant(pool, constants[i2], i2);
        }
    }

    private void processConstant(ConstantPool pool, Constant c2, int i2) {
        if (c2 == null) {
            return;
        }
        this.log("      const[" + i2 + "]=" + pool.constantToString(c2) + " inst=" + c2.getClass().getName(), 4);
        byte tag = c2.getTag();
        switch (tag) {
            case 7: {
                int ind = ((ConstantClass)c2).getNameIndex();
                c2 = pool.getConstant(ind, (byte)1);
                String className = Utility.compactClassName((String)((ConstantUtf8)c2).getBytes(), (boolean)false);
                this.log("      classNamePre=" + className, 4);
                className = VerifyDesignDelegate.getRidOfArray(className);
                String firstLetter = className.charAt(0) + "";
                if (this.primitives.contains(firstLetter)) {
                    return;
                }
                this.log("      className=" + className, 3);
                this.design.checkClass(className);
                break;
            }
        }
    }

    private static String getRidOfArray(String className) {
        while (className.startsWith("[")) {
            className = className.substring(1, className.length());
        }
        return className;
    }

    public static String getPackageName(String className) {
        String packageName = "default package";
        int index = className.lastIndexOf(".");
        if (index > 0) {
            packageName = className.substring(0, index);
        }
        return packageName;
    }

    public void log(String msg, int level) {
        this.task.log(msg, level);
    }
}

