/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.design;

import java.io.File;
import net.sf.antcontrib.design.Design;
import net.sf.antcontrib.design.InstructionVisitor;
import net.sf.antcontrib.design.Log;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.Visitor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;

class VisitorImpl
extends EmptyVisitor {
    private ConstantPool pool;
    private Log log;
    private Design design;
    private ConstantPoolGen poolGen;
    private InstructionVisitor visitor;
    private Location location;

    public VisitorImpl(ConstantPool pool, Log log, Design d2, Location loc) {
        this.pool = pool;
        this.log = log;
        this.design = d2;
        this.location = loc;
        this.poolGen = new ConstantPoolGen(pool);
        this.visitor = new InstructionVisitor(this.poolGen, log, d2);
    }

    private void log(String s2, int level) {
        this.log.log(s2, level);
    }

    public void visitJavaClass(JavaClass c2) {
        this.log("      super=" + c2.getSuperclassName(), 3);
        String[] names = c2.getInterfaceNames();
        String superClass = c2.getSuperclassName();
        this.design.checkClass(superClass);
        for (int i2 = 0; i2 < names.length; ++i2) {
            this.log("      interfaces=" + names[i2], 3);
            this.design.checkClass(names[i2]);
        }
    }

    public void visitField(Field f2) {
        String type = Utility.methodSignatureReturnType((String)f2.getSignature());
        this.log("      field type=" + type, 3);
        this.design.checkClass(type);
    }

    public void visitLocalVariable(LocalVariable v2) {
        String type = Utility.methodSignatureReturnType((String)v2.getSignature());
        this.log("         localVar type=" + type, 3);
        this.design.checkClass(type);
    }

    public void visitMethod(Method m2) {
        this.log("      method=" + m2.getName(), 3);
        String retType = Utility.methodSignatureReturnType((String)m2.getSignature());
        this.log("         method ret type=" + retType, 3);
        if (!"void".equals(retType)) {
            this.design.checkClass(retType);
        }
        String[] types = Utility.methodSignatureArgumentTypes((String)m2.getSignature());
        for (int i2 = 0; i2 < types.length; ++i2) {
            this.log("         method param[" + i2 + "]=" + types[i2], 3);
            this.design.checkClass(types[i2]);
        }
        ExceptionTable excs = m2.getExceptionTable();
        if (excs != null) {
            types = excs.getExceptionNames();
            for (int i3 = 0; i3 < types.length; ++i3) {
                this.log("         exc=" + types[i3], 3);
                this.design.checkClass(types[i3]);
            }
        }
        this.processInstructions(m2);
    }

    private void processInstructions(Method m2) {
        MethodGen mg = new MethodGen(m2, this.design.getCurrentClass(), this.poolGen);
        if (!mg.isAbstract() && !mg.isNative()) {
            for (InstructionHandle ih = mg.getInstructionList().getStart(); ih != null; ih = ih.getNext()) {
                Instruction i2 = ih.getInstruction();
                this.log("         instr=" + i2, 4);
                i2.accept((Visitor)this.visitor);
            }
        }
    }

    public void visitCodeException(CodeException c2) {
        String s2 = c2.toString(this.pool, false);
        int catch_type = c2.getCatchType();
        if (catch_type == 0) {
            return;
        }
        String temp = this.pool.getConstantString(catch_type, (byte)7);
        String str = Utility.compactClassName((String)temp, (boolean)false);
        this.log("         catch=" + str, 4);
        this.design.checkClass(str);
    }

    public void visitCode(Code c2) {
        LineNumberTable table = c2.getLineNumberTable();
        if (table == null) {
            throw new BuildException(VisitorImpl.getNoDebugMsg(this.design.getCurrentClass()), this.location);
        }
    }

    public static String getNoDebugMsg(String className) {
        String s2 = "Class=" + className + " was not compiled with the debug option(-g) and\n" + "therefore verifydesign cannot be used on this jar.  Please compile your code\n" + "with -g option in javac or debug=\"true\" in the ant build.xml file";
        return s2;
    }

    public static String getNoFileMsg(File jarName) {
        String s2 = "File you specified in your path(or jar attribute)='" + jarName.getAbsolutePath() + "' does not exist";
        return s2;
    }
}

