/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.antcontrib.util.ThreadPool;
import net.sf.antcontrib.util.ThreadPoolThread;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.taskdefs.CallTarget;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;

public class ForEach
extends Task {
    private String list = null;
    private String param = null;
    private String delimiter = ",";
    private String target = null;
    private boolean inheritAll = false;
    private boolean inheritRefs = false;
    private Vector params = new Vector();
    private Vector references = new Vector();
    private Path currPath;
    private boolean parallel = false;
    private boolean trim;
    private int maxThreads = 5;
    private Mapper mapper;

    private void executeParallel(Vector tasks) {
        ThreadPool pool = new ThreadPool(this.maxThreads);
        Enumeration e2 = tasks.elements();
        Runnable r2 = null;
        Vector<ThreadPoolThread> threads = new Vector<ThreadPoolThread>();
        while (e2.hasMoreElements()) {
            final Task task = (Task)e2.nextElement();
            r2 = new Runnable(){

                public void run() {
                    task.execute();
                }
            };
            try {
                ThreadPoolThread tpt = pool.borrowThread();
                tpt.setRunnable(r2);
                tpt.start();
                threads.addElement(tpt);
            }
            catch (Exception ex2) {
                throw new BuildException(ex2);
            }
        }
        Enumeration te = threads.elements();
        Thread t2 = null;
        while (te.hasMoreElements()) {
            t2 = (Thread)te.nextElement();
            if (!t2.isAlive()) continue;
            try {
                t2.join();
            }
            catch (InterruptedException ex3) {
                throw new BuildException(ex3);
            }
        }
    }

    private void executeSequential(Vector tasks) {
        TaskContainer tc = (TaskContainer)((Object)this.getProject().createTask("sequential"));
        Enumeration e2 = tasks.elements();
        Task t2 = null;
        while (e2.hasMoreElements()) {
            t2 = (Task)e2.nextElement();
            tc.addTask(t2);
        }
        ((Task)((Object)tc)).execute();
    }

    public void execute() throws BuildException {
        if (this.list == null && this.currPath == null) {
            throw new BuildException("You must have a list or path to iterate through");
        }
        if (this.param == null) {
            throw new BuildException("You must supply a property name to set on each iteration in param");
        }
        if (this.target == null) {
            throw new BuildException("You must supply a target to perform");
        }
        Vector<Object> values = new Vector<Object>();
        if (this.list != null) {
            StringTokenizer st = new StringTokenizer(this.list, this.delimiter);
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (this.trim) {
                    tok = tok.trim();
                }
                values.addElement(tok);
            }
        }
        String[] pathElements = new String[]{};
        if (this.currPath != null) {
            pathElements = this.currPath.list();
        }
        for (int i2 = 0; i2 < pathElements.length; ++i2) {
            if (this.mapper != null) {
                FileNameMapper m2 = this.mapper.getImplementation();
                String[] mapped = m2.mapFileName(pathElements[i2]);
                for (int j2 = 0; j2 < mapped.length; ++j2) {
                    values.addElement(mapped[j2]);
                }
                continue;
            }
            values.addElement(new File(pathElements[i2]));
        }
        Vector<CallTarget> tasks = new Vector<CallTarget>();
        int sz = values.size();
        CallTarget ct2 = null;
        Object val = null;
        Property p2 = null;
        for (int i3 = 0; i3 < sz; ++i3) {
            val = values.elementAt(i3);
            ct2 = this.createCallTarget();
            p2 = ct2.createParam();
            p2.setName(this.param);
            if (val instanceof File) {
                p2.setLocation((File)val);
            } else {
                p2.setValue(val);
            }
            tasks.addElement(ct2);
        }
        if (this.parallel && this.maxThreads > 1) {
            this.executeParallel(tasks);
        } else {
            this.executeSequential(tasks);
        }
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public void setList(String list) {
        this.list = list;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public void setInheritall(boolean b2) {
        this.inheritAll = b2;
    }

    public void setInheritrefs(boolean b2) {
        this.inheritRefs = b2;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void addParam(Property p2) {
        this.params.addElement(p2);
    }

    public void addReference(Ant.Reference r2) {
        this.references.addElement(r2);
    }

    public void addFileset(FileSet set) {
        this.log("The nested fileset element is deprectated, use a nested path instead", 1);
        this.createPath().addFileset(set);
    }

    public Path createPath() {
        if (this.currPath == null) {
            this.currPath = new Path(this.getProject());
        }
        return this.currPath;
    }

    public Mapper createMapper() {
        this.mapper = new Mapper(this.getProject());
        return this.mapper;
    }

    private CallTarget createCallTarget() {
        CallTarget ct2 = (CallTarget)this.getProject().createTask("antcall");
        ct2.setOwningTarget(this.getOwningTarget());
        ct2.init();
        ct2.setTarget(this.target);
        ct2.setInheritAll(this.inheritAll);
        ct2.setInheritRefs(this.inheritRefs);
        Enumeration e2 = this.params.elements();
        while (e2.hasMoreElements()) {
            Property param = (Property)e2.nextElement();
            Property toSet = ct2.createParam();
            toSet.setName(param.getName());
            if (param.getValue() != null) {
                toSet.setValue(param.getValue());
            }
            if (param.getFile() != null) {
                toSet.setFile(param.getFile());
            }
            if (param.getResource() != null) {
                toSet.setResource(param.getResource());
            }
            if (param.getPrefix() != null) {
                toSet.setPrefix(param.getPrefix());
            }
            if (param.getRefid() != null) {
                toSet.setRefid(param.getRefid());
            }
            if (param.getEnvironment() != null) {
                toSet.setEnvironment(param.getEnvironment());
            }
            if (param.getClasspath() == null) continue;
            toSet.setClasspath(param.getClasspath());
        }
        e2 = this.references.elements();
        while (e2.hasMoreElements()) {
            ct2.addReference((Ant.Reference)e2.nextElement());
        }
        return ct2;
    }

    protected void handleOutput(String line) {
        try {
            super.handleOutput(line);
        }
        catch (IllegalAccessError e2) {
            super.handleOutput(line);
        }
    }

    protected void handleErrorOutput(String line) {
        try {
            super.handleErrorOutput(line);
        }
        catch (IllegalAccessError e2) {
            super.handleErrorOutput(line);
        }
    }
}

