/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Parallel;
import org.apache.tools.ant.taskdefs.Sequential;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;

public class OutOfDate
extends Task
implements Condition {
    private Task doTask = null;
    private String property;
    private String value = "true";
    private boolean force = false;
    private int verbosity = 3;
    private Vector mappers = new Vector();
    private Path targetpaths = null;
    private Path sourcepaths = null;
    private String outputSources = null;
    private String outputSourcesPath = null;
    private String outputTargets = null;
    private String outputTargetsPath = null;
    private String allTargets = null;
    private String allTargetsPath = null;
    private String separator = " ";
    private DeleteTargets deleteTargets = null;
    private int collection = 0;
    private Hashtable targetSet = new Hashtable();
    private Hashtable sourceSet = new Hashtable();
    private Hashtable allTargetSet = new Hashtable();
    private Hashtable allSourceSet = new Hashtable();

    public void setCollection(CollectionEnum collection) {
        this.collection = collection.getIndex();
    }

    public Mapper createMapper() {
        MyMapper mapper = new MyMapper(this.getProject());
        this.mappers.addElement(mapper);
        return mapper;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 3;
    }

    public Path createTargetfiles() {
        if (this.targetpaths == null) {
            this.targetpaths = new Path(this.getProject());
        }
        return this.targetpaths;
    }

    public Path createSourcefiles() {
        if (this.sourcepaths == null) {
            this.sourcepaths = new Path(this.getProject());
        }
        return this.sourcepaths;
    }

    public void setOutputSources(String outputSources) {
        this.outputSources = outputSources;
    }

    public void setOutputTargets(String outputTargets) {
        this.outputTargets = outputTargets;
    }

    public void setOutputTargetsPath(String outputTargetsPath) {
        this.outputTargetsPath = outputTargetsPath;
    }

    public void setAllTargetsPath(String allTargetsPath) {
        this.allTargetsPath = allTargetsPath;
    }

    public void setAllTargets(String allTargets) {
        this.allTargets = allTargets;
    }

    public void setOutputSourcesPath(String outputSourcesPath) {
        this.outputSourcesPath = outputSourcesPath;
    }

    public DeleteTargets createDeleteTargets() {
        this.deleteTargets = new DeleteTargets();
        return this.deleteTargets;
    }

    public void addParallel(Parallel doTask) {
        if (this.doTask != null) {
            throw new BuildException("You must not nest more that one <parallel> or <sequential> into <outofdate>");
        }
        this.doTask = doTask;
    }

    public void addSequential(Sequential doTask) {
        if (this.doTask != null) {
            throw new BuildException("You must not nest more that one <parallel> or <sequential> into <outofdate>");
        }
        this.doTask = doTask;
    }

    public boolean eval() {
        boolean ret = false;
        FileUtils fileUtils = FileUtils.newFileUtils();
        if (this.sourcepaths == null) {
            throw new BuildException("You must specify a <sourcefiles> element.");
        }
        if (this.targetpaths == null && this.mappers.size() == 0) {
            throw new BuildException("You must specify a <targetfiles> or <mapper> element.");
        }
        String[] spaths = this.sourcepaths.list();
        for (int i2 = 0; i2 < spaths.length; ++i2) {
            File sourceFile = new File(spaths[i2]);
            if (sourceFile.exists()) continue;
            throw new BuildException(sourceFile.getAbsolutePath() + " not found.");
        }
        if (this.targetpaths != null) {
            String[] paths = this.targetpaths.list();
            if (paths.length == 0) {
                ret = true;
            } else {
                for (int i3 = 0; i3 < paths.length; ++i3) {
                    if (!this.targetNeedsGen(paths[i3], spaths)) continue;
                    ret = true;
                }
            }
        }
        Enumeration e2 = this.mappers.elements();
        while (e2.hasMoreElements()) {
            MyMapper mapper = (MyMapper)e2.nextElement();
            File relativeDir = mapper.getDir();
            File baseDir = new File(this.getProject().getProperty("basedir"));
            if (relativeDir == null) {
                relativeDir = baseDir;
            }
            String[] rpaths = new String[spaths.length];
            for (int i4 = 0; i4 < spaths.length; ++i4) {
                rpaths[i4] = fileUtils.removeLeadingPath(relativeDir, new File(spaths[i4]));
            }
            FileNameMapper fileNameMapper = mapper.getImplementation();
            for (int i5 = 0; i5 < spaths.length; ++i5) {
                String[] mapped = fileNameMapper.mapFileName(rpaths[i5]);
                if (mapped == null) continue;
                for (int j2 = 0; j2 < mapped.length; ++j2) {
                    if (!this.outOfDate(new File(spaths[i5]), fileUtils.resolveFile(baseDir, mapped[j2]))) continue;
                    ret = true;
                }
            }
        }
        if (this.allTargets != null) {
            this.getProject().setNewProperty(this.allTargets, this.setToString(this.allTargetSet));
        }
        if (this.allTargetsPath != null) {
            this.getProject().addReference(this.allTargetsPath, this.setToPath(this.allTargetSet));
        }
        if (this.outputSources != null) {
            this.getProject().setNewProperty(this.outputSources, this.setToString(this.sourceSet));
        }
        if (this.outputTargets != null) {
            this.getProject().setNewProperty(this.outputTargets, this.setToString(this.targetSet));
        }
        if (this.outputSourcesPath != null) {
            this.getProject().addReference(this.outputSourcesPath, this.setToPath(this.sourceSet));
        }
        if (this.outputTargetsPath != null) {
            this.getProject().addReference(this.outputTargetsPath, this.setToPath(this.targetSet));
        }
        if (this.force) {
            ret = true;
        }
        if (ret && this.deleteTargets != null) {
            this.deleteTargets.execute();
        }
        if (ret && this.property != null) {
            this.getProject().setNewProperty(this.property, this.value);
        }
        return ret;
    }

    private boolean targetNeedsGen(String target, String[] spaths) {
        boolean ret = false;
        File targetFile = new File(target);
        for (int i2 = 0; i2 < spaths.length; ++i2) {
            if (!this.outOfDate(new File(spaths[i2]), targetFile)) continue;
            ret = true;
        }
        if (spaths.length == 0 && this.outOfDate(null, targetFile)) {
            ret = true;
        }
        return ret;
    }

    public Iterator iterator() {
        this.eval();
        switch (this.collection) {
            case 0: {
                return this.sourceSet.values().iterator();
            }
            case 1: {
                return this.targetSet.values().iterator();
            }
            case 2: {
                return this.allSourceSet.values().iterator();
            }
            case 3: {
                return this.allTargetSet.values().iterator();
            }
        }
        return this.sourceSet.values().iterator();
    }

    public void execute() {
        if (!this.eval()) {
            return;
        }
        if (this.doTask != null) {
            this.doTask.perform();
        }
    }

    private boolean outOfDate(File sourceFile, File targetFile) {
        boolean ret = false;
        if (sourceFile != null) {
            this.allSourceSet.put(sourceFile, sourceFile);
        }
        this.allTargetSet.put(targetFile, targetFile);
        if (!targetFile.exists()) {
            ret = true;
        }
        if (!ret && sourceFile != null) {
            boolean bl2 = ret = sourceFile.lastModified() > targetFile.lastModified();
        }
        if (ret) {
            if (sourceFile != null && this.sourceSet.get(sourceFile) == null || this.targetSet.get(targetFile) == null) {
                this.log("SourceFile " + sourceFile + " outofdate " + "with regard to " + targetFile, this.verbosity);
            }
            if (sourceFile != null) {
                this.sourceSet.put(sourceFile, sourceFile);
            }
            this.targetSet.put(targetFile, targetFile);
        }
        return ret;
    }

    private String setToString(Hashtable set) {
        StringBuffer b2 = new StringBuffer();
        Enumeration e2 = set.keys();
        while (e2.hasMoreElements()) {
            String s2;
            File v2 = (File)e2.nextElement();
            if (b2.length() != 0) {
                b2.append(this.separator);
            }
            if ((s2 = v2.getAbsolutePath()).indexOf(this.separator) != -1) {
                s2 = s2.indexOf("\"") != -1 ? "'" + s2 + "'" : "\"" + s2 + "\"";
            }
            b2.append(s2);
        }
        return b2.toString();
    }

    private Path setToPath(Hashtable set) {
        Path ret = new Path(this.getProject());
        Enumeration e2 = set.keys();
        while (e2.hasMoreElements()) {
            File v2 = (File)e2.nextElement();
            Path.PathElement el2 = ret.createPathElement();
            el2.setLocation(v2);
        }
        return ret;
    }

    public static class MyMapper
    extends Mapper {
        private File dir = null;

        public MyMapper(Project project) {
            super(project);
        }

        public void setDir(File dir) {
            this.dir = dir;
        }

        public File getDir() {
            return this.dir;
        }
    }

    public class DeleteTargets {
        private boolean all = false;
        private boolean quiet = false;
        private boolean failOnError = false;
        private int myLogging = 2;
        private static final int DELETE_RETRY_SLEEP_MILLIS = 10;

        public void setAll(boolean all) {
            this.all = all;
        }

        public void setQuiet(boolean quiet) {
            this.quiet = quiet;
            this.myLogging = quiet ? 3 : 2;
        }

        public void setFailOnError(boolean failOnError) {
            this.failOnError = failOnError;
        }

        private void execute() {
            if (this.myLogging != 2) {
                this.myLogging = OutOfDate.this.verbosity;
            }
            if (this.quiet) {
                this.failOnError = false;
            }
            Path toBeDeleted = null;
            toBeDeleted = this.all ? OutOfDate.this.setToPath(OutOfDate.this.allTargetSet) : OutOfDate.this.setToPath(OutOfDate.this.targetSet);
            String[] names = toBeDeleted.list();
            for (int i2 = 0; i2 < names.length; ++i2) {
                File file = new File(names[i2]);
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    this.removeDir(file);
                    continue;
                }
                OutOfDate.this.log("Deleting " + file.getAbsolutePath(), this.myLogging);
                if (file.delete()) continue;
                String message = "Unable to delete file " + file.getAbsolutePath();
                if (this.failOnError) {
                    throw new BuildException(message);
                }
                OutOfDate.this.log(message, this.myLogging);
            }
        }

        private boolean delete(File f2) {
            if (!f2.delete()) {
                try {
                    Thread.sleep(10L);
                    return f2.delete();
                }
                catch (InterruptedException ex2) {
                    return f2.delete();
                }
            }
            return true;
        }

        private void removeDir(File d2) {
            String[] list = d2.list();
            if (list == null) {
                list = new String[]{};
            }
            for (int i2 = 0; i2 < list.length; ++i2) {
                String s2 = list[i2];
                File f2 = new File(d2, s2);
                if (f2.isDirectory()) {
                    this.removeDir(f2);
                    continue;
                }
                OutOfDate.this.log("Deleting " + f2.getAbsolutePath(), this.myLogging);
                if (f2.delete()) continue;
                String message = "Unable to delete file " + f2.getAbsolutePath();
                if (this.failOnError) {
                    throw new BuildException(message);
                }
                OutOfDate.this.log(message, this.myLogging);
            }
            OutOfDate.this.log("Deleting directory " + d2.getAbsolutePath(), this.myLogging);
            if (!this.delete(d2)) {
                String message = "Unable to delete directory " + d2.getAbsolutePath();
                if (this.failOnError) {
                    throw new BuildException(message);
                }
                OutOfDate.this.log(message, this.myLogging);
            }
        }
    }

    public static class CollectionEnum
    extends EnumeratedAttribute {
        public static final int SOURCES = 0;
        public static final int TARGETS = 1;
        public static final int ALLSOURCES = 2;
        public static final int ALLTARGETS = 3;

        public String[] getValues() {
            return new String[]{"sources", "targets", "allsources", "alltargets"};
        }
    }
}

