/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class Relentless
extends Task
implements TaskContainer {
    private Vector taskList = new Vector();
    private boolean terse = false;

    public void execute() throws BuildException {
        int failCount = 0;
        int taskNo = 0;
        if (this.taskList.size() == 0) {
            throw new BuildException("No tasks specified for <relentless>.");
        }
        this.log("Relentlessly executing: " + this.getDescription());
        Iterator iter = this.taskList.iterator();
        while (iter.hasNext()) {
            Task t2 = (Task)iter.next();
            ++taskNo;
            String desc = t2.getDescription();
            if (desc == null) {
                desc = "task " + taskNo;
            }
            if (!this.terse) {
                this.log("Executing: " + desc);
            }
            try {
                t2.perform();
            }
            catch (BuildException x2) {
                this.log("Task " + desc + " failed: " + x2.getMessage());
                ++failCount;
            }
        }
        if (failCount > 0) {
            throw new BuildException("Relentless execution: " + failCount + " of " + this.taskList.size() + " tasks failed.");
        }
        this.log("All tasks completed successfully.");
    }

    public void addTask(Task task) {
        this.taskList.add(task);
    }

    public void setTerse(boolean terse) {
        this.terse = terse;
    }

    public boolean isTerse() {
        return this.terse;
    }
}

